<?php

namespace TurkkepEFatura\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfAdditionalInfo ArrayType
 * @subpackage Arrays
 */
class ArrayOfAdditionalInfo extends AbstractStructArrayBase
{
    /**
     * The AdditionalInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \TurkkepEFatura\StructType\AdditionalInfo[]
     */
    public $AdditionalInfo;
    /**
     * Constructor method for ArrayOfAdditionalInfo
     * @uses ArrayOfAdditionalInfo::setAdditionalInfo()
     * @param \TurkkepEFatura\StructType\AdditionalInfo[] $additionalInfo
     */
    public function __construct(array $additionalInfo = array())
    {
        $this
            ->setAdditionalInfo($additionalInfo);
    }
    /**
     * Get AdditionalInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \TurkkepEFatura\StructType\AdditionalInfo[]|null
     */
    public function getAdditionalInfo()
    {
        return isset($this->AdditionalInfo) ? $this->AdditionalInfo : null;
    }
    /**
     * This method is responsible for validating the values passed to the setAdditionalInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAdditionalInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAdditionalInfoForArrayConstraintsFromSetAdditionalInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfAdditionalInfoAdditionalInfoItem) {
            // validation for constraint: itemType
            if (!$arrayOfAdditionalInfoAdditionalInfoItem instanceof \TurkkepEFatura\StructType\AdditionalInfo) {
                $invalidValues[] = is_object($arrayOfAdditionalInfoAdditionalInfoItem) ? get_class($arrayOfAdditionalInfoAdditionalInfoItem) : sprintf('%s(%s)', gettype($arrayOfAdditionalInfoAdditionalInfoItem), var_export($arrayOfAdditionalInfoAdditionalInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AdditionalInfo property can only contain items of type \TurkkepEFatura\StructType\AdditionalInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AdditionalInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\AdditionalInfo[] $additionalInfo
     * @return \TurkkepEFatura\ArrayType\ArrayOfAdditionalInfo
     */
    public function setAdditionalInfo(array $additionalInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($additionalInfoArrayErrorMessage = self::validateAdditionalInfoForArrayConstraintsFromSetAdditionalInfo($additionalInfo))) {
            throw new \InvalidArgumentException($additionalInfoArrayErrorMessage, __LINE__);
        }
        if (is_null($additionalInfo) || (is_array($additionalInfo) && empty($additionalInfo))) {
            unset($this->AdditionalInfo);
        } else {
            $this->AdditionalInfo = $additionalInfo;
        }
        return $this;
    }
    /**
     * Add item to AdditionalInfo value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\AdditionalInfo $item
     * @return \TurkkepEFatura\ArrayType\ArrayOfAdditionalInfo
     */
    public function addToAdditionalInfo(\TurkkepEFatura\StructType\AdditionalInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \TurkkepEFatura\StructType\AdditionalInfo) {
            throw new \InvalidArgumentException(sprintf('The AdditionalInfo property can only contain items of type \TurkkepEFatura\StructType\AdditionalInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AdditionalInfo[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \TurkkepEFatura\StructType\AdditionalInfo|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \TurkkepEFatura\StructType\AdditionalInfo|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \TurkkepEFatura\StructType\AdditionalInfo|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \TurkkepEFatura\StructType\AdditionalInfo|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \TurkkepEFatura\StructType\AdditionalInfo|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string AdditionalInfo
     */
    public function getAttributeName()
    {
        return 'AdditionalInfo';
    }
}
