<?php

namespace TurkkepEFatura\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TaxTotalType StructType
 * @subpackage Structs
 */
class TaxTotalType extends AbstractStructBase
{
    /**
     * The TaxAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:TaxAmount
     * @var \TurkkepEFatura\StructType\TaxAmountType
     */
    public $TaxAmount;
    /**
     * The TaxSubtotal
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\TaxSubtotalType[]
     */
    public $TaxSubtotal;
    /**
     * Constructor method for TaxTotalType
     * @uses TaxTotalType::setTaxAmount()
     * @uses TaxTotalType::setTaxSubtotal()
     * @param \TurkkepEFatura\StructType\TaxAmountType $taxAmount
     * @param \TurkkepEFatura\StructType\TaxSubtotalType[] $taxSubtotal
     */
    public function __construct(\TurkkepEFatura\StructType\TaxAmountType $taxAmount = null, array $taxSubtotal = array())
    {
        $this
            ->setTaxAmount($taxAmount)
            ->setTaxSubtotal($taxSubtotal);
    }
    /**
     * Get TaxAmount value
     * @return \TurkkepEFatura\StructType\TaxAmountType|null
     */
    public function getTaxAmount()
    {
        return $this->TaxAmount;
    }
    /**
     * Set TaxAmount value
     * @param \TurkkepEFatura\StructType\TaxAmountType $taxAmount
     * @return \TurkkepEFatura\StructType\TaxTotalType
     */
    public function setTaxAmount(\TurkkepEFatura\StructType\TaxAmountType $taxAmount = null)
    {
        $this->TaxAmount = $taxAmount;
        return $this;
    }
    /**
     * Get TaxSubtotal value
     * @return \TurkkepEFatura\StructType\TaxSubtotalType[]|null
     */
    public function getTaxSubtotal()
    {
        return $this->TaxSubtotal;
    }
    /**
     * This method is responsible for validating the values passed to the setTaxSubtotal method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTaxSubtotal method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTaxSubtotalForArrayConstraintsFromSetTaxSubtotal(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $taxTotalTypeTaxSubtotalItem) {
            // validation for constraint: itemType
            if (!$taxTotalTypeTaxSubtotalItem instanceof \TurkkepEFatura\StructType\TaxSubtotalType) {
                $invalidValues[] = is_object($taxTotalTypeTaxSubtotalItem) ? get_class($taxTotalTypeTaxSubtotalItem) : sprintf('%s(%s)', gettype($taxTotalTypeTaxSubtotalItem), var_export($taxTotalTypeTaxSubtotalItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TaxSubtotal property can only contain items of type \TurkkepEFatura\StructType\TaxSubtotalType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TaxSubtotal value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\TaxSubtotalType[] $taxSubtotal
     * @return \TurkkepEFatura\StructType\TaxTotalType
     */
    public function setTaxSubtotal(array $taxSubtotal = array())
    {
        // validation for constraint: array
        if ('' !== ($taxSubtotalArrayErrorMessage = self::validateTaxSubtotalForArrayConstraintsFromSetTaxSubtotal($taxSubtotal))) {
            throw new \InvalidArgumentException($taxSubtotalArrayErrorMessage, __LINE__);
        }
        $this->TaxSubtotal = $taxSubtotal;
        return $this;
    }
    /**
     * Add item to TaxSubtotal value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\TaxSubtotalType $item
     * @return \TurkkepEFatura\StructType\TaxTotalType
     */
    public function addToTaxSubtotal(\TurkkepEFatura\StructType\TaxSubtotalType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \TurkkepEFatura\StructType\TaxSubtotalType) {
            throw new \InvalidArgumentException(sprintf('The TaxSubtotal property can only contain items of type \TurkkepEFatura\StructType\TaxSubtotalType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TaxSubtotal[] = $item;
        return $this;
    }
}
