<?php

namespace TurkkepEFatura\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TaxSubtotalType StructType
 * @subpackage Structs
 */
class TaxSubtotalType extends AbstractStructBase
{
    /**
     * The TaxableAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:TaxableAmount
     * @var \TurkkepEFatura\StructType\TaxableAmountType
     */
    public $TaxableAmount;
    /**
     * The TaxAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:TaxAmount
     * @var \TurkkepEFatura\StructType\TaxAmountType
     */
    public $TaxAmount;
    /**
     * The CalculationSequenceNumeric
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:CalculationSequenceNumeric
     * @var \TurkkepEFatura\StructType\CalculationSequenceNumericType
     */
    public $CalculationSequenceNumeric;
    /**
     * The TransactionCurrencyTaxAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:TransactionCurrencyTaxAmount
     * @var \TurkkepEFatura\StructType\TransactionCurrencyTaxAmountType
     */
    public $TransactionCurrencyTaxAmount;
    /**
     * The Percent
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:Percent
     * @var \TurkkepEFatura\StructType\PercentType
     */
    public $Percent;
    /**
     * The BaseUnitMeasure
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:BaseUnitMeasure
     * @var \TurkkepEFatura\StructType\BaseUnitMeasureType
     */
    public $BaseUnitMeasure;
    /**
     * The PerUnitAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:PerUnitAmount
     * @var \TurkkepEFatura\StructType\PerUnitAmountType
     */
    public $PerUnitAmount;
    /**
     * The TaxCategory
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\TaxCategoryType
     */
    public $TaxCategory;
    /**
     * Constructor method for TaxSubtotalType
     * @uses TaxSubtotalType::setTaxableAmount()
     * @uses TaxSubtotalType::setTaxAmount()
     * @uses TaxSubtotalType::setCalculationSequenceNumeric()
     * @uses TaxSubtotalType::setTransactionCurrencyTaxAmount()
     * @uses TaxSubtotalType::setPercent()
     * @uses TaxSubtotalType::setBaseUnitMeasure()
     * @uses TaxSubtotalType::setPerUnitAmount()
     * @uses TaxSubtotalType::setTaxCategory()
     * @param \TurkkepEFatura\StructType\TaxableAmountType $taxableAmount
     * @param \TurkkepEFatura\StructType\TaxAmountType $taxAmount
     * @param \TurkkepEFatura\StructType\CalculationSequenceNumericType $calculationSequenceNumeric
     * @param \TurkkepEFatura\StructType\TransactionCurrencyTaxAmountType $transactionCurrencyTaxAmount
     * @param \TurkkepEFatura\StructType\PercentType $percent
     * @param \TurkkepEFatura\StructType\BaseUnitMeasureType $baseUnitMeasure
     * @param \TurkkepEFatura\StructType\PerUnitAmountType $perUnitAmount
     * @param \TurkkepEFatura\StructType\TaxCategoryType $taxCategory
     */
    public function __construct(\TurkkepEFatura\StructType\TaxableAmountType $taxableAmount = null, \TurkkepEFatura\StructType\TaxAmountType $taxAmount = null, \TurkkepEFatura\StructType\CalculationSequenceNumericType $calculationSequenceNumeric = null, \TurkkepEFatura\StructType\TransactionCurrencyTaxAmountType $transactionCurrencyTaxAmount = null, \TurkkepEFatura\StructType\PercentType $percent = null, \TurkkepEFatura\StructType\BaseUnitMeasureType $baseUnitMeasure = null, \TurkkepEFatura\StructType\PerUnitAmountType $perUnitAmount = null, \TurkkepEFatura\StructType\TaxCategoryType $taxCategory = null)
    {
        $this
            ->setTaxableAmount($taxableAmount)
            ->setTaxAmount($taxAmount)
            ->setCalculationSequenceNumeric($calculationSequenceNumeric)
            ->setTransactionCurrencyTaxAmount($transactionCurrencyTaxAmount)
            ->setPercent($percent)
            ->setBaseUnitMeasure($baseUnitMeasure)
            ->setPerUnitAmount($perUnitAmount)
            ->setTaxCategory($taxCategory);
    }
    /**
     * Get TaxableAmount value
     * @return \TurkkepEFatura\StructType\TaxableAmountType|null
     */
    public function getTaxableAmount()
    {
        return $this->TaxableAmount;
    }
    /**
     * Set TaxableAmount value
     * @param \TurkkepEFatura\StructType\TaxableAmountType $taxableAmount
     * @return \TurkkepEFatura\StructType\TaxSubtotalType
     */
    public function setTaxableAmount(\TurkkepEFatura\StructType\TaxableAmountType $taxableAmount = null)
    {
        $this->TaxableAmount = $taxableAmount;
        return $this;
    }
    /**
     * Get TaxAmount value
     * @return \TurkkepEFatura\StructType\TaxAmountType|null
     */
    public function getTaxAmount()
    {
        return $this->TaxAmount;
    }
    /**
     * Set TaxAmount value
     * @param \TurkkepEFatura\StructType\TaxAmountType $taxAmount
     * @return \TurkkepEFatura\StructType\TaxSubtotalType
     */
    public function setTaxAmount(\TurkkepEFatura\StructType\TaxAmountType $taxAmount = null)
    {
        $this->TaxAmount = $taxAmount;
        return $this;
    }
    /**
     * Get CalculationSequenceNumeric value
     * @return \TurkkepEFatura\StructType\CalculationSequenceNumericType|null
     */
    public function getCalculationSequenceNumeric()
    {
        return $this->CalculationSequenceNumeric;
    }
    /**
     * Set CalculationSequenceNumeric value
     * @param \TurkkepEFatura\StructType\CalculationSequenceNumericType $calculationSequenceNumeric
     * @return \TurkkepEFatura\StructType\TaxSubtotalType
     */
    public function setCalculationSequenceNumeric(\TurkkepEFatura\StructType\CalculationSequenceNumericType $calculationSequenceNumeric = null)
    {
        $this->CalculationSequenceNumeric = $calculationSequenceNumeric;
        return $this;
    }
    /**
     * Get TransactionCurrencyTaxAmount value
     * @return \TurkkepEFatura\StructType\TransactionCurrencyTaxAmountType|null
     */
    public function getTransactionCurrencyTaxAmount()
    {
        return $this->TransactionCurrencyTaxAmount;
    }
    /**
     * Set TransactionCurrencyTaxAmount value
     * @param \TurkkepEFatura\StructType\TransactionCurrencyTaxAmountType $transactionCurrencyTaxAmount
     * @return \TurkkepEFatura\StructType\TaxSubtotalType
     */
    public function setTransactionCurrencyTaxAmount(\TurkkepEFatura\StructType\TransactionCurrencyTaxAmountType $transactionCurrencyTaxAmount = null)
    {
        $this->TransactionCurrencyTaxAmount = $transactionCurrencyTaxAmount;
        return $this;
    }
    /**
     * Get Percent value
     * @return \TurkkepEFatura\StructType\PercentType|null
     */
    public function getPercent()
    {
        return $this->Percent;
    }
    /**
     * Set Percent value
     * @param \TurkkepEFatura\StructType\PercentType $percent
     * @return \TurkkepEFatura\StructType\TaxSubtotalType
     */
    public function setPercent(\TurkkepEFatura\StructType\PercentType $percent = null)
    {
        $this->Percent = $percent;
        return $this;
    }
    /**
     * Get BaseUnitMeasure value
     * @return \TurkkepEFatura\StructType\BaseUnitMeasureType|null
     */
    public function getBaseUnitMeasure()
    {
        return $this->BaseUnitMeasure;
    }
    /**
     * Set BaseUnitMeasure value
     * @param \TurkkepEFatura\StructType\BaseUnitMeasureType $baseUnitMeasure
     * @return \TurkkepEFatura\StructType\TaxSubtotalType
     */
    public function setBaseUnitMeasure(\TurkkepEFatura\StructType\BaseUnitMeasureType $baseUnitMeasure = null)
    {
        $this->BaseUnitMeasure = $baseUnitMeasure;
        return $this;
    }
    /**
     * Get PerUnitAmount value
     * @return \TurkkepEFatura\StructType\PerUnitAmountType|null
     */
    public function getPerUnitAmount()
    {
        return $this->PerUnitAmount;
    }
    /**
     * Set PerUnitAmount value
     * @param \TurkkepEFatura\StructType\PerUnitAmountType $perUnitAmount
     * @return \TurkkepEFatura\StructType\TaxSubtotalType
     */
    public function setPerUnitAmount(\TurkkepEFatura\StructType\PerUnitAmountType $perUnitAmount = null)
    {
        $this->PerUnitAmount = $perUnitAmount;
        return $this;
    }
    /**
     * Get TaxCategory value
     * @return \TurkkepEFatura\StructType\TaxCategoryType|null
     */
    public function getTaxCategory()
    {
        return $this->TaxCategory;
    }
    /**
     * Set TaxCategory value
     * @param \TurkkepEFatura\StructType\TaxCategoryType $taxCategory
     * @return \TurkkepEFatura\StructType\TaxSubtotalType
     */
    public function setTaxCategory(\TurkkepEFatura\StructType\TaxCategoryType $taxCategory = null)
    {
        $this->TaxCategory = $taxCategory;
        return $this;
    }
}
