<?php

namespace TurkkepEFatura\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Shipment StructType
 * @subpackage Structs
 */
class Shipment extends AbstractStructBase
{
    /**
     * The InsuranceAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $InsuranceAmount;
    /**
     * The GrossWeightAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $GrossWeightAmount;
    /**
     * The NetWeightAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $NetWeightAmount;
    /**
     * The CarriageAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $CarriageAmount;
    /**
     * The QuantityType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \TurkkepEFatura\StructType\QuantityType
     */
    public $QuantityType;
    /**
     * Constructor method for Shipment
     * @uses Shipment::setInsuranceAmount()
     * @uses Shipment::setGrossWeightAmount()
     * @uses Shipment::setNetWeightAmount()
     * @uses Shipment::setCarriageAmount()
     * @uses Shipment::setQuantityType()
     * @param float $insuranceAmount
     * @param float $grossWeightAmount
     * @param float $netWeightAmount
     * @param float $carriageAmount
     * @param \TurkkepEFatura\StructType\QuantityType $quantityType
     */
    public function __construct($insuranceAmount = null, $grossWeightAmount = null, $netWeightAmount = null, $carriageAmount = null, \TurkkepEFatura\StructType\QuantityType $quantityType = null)
    {
        $this
            ->setInsuranceAmount($insuranceAmount)
            ->setGrossWeightAmount($grossWeightAmount)
            ->setNetWeightAmount($netWeightAmount)
            ->setCarriageAmount($carriageAmount)
            ->setQuantityType($quantityType);
    }
    /**
     * Get InsuranceAmount value
     * @return float
     */
    public function getInsuranceAmount()
    {
        return $this->InsuranceAmount;
    }
    /**
     * Set InsuranceAmount value
     * @param float $insuranceAmount
     * @return \TurkkepEFatura\StructType\Shipment
     */
    public function setInsuranceAmount($insuranceAmount = null)
    {
        // validation for constraint: float
        if (!is_null($insuranceAmount) && !(is_float($insuranceAmount) || is_numeric($insuranceAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($insuranceAmount, true), gettype($insuranceAmount)), __LINE__);
        }
        $this->InsuranceAmount = $insuranceAmount;
        return $this;
    }
    /**
     * Get GrossWeightAmount value
     * @return float
     */
    public function getGrossWeightAmount()
    {
        return $this->GrossWeightAmount;
    }
    /**
     * Set GrossWeightAmount value
     * @param float $grossWeightAmount
     * @return \TurkkepEFatura\StructType\Shipment
     */
    public function setGrossWeightAmount($grossWeightAmount = null)
    {
        // validation for constraint: float
        if (!is_null($grossWeightAmount) && !(is_float($grossWeightAmount) || is_numeric($grossWeightAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($grossWeightAmount, true), gettype($grossWeightAmount)), __LINE__);
        }
        $this->GrossWeightAmount = $grossWeightAmount;
        return $this;
    }
    /**
     * Get NetWeightAmount value
     * @return float
     */
    public function getNetWeightAmount()
    {
        return $this->NetWeightAmount;
    }
    /**
     * Set NetWeightAmount value
     * @param float $netWeightAmount
     * @return \TurkkepEFatura\StructType\Shipment
     */
    public function setNetWeightAmount($netWeightAmount = null)
    {
        // validation for constraint: float
        if (!is_null($netWeightAmount) && !(is_float($netWeightAmount) || is_numeric($netWeightAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($netWeightAmount, true), gettype($netWeightAmount)), __LINE__);
        }
        $this->NetWeightAmount = $netWeightAmount;
        return $this;
    }
    /**
     * Get CarriageAmount value
     * @return float
     */
    public function getCarriageAmount()
    {
        return $this->CarriageAmount;
    }
    /**
     * Set CarriageAmount value
     * @param float $carriageAmount
     * @return \TurkkepEFatura\StructType\Shipment
     */
    public function setCarriageAmount($carriageAmount = null)
    {
        // validation for constraint: float
        if (!is_null($carriageAmount) && !(is_float($carriageAmount) || is_numeric($carriageAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($carriageAmount, true), gettype($carriageAmount)), __LINE__);
        }
        $this->CarriageAmount = $carriageAmount;
        return $this;
    }
    /**
     * Get QuantityType value
     * @return \TurkkepEFatura\StructType\QuantityType
     */
    public function getQuantityType()
    {
        return $this->QuantityType;
    }
    /**
     * Set QuantityType value
     * @param \TurkkepEFatura\StructType\QuantityType $quantityType
     * @return \TurkkepEFatura\StructType\Shipment
     */
    public function setQuantityType(\TurkkepEFatura\StructType\QuantityType $quantityType = null)
    {
        $this->QuantityType = $quantityType;
        return $this;
    }
}
