<?php

namespace TurkkepEFatura\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SgkInvoice StructType
 * @subpackage Structs
 */
class SgkInvoice extends AbstractStructBase
{
    /**
     * The AdditionalInvoiceType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $AdditionalInvoiceType;
    /**
     * The PeriodStartDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $PeriodStartDate;
    /**
     * The PeriodEndDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $PeriodEndDate;
    /**
     * The TaxPayerCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TaxPayerCode;
    /**
     * The TaxPayerName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TaxPayerName;
    /**
     * The FileNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FileNo;
    /**
     * Constructor method for SgkInvoice
     * @uses SgkInvoice::setAdditionalInvoiceType()
     * @uses SgkInvoice::setPeriodStartDate()
     * @uses SgkInvoice::setPeriodEndDate()
     * @uses SgkInvoice::setTaxPayerCode()
     * @uses SgkInvoice::setTaxPayerName()
     * @uses SgkInvoice::setFileNo()
     * @param string $additionalInvoiceType
     * @param string $periodStartDate
     * @param string $periodEndDate
     * @param string $taxPayerCode
     * @param string $taxPayerName
     * @param string $fileNo
     */
    public function __construct($additionalInvoiceType = null, $periodStartDate = null, $periodEndDate = null, $taxPayerCode = null, $taxPayerName = null, $fileNo = null)
    {
        $this
            ->setAdditionalInvoiceType($additionalInvoiceType)
            ->setPeriodStartDate($periodStartDate)
            ->setPeriodEndDate($periodEndDate)
            ->setTaxPayerCode($taxPayerCode)
            ->setTaxPayerName($taxPayerName)
            ->setFileNo($fileNo);
    }
    /**
     * Get AdditionalInvoiceType value
     * @return string
     */
    public function getAdditionalInvoiceType()
    {
        return $this->AdditionalInvoiceType;
    }
    /**
     * Set AdditionalInvoiceType value
     * @uses \TurkkepEFatura\EnumType\AdditionalInvoiceType::valueIsValid()
     * @uses \TurkkepEFatura\EnumType\AdditionalInvoiceType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $additionalInvoiceType
     * @return \TurkkepEFatura\StructType\SgkInvoice
     */
    public function setAdditionalInvoiceType($additionalInvoiceType = null)
    {
        // validation for constraint: enumeration
        if (!\TurkkepEFatura\EnumType\AdditionalInvoiceType::valueIsValid($additionalInvoiceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \TurkkepEFatura\EnumType\AdditionalInvoiceType', is_array($additionalInvoiceType) ? implode(', ', $additionalInvoiceType) : var_export($additionalInvoiceType, true), implode(', ', \TurkkepEFatura\EnumType\AdditionalInvoiceType::getValidValues())), __LINE__);
        }
        $this->AdditionalInvoiceType = $additionalInvoiceType;
        return $this;
    }
    /**
     * Get PeriodStartDate value
     * @return string
     */
    public function getPeriodStartDate()
    {
        return $this->PeriodStartDate;
    }
    /**
     * Set PeriodStartDate value
     * @param string $periodStartDate
     * @return \TurkkepEFatura\StructType\SgkInvoice
     */
    public function setPeriodStartDate($periodStartDate = null)
    {
        // validation for constraint: string
        if (!is_null($periodStartDate) && !is_string($periodStartDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($periodStartDate, true), gettype($periodStartDate)), __LINE__);
        }
        $this->PeriodStartDate = $periodStartDate;
        return $this;
    }
    /**
     * Get PeriodEndDate value
     * @return string
     */
    public function getPeriodEndDate()
    {
        return $this->PeriodEndDate;
    }
    /**
     * Set PeriodEndDate value
     * @param string $periodEndDate
     * @return \TurkkepEFatura\StructType\SgkInvoice
     */
    public function setPeriodEndDate($periodEndDate = null)
    {
        // validation for constraint: string
        if (!is_null($periodEndDate) && !is_string($periodEndDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($periodEndDate, true), gettype($periodEndDate)), __LINE__);
        }
        $this->PeriodEndDate = $periodEndDate;
        return $this;
    }
    /**
     * Get TaxPayerCode value
     * @return string|null
     */
    public function getTaxPayerCode()
    {
        return $this->TaxPayerCode;
    }
    /**
     * Set TaxPayerCode value
     * @param string $taxPayerCode
     * @return \TurkkepEFatura\StructType\SgkInvoice
     */
    public function setTaxPayerCode($taxPayerCode = null)
    {
        // validation for constraint: string
        if (!is_null($taxPayerCode) && !is_string($taxPayerCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxPayerCode, true), gettype($taxPayerCode)), __LINE__);
        }
        $this->TaxPayerCode = $taxPayerCode;
        return $this;
    }
    /**
     * Get TaxPayerName value
     * @return string|null
     */
    public function getTaxPayerName()
    {
        return $this->TaxPayerName;
    }
    /**
     * Set TaxPayerName value
     * @param string $taxPayerName
     * @return \TurkkepEFatura\StructType\SgkInvoice
     */
    public function setTaxPayerName($taxPayerName = null)
    {
        // validation for constraint: string
        if (!is_null($taxPayerName) && !is_string($taxPayerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxPayerName, true), gettype($taxPayerName)), __LINE__);
        }
        $this->TaxPayerName = $taxPayerName;
        return $this;
    }
    /**
     * Get FileNo value
     * @return string|null
     */
    public function getFileNo()
    {
        return $this->FileNo;
    }
    /**
     * Set FileNo value
     * @param string $fileNo
     * @return \TurkkepEFatura\StructType\SgkInvoice
     */
    public function setFileNo($fileNo = null)
    {
        // validation for constraint: string
        if (!is_null($fileNo) && !is_string($fileNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fileNo, true), gettype($fileNo)), __LINE__);
        }
        $this->FileNo = $fileNo;
        return $this;
    }
}
