<?php

namespace TurkkepEFatura\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SendInvoiceReturnType StructType
 * @subpackage Structs
 */
class SendInvoiceReturnType extends AbstractStructBase
{
    /**
     * The InvoiceId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $InvoiceId;
    /**
     * The InvoiceReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InvoiceReference;
    /**
     * Constructor method for SendInvoiceReturnType
     * @uses SendInvoiceReturnType::setInvoiceId()
     * @uses SendInvoiceReturnType::setInvoiceReference()
     * @param int $invoiceId
     * @param string $invoiceReference
     */
    public function __construct($invoiceId = null, $invoiceReference = null)
    {
        $this
            ->setInvoiceId($invoiceId)
            ->setInvoiceReference($invoiceReference);
    }
    /**
     * Get InvoiceId value
     * @return int
     */
    public function getInvoiceId()
    {
        return $this->InvoiceId;
    }
    /**
     * Set InvoiceId value
     * @param int $invoiceId
     * @return \TurkkepEFatura\StructType\SendInvoiceReturnType
     */
    public function setInvoiceId($invoiceId = null)
    {
        // validation for constraint: int
        if (!is_null($invoiceId) && !(is_int($invoiceId) || ctype_digit($invoiceId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($invoiceId, true), gettype($invoiceId)), __LINE__);
        }
        $this->InvoiceId = $invoiceId;
        return $this;
    }
    /**
     * Get InvoiceReference value
     * @return string|null
     */
    public function getInvoiceReference()
    {
        return $this->InvoiceReference;
    }
    /**
     * Set InvoiceReference value
     * @param string $invoiceReference
     * @return \TurkkepEFatura\StructType\SendInvoiceReturnType
     */
    public function setInvoiceReference($invoiceReference = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceReference) && !is_string($invoiceReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceReference, true), gettype($invoiceReference)), __LINE__);
        }
        $this->InvoiceReference = $invoiceReference;
        return $this;
    }
}
