<?php

namespace TurkkepEFatura\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SendDespatchInvoiceReturnType StructType
 * @subpackage Structs
 */
class SendDespatchInvoiceReturnType extends ReturnType
{
    /**
     * The InvoiceId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $InvoiceId;
    /**
     * The DespatchInvoiceReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DespatchInvoiceReference;
    /**
     * Constructor method for SendDespatchInvoiceReturnType
     * @uses SendDespatchInvoiceReturnType::setInvoiceId()
     * @uses SendDespatchInvoiceReturnType::setDespatchInvoiceReference()
     * @param int $invoiceId
     * @param string $despatchInvoiceReference
     */
    public function __construct($invoiceId = null, $despatchInvoiceReference = null)
    {
        $this
            ->setInvoiceId($invoiceId)
            ->setDespatchInvoiceReference($despatchInvoiceReference);
    }
    /**
     * Get InvoiceId value
     * @return int
     */
    public function getInvoiceId()
    {
        return $this->InvoiceId;
    }
    /**
     * Set InvoiceId value
     * @param int $invoiceId
     * @return \TurkkepEFatura\StructType\SendDespatchInvoiceReturnType
     */
    public function setInvoiceId($invoiceId = null)
    {
        // validation for constraint: int
        if (!is_null($invoiceId) && !(is_int($invoiceId) || ctype_digit($invoiceId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($invoiceId, true), gettype($invoiceId)), __LINE__);
        }
        $this->InvoiceId = $invoiceId;
        return $this;
    }
    /**
     * Get DespatchInvoiceReference value
     * @return string|null
     */
    public function getDespatchInvoiceReference()
    {
        return $this->DespatchInvoiceReference;
    }
    /**
     * Set DespatchInvoiceReference value
     * @param string $despatchInvoiceReference
     * @return \TurkkepEFatura\StructType\SendDespatchInvoiceReturnType
     */
    public function setDespatchInvoiceReference($despatchInvoiceReference = null)
    {
        // validation for constraint: string
        if (!is_null($despatchInvoiceReference) && !is_string($despatchInvoiceReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($despatchInvoiceReference, true), gettype($despatchInvoiceReference)), __LINE__);
        }
        $this->DespatchInvoiceReference = $despatchInvoiceReference;
        return $this;
    }
}
