<?php

namespace TurkkepEFatura\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ResponseType StructType
 * @subpackage Structs
 */
class ResponseType extends AbstractStructBase
{
    /**
     * The ReferenceID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:ReferenceID
     * @var \TurkkepEFatura\StructType\ReferenceIDType
     */
    public $ReferenceID;
    /**
     * The ResponseCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:ResponseCode
     * @var \TurkkepEFatura\StructType\ResponseCodeType
     */
    public $ResponseCode;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: s3:Description
     * @var \TurkkepEFatura\StructType\DescriptionType[]
     */
    public $Description;
    /**
     * Constructor method for ResponseType
     * @uses ResponseType::setReferenceID()
     * @uses ResponseType::setResponseCode()
     * @uses ResponseType::setDescription()
     * @param \TurkkepEFatura\StructType\ReferenceIDType $referenceID
     * @param \TurkkepEFatura\StructType\ResponseCodeType $responseCode
     * @param \TurkkepEFatura\StructType\DescriptionType[] $description
     */
    public function __construct(\TurkkepEFatura\StructType\ReferenceIDType $referenceID = null, \TurkkepEFatura\StructType\ResponseCodeType $responseCode = null, array $description = array())
    {
        $this
            ->setReferenceID($referenceID)
            ->setResponseCode($responseCode)
            ->setDescription($description);
    }
    /**
     * Get ReferenceID value
     * @return \TurkkepEFatura\StructType\ReferenceIDType|null
     */
    public function getReferenceID()
    {
        return $this->ReferenceID;
    }
    /**
     * Set ReferenceID value
     * @param \TurkkepEFatura\StructType\ReferenceIDType $referenceID
     * @return \TurkkepEFatura\StructType\ResponseType
     */
    public function setReferenceID(\TurkkepEFatura\StructType\ReferenceIDType $referenceID = null)
    {
        $this->ReferenceID = $referenceID;
        return $this;
    }
    /**
     * Get ResponseCode value
     * @return \TurkkepEFatura\StructType\ResponseCodeType|null
     */
    public function getResponseCode()
    {
        return $this->ResponseCode;
    }
    /**
     * Set ResponseCode value
     * @param \TurkkepEFatura\StructType\ResponseCodeType $responseCode
     * @return \TurkkepEFatura\StructType\ResponseType
     */
    public function setResponseCode(\TurkkepEFatura\StructType\ResponseCodeType $responseCode = null)
    {
        $this->ResponseCode = $responseCode;
        return $this;
    }
    /**
     * Get Description value
     * @return \TurkkepEFatura\StructType\DescriptionType[]|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * This method is responsible for validating the values passed to the setDescription method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDescription method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDescriptionForArrayConstraintsFromSetDescription(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $responseTypeDescriptionItem) {
            // validation for constraint: itemType
            if (!$responseTypeDescriptionItem instanceof \TurkkepEFatura\StructType\DescriptionType) {
                $invalidValues[] = is_object($responseTypeDescriptionItem) ? get_class($responseTypeDescriptionItem) : sprintf('%s(%s)', gettype($responseTypeDescriptionItem), var_export($responseTypeDescriptionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Description property can only contain items of type \TurkkepEFatura\StructType\DescriptionType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Description value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\DescriptionType[] $description
     * @return \TurkkepEFatura\StructType\ResponseType
     */
    public function setDescription(array $description = array())
    {
        // validation for constraint: array
        if ('' !== ($descriptionArrayErrorMessage = self::validateDescriptionForArrayConstraintsFromSetDescription($description))) {
            throw new \InvalidArgumentException($descriptionArrayErrorMessage, __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Add item to Description value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\DescriptionType $item
     * @return \TurkkepEFatura\StructType\ResponseType
     */
    public function addToDescription(\TurkkepEFatura\StructType\DescriptionType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \TurkkepEFatura\StructType\DescriptionType) {
            throw new \InvalidArgumentException(sprintf('The Description property can only contain items of type \TurkkepEFatura\StructType\DescriptionType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Description[] = $item;
        return $this;
    }
}
