<?php

namespace TurkkepEFatura\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Representative StructType
 * @subpackage Structs
 */
class Representative extends AbstractStructBase
{
    /**
     * The RepresentativeName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RepresentativeName;
    /**
     * The TaxIdNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TaxIdNo;
    /**
     * The RepresentativeAlias
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RepresentativeAlias;
    /**
     * The Country
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Country;
    /**
     * The CitySubDivision
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CitySubDivision;
    /**
     * The Street
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Street;
    /**
     * The GlobalCityName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $GlobalCityName;
    /**
     * Constructor method for Representative
     * @uses Representative::setRepresentativeName()
     * @uses Representative::setTaxIdNo()
     * @uses Representative::setRepresentativeAlias()
     * @uses Representative::setCountry()
     * @uses Representative::setCitySubDivision()
     * @uses Representative::setStreet()
     * @uses Representative::setGlobalCityName()
     * @param string $representativeName
     * @param string $taxIdNo
     * @param string $representativeAlias
     * @param string $country
     * @param string $citySubDivision
     * @param string $street
     * @param string $globalCityName
     */
    public function __construct($representativeName = null, $taxIdNo = null, $representativeAlias = null, $country = null, $citySubDivision = null, $street = null, $globalCityName = null)
    {
        $this
            ->setRepresentativeName($representativeName)
            ->setTaxIdNo($taxIdNo)
            ->setRepresentativeAlias($representativeAlias)
            ->setCountry($country)
            ->setCitySubDivision($citySubDivision)
            ->setStreet($street)
            ->setGlobalCityName($globalCityName);
    }
    /**
     * Get RepresentativeName value
     * @return string|null
     */
    public function getRepresentativeName()
    {
        return $this->RepresentativeName;
    }
    /**
     * Set RepresentativeName value
     * @param string $representativeName
     * @return \TurkkepEFatura\StructType\Representative
     */
    public function setRepresentativeName($representativeName = null)
    {
        // validation for constraint: string
        if (!is_null($representativeName) && !is_string($representativeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($representativeName, true), gettype($representativeName)), __LINE__);
        }
        $this->RepresentativeName = $representativeName;
        return $this;
    }
    /**
     * Get TaxIdNo value
     * @return string|null
     */
    public function getTaxIdNo()
    {
        return $this->TaxIdNo;
    }
    /**
     * Set TaxIdNo value
     * @param string $taxIdNo
     * @return \TurkkepEFatura\StructType\Representative
     */
    public function setTaxIdNo($taxIdNo = null)
    {
        // validation for constraint: string
        if (!is_null($taxIdNo) && !is_string($taxIdNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxIdNo, true), gettype($taxIdNo)), __LINE__);
        }
        $this->TaxIdNo = $taxIdNo;
        return $this;
    }
    /**
     * Get RepresentativeAlias value
     * @return string|null
     */
    public function getRepresentativeAlias()
    {
        return $this->RepresentativeAlias;
    }
    /**
     * Set RepresentativeAlias value
     * @param string $representativeAlias
     * @return \TurkkepEFatura\StructType\Representative
     */
    public function setRepresentativeAlias($representativeAlias = null)
    {
        // validation for constraint: string
        if (!is_null($representativeAlias) && !is_string($representativeAlias)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($representativeAlias, true), gettype($representativeAlias)), __LINE__);
        }
        $this->RepresentativeAlias = $representativeAlias;
        return $this;
    }
    /**
     * Get Country value
     * @return string|null
     */
    public function getCountry()
    {
        return $this->Country;
    }
    /**
     * Set Country value
     * @param string $country
     * @return \TurkkepEFatura\StructType\Representative
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($country, true), gettype($country)), __LINE__);
        }
        $this->Country = $country;
        return $this;
    }
    /**
     * Get CitySubDivision value
     * @return string|null
     */
    public function getCitySubDivision()
    {
        return $this->CitySubDivision;
    }
    /**
     * Set CitySubDivision value
     * @param string $citySubDivision
     * @return \TurkkepEFatura\StructType\Representative
     */
    public function setCitySubDivision($citySubDivision = null)
    {
        // validation for constraint: string
        if (!is_null($citySubDivision) && !is_string($citySubDivision)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($citySubDivision, true), gettype($citySubDivision)), __LINE__);
        }
        $this->CitySubDivision = $citySubDivision;
        return $this;
    }
    /**
     * Get Street value
     * @return string|null
     */
    public function getStreet()
    {
        return $this->Street;
    }
    /**
     * Set Street value
     * @param string $street
     * @return \TurkkepEFatura\StructType\Representative
     */
    public function setStreet($street = null)
    {
        // validation for constraint: string
        if (!is_null($street) && !is_string($street)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($street, true), gettype($street)), __LINE__);
        }
        $this->Street = $street;
        return $this;
    }
    /**
     * Get GlobalCityName value
     * @return string|null
     */
    public function getGlobalCityName()
    {
        return $this->GlobalCityName;
    }
    /**
     * Set GlobalCityName value
     * @param string $globalCityName
     * @return \TurkkepEFatura\StructType\Representative
     */
    public function setGlobalCityName($globalCityName = null)
    {
        // validation for constraint: string
        if (!is_null($globalCityName) && !is_string($globalCityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($globalCityName, true), gettype($globalCityName)), __LINE__);
        }
        $this->GlobalCityName = $globalCityName;
        return $this;
    }
}
