<?php

namespace TurkkepEFatura\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PricingReferenceType StructType
 * @subpackage Structs
 */
class PricingReferenceType extends AbstractStructBase
{
    /**
     * The OriginalItemLocationQuantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\ItemLocationQuantityType
     */
    public $OriginalItemLocationQuantity;
    /**
     * The AlternativeConditionPrice
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\PriceType[]
     */
    public $AlternativeConditionPrice;
    /**
     * Constructor method for PricingReferenceType
     * @uses PricingReferenceType::setOriginalItemLocationQuantity()
     * @uses PricingReferenceType::setAlternativeConditionPrice()
     * @param \TurkkepEFatura\StructType\ItemLocationQuantityType $originalItemLocationQuantity
     * @param \TurkkepEFatura\StructType\PriceType[] $alternativeConditionPrice
     */
    public function __construct(\TurkkepEFatura\StructType\ItemLocationQuantityType $originalItemLocationQuantity = null, array $alternativeConditionPrice = array())
    {
        $this
            ->setOriginalItemLocationQuantity($originalItemLocationQuantity)
            ->setAlternativeConditionPrice($alternativeConditionPrice);
    }
    /**
     * Get OriginalItemLocationQuantity value
     * @return \TurkkepEFatura\StructType\ItemLocationQuantityType|null
     */
    public function getOriginalItemLocationQuantity()
    {
        return $this->OriginalItemLocationQuantity;
    }
    /**
     * Set OriginalItemLocationQuantity value
     * @param \TurkkepEFatura\StructType\ItemLocationQuantityType $originalItemLocationQuantity
     * @return \TurkkepEFatura\StructType\PricingReferenceType
     */
    public function setOriginalItemLocationQuantity(\TurkkepEFatura\StructType\ItemLocationQuantityType $originalItemLocationQuantity = null)
    {
        $this->OriginalItemLocationQuantity = $originalItemLocationQuantity;
        return $this;
    }
    /**
     * Get AlternativeConditionPrice value
     * @return \TurkkepEFatura\StructType\PriceType[]|null
     */
    public function getAlternativeConditionPrice()
    {
        return $this->AlternativeConditionPrice;
    }
    /**
     * This method is responsible for validating the values passed to the setAlternativeConditionPrice method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAlternativeConditionPrice method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAlternativeConditionPriceForArrayConstraintsFromSetAlternativeConditionPrice(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $pricingReferenceTypeAlternativeConditionPriceItem) {
            // validation for constraint: itemType
            if (!$pricingReferenceTypeAlternativeConditionPriceItem instanceof \TurkkepEFatura\StructType\PriceType) {
                $invalidValues[] = is_object($pricingReferenceTypeAlternativeConditionPriceItem) ? get_class($pricingReferenceTypeAlternativeConditionPriceItem) : sprintf('%s(%s)', gettype($pricingReferenceTypeAlternativeConditionPriceItem), var_export($pricingReferenceTypeAlternativeConditionPriceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AlternativeConditionPrice property can only contain items of type \TurkkepEFatura\StructType\PriceType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AlternativeConditionPrice value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\PriceType[] $alternativeConditionPrice
     * @return \TurkkepEFatura\StructType\PricingReferenceType
     */
    public function setAlternativeConditionPrice(array $alternativeConditionPrice = array())
    {
        // validation for constraint: array
        if ('' !== ($alternativeConditionPriceArrayErrorMessage = self::validateAlternativeConditionPriceForArrayConstraintsFromSetAlternativeConditionPrice($alternativeConditionPrice))) {
            throw new \InvalidArgumentException($alternativeConditionPriceArrayErrorMessage, __LINE__);
        }
        $this->AlternativeConditionPrice = $alternativeConditionPrice;
        return $this;
    }
    /**
     * Add item to AlternativeConditionPrice value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\PriceType $item
     * @return \TurkkepEFatura\StructType\PricingReferenceType
     */
    public function addToAlternativeConditionPrice(\TurkkepEFatura\StructType\PriceType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \TurkkepEFatura\StructType\PriceType) {
            throw new \InvalidArgumentException(sprintf('The AlternativeConditionPrice property can only contain items of type \TurkkepEFatura\StructType\PriceType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AlternativeConditionPrice[] = $item;
        return $this;
    }
}
