<?php

namespace TurkkepEFatura\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentTermsType StructType
 * @subpackage Structs
 */
class PaymentTermsType extends AbstractStructBase
{
    /**
     * The Note
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:Note
     * @var \TurkkepEFatura\StructType\NoteType
     */
    public $Note;
    /**
     * The PenaltySurchargePercent
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:PenaltySurchargePercent
     * @var \TurkkepEFatura\StructType\PenaltySurchargePercentType
     */
    public $PenaltySurchargePercent;
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:Amount
     * @var \TurkkepEFatura\StructType\AmountType
     */
    public $Amount;
    /**
     * The PenaltyAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:PenaltyAmount
     * @var \TurkkepEFatura\StructType\PenaltyAmountType
     */
    public $PenaltyAmount;
    /**
     * The PaymentDueDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:PaymentDueDate
     * @var \TurkkepEFatura\StructType\PaymentDueDateType
     */
    public $PaymentDueDate;
    /**
     * The SettlementPeriod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\PeriodType
     */
    public $SettlementPeriod;
    /**
     * Constructor method for PaymentTermsType
     * @uses PaymentTermsType::setNote()
     * @uses PaymentTermsType::setPenaltySurchargePercent()
     * @uses PaymentTermsType::setAmount()
     * @uses PaymentTermsType::setPenaltyAmount()
     * @uses PaymentTermsType::setPaymentDueDate()
     * @uses PaymentTermsType::setSettlementPeriod()
     * @param \TurkkepEFatura\StructType\NoteType $note
     * @param \TurkkepEFatura\StructType\PenaltySurchargePercentType $penaltySurchargePercent
     * @param \TurkkepEFatura\StructType\AmountType $amount
     * @param \TurkkepEFatura\StructType\PenaltyAmountType $penaltyAmount
     * @param \TurkkepEFatura\StructType\PaymentDueDateType $paymentDueDate
     * @param \TurkkepEFatura\StructType\PeriodType $settlementPeriod
     */
    public function __construct(\TurkkepEFatura\StructType\NoteType $note = null, \TurkkepEFatura\StructType\PenaltySurchargePercentType $penaltySurchargePercent = null, \TurkkepEFatura\StructType\AmountType $amount = null, \TurkkepEFatura\StructType\PenaltyAmountType $penaltyAmount = null, \TurkkepEFatura\StructType\PaymentDueDateType $paymentDueDate = null, \TurkkepEFatura\StructType\PeriodType $settlementPeriod = null)
    {
        $this
            ->setNote($note)
            ->setPenaltySurchargePercent($penaltySurchargePercent)
            ->setAmount($amount)
            ->setPenaltyAmount($penaltyAmount)
            ->setPaymentDueDate($paymentDueDate)
            ->setSettlementPeriod($settlementPeriod);
    }
    /**
     * Get Note value
     * @return \TurkkepEFatura\StructType\NoteType|null
     */
    public function getNote()
    {
        return $this->Note;
    }
    /**
     * Set Note value
     * @param \TurkkepEFatura\StructType\NoteType $note
     * @return \TurkkepEFatura\StructType\PaymentTermsType
     */
    public function setNote(\TurkkepEFatura\StructType\NoteType $note = null)
    {
        $this->Note = $note;
        return $this;
    }
    /**
     * Get PenaltySurchargePercent value
     * @return \TurkkepEFatura\StructType\PenaltySurchargePercentType|null
     */
    public function getPenaltySurchargePercent()
    {
        return $this->PenaltySurchargePercent;
    }
    /**
     * Set PenaltySurchargePercent value
     * @param \TurkkepEFatura\StructType\PenaltySurchargePercentType $penaltySurchargePercent
     * @return \TurkkepEFatura\StructType\PaymentTermsType
     */
    public function setPenaltySurchargePercent(\TurkkepEFatura\StructType\PenaltySurchargePercentType $penaltySurchargePercent = null)
    {
        $this->PenaltySurchargePercent = $penaltySurchargePercent;
        return $this;
    }
    /**
     * Get Amount value
     * @return \TurkkepEFatura\StructType\AmountType|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param \TurkkepEFatura\StructType\AmountType $amount
     * @return \TurkkepEFatura\StructType\PaymentTermsType
     */
    public function setAmount(\TurkkepEFatura\StructType\AmountType $amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get PenaltyAmount value
     * @return \TurkkepEFatura\StructType\PenaltyAmountType|null
     */
    public function getPenaltyAmount()
    {
        return $this->PenaltyAmount;
    }
    /**
     * Set PenaltyAmount value
     * @param \TurkkepEFatura\StructType\PenaltyAmountType $penaltyAmount
     * @return \TurkkepEFatura\StructType\PaymentTermsType
     */
    public function setPenaltyAmount(\TurkkepEFatura\StructType\PenaltyAmountType $penaltyAmount = null)
    {
        $this->PenaltyAmount = $penaltyAmount;
        return $this;
    }
    /**
     * Get PaymentDueDate value
     * @return \TurkkepEFatura\StructType\PaymentDueDateType|null
     */
    public function getPaymentDueDate()
    {
        return $this->PaymentDueDate;
    }
    /**
     * Set PaymentDueDate value
     * @param \TurkkepEFatura\StructType\PaymentDueDateType $paymentDueDate
     * @return \TurkkepEFatura\StructType\PaymentTermsType
     */
    public function setPaymentDueDate(\TurkkepEFatura\StructType\PaymentDueDateType $paymentDueDate = null)
    {
        $this->PaymentDueDate = $paymentDueDate;
        return $this;
    }
    /**
     * Get SettlementPeriod value
     * @return \TurkkepEFatura\StructType\PeriodType|null
     */
    public function getSettlementPeriod()
    {
        return $this->SettlementPeriod;
    }
    /**
     * Set SettlementPeriod value
     * @param \TurkkepEFatura\StructType\PeriodType $settlementPeriod
     * @return \TurkkepEFatura\StructType\PaymentTermsType
     */
    public function setSettlementPeriod(\TurkkepEFatura\StructType\PeriodType $settlementPeriod = null)
    {
        $this->SettlementPeriod = $settlementPeriod;
        return $this;
    }
}
