<?php

namespace TurkkepEFatura\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentMeansType StructType
 * @subpackage Structs
 */
class PaymentMeansType extends AbstractStructBase
{
    /**
     * The PaymentMeansCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:PaymentMeansCode
     * @var \TurkkepEFatura\StructType\PaymentMeansCodeType
     */
    public $PaymentMeansCode;
    /**
     * The PaymentDueDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:PaymentDueDate
     * @var \TurkkepEFatura\StructType\PaymentDueDateType
     */
    public $PaymentDueDate;
    /**
     * The PaymentChannelCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:PaymentChannelCode
     * @var \TurkkepEFatura\StructType\PaymentChannelCodeType
     */
    public $PaymentChannelCode;
    /**
     * The InstructionNote
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:InstructionNote
     * @var \TurkkepEFatura\StructType\InstructionNoteType
     */
    public $InstructionNote;
    /**
     * The PayerFinancialAccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\FinancialAccountType
     */
    public $PayerFinancialAccount;
    /**
     * The PayeeFinancialAccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\FinancialAccountType
     */
    public $PayeeFinancialAccount;
    /**
     * Constructor method for PaymentMeansType
     * @uses PaymentMeansType::setPaymentMeansCode()
     * @uses PaymentMeansType::setPaymentDueDate()
     * @uses PaymentMeansType::setPaymentChannelCode()
     * @uses PaymentMeansType::setInstructionNote()
     * @uses PaymentMeansType::setPayerFinancialAccount()
     * @uses PaymentMeansType::setPayeeFinancialAccount()
     * @param \TurkkepEFatura\StructType\PaymentMeansCodeType $paymentMeansCode
     * @param \TurkkepEFatura\StructType\PaymentDueDateType $paymentDueDate
     * @param \TurkkepEFatura\StructType\PaymentChannelCodeType $paymentChannelCode
     * @param \TurkkepEFatura\StructType\InstructionNoteType $instructionNote
     * @param \TurkkepEFatura\StructType\FinancialAccountType $payerFinancialAccount
     * @param \TurkkepEFatura\StructType\FinancialAccountType $payeeFinancialAccount
     */
    public function __construct(\TurkkepEFatura\StructType\PaymentMeansCodeType $paymentMeansCode = null, \TurkkepEFatura\StructType\PaymentDueDateType $paymentDueDate = null, \TurkkepEFatura\StructType\PaymentChannelCodeType $paymentChannelCode = null, \TurkkepEFatura\StructType\InstructionNoteType $instructionNote = null, \TurkkepEFatura\StructType\FinancialAccountType $payerFinancialAccount = null, \TurkkepEFatura\StructType\FinancialAccountType $payeeFinancialAccount = null)
    {
        $this
            ->setPaymentMeansCode($paymentMeansCode)
            ->setPaymentDueDate($paymentDueDate)
            ->setPaymentChannelCode($paymentChannelCode)
            ->setInstructionNote($instructionNote)
            ->setPayerFinancialAccount($payerFinancialAccount)
            ->setPayeeFinancialAccount($payeeFinancialAccount);
    }
    /**
     * Get PaymentMeansCode value
     * @return \TurkkepEFatura\StructType\PaymentMeansCodeType|null
     */
    public function getPaymentMeansCode()
    {
        return $this->PaymentMeansCode;
    }
    /**
     * Set PaymentMeansCode value
     * @param \TurkkepEFatura\StructType\PaymentMeansCodeType $paymentMeansCode
     * @return \TurkkepEFatura\StructType\PaymentMeansType
     */
    public function setPaymentMeansCode(\TurkkepEFatura\StructType\PaymentMeansCodeType $paymentMeansCode = null)
    {
        $this->PaymentMeansCode = $paymentMeansCode;
        return $this;
    }
    /**
     * Get PaymentDueDate value
     * @return \TurkkepEFatura\StructType\PaymentDueDateType|null
     */
    public function getPaymentDueDate()
    {
        return $this->PaymentDueDate;
    }
    /**
     * Set PaymentDueDate value
     * @param \TurkkepEFatura\StructType\PaymentDueDateType $paymentDueDate
     * @return \TurkkepEFatura\StructType\PaymentMeansType
     */
    public function setPaymentDueDate(\TurkkepEFatura\StructType\PaymentDueDateType $paymentDueDate = null)
    {
        $this->PaymentDueDate = $paymentDueDate;
        return $this;
    }
    /**
     * Get PaymentChannelCode value
     * @return \TurkkepEFatura\StructType\PaymentChannelCodeType|null
     */
    public function getPaymentChannelCode()
    {
        return $this->PaymentChannelCode;
    }
    /**
     * Set PaymentChannelCode value
     * @param \TurkkepEFatura\StructType\PaymentChannelCodeType $paymentChannelCode
     * @return \TurkkepEFatura\StructType\PaymentMeansType
     */
    public function setPaymentChannelCode(\TurkkepEFatura\StructType\PaymentChannelCodeType $paymentChannelCode = null)
    {
        $this->PaymentChannelCode = $paymentChannelCode;
        return $this;
    }
    /**
     * Get InstructionNote value
     * @return \TurkkepEFatura\StructType\InstructionNoteType|null
     */
    public function getInstructionNote()
    {
        return $this->InstructionNote;
    }
    /**
     * Set InstructionNote value
     * @param \TurkkepEFatura\StructType\InstructionNoteType $instructionNote
     * @return \TurkkepEFatura\StructType\PaymentMeansType
     */
    public function setInstructionNote(\TurkkepEFatura\StructType\InstructionNoteType $instructionNote = null)
    {
        $this->InstructionNote = $instructionNote;
        return $this;
    }
    /**
     * Get PayerFinancialAccount value
     * @return \TurkkepEFatura\StructType\FinancialAccountType|null
     */
    public function getPayerFinancialAccount()
    {
        return $this->PayerFinancialAccount;
    }
    /**
     * Set PayerFinancialAccount value
     * @param \TurkkepEFatura\StructType\FinancialAccountType $payerFinancialAccount
     * @return \TurkkepEFatura\StructType\PaymentMeansType
     */
    public function setPayerFinancialAccount(\TurkkepEFatura\StructType\FinancialAccountType $payerFinancialAccount = null)
    {
        $this->PayerFinancialAccount = $payerFinancialAccount;
        return $this;
    }
    /**
     * Get PayeeFinancialAccount value
     * @return \TurkkepEFatura\StructType\FinancialAccountType|null
     */
    public function getPayeeFinancialAccount()
    {
        return $this->PayeeFinancialAccount;
    }
    /**
     * Set PayeeFinancialAccount value
     * @param \TurkkepEFatura\StructType\FinancialAccountType $payeeFinancialAccount
     * @return \TurkkepEFatura\StructType\PaymentMeansType
     */
    public function setPayeeFinancialAccount(\TurkkepEFatura\StructType\FinancialAccountType $payeeFinancialAccount = null)
    {
        $this->PayeeFinancialAccount = $payeeFinancialAccount;
        return $this;
    }
}
