<?php

namespace TurkkepEFatura\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentMeans StructType
 * Meta information extracted from the WSDL
 * - type: s6:PaymentMeansType
 * @subpackage Structs
 */
class PaymentMeans extends AbstractStructBase
{
    /**
     * The PaymentDueDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $PaymentDueDate;
    /**
     * The FinancialAccountCurrency
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $FinancialAccountCurrency;
    /**
     * The PaymentMeansCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PaymentMeansCode;
    /**
     * The Note
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Note;
    /**
     * The FinancialAccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FinancialAccount;
    /**
     * The FinancialAccountNote
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FinancialAccountNote;
    /**
     * The PaymentChannelCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PaymentChannelCode;
    /**
     * Constructor method for PaymentMeans
     * @uses PaymentMeans::setPaymentDueDate()
     * @uses PaymentMeans::setFinancialAccountCurrency()
     * @uses PaymentMeans::setPaymentMeansCode()
     * @uses PaymentMeans::setNote()
     * @uses PaymentMeans::setFinancialAccount()
     * @uses PaymentMeans::setFinancialAccountNote()
     * @uses PaymentMeans::setPaymentChannelCode()
     * @param string $paymentDueDate
     * @param string $financialAccountCurrency
     * @param string $paymentMeansCode
     * @param string $note
     * @param string $financialAccount
     * @param string $financialAccountNote
     * @param string $paymentChannelCode
     */
    public function __construct($paymentDueDate = null, $financialAccountCurrency = null, $paymentMeansCode = null, $note = null, $financialAccount = null, $financialAccountNote = null, $paymentChannelCode = null)
    {
        $this
            ->setPaymentDueDate($paymentDueDate)
            ->setFinancialAccountCurrency($financialAccountCurrency)
            ->setPaymentMeansCode($paymentMeansCode)
            ->setNote($note)
            ->setFinancialAccount($financialAccount)
            ->setFinancialAccountNote($financialAccountNote)
            ->setPaymentChannelCode($paymentChannelCode);
    }
    /**
     * Get PaymentDueDate value
     * @return string
     */
    public function getPaymentDueDate()
    {
        return $this->PaymentDueDate;
    }
    /**
     * Set PaymentDueDate value
     * @param string $paymentDueDate
     * @return \TurkkepEFatura\StructType\PaymentMeans
     */
    public function setPaymentDueDate($paymentDueDate = null)
    {
        // validation for constraint: string
        if (!is_null($paymentDueDate) && !is_string($paymentDueDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentDueDate, true), gettype($paymentDueDate)), __LINE__);
        }
        $this->PaymentDueDate = $paymentDueDate;
        return $this;
    }
    /**
     * Get FinancialAccountCurrency value
     * @return string
     */
    public function getFinancialAccountCurrency()
    {
        return $this->FinancialAccountCurrency;
    }
    /**
     * Set FinancialAccountCurrency value
     * @uses \TurkkepEFatura\EnumType\CurrencyType::valueIsValid()
     * @uses \TurkkepEFatura\EnumType\CurrencyType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $financialAccountCurrency
     * @return \TurkkepEFatura\StructType\PaymentMeans
     */
    public function setFinancialAccountCurrency($financialAccountCurrency = null)
    {
        // validation for constraint: enumeration
        if (!\TurkkepEFatura\EnumType\CurrencyType::valueIsValid($financialAccountCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \TurkkepEFatura\EnumType\CurrencyType', is_array($financialAccountCurrency) ? implode(', ', $financialAccountCurrency) : var_export($financialAccountCurrency, true), implode(', ', \TurkkepEFatura\EnumType\CurrencyType::getValidValues())), __LINE__);
        }
        $this->FinancialAccountCurrency = $financialAccountCurrency;
        return $this;
    }
    /**
     * Get PaymentMeansCode value
     * @return string|null
     */
    public function getPaymentMeansCode()
    {
        return $this->PaymentMeansCode;
    }
    /**
     * Set PaymentMeansCode value
     * @param string $paymentMeansCode
     * @return \TurkkepEFatura\StructType\PaymentMeans
     */
    public function setPaymentMeansCode($paymentMeansCode = null)
    {
        // validation for constraint: string
        if (!is_null($paymentMeansCode) && !is_string($paymentMeansCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentMeansCode, true), gettype($paymentMeansCode)), __LINE__);
        }
        $this->PaymentMeansCode = $paymentMeansCode;
        return $this;
    }
    /**
     * Get Note value
     * @return string|null
     */
    public function getNote()
    {
        return $this->Note;
    }
    /**
     * Set Note value
     * @param string $note
     * @return \TurkkepEFatura\StructType\PaymentMeans
     */
    public function setNote($note = null)
    {
        // validation for constraint: string
        if (!is_null($note) && !is_string($note)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($note, true), gettype($note)), __LINE__);
        }
        $this->Note = $note;
        return $this;
    }
    /**
     * Get FinancialAccount value
     * @return string|null
     */
    public function getFinancialAccount()
    {
        return $this->FinancialAccount;
    }
    /**
     * Set FinancialAccount value
     * @param string $financialAccount
     * @return \TurkkepEFatura\StructType\PaymentMeans
     */
    public function setFinancialAccount($financialAccount = null)
    {
        // validation for constraint: string
        if (!is_null($financialAccount) && !is_string($financialAccount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($financialAccount, true), gettype($financialAccount)), __LINE__);
        }
        $this->FinancialAccount = $financialAccount;
        return $this;
    }
    /**
     * Get FinancialAccountNote value
     * @return string|null
     */
    public function getFinancialAccountNote()
    {
        return $this->FinancialAccountNote;
    }
    /**
     * Set FinancialAccountNote value
     * @param string $financialAccountNote
     * @return \TurkkepEFatura\StructType\PaymentMeans
     */
    public function setFinancialAccountNote($financialAccountNote = null)
    {
        // validation for constraint: string
        if (!is_null($financialAccountNote) && !is_string($financialAccountNote)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($financialAccountNote, true), gettype($financialAccountNote)), __LINE__);
        }
        $this->FinancialAccountNote = $financialAccountNote;
        return $this;
    }
    /**
     * Get PaymentChannelCode value
     * @return string|null
     */
    public function getPaymentChannelCode()
    {
        return $this->PaymentChannelCode;
    }
    /**
     * Set PaymentChannelCode value
     * @param string $paymentChannelCode
     * @return \TurkkepEFatura\StructType\PaymentMeans
     */
    public function setPaymentChannelCode($paymentChannelCode = null)
    {
        // validation for constraint: string
        if (!is_null($paymentChannelCode) && !is_string($paymentChannelCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentChannelCode, true), gettype($paymentChannelCode)), __LINE__);
        }
        $this->PaymentChannelCode = $paymentChannelCode;
        return $this;
    }
}
