<?php

namespace TurkkepEFatura\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Party StructType
 * @subpackage Structs
 */
class Party extends AbstractStructBase
{
    /**
     * The IsPerson
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsPerson;
    /**
     * The PartyType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \TurkkepEFatura\StructType\PartyType|String
     */
    public $PartyType;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The TaxOrIdNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TaxOrIdNo;
    /**
     * The CompanyName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CompanyName;
    /**
     * The TradeRegistrationNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TradeRegistrationNo;
    /**
     * The MERSISNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MERSISNo;
    /**
     * The PersonName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PersonName;
    /**
     * The PersonSurname
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PersonSurname;
    /**
     * The PersonMiddleName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PersonMiddleName;
    /**
     * The PersonTitle
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PersonTitle;
    /**
     * The PersonNameSuffix
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PersonNameSuffix;
    /**
     * The TaxOffice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TaxOffice;
    /**
     * The Email
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Email;
    /**
     * The FaxNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FaxNumber;
    /**
     * The MobileNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MobileNumber;
    /**
     * The PhoneNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PhoneNumber;
    /**
     * The WebSite
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $WebSite;
    /**
     * The City
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $City;
    /**
     * The CitySubDivision
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CitySubDivision;
    /**
     * The Street
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Street;
    /**
     * The BuildingName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BuildingName;
    /**
     * The BuildingNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BuildingNo;
    /**
     * The RoomNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RoomNo;
    /**
     * The ZipCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ZipCode;
    /**
     * The Region
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Region;
    /**
     * The Country
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Country;
    /**
     * The TaxRecordCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TaxRecordCode;
    /**
     * The ExtraIdentities
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \TurkkepEFatura\ArrayType\ArrayOfExtraIdentity
     */
    public $ExtraIdentities;
    /**
     * The AgentParty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\Party
     */
    public $AgentParty;
    /**
     * Constructor method for Party
     * @uses Party::setIsPerson()
     * @uses Party::setPartyType()
     * @uses Party::setName()
     * @uses Party::setTaxOrIdNo()
     * @uses Party::setCompanyName()
     * @uses Party::setTradeRegistrationNo()
     * @uses Party::setMERSISNo()
     * @uses Party::setPersonName()
     * @uses Party::setPersonSurname()
     * @uses Party::setPersonMiddleName()
     * @uses Party::setPersonTitle()
     * @uses Party::setPersonNameSuffix()
     * @uses Party::setTaxOffice()
     * @uses Party::setEmail()
     * @uses Party::setFaxNumber()
     * @uses Party::setMobileNumber()
     * @uses Party::setPhoneNumber()
     * @uses Party::setWebSite()
     * @uses Party::setCity()
     * @uses Party::setCitySubDivision()
     * @uses Party::setStreet()
     * @uses Party::setBuildingName()
     * @uses Party::setBuildingNo()
     * @uses Party::setRoomNo()
     * @uses Party::setZipCode()
     * @uses Party::setRegion()
     * @uses Party::setCountry()
     * @uses Party::setTaxRecordCode()
     * @uses Party::setExtraIdentities()
     * @uses Party::setAgentParty()
     * @param bool $isPerson
     * @param \TurkkepEFatura\StructType\PartyType $partyType
     * @param string $name
     * @param string $taxOrIdNo
     * @param string $companyName
     * @param string $tradeRegistrationNo
     * @param string $mERSISNo
     * @param string $personName
     * @param string $personSurname
     * @param string $personMiddleName
     * @param string $personTitle
     * @param string $personNameSuffix
     * @param string $taxOffice
     * @param string $email
     * @param string $faxNumber
     * @param string $mobileNumber
     * @param string $phoneNumber
     * @param string $webSite
     * @param string $city
     * @param string $citySubDivision
     * @param string $street
     * @param string $buildingName
     * @param string $buildingNo
     * @param string $roomNo
     * @param string $zipCode
     * @param string $region
     * @param string $country
     * @param string $taxRecordCode
     * @param \TurkkepEFatura\ArrayType\ArrayOfExtraIdentity $extraIdentities
     * @param \TurkkepEFatura\StructType\Party $agentParty
     */
    public function __construct($isPerson = null, \TurkkepEFatura\StructType\PartyType $partyType = null, $name = null, $taxOrIdNo = null, $companyName = null, $tradeRegistrationNo = null, $mERSISNo = null, $personName = null, $personSurname = null, $personMiddleName = null, $personTitle = null, $personNameSuffix = null, $taxOffice = null, $email = null, $faxNumber = null, $mobileNumber = null, $phoneNumber = null, $webSite = null, $city = null, $citySubDivision = null, $street = null, $buildingName = null, $buildingNo = null, $roomNo = null, $zipCode = null, $region = null, $country = null, $taxRecordCode = null, \TurkkepEFatura\ArrayType\ArrayOfExtraIdentity $extraIdentities = null, \TurkkepEFatura\StructType\Party $agentParty = null)
    {
        $this
            ->setIsPerson($isPerson)
            ->setPartyType($partyType)
            ->setName($name)
            ->setTaxOrIdNo($taxOrIdNo)
            ->setCompanyName($companyName)
            ->setTradeRegistrationNo($tradeRegistrationNo)
            ->setMERSISNo($mERSISNo)
            ->setPersonName($personName)
            ->setPersonSurname($personSurname)
            ->setPersonMiddleName($personMiddleName)
            ->setPersonTitle($personTitle)
            ->setPersonNameSuffix($personNameSuffix)
            ->setTaxOffice($taxOffice)
            ->setEmail($email)
            ->setFaxNumber($faxNumber)
            ->setMobileNumber($mobileNumber)
            ->setPhoneNumber($phoneNumber)
            ->setWebSite($webSite)
            ->setCity($city)
            ->setCitySubDivision($citySubDivision)
            ->setStreet($street)
            ->setBuildingName($buildingName)
            ->setBuildingNo($buildingNo)
            ->setRoomNo($roomNo)
            ->setZipCode($zipCode)
            ->setRegion($region)
            ->setCountry($country)
            ->setTaxRecordCode($taxRecordCode)
            ->setExtraIdentities($extraIdentities)
            ->setAgentParty($agentParty);
    }
    /**
     * Get IsPerson value
     * @return bool
     */
    public function getIsPerson()
    {
        return $this->IsPerson;
    }
    /**
     * Set IsPerson value
     * @param bool $isPerson
     * @return \TurkkepEFatura\StructType\Party
     */
    public function setIsPerson($isPerson = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPerson) && !is_bool($isPerson)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isPerson, true), gettype($isPerson)), __LINE__);
        }
        $this->IsPerson = $isPerson;
        return $this;
    }
    /**
     * Get PartyType value
     * @return \TurkkepEFatura\StructType\PartyType
     */
    public function getPartyType()
    {
        return $this->PartyType;
    }
    /**
     * Set PartyType value
     * @param \TurkkepEFatura\StructType\PartyType|String $partyType
     * @return \TurkkepEFatura\StructType\Party
     */
    public function setPartyType($partyType = null)
    {
        $this->PartyType = $partyType;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \TurkkepEFatura\StructType\Party
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get TaxOrIdNo value
     * @return string|null
     */
    public function getTaxOrIdNo()
    {
        return $this->TaxOrIdNo;
    }
    /**
     * Set TaxOrIdNo value
     * @param string $taxOrIdNo
     * @return \TurkkepEFatura\StructType\Party
     */
    public function setTaxOrIdNo($taxOrIdNo = null)
    {
        // validation for constraint: string
        if (!is_null($taxOrIdNo) && !is_string($taxOrIdNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxOrIdNo, true), gettype($taxOrIdNo)), __LINE__);
        }
        $this->TaxOrIdNo = $taxOrIdNo;
        return $this;
    }
    /**
     * Get CompanyName value
     * @return string|null
     */
    public function getCompanyName()
    {
        return $this->CompanyName;
    }
    /**
     * Set CompanyName value
     * @param string $companyName
     * @return \TurkkepEFatura\StructType\Party
     */
    public function setCompanyName($companyName = null)
    {
        // validation for constraint: string
        if (!is_null($companyName) && !is_string($companyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($companyName, true), gettype($companyName)), __LINE__);
        }
        $this->CompanyName = $companyName;
        return $this;
    }
    /**
     * Get TradeRegistrationNo value
     * @return string|null
     */
    public function getTradeRegistrationNo()
    {
        return $this->TradeRegistrationNo;
    }
    /**
     * Set TradeRegistrationNo value
     * @param string $tradeRegistrationNo
     * @return \TurkkepEFatura\StructType\Party
     */
    public function setTradeRegistrationNo($tradeRegistrationNo = null)
    {
        // validation for constraint: string
        if (!is_null($tradeRegistrationNo) && !is_string($tradeRegistrationNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tradeRegistrationNo, true), gettype($tradeRegistrationNo)), __LINE__);
        }
        $this->TradeRegistrationNo = $tradeRegistrationNo;
        return $this;
    }
    /**
     * Get MERSISNo value
     * @return string|null
     */
    public function getMERSISNo()
    {
        return $this->MERSISNo;
    }
    /**
     * Set MERSISNo value
     * @param string $mERSISNo
     * @return \TurkkepEFatura\StructType\Party
     */
    public function setMERSISNo($mERSISNo = null)
    {
        // validation for constraint: string
        if (!is_null($mERSISNo) && !is_string($mERSISNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mERSISNo, true), gettype($mERSISNo)), __LINE__);
        }
        $this->MERSISNo = $mERSISNo;
        return $this;
    }
    /**
     * Get PersonName value
     * @return string|null
     */
    public function getPersonName()
    {
        return $this->PersonName;
    }
    /**
     * Set PersonName value
     * @param string $personName
     * @return \TurkkepEFatura\StructType\Party
     */
    public function setPersonName($personName = null)
    {
        // validation for constraint: string
        if (!is_null($personName) && !is_string($personName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($personName, true), gettype($personName)), __LINE__);
        }
        $this->PersonName = $personName;
        return $this;
    }
    /**
     * Get PersonSurname value
     * @return string|null
     */
    public function getPersonSurname()
    {
        return $this->PersonSurname;
    }
    /**
     * Set PersonSurname value
     * @param string $personSurname
     * @return \TurkkepEFatura\StructType\Party
     */
    public function setPersonSurname($personSurname = null)
    {
        // validation for constraint: string
        if (!is_null($personSurname) && !is_string($personSurname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($personSurname, true), gettype($personSurname)), __LINE__);
        }
        $this->PersonSurname = $personSurname;
        return $this;
    }
    /**
     * Get PersonMiddleName value
     * @return string|null
     */
    public function getPersonMiddleName()
    {
        return $this->PersonMiddleName;
    }
    /**
     * Set PersonMiddleName value
     * @param string $personMiddleName
     * @return \TurkkepEFatura\StructType\Party
     */
    public function setPersonMiddleName($personMiddleName = null)
    {
        // validation for constraint: string
        if (!is_null($personMiddleName) && !is_string($personMiddleName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($personMiddleName, true), gettype($personMiddleName)), __LINE__);
        }
        $this->PersonMiddleName = $personMiddleName;
        return $this;
    }
    /**
     * Get PersonTitle value
     * @return string|null
     */
    public function getPersonTitle()
    {
        return $this->PersonTitle;
    }
    /**
     * Set PersonTitle value
     * @param string $personTitle
     * @return \TurkkepEFatura\StructType\Party
     */
    public function setPersonTitle($personTitle = null)
    {
        // validation for constraint: string
        if (!is_null($personTitle) && !is_string($personTitle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($personTitle, true), gettype($personTitle)), __LINE__);
        }
        $this->PersonTitle = $personTitle;
        return $this;
    }
    /**
     * Get PersonNameSuffix value
     * @return string|null
     */
    public function getPersonNameSuffix()
    {
        return $this->PersonNameSuffix;
    }
    /**
     * Set PersonNameSuffix value
     * @param string $personNameSuffix
     * @return \TurkkepEFatura\StructType\Party
     */
    public function setPersonNameSuffix($personNameSuffix = null)
    {
        // validation for constraint: string
        if (!is_null($personNameSuffix) && !is_string($personNameSuffix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($personNameSuffix, true), gettype($personNameSuffix)), __LINE__);
        }
        $this->PersonNameSuffix = $personNameSuffix;
        return $this;
    }
    /**
     * Get TaxOffice value
     * @return string|null
     */
    public function getTaxOffice()
    {
        return $this->TaxOffice;
    }
    /**
     * Set TaxOffice value
     * @param string $taxOffice
     * @return \TurkkepEFatura\StructType\Party
     */
    public function setTaxOffice($taxOffice = null)
    {
        // validation for constraint: string
        if (!is_null($taxOffice) && !is_string($taxOffice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxOffice, true), gettype($taxOffice)), __LINE__);
        }
        $this->TaxOffice = $taxOffice;
        return $this;
    }
    /**
     * Get Email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @param string $email
     * @return \TurkkepEFatura\StructType\Party
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        $this->Email = $email;
        return $this;
    }
    /**
     * Get FaxNumber value
     * @return string|null
     */
    public function getFaxNumber()
    {
        return $this->FaxNumber;
    }
    /**
     * Set FaxNumber value
     * @param string $faxNumber
     * @return \TurkkepEFatura\StructType\Party
     */
    public function setFaxNumber($faxNumber = null)
    {
        // validation for constraint: string
        if (!is_null($faxNumber) && !is_string($faxNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($faxNumber, true), gettype($faxNumber)), __LINE__);
        }
        $this->FaxNumber = $faxNumber;
        return $this;
    }
    /**
     * Get MobileNumber value
     * @return string|null
     */
    public function getMobileNumber()
    {
        return $this->MobileNumber;
    }
    /**
     * Set MobileNumber value
     * @param string $mobileNumber
     * @return \TurkkepEFatura\StructType\Party
     */
    public function setMobileNumber($mobileNumber = null)
    {
        // validation for constraint: string
        if (!is_null($mobileNumber) && !is_string($mobileNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mobileNumber, true), gettype($mobileNumber)), __LINE__);
        }
        $this->MobileNumber = $mobileNumber;
        return $this;
    }
    /**
     * Get PhoneNumber value
     * @return string|null
     */
    public function getPhoneNumber()
    {
        return $this->PhoneNumber;
    }
    /**
     * Set PhoneNumber value
     * @param string $phoneNumber
     * @return \TurkkepEFatura\StructType\Party
     */
    public function setPhoneNumber($phoneNumber = null)
    {
        // validation for constraint: string
        if (!is_null($phoneNumber) && !is_string($phoneNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phoneNumber, true), gettype($phoneNumber)), __LINE__);
        }
        $this->PhoneNumber = $phoneNumber;
        return $this;
    }
    /**
     * Get WebSite value
     * @return string|null
     */
    public function getWebSite()
    {
        return $this->WebSite;
    }
    /**
     * Set WebSite value
     * @param string $webSite
     * @return \TurkkepEFatura\StructType\Party
     */
    public function setWebSite($webSite = null)
    {
        // validation for constraint: string
        if (!is_null($webSite) && !is_string($webSite)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($webSite, true), gettype($webSite)), __LINE__);
        }
        $this->WebSite = $webSite;
        return $this;
    }
    /**
     * Get City value
     * @return string|null
     */
    public function getCity()
    {
        return $this->City;
    }
    /**
     * Set City value
     * @param string $city
     * @return \TurkkepEFatura\StructType\Party
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($city, true), gettype($city)), __LINE__);
        }
        $this->City = $city;
        return $this;
    }
    /**
     * Get CitySubDivision value
     * @return string|null
     */
    public function getCitySubDivision()
    {
        return $this->CitySubDivision;
    }
    /**
     * Set CitySubDivision value
     * @param string $citySubDivision
     * @return \TurkkepEFatura\StructType\Party
     */
    public function setCitySubDivision($citySubDivision = null)
    {
        // validation for constraint: string
        if (!is_null($citySubDivision) && !is_string($citySubDivision)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($citySubDivision, true), gettype($citySubDivision)), __LINE__);
        }
        $this->CitySubDivision = $citySubDivision;
        return $this;
    }
    /**
     * Get Street value
     * @return string|null
     */
    public function getStreet()
    {
        return $this->Street;
    }
    /**
     * Set Street value
     * @param string $street
     * @return \TurkkepEFatura\StructType\Party
     */
    public function setStreet($street = null)
    {
        // validation for constraint: string
        if (!is_null($street) && !is_string($street)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($street, true), gettype($street)), __LINE__);
        }
        $this->Street = $street;
        return $this;
    }
    /**
     * Get BuildingName value
     * @return string|null
     */
    public function getBuildingName()
    {
        return $this->BuildingName;
    }
    /**
     * Set BuildingName value
     * @param string $buildingName
     * @return \TurkkepEFatura\StructType\Party
     */
    public function setBuildingName($buildingName = null)
    {
        // validation for constraint: string
        if (!is_null($buildingName) && !is_string($buildingName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($buildingName, true), gettype($buildingName)), __LINE__);
        }
        $this->BuildingName = $buildingName;
        return $this;
    }
    /**
     * Get BuildingNo value
     * @return string|null
     */
    public function getBuildingNo()
    {
        return $this->BuildingNo;
    }
    /**
     * Set BuildingNo value
     * @param string $buildingNo
     * @return \TurkkepEFatura\StructType\Party
     */
    public function setBuildingNo($buildingNo = null)
    {
        // validation for constraint: string
        if (!is_null($buildingNo) && !is_string($buildingNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($buildingNo, true), gettype($buildingNo)), __LINE__);
        }
        $this->BuildingNo = $buildingNo;
        return $this;
    }
    /**
     * Get RoomNo value
     * @return string|null
     */
    public function getRoomNo()
    {
        return $this->RoomNo;
    }
    /**
     * Set RoomNo value
     * @param string $roomNo
     * @return \TurkkepEFatura\StructType\Party
     */
    public function setRoomNo($roomNo = null)
    {
        // validation for constraint: string
        if (!is_null($roomNo) && !is_string($roomNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($roomNo, true), gettype($roomNo)), __LINE__);
        }
        $this->RoomNo = $roomNo;
        return $this;
    }
    /**
     * Get ZipCode value
     * @return string|null
     */
    public function getZipCode()
    {
        return $this->ZipCode;
    }
    /**
     * Set ZipCode value
     * @param string $zipCode
     * @return \TurkkepEFatura\StructType\Party
     */
    public function setZipCode($zipCode = null)
    {
        // validation for constraint: string
        if (!is_null($zipCode) && !is_string($zipCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($zipCode, true), gettype($zipCode)), __LINE__);
        }
        $this->ZipCode = $zipCode;
        return $this;
    }
    /**
     * Get Region value
     * @return string|null
     */
    public function getRegion()
    {
        return $this->Region;
    }
    /**
     * Set Region value
     * @param string $region
     * @return \TurkkepEFatura\StructType\Party
     */
    public function setRegion($region = null)
    {
        // validation for constraint: string
        if (!is_null($region) && !is_string($region)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($region, true), gettype($region)), __LINE__);
        }
        $this->Region = $region;
        return $this;
    }
    /**
     * Get Country value
     * @return string|null
     */
    public function getCountry()
    {
        return $this->Country;
    }
    /**
     * Set Country value
     * @param string $country
     * @return \TurkkepEFatura\StructType\Party
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($country, true), gettype($country)), __LINE__);
        }
        $this->Country = $country;
        return $this;
    }
    /**
     * Get TaxRecordCode value
     * @return string|null
     */
    public function getTaxRecordCode()
    {
        return $this->TaxRecordCode;
    }
    /**
     * Set TaxRecordCode value
     * @param string $taxRecordCode
     * @return \TurkkepEFatura\StructType\Party
     */
    public function setTaxRecordCode($taxRecordCode = null)
    {
        // validation for constraint: string
        if (!is_null($taxRecordCode) && !is_string($taxRecordCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxRecordCode, true), gettype($taxRecordCode)), __LINE__);
        }
        $this->TaxRecordCode = $taxRecordCode;
        return $this;
    }
    /**
     * Get ExtraIdentities value
     * @return \TurkkepEFatura\ArrayType\ArrayOfExtraIdentity|null
     */
    public function getExtraIdentities()
    {
        return $this->ExtraIdentities;
    }
    /**
     * Set ExtraIdentities value
     * @param \TurkkepEFatura\ArrayType\ArrayOfExtraIdentity $extraIdentities
     * @return \TurkkepEFatura\StructType\Party
     */
    public function setExtraIdentities(\TurkkepEFatura\ArrayType\ArrayOfExtraIdentity $extraIdentities = null)
    {
        $this->ExtraIdentities = $extraIdentities;
        return $this;
    }
    /**
     * Get AgentParty value
     * @return \TurkkepEFatura\StructType\Party|null
     */
    public function getAgentParty()
    {
        return $this->AgentParty;
    }
    /**
     * Set AgentParty value
     * @param \TurkkepEFatura\StructType\Party $agentParty
     * @return \TurkkepEFatura\StructType\Party
     */
    public function setAgentParty(\TurkkepEFatura\StructType\Party $agentParty = null)
    {
        $this->AgentParty = $agentParty;
        return $this;
    }
}
