<?php

namespace TurkkepEFatura\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PackageType StructType
 * @subpackage Structs
 */
class PackageType extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:ID
     * @var \TurkkepEFatura\StructType\IDType
     */
    public $ID;
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:Quantity
     * @var \TurkkepEFatura\StructType\QuantityType
     */
    public $Quantity;
    /**
     * The ReturnableMaterialIndicator
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:ReturnableMaterialIndicator
     * @var \TurkkepEFatura\StructType\ReturnableMaterialIndicatorType
     */
    public $ReturnableMaterialIndicator;
    /**
     * The PackageLevelCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:PackageLevelCode
     * @var \TurkkepEFatura\StructType\PackageLevelCodeType
     */
    public $PackageLevelCode;
    /**
     * The PackagingTypeCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:PackagingTypeCode
     * @var \TurkkepEFatura\StructType\PackagingTypeCodeType
     */
    public $PackagingTypeCode;
    /**
     * The PackingMaterial
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: s3:PackingMaterial
     * @var \TurkkepEFatura\StructType\PackingMaterialType[]
     */
    public $PackingMaterial;
    /**
     * The ContainedPackage
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\PackageType[]
     */
    public $ContainedPackage;
    /**
     * The GoodsItem
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\GoodsItemType[]
     */
    public $GoodsItem;
    /**
     * The MeasurementDimension
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\DimensionType[]
     */
    public $MeasurementDimension;
    /**
     * Constructor method for PackageType
     * @uses PackageType::setID()
     * @uses PackageType::setQuantity()
     * @uses PackageType::setReturnableMaterialIndicator()
     * @uses PackageType::setPackageLevelCode()
     * @uses PackageType::setPackagingTypeCode()
     * @uses PackageType::setPackingMaterial()
     * @uses PackageType::setContainedPackage()
     * @uses PackageType::setGoodsItem()
     * @uses PackageType::setMeasurementDimension()
     * @param \TurkkepEFatura\StructType\IDType $iD
     * @param \TurkkepEFatura\StructType\QuantityType $quantity
     * @param \TurkkepEFatura\StructType\ReturnableMaterialIndicatorType $returnableMaterialIndicator
     * @param \TurkkepEFatura\StructType\PackageLevelCodeType $packageLevelCode
     * @param \TurkkepEFatura\StructType\PackagingTypeCodeType $packagingTypeCode
     * @param \TurkkepEFatura\StructType\PackingMaterialType[] $packingMaterial
     * @param \TurkkepEFatura\StructType\PackageType[] $containedPackage
     * @param \TurkkepEFatura\StructType\GoodsItemType[] $goodsItem
     * @param \TurkkepEFatura\StructType\DimensionType[] $measurementDimension
     */
    public function __construct(\TurkkepEFatura\StructType\IDType $iD = null, \TurkkepEFatura\StructType\QuantityType $quantity = null, \TurkkepEFatura\StructType\ReturnableMaterialIndicatorType $returnableMaterialIndicator = null, \TurkkepEFatura\StructType\PackageLevelCodeType $packageLevelCode = null, \TurkkepEFatura\StructType\PackagingTypeCodeType $packagingTypeCode = null, array $packingMaterial = array(), array $containedPackage = array(), array $goodsItem = array(), array $measurementDimension = array())
    {
        $this
            ->setID($iD)
            ->setQuantity($quantity)
            ->setReturnableMaterialIndicator($returnableMaterialIndicator)
            ->setPackageLevelCode($packageLevelCode)
            ->setPackagingTypeCode($packagingTypeCode)
            ->setPackingMaterial($packingMaterial)
            ->setContainedPackage($containedPackage)
            ->setGoodsItem($goodsItem)
            ->setMeasurementDimension($measurementDimension);
    }
    /**
     * Get ID value
     * @return \TurkkepEFatura\StructType\IDType|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param \TurkkepEFatura\StructType\IDType $iD
     * @return \TurkkepEFatura\StructType\PackageType
     */
    public function setID(\TurkkepEFatura\StructType\IDType $iD = null)
    {
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Quantity value
     * @return \TurkkepEFatura\StructType\QuantityType|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param \TurkkepEFatura\StructType\QuantityType $quantity
     * @return \TurkkepEFatura\StructType\PackageType
     */
    public function setQuantity(\TurkkepEFatura\StructType\QuantityType $quantity = null)
    {
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get ReturnableMaterialIndicator value
     * @return \TurkkepEFatura\StructType\ReturnableMaterialIndicatorType|null
     */
    public function getReturnableMaterialIndicator()
    {
        return $this->ReturnableMaterialIndicator;
    }
    /**
     * Set ReturnableMaterialIndicator value
     * @param \TurkkepEFatura\StructType\ReturnableMaterialIndicatorType $returnableMaterialIndicator
     * @return \TurkkepEFatura\StructType\PackageType
     */
    public function setReturnableMaterialIndicator(\TurkkepEFatura\StructType\ReturnableMaterialIndicatorType $returnableMaterialIndicator = null)
    {
        $this->ReturnableMaterialIndicator = $returnableMaterialIndicator;
        return $this;
    }
    /**
     * Get PackageLevelCode value
     * @return \TurkkepEFatura\StructType\PackageLevelCodeType|null
     */
    public function getPackageLevelCode()
    {
        return $this->PackageLevelCode;
    }
    /**
     * Set PackageLevelCode value
     * @param \TurkkepEFatura\StructType\PackageLevelCodeType $packageLevelCode
     * @return \TurkkepEFatura\StructType\PackageType
     */
    public function setPackageLevelCode(\TurkkepEFatura\StructType\PackageLevelCodeType $packageLevelCode = null)
    {
        $this->PackageLevelCode = $packageLevelCode;
        return $this;
    }
    /**
     * Get PackagingTypeCode value
     * @return \TurkkepEFatura\StructType\PackagingTypeCodeType|null
     */
    public function getPackagingTypeCode()
    {
        return $this->PackagingTypeCode;
    }
    /**
     * Set PackagingTypeCode value
     * @param \TurkkepEFatura\StructType\PackagingTypeCodeType $packagingTypeCode
     * @return \TurkkepEFatura\StructType\PackageType
     */
    public function setPackagingTypeCode(\TurkkepEFatura\StructType\PackagingTypeCodeType $packagingTypeCode = null)
    {
        $this->PackagingTypeCode = $packagingTypeCode;
        return $this;
    }
    /**
     * Get PackingMaterial value
     * @return \TurkkepEFatura\StructType\PackingMaterialType[]|null
     */
    public function getPackingMaterial()
    {
        return $this->PackingMaterial;
    }
    /**
     * This method is responsible for validating the values passed to the setPackingMaterial method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPackingMaterial method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePackingMaterialForArrayConstraintsFromSetPackingMaterial(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $packageTypePackingMaterialItem) {
            // validation for constraint: itemType
            if (!$packageTypePackingMaterialItem instanceof \TurkkepEFatura\StructType\PackingMaterialType) {
                $invalidValues[] = is_object($packageTypePackingMaterialItem) ? get_class($packageTypePackingMaterialItem) : sprintf('%s(%s)', gettype($packageTypePackingMaterialItem), var_export($packageTypePackingMaterialItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PackingMaterial property can only contain items of type \TurkkepEFatura\StructType\PackingMaterialType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PackingMaterial value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\PackingMaterialType[] $packingMaterial
     * @return \TurkkepEFatura\StructType\PackageType
     */
    public function setPackingMaterial(array $packingMaterial = array())
    {
        // validation for constraint: array
        if ('' !== ($packingMaterialArrayErrorMessage = self::validatePackingMaterialForArrayConstraintsFromSetPackingMaterial($packingMaterial))) {
            throw new \InvalidArgumentException($packingMaterialArrayErrorMessage, __LINE__);
        }
        $this->PackingMaterial = $packingMaterial;
        return $this;
    }
    /**
     * Add item to PackingMaterial value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\PackingMaterialType $item
     * @return \TurkkepEFatura\StructType\PackageType
     */
    public function addToPackingMaterial(\TurkkepEFatura\StructType\PackingMaterialType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \TurkkepEFatura\StructType\PackingMaterialType) {
            throw new \InvalidArgumentException(sprintf('The PackingMaterial property can only contain items of type \TurkkepEFatura\StructType\PackingMaterialType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PackingMaterial[] = $item;
        return $this;
    }
    /**
     * Get ContainedPackage value
     * @return \TurkkepEFatura\StructType\PackageType[]|null
     */
    public function getContainedPackage()
    {
        return $this->ContainedPackage;
    }
    /**
     * This method is responsible for validating the values passed to the setContainedPackage method
     * This method is willingly generated in order to preserve the one-line inline validation within the setContainedPackage method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateContainedPackageForArrayConstraintsFromSetContainedPackage(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $packageTypeContainedPackageItem) {
            // validation for constraint: itemType
            if (!$packageTypeContainedPackageItem instanceof \TurkkepEFatura\StructType\PackageType) {
                $invalidValues[] = is_object($packageTypeContainedPackageItem) ? get_class($packageTypeContainedPackageItem) : sprintf('%s(%s)', gettype($packageTypeContainedPackageItem), var_export($packageTypeContainedPackageItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ContainedPackage property can only contain items of type \TurkkepEFatura\StructType\PackageType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ContainedPackage value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\PackageType[] $containedPackage
     * @return \TurkkepEFatura\StructType\PackageType
     */
    public function setContainedPackage(array $containedPackage = array())
    {
        // validation for constraint: array
        if ('' !== ($containedPackageArrayErrorMessage = self::validateContainedPackageForArrayConstraintsFromSetContainedPackage($containedPackage))) {
            throw new \InvalidArgumentException($containedPackageArrayErrorMessage, __LINE__);
        }
        $this->ContainedPackage = $containedPackage;
        return $this;
    }
    /**
     * Add item to ContainedPackage value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\PackageType $item
     * @return \TurkkepEFatura\StructType\PackageType
     */
    public function addToContainedPackage(\TurkkepEFatura\StructType\PackageType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \TurkkepEFatura\StructType\PackageType) {
            throw new \InvalidArgumentException(sprintf('The ContainedPackage property can only contain items of type \TurkkepEFatura\StructType\PackageType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ContainedPackage[] = $item;
        return $this;
    }
    /**
     * Get GoodsItem value
     * @return \TurkkepEFatura\StructType\GoodsItemType[]|null
     */
    public function getGoodsItem()
    {
        return $this->GoodsItem;
    }
    /**
     * This method is responsible for validating the values passed to the setGoodsItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGoodsItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGoodsItemForArrayConstraintsFromSetGoodsItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $packageTypeGoodsItemItem) {
            // validation for constraint: itemType
            if (!$packageTypeGoodsItemItem instanceof \TurkkepEFatura\StructType\GoodsItemType) {
                $invalidValues[] = is_object($packageTypeGoodsItemItem) ? get_class($packageTypeGoodsItemItem) : sprintf('%s(%s)', gettype($packageTypeGoodsItemItem), var_export($packageTypeGoodsItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The GoodsItem property can only contain items of type \TurkkepEFatura\StructType\GoodsItemType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set GoodsItem value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\GoodsItemType[] $goodsItem
     * @return \TurkkepEFatura\StructType\PackageType
     */
    public function setGoodsItem(array $goodsItem = array())
    {
        // validation for constraint: array
        if ('' !== ($goodsItemArrayErrorMessage = self::validateGoodsItemForArrayConstraintsFromSetGoodsItem($goodsItem))) {
            throw new \InvalidArgumentException($goodsItemArrayErrorMessage, __LINE__);
        }
        $this->GoodsItem = $goodsItem;
        return $this;
    }
    /**
     * Add item to GoodsItem value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\GoodsItemType $item
     * @return \TurkkepEFatura\StructType\PackageType
     */
    public function addToGoodsItem(\TurkkepEFatura\StructType\GoodsItemType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \TurkkepEFatura\StructType\GoodsItemType) {
            throw new \InvalidArgumentException(sprintf('The GoodsItem property can only contain items of type \TurkkepEFatura\StructType\GoodsItemType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->GoodsItem[] = $item;
        return $this;
    }
    /**
     * Get MeasurementDimension value
     * @return \TurkkepEFatura\StructType\DimensionType[]|null
     */
    public function getMeasurementDimension()
    {
        return $this->MeasurementDimension;
    }
    /**
     * This method is responsible for validating the values passed to the setMeasurementDimension method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMeasurementDimension method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMeasurementDimensionForArrayConstraintsFromSetMeasurementDimension(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $packageTypeMeasurementDimensionItem) {
            // validation for constraint: itemType
            if (!$packageTypeMeasurementDimensionItem instanceof \TurkkepEFatura\StructType\DimensionType) {
                $invalidValues[] = is_object($packageTypeMeasurementDimensionItem) ? get_class($packageTypeMeasurementDimensionItem) : sprintf('%s(%s)', gettype($packageTypeMeasurementDimensionItem), var_export($packageTypeMeasurementDimensionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The MeasurementDimension property can only contain items of type \TurkkepEFatura\StructType\DimensionType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set MeasurementDimension value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\DimensionType[] $measurementDimension
     * @return \TurkkepEFatura\StructType\PackageType
     */
    public function setMeasurementDimension(array $measurementDimension = array())
    {
        // validation for constraint: array
        if ('' !== ($measurementDimensionArrayErrorMessage = self::validateMeasurementDimensionForArrayConstraintsFromSetMeasurementDimension($measurementDimension))) {
            throw new \InvalidArgumentException($measurementDimensionArrayErrorMessage, __LINE__);
        }
        $this->MeasurementDimension = $measurementDimension;
        return $this;
    }
    /**
     * Add item to MeasurementDimension value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\DimensionType $item
     * @return \TurkkepEFatura\StructType\PackageType
     */
    public function addToMeasurementDimension(\TurkkepEFatura\StructType\DimensionType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \TurkkepEFatura\StructType\DimensionType) {
            throw new \InvalidArgumentException(sprintf('The MeasurementDimension property can only contain items of type \TurkkepEFatura\StructType\DimensionType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->MeasurementDimension[] = $item;
        return $this;
    }
}
