<?php

namespace TurkkepEFatura\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderLineReferenceType StructType
 * @subpackage Structs
 */
class OrderLineReferenceType extends AbstractStructBase
{
    /**
     * The LineID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:LineID
     * @var \TurkkepEFatura\StructType\LineIDType
     */
    public $LineID;
    /**
     * The SalesOrderLineID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:SalesOrderLineID
     * @var \TurkkepEFatura\StructType\SalesOrderLineIDType
     */
    public $SalesOrderLineID;
    /**
     * The UUID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:UUID
     * @var \TurkkepEFatura\StructType\UUIDType
     */
    public $UUID;
    /**
     * The LineStatusCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:LineStatusCode
     * @var \TurkkepEFatura\StructType\LineStatusCodeType
     */
    public $LineStatusCode;
    /**
     * The OrderReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\OrderReferenceType
     */
    public $OrderReference;
    /**
     * Constructor method for OrderLineReferenceType
     * @uses OrderLineReferenceType::setLineID()
     * @uses OrderLineReferenceType::setSalesOrderLineID()
     * @uses OrderLineReferenceType::setUUID()
     * @uses OrderLineReferenceType::setLineStatusCode()
     * @uses OrderLineReferenceType::setOrderReference()
     * @param \TurkkepEFatura\StructType\LineIDType $lineID
     * @param \TurkkepEFatura\StructType\SalesOrderLineIDType $salesOrderLineID
     * @param \TurkkepEFatura\StructType\UUIDType $uUID
     * @param \TurkkepEFatura\StructType\LineStatusCodeType $lineStatusCode
     * @param \TurkkepEFatura\StructType\OrderReferenceType $orderReference
     */
    public function __construct(\TurkkepEFatura\StructType\LineIDType $lineID = null, \TurkkepEFatura\StructType\SalesOrderLineIDType $salesOrderLineID = null, \TurkkepEFatura\StructType\UUIDType $uUID = null, \TurkkepEFatura\StructType\LineStatusCodeType $lineStatusCode = null, \TurkkepEFatura\StructType\OrderReferenceType $orderReference = null)
    {
        $this
            ->setLineID($lineID)
            ->setSalesOrderLineID($salesOrderLineID)
            ->setUUID($uUID)
            ->setLineStatusCode($lineStatusCode)
            ->setOrderReference($orderReference);
    }
    /**
     * Get LineID value
     * @return \TurkkepEFatura\StructType\LineIDType|null
     */
    public function getLineID()
    {
        return $this->LineID;
    }
    /**
     * Set LineID value
     * @param \TurkkepEFatura\StructType\LineIDType $lineID
     * @return \TurkkepEFatura\StructType\OrderLineReferenceType
     */
    public function setLineID(\TurkkepEFatura\StructType\LineIDType $lineID = null)
    {
        $this->LineID = $lineID;
        return $this;
    }
    /**
     * Get SalesOrderLineID value
     * @return \TurkkepEFatura\StructType\SalesOrderLineIDType|null
     */
    public function getSalesOrderLineID()
    {
        return $this->SalesOrderLineID;
    }
    /**
     * Set SalesOrderLineID value
     * @param \TurkkepEFatura\StructType\SalesOrderLineIDType $salesOrderLineID
     * @return \TurkkepEFatura\StructType\OrderLineReferenceType
     */
    public function setSalesOrderLineID(\TurkkepEFatura\StructType\SalesOrderLineIDType $salesOrderLineID = null)
    {
        $this->SalesOrderLineID = $salesOrderLineID;
        return $this;
    }
    /**
     * Get UUID value
     * @return \TurkkepEFatura\StructType\UUIDType|null
     */
    public function getUUID()
    {
        return $this->UUID;
    }
    /**
     * Set UUID value
     * @param \TurkkepEFatura\StructType\UUIDType $uUID
     * @return \TurkkepEFatura\StructType\OrderLineReferenceType
     */
    public function setUUID(\TurkkepEFatura\StructType\UUIDType $uUID = null)
    {
        $this->UUID = $uUID;
        return $this;
    }
    /**
     * Get LineStatusCode value
     * @return \TurkkepEFatura\StructType\LineStatusCodeType|null
     */
    public function getLineStatusCode()
    {
        return $this->LineStatusCode;
    }
    /**
     * Set LineStatusCode value
     * @param \TurkkepEFatura\StructType\LineStatusCodeType $lineStatusCode
     * @return \TurkkepEFatura\StructType\OrderLineReferenceType
     */
    public function setLineStatusCode(\TurkkepEFatura\StructType\LineStatusCodeType $lineStatusCode = null)
    {
        $this->LineStatusCode = $lineStatusCode;
        return $this;
    }
    /**
     * Get OrderReference value
     * @return \TurkkepEFatura\StructType\OrderReferenceType|null
     */
    public function getOrderReference()
    {
        return $this->OrderReference;
    }
    /**
     * Set OrderReference value
     * @param \TurkkepEFatura\StructType\OrderReferenceType $orderReference
     * @return \TurkkepEFatura\StructType\OrderLineReferenceType
     */
    public function setOrderReference(\TurkkepEFatura\StructType\OrderReferenceType $orderReference = null)
    {
        $this->OrderReference = $orderReference;
        return $this;
    }
}
