<?php

namespace TurkkepEFatura\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ItemType StructType
 * @subpackage Structs
 */
class ItemType extends AbstractStructBase
{
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:Description
     * @var \TurkkepEFatura\StructType\DescriptionType
     */
    public $Description;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:Name
     * @var \TurkkepEFatura\StructType\NameType
     */
    public $Name;
    /**
     * The Keyword
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:Keyword
     * @var \TurkkepEFatura\StructType\KeywordType
     */
    public $Keyword;
    /**
     * The BrandName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:BrandName
     * @var \TurkkepEFatura\StructType\BrandNameType
     */
    public $BrandName;
    /**
     * The ModelName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:ModelName
     * @var \TurkkepEFatura\StructType\ModelNameType
     */
    public $ModelName;
    /**
     * The BuyersItemIdentification
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\ItemIdentificationType
     */
    public $BuyersItemIdentification;
    /**
     * The SellersItemIdentification
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\ItemIdentificationType
     */
    public $SellersItemIdentification;
    /**
     * The ManufacturersItemIdentification
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\ItemIdentificationType
     */
    public $ManufacturersItemIdentification;
    /**
     * The AdditionalItemIdentification
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\ItemIdentificationType[]
     */
    public $AdditionalItemIdentification;
    /**
     * The OriginCountry
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\CountryType
     */
    public $OriginCountry;
    /**
     * The CommodityClassification
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\CommodityClassificationType[]
     */
    public $CommodityClassification;
    /**
     * The ItemInstance
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\ItemInstanceType[]
     */
    public $ItemInstance;
    /**
     * Constructor method for ItemType
     * @uses ItemType::setDescription()
     * @uses ItemType::setName()
     * @uses ItemType::setKeyword()
     * @uses ItemType::setBrandName()
     * @uses ItemType::setModelName()
     * @uses ItemType::setBuyersItemIdentification()
     * @uses ItemType::setSellersItemIdentification()
     * @uses ItemType::setManufacturersItemIdentification()
     * @uses ItemType::setAdditionalItemIdentification()
     * @uses ItemType::setOriginCountry()
     * @uses ItemType::setCommodityClassification()
     * @uses ItemType::setItemInstance()
     * @param \TurkkepEFatura\StructType\DescriptionType $description
     * @param \TurkkepEFatura\StructType\NameType $name
     * @param \TurkkepEFatura\StructType\KeywordType $keyword
     * @param \TurkkepEFatura\StructType\BrandNameType $brandName
     * @param \TurkkepEFatura\StructType\ModelNameType $modelName
     * @param \TurkkepEFatura\StructType\ItemIdentificationType $buyersItemIdentification
     * @param \TurkkepEFatura\StructType\ItemIdentificationType $sellersItemIdentification
     * @param \TurkkepEFatura\StructType\ItemIdentificationType $manufacturersItemIdentification
     * @param \TurkkepEFatura\StructType\ItemIdentificationType[] $additionalItemIdentification
     * @param \TurkkepEFatura\StructType\CountryType $originCountry
     * @param \TurkkepEFatura\StructType\CommodityClassificationType[] $commodityClassification
     * @param \TurkkepEFatura\StructType\ItemInstanceType[] $itemInstance
     */
    public function __construct(\TurkkepEFatura\StructType\DescriptionType $description = null, \TurkkepEFatura\StructType\NameType $name = null, \TurkkepEFatura\StructType\KeywordType $keyword = null, \TurkkepEFatura\StructType\BrandNameType $brandName = null, \TurkkepEFatura\StructType\ModelNameType $modelName = null, \TurkkepEFatura\StructType\ItemIdentificationType $buyersItemIdentification = null, \TurkkepEFatura\StructType\ItemIdentificationType $sellersItemIdentification = null, \TurkkepEFatura\StructType\ItemIdentificationType $manufacturersItemIdentification = null, array $additionalItemIdentification = array(), \TurkkepEFatura\StructType\CountryType $originCountry = null, array $commodityClassification = array(), array $itemInstance = array())
    {
        $this
            ->setDescription($description)
            ->setName($name)
            ->setKeyword($keyword)
            ->setBrandName($brandName)
            ->setModelName($modelName)
            ->setBuyersItemIdentification($buyersItemIdentification)
            ->setSellersItemIdentification($sellersItemIdentification)
            ->setManufacturersItemIdentification($manufacturersItemIdentification)
            ->setAdditionalItemIdentification($additionalItemIdentification)
            ->setOriginCountry($originCountry)
            ->setCommodityClassification($commodityClassification)
            ->setItemInstance($itemInstance);
    }
    /**
     * Get Description value
     * @return \TurkkepEFatura\StructType\DescriptionType|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param \TurkkepEFatura\StructType\DescriptionType $description
     * @return \TurkkepEFatura\StructType\ItemType
     */
    public function setDescription(\TurkkepEFatura\StructType\DescriptionType $description = null)
    {
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Name value
     * @return \TurkkepEFatura\StructType\NameType|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param \TurkkepEFatura\StructType\NameType $name
     * @return \TurkkepEFatura\StructType\ItemType
     */
    public function setName(\TurkkepEFatura\StructType\NameType $name = null)
    {
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Keyword value
     * @return \TurkkepEFatura\StructType\KeywordType|null
     */
    public function getKeyword()
    {
        return $this->Keyword;
    }
    /**
     * Set Keyword value
     * @param \TurkkepEFatura\StructType\KeywordType $keyword
     * @return \TurkkepEFatura\StructType\ItemType
     */
    public function setKeyword(\TurkkepEFatura\StructType\KeywordType $keyword = null)
    {
        $this->Keyword = $keyword;
        return $this;
    }
    /**
     * Get BrandName value
     * @return \TurkkepEFatura\StructType\BrandNameType|null
     */
    public function getBrandName()
    {
        return $this->BrandName;
    }
    /**
     * Set BrandName value
     * @param \TurkkepEFatura\StructType\BrandNameType $brandName
     * @return \TurkkepEFatura\StructType\ItemType
     */
    public function setBrandName(\TurkkepEFatura\StructType\BrandNameType $brandName = null)
    {
        $this->BrandName = $brandName;
        return $this;
    }
    /**
     * Get ModelName value
     * @return \TurkkepEFatura\StructType\ModelNameType|null
     */
    public function getModelName()
    {
        return $this->ModelName;
    }
    /**
     * Set ModelName value
     * @param \TurkkepEFatura\StructType\ModelNameType $modelName
     * @return \TurkkepEFatura\StructType\ItemType
     */
    public function setModelName(\TurkkepEFatura\StructType\ModelNameType $modelName = null)
    {
        $this->ModelName = $modelName;
        return $this;
    }
    /**
     * Get BuyersItemIdentification value
     * @return \TurkkepEFatura\StructType\ItemIdentificationType|null
     */
    public function getBuyersItemIdentification()
    {
        return $this->BuyersItemIdentification;
    }
    /**
     * Set BuyersItemIdentification value
     * @param \TurkkepEFatura\StructType\ItemIdentificationType $buyersItemIdentification
     * @return \TurkkepEFatura\StructType\ItemType
     */
    public function setBuyersItemIdentification(\TurkkepEFatura\StructType\ItemIdentificationType $buyersItemIdentification = null)
    {
        $this->BuyersItemIdentification = $buyersItemIdentification;
        return $this;
    }
    /**
     * Get SellersItemIdentification value
     * @return \TurkkepEFatura\StructType\ItemIdentificationType|null
     */
    public function getSellersItemIdentification()
    {
        return $this->SellersItemIdentification;
    }
    /**
     * Set SellersItemIdentification value
     * @param \TurkkepEFatura\StructType\ItemIdentificationType $sellersItemIdentification
     * @return \TurkkepEFatura\StructType\ItemType
     */
    public function setSellersItemIdentification(\TurkkepEFatura\StructType\ItemIdentificationType $sellersItemIdentification = null)
    {
        $this->SellersItemIdentification = $sellersItemIdentification;
        return $this;
    }
    /**
     * Get ManufacturersItemIdentification value
     * @return \TurkkepEFatura\StructType\ItemIdentificationType|null
     */
    public function getManufacturersItemIdentification()
    {
        return $this->ManufacturersItemIdentification;
    }
    /**
     * Set ManufacturersItemIdentification value
     * @param \TurkkepEFatura\StructType\ItemIdentificationType $manufacturersItemIdentification
     * @return \TurkkepEFatura\StructType\ItemType
     */
    public function setManufacturersItemIdentification(\TurkkepEFatura\StructType\ItemIdentificationType $manufacturersItemIdentification = null)
    {
        $this->ManufacturersItemIdentification = $manufacturersItemIdentification;
        return $this;
    }
    /**
     * Get AdditionalItemIdentification value
     * @return \TurkkepEFatura\StructType\ItemIdentificationType[]|null
     */
    public function getAdditionalItemIdentification()
    {
        return $this->AdditionalItemIdentification;
    }
    /**
     * This method is responsible for validating the values passed to the setAdditionalItemIdentification method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAdditionalItemIdentification method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAdditionalItemIdentificationForArrayConstraintsFromSetAdditionalItemIdentification(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $itemTypeAdditionalItemIdentificationItem) {
            // validation for constraint: itemType
            if (!$itemTypeAdditionalItemIdentificationItem instanceof \TurkkepEFatura\StructType\ItemIdentificationType) {
                $invalidValues[] = is_object($itemTypeAdditionalItemIdentificationItem) ? get_class($itemTypeAdditionalItemIdentificationItem) : sprintf('%s(%s)', gettype($itemTypeAdditionalItemIdentificationItem), var_export($itemTypeAdditionalItemIdentificationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AdditionalItemIdentification property can only contain items of type \TurkkepEFatura\StructType\ItemIdentificationType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AdditionalItemIdentification value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\ItemIdentificationType[] $additionalItemIdentification
     * @return \TurkkepEFatura\StructType\ItemType
     */
    public function setAdditionalItemIdentification(array $additionalItemIdentification = array())
    {
        // validation for constraint: array
        if ('' !== ($additionalItemIdentificationArrayErrorMessage = self::validateAdditionalItemIdentificationForArrayConstraintsFromSetAdditionalItemIdentification($additionalItemIdentification))) {
            throw new \InvalidArgumentException($additionalItemIdentificationArrayErrorMessage, __LINE__);
        }
        $this->AdditionalItemIdentification = $additionalItemIdentification;
        return $this;
    }
    /**
     * Add item to AdditionalItemIdentification value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\ItemIdentificationType $item
     * @return \TurkkepEFatura\StructType\ItemType
     */
    public function addToAdditionalItemIdentification(\TurkkepEFatura\StructType\ItemIdentificationType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \TurkkepEFatura\StructType\ItemIdentificationType) {
            throw new \InvalidArgumentException(sprintf('The AdditionalItemIdentification property can only contain items of type \TurkkepEFatura\StructType\ItemIdentificationType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AdditionalItemIdentification[] = $item;
        return $this;
    }
    /**
     * Get OriginCountry value
     * @return \TurkkepEFatura\StructType\CountryType|null
     */
    public function getOriginCountry()
    {
        return $this->OriginCountry;
    }
    /**
     * Set OriginCountry value
     * @param \TurkkepEFatura\StructType\CountryType $originCountry
     * @return \TurkkepEFatura\StructType\ItemType
     */
    public function setOriginCountry(\TurkkepEFatura\StructType\CountryType $originCountry = null)
    {
        $this->OriginCountry = $originCountry;
        return $this;
    }
    /**
     * Get CommodityClassification value
     * @return \TurkkepEFatura\StructType\CommodityClassificationType[]|null
     */
    public function getCommodityClassification()
    {
        return $this->CommodityClassification;
    }
    /**
     * This method is responsible for validating the values passed to the setCommodityClassification method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCommodityClassification method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCommodityClassificationForArrayConstraintsFromSetCommodityClassification(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $itemTypeCommodityClassificationItem) {
            // validation for constraint: itemType
            if (!$itemTypeCommodityClassificationItem instanceof \TurkkepEFatura\StructType\CommodityClassificationType) {
                $invalidValues[] = is_object($itemTypeCommodityClassificationItem) ? get_class($itemTypeCommodityClassificationItem) : sprintf('%s(%s)', gettype($itemTypeCommodityClassificationItem), var_export($itemTypeCommodityClassificationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CommodityClassification property can only contain items of type \TurkkepEFatura\StructType\CommodityClassificationType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CommodityClassification value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\CommodityClassificationType[] $commodityClassification
     * @return \TurkkepEFatura\StructType\ItemType
     */
    public function setCommodityClassification(array $commodityClassification = array())
    {
        // validation for constraint: array
        if ('' !== ($commodityClassificationArrayErrorMessage = self::validateCommodityClassificationForArrayConstraintsFromSetCommodityClassification($commodityClassification))) {
            throw new \InvalidArgumentException($commodityClassificationArrayErrorMessage, __LINE__);
        }
        $this->CommodityClassification = $commodityClassification;
        return $this;
    }
    /**
     * Add item to CommodityClassification value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\CommodityClassificationType $item
     * @return \TurkkepEFatura\StructType\ItemType
     */
    public function addToCommodityClassification(\TurkkepEFatura\StructType\CommodityClassificationType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \TurkkepEFatura\StructType\CommodityClassificationType) {
            throw new \InvalidArgumentException(sprintf('The CommodityClassification property can only contain items of type \TurkkepEFatura\StructType\CommodityClassificationType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CommodityClassification[] = $item;
        return $this;
    }
    /**
     * Get ItemInstance value
     * @return \TurkkepEFatura\StructType\ItemInstanceType[]|null
     */
    public function getItemInstance()
    {
        return $this->ItemInstance;
    }
    /**
     * This method is responsible for validating the values passed to the setItemInstance method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItemInstance method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateItemInstanceForArrayConstraintsFromSetItemInstance(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $itemTypeItemInstanceItem) {
            // validation for constraint: itemType
            if (!$itemTypeItemInstanceItem instanceof \TurkkepEFatura\StructType\ItemInstanceType) {
                $invalidValues[] = is_object($itemTypeItemInstanceItem) ? get_class($itemTypeItemInstanceItem) : sprintf('%s(%s)', gettype($itemTypeItemInstanceItem), var_export($itemTypeItemInstanceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ItemInstance property can only contain items of type \TurkkepEFatura\StructType\ItemInstanceType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ItemInstance value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\ItemInstanceType[] $itemInstance
     * @return \TurkkepEFatura\StructType\ItemType
     */
    public function setItemInstance(array $itemInstance = array())
    {
        // validation for constraint: array
        if ('' !== ($itemInstanceArrayErrorMessage = self::validateItemInstanceForArrayConstraintsFromSetItemInstance($itemInstance))) {
            throw new \InvalidArgumentException($itemInstanceArrayErrorMessage, __LINE__);
        }
        $this->ItemInstance = $itemInstance;
        return $this;
    }
    /**
     * Add item to ItemInstance value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\ItemInstanceType $item
     * @return \TurkkepEFatura\StructType\ItemType
     */
    public function addToItemInstance(\TurkkepEFatura\StructType\ItemInstanceType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \TurkkepEFatura\StructType\ItemInstanceType) {
            throw new \InvalidArgumentException(sprintf('The ItemInstance property can only contain items of type \TurkkepEFatura\StructType\ItemInstanceType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ItemInstance[] = $item;
        return $this;
    }
}
