<?php

namespace TurkkepEFatura\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ItemInstanceType StructType
 * @subpackage Structs
 */
class ItemInstanceType extends AbstractStructBase
{
    /**
     * The ProductTraceID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:ProductTraceID
     * @var \TurkkepEFatura\StructType\ProductTraceIDType
     */
    public $ProductTraceID;
    /**
     * The ManufactureDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:ManufactureDate
     * @var \TurkkepEFatura\StructType\ManufactureDateType
     */
    public $ManufactureDate;
    /**
     * The ManufactureTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:ManufactureTime
     * @var \TurkkepEFatura\StructType\ManufactureTimeType
     */
    public $ManufactureTime;
    /**
     * The BestBeforeDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:BestBeforeDate
     * @var \TurkkepEFatura\StructType\BestBeforeDateType
     */
    public $BestBeforeDate;
    /**
     * The RegistrationID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:RegistrationID
     * @var \TurkkepEFatura\StructType\RegistrationIDType
     */
    public $RegistrationID;
    /**
     * The SerialID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:SerialID
     * @var \TurkkepEFatura\StructType\SerialIDType
     */
    public $SerialID;
    /**
     * The AdditionalItemProperty
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\ItemPropertyType[]
     */
    public $AdditionalItemProperty;
    /**
     * The LotIdentification
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\LotIdentificationType
     */
    public $LotIdentification;
    /**
     * Constructor method for ItemInstanceType
     * @uses ItemInstanceType::setProductTraceID()
     * @uses ItemInstanceType::setManufactureDate()
     * @uses ItemInstanceType::setManufactureTime()
     * @uses ItemInstanceType::setBestBeforeDate()
     * @uses ItemInstanceType::setRegistrationID()
     * @uses ItemInstanceType::setSerialID()
     * @uses ItemInstanceType::setAdditionalItemProperty()
     * @uses ItemInstanceType::setLotIdentification()
     * @param \TurkkepEFatura\StructType\ProductTraceIDType $productTraceID
     * @param \TurkkepEFatura\StructType\ManufactureDateType $manufactureDate
     * @param \TurkkepEFatura\StructType\ManufactureTimeType $manufactureTime
     * @param \TurkkepEFatura\StructType\BestBeforeDateType $bestBeforeDate
     * @param \TurkkepEFatura\StructType\RegistrationIDType $registrationID
     * @param \TurkkepEFatura\StructType\SerialIDType $serialID
     * @param \TurkkepEFatura\StructType\ItemPropertyType[] $additionalItemProperty
     * @param \TurkkepEFatura\StructType\LotIdentificationType $lotIdentification
     */
    public function __construct(\TurkkepEFatura\StructType\ProductTraceIDType $productTraceID = null, \TurkkepEFatura\StructType\ManufactureDateType $manufactureDate = null, \TurkkepEFatura\StructType\ManufactureTimeType $manufactureTime = null, \TurkkepEFatura\StructType\BestBeforeDateType $bestBeforeDate = null, \TurkkepEFatura\StructType\RegistrationIDType $registrationID = null, \TurkkepEFatura\StructType\SerialIDType $serialID = null, array $additionalItemProperty = array(), \TurkkepEFatura\StructType\LotIdentificationType $lotIdentification = null)
    {
        $this
            ->setProductTraceID($productTraceID)
            ->setManufactureDate($manufactureDate)
            ->setManufactureTime($manufactureTime)
            ->setBestBeforeDate($bestBeforeDate)
            ->setRegistrationID($registrationID)
            ->setSerialID($serialID)
            ->setAdditionalItemProperty($additionalItemProperty)
            ->setLotIdentification($lotIdentification);
    }
    /**
     * Get ProductTraceID value
     * @return \TurkkepEFatura\StructType\ProductTraceIDType|null
     */
    public function getProductTraceID()
    {
        return $this->ProductTraceID;
    }
    /**
     * Set ProductTraceID value
     * @param \TurkkepEFatura\StructType\ProductTraceIDType $productTraceID
     * @return \TurkkepEFatura\StructType\ItemInstanceType
     */
    public function setProductTraceID(\TurkkepEFatura\StructType\ProductTraceIDType $productTraceID = null)
    {
        $this->ProductTraceID = $productTraceID;
        return $this;
    }
    /**
     * Get ManufactureDate value
     * @return \TurkkepEFatura\StructType\ManufactureDateType|null
     */
    public function getManufactureDate()
    {
        return $this->ManufactureDate;
    }
    /**
     * Set ManufactureDate value
     * @param \TurkkepEFatura\StructType\ManufactureDateType $manufactureDate
     * @return \TurkkepEFatura\StructType\ItemInstanceType
     */
    public function setManufactureDate(\TurkkepEFatura\StructType\ManufactureDateType $manufactureDate = null)
    {
        $this->ManufactureDate = $manufactureDate;
        return $this;
    }
    /**
     * Get ManufactureTime value
     * @return \TurkkepEFatura\StructType\ManufactureTimeType|null
     */
    public function getManufactureTime()
    {
        return $this->ManufactureTime;
    }
    /**
     * Set ManufactureTime value
     * @param \TurkkepEFatura\StructType\ManufactureTimeType $manufactureTime
     * @return \TurkkepEFatura\StructType\ItemInstanceType
     */
    public function setManufactureTime(\TurkkepEFatura\StructType\ManufactureTimeType $manufactureTime = null)
    {
        $this->ManufactureTime = $manufactureTime;
        return $this;
    }
    /**
     * Get BestBeforeDate value
     * @return \TurkkepEFatura\StructType\BestBeforeDateType|null
     */
    public function getBestBeforeDate()
    {
        return $this->BestBeforeDate;
    }
    /**
     * Set BestBeforeDate value
     * @param \TurkkepEFatura\StructType\BestBeforeDateType $bestBeforeDate
     * @return \TurkkepEFatura\StructType\ItemInstanceType
     */
    public function setBestBeforeDate(\TurkkepEFatura\StructType\BestBeforeDateType $bestBeforeDate = null)
    {
        $this->BestBeforeDate = $bestBeforeDate;
        return $this;
    }
    /**
     * Get RegistrationID value
     * @return \TurkkepEFatura\StructType\RegistrationIDType|null
     */
    public function getRegistrationID()
    {
        return $this->RegistrationID;
    }
    /**
     * Set RegistrationID value
     * @param \TurkkepEFatura\StructType\RegistrationIDType $registrationID
     * @return \TurkkepEFatura\StructType\ItemInstanceType
     */
    public function setRegistrationID(\TurkkepEFatura\StructType\RegistrationIDType $registrationID = null)
    {
        $this->RegistrationID = $registrationID;
        return $this;
    }
    /**
     * Get SerialID value
     * @return \TurkkepEFatura\StructType\SerialIDType|null
     */
    public function getSerialID()
    {
        return $this->SerialID;
    }
    /**
     * Set SerialID value
     * @param \TurkkepEFatura\StructType\SerialIDType $serialID
     * @return \TurkkepEFatura\StructType\ItemInstanceType
     */
    public function setSerialID(\TurkkepEFatura\StructType\SerialIDType $serialID = null)
    {
        $this->SerialID = $serialID;
        return $this;
    }
    /**
     * Get AdditionalItemProperty value
     * @return \TurkkepEFatura\StructType\ItemPropertyType[]|null
     */
    public function getAdditionalItemProperty()
    {
        return $this->AdditionalItemProperty;
    }
    /**
     * This method is responsible for validating the values passed to the setAdditionalItemProperty method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAdditionalItemProperty method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAdditionalItemPropertyForArrayConstraintsFromSetAdditionalItemProperty(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $itemInstanceTypeAdditionalItemPropertyItem) {
            // validation for constraint: itemType
            if (!$itemInstanceTypeAdditionalItemPropertyItem instanceof \TurkkepEFatura\StructType\ItemPropertyType) {
                $invalidValues[] = is_object($itemInstanceTypeAdditionalItemPropertyItem) ? get_class($itemInstanceTypeAdditionalItemPropertyItem) : sprintf('%s(%s)', gettype($itemInstanceTypeAdditionalItemPropertyItem), var_export($itemInstanceTypeAdditionalItemPropertyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AdditionalItemProperty property can only contain items of type \TurkkepEFatura\StructType\ItemPropertyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AdditionalItemProperty value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\ItemPropertyType[] $additionalItemProperty
     * @return \TurkkepEFatura\StructType\ItemInstanceType
     */
    public function setAdditionalItemProperty(array $additionalItemProperty = array())
    {
        // validation for constraint: array
        if ('' !== ($additionalItemPropertyArrayErrorMessage = self::validateAdditionalItemPropertyForArrayConstraintsFromSetAdditionalItemProperty($additionalItemProperty))) {
            throw new \InvalidArgumentException($additionalItemPropertyArrayErrorMessage, __LINE__);
        }
        $this->AdditionalItemProperty = $additionalItemProperty;
        return $this;
    }
    /**
     * Add item to AdditionalItemProperty value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\ItemPropertyType $item
     * @return \TurkkepEFatura\StructType\ItemInstanceType
     */
    public function addToAdditionalItemProperty(\TurkkepEFatura\StructType\ItemPropertyType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \TurkkepEFatura\StructType\ItemPropertyType) {
            throw new \InvalidArgumentException(sprintf('The AdditionalItemProperty property can only contain items of type \TurkkepEFatura\StructType\ItemPropertyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AdditionalItemProperty[] = $item;
        return $this;
    }
    /**
     * Get LotIdentification value
     * @return \TurkkepEFatura\StructType\LotIdentificationType|null
     */
    public function getLotIdentification()
    {
        return $this->LotIdentification;
    }
    /**
     * Set LotIdentification value
     * @param \TurkkepEFatura\StructType\LotIdentificationType $lotIdentification
     * @return \TurkkepEFatura\StructType\ItemInstanceType
     */
    public function setLotIdentification(\TurkkepEFatura\StructType\LotIdentificationType $lotIdentification = null)
    {
        $this->LotIdentification = $lotIdentification;
        return $this;
    }
}
