<?php

namespace TurkkepEFatura\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvoiceReturnTypeMainOrganization StructType
 * @subpackage Structs
 */
class InvoiceReturnTypeMainOrganization extends AbstractStructBase
{
    /**
     * The InvoiceId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $InvoiceId;
    /**
     * The UUID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UUID;
    /**
     * The InvoiceReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InvoiceReference;
    /**
     * Constructor method for InvoiceReturnTypeMainOrganization
     * @uses InvoiceReturnTypeMainOrganization::setInvoiceId()
     * @uses InvoiceReturnTypeMainOrganization::setUUID()
     * @uses InvoiceReturnTypeMainOrganization::setInvoiceReference()
     * @param int $invoiceId
     * @param string $uUID
     * @param string $invoiceReference
     */
    public function __construct($invoiceId = null, $uUID = null, $invoiceReference = null)
    {
        $this
            ->setInvoiceId($invoiceId)
            ->setUUID($uUID)
            ->setInvoiceReference($invoiceReference);
    }
    /**
     * Get InvoiceId value
     * @return int
     */
    public function getInvoiceId()
    {
        return $this->InvoiceId;
    }
    /**
     * Set InvoiceId value
     * @param int $invoiceId
     * @return \TurkkepEFatura\StructType\InvoiceReturnTypeMainOrganization
     */
    public function setInvoiceId($invoiceId = null)
    {
        // validation for constraint: int
        if (!is_null($invoiceId) && !(is_int($invoiceId) || ctype_digit($invoiceId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($invoiceId, true), gettype($invoiceId)), __LINE__);
        }
        $this->InvoiceId = $invoiceId;
        return $this;
    }
    /**
     * Get UUID value
     * @return string|null
     */
    public function getUUID()
    {
        return $this->UUID;
    }
    /**
     * Set UUID value
     * @param string $uUID
     * @return \TurkkepEFatura\StructType\InvoiceReturnTypeMainOrganization
     */
    public function setUUID($uUID = null)
    {
        // validation for constraint: string
        if (!is_null($uUID) && !is_string($uUID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uUID, true), gettype($uUID)), __LINE__);
        }
        $this->UUID = $uUID;
        return $this;
    }
    /**
     * Get InvoiceReference value
     * @return string|null
     */
    public function getInvoiceReference()
    {
        return $this->InvoiceReference;
    }
    /**
     * Set InvoiceReference value
     * @param string $invoiceReference
     * @return \TurkkepEFatura\StructType\InvoiceReturnTypeMainOrganization
     */
    public function setInvoiceReference($invoiceReference = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceReference) && !is_string($invoiceReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceReference, true), gettype($invoiceReference)), __LINE__);
        }
        $this->InvoiceReference = $invoiceReference;
        return $this;
    }
}
