<?php

namespace TurkkepEFatura\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExtraIdentity StructType
 * @subpackage Structs
 */
class ExtraIdentity extends AbstractStructBase
{
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Type;
    /**
     * The Value
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Value;
    /**
     * Constructor method for ExtraIdentity
     * @uses ExtraIdentity::setType()
     * @uses ExtraIdentity::setValue()
     * @param string $type
     * @param string $value
     */
    public function __construct($type = null, $value = null)
    {
        $this
            ->setType($type)
            ->setValue($value);
    }
    /**
     * Get Type value
     * @return string
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @uses \TurkkepEFatura\EnumType\ExtraIdentityType::valueIsValid()
     * @uses \TurkkepEFatura\EnumType\ExtraIdentityType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \TurkkepEFatura\StructType\ExtraIdentity
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\TurkkepEFatura\EnumType\ExtraIdentityType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \TurkkepEFatura\EnumType\ExtraIdentityType', is_array($type) ? implode(', ', $type) : var_export($type, true), implode(', ', \TurkkepEFatura\EnumType\ExtraIdentityType::getValidValues())), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Value value
     * @return string|null
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @param string $value
     * @return \TurkkepEFatura\StructType\ExtraIdentity
     */
    public function setValue($value = null)
    {
        // validation for constraint: string
        if (!is_null($value) && !is_string($value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        $this->Value = $value;
        return $this;
    }
}
