<?php

namespace TurkkepEFatura\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DimensionType StructType
 * @subpackage Structs
 */
class DimensionType extends AbstractStructBase
{
    /**
     * The AttributeID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:AttributeID
     * @var \TurkkepEFatura\StructType\AttributeIDType
     */
    public $AttributeID;
    /**
     * The Measure
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:Measure
     * @var \TurkkepEFatura\StructType\MeasureType
     */
    public $Measure;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: s3:Description
     * @var \TurkkepEFatura\StructType\DescriptionType[]
     */
    public $Description;
    /**
     * The MinimumMeasure
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:MinimumMeasure
     * @var \TurkkepEFatura\StructType\MinimumMeasureType
     */
    public $MinimumMeasure;
    /**
     * The MaximumMeasure
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:MaximumMeasure
     * @var \TurkkepEFatura\StructType\MaximumMeasureType
     */
    public $MaximumMeasure;
    /**
     * Constructor method for DimensionType
     * @uses DimensionType::setAttributeID()
     * @uses DimensionType::setMeasure()
     * @uses DimensionType::setDescription()
     * @uses DimensionType::setMinimumMeasure()
     * @uses DimensionType::setMaximumMeasure()
     * @param \TurkkepEFatura\StructType\AttributeIDType $attributeID
     * @param \TurkkepEFatura\StructType\MeasureType $measure
     * @param \TurkkepEFatura\StructType\DescriptionType[] $description
     * @param \TurkkepEFatura\StructType\MinimumMeasureType $minimumMeasure
     * @param \TurkkepEFatura\StructType\MaximumMeasureType $maximumMeasure
     */
    public function __construct(\TurkkepEFatura\StructType\AttributeIDType $attributeID = null, \TurkkepEFatura\StructType\MeasureType $measure = null, array $description = array(), \TurkkepEFatura\StructType\MinimumMeasureType $minimumMeasure = null, \TurkkepEFatura\StructType\MaximumMeasureType $maximumMeasure = null)
    {
        $this
            ->setAttributeID($attributeID)
            ->setMeasure($measure)
            ->setDescription($description)
            ->setMinimumMeasure($minimumMeasure)
            ->setMaximumMeasure($maximumMeasure);
    }
    /**
     * Get AttributeID value
     * @return \TurkkepEFatura\StructType\AttributeIDType|null
     */
    public function getAttributeID()
    {
        return $this->AttributeID;
    }
    /**
     * Set AttributeID value
     * @param \TurkkepEFatura\StructType\AttributeIDType $attributeID
     * @return \TurkkepEFatura\StructType\DimensionType
     */
    public function setAttributeID(\TurkkepEFatura\StructType\AttributeIDType $attributeID = null)
    {
        $this->AttributeID = $attributeID;
        return $this;
    }
    /**
     * Get Measure value
     * @return \TurkkepEFatura\StructType\MeasureType|null
     */
    public function getMeasure()
    {
        return $this->Measure;
    }
    /**
     * Set Measure value
     * @param \TurkkepEFatura\StructType\MeasureType $measure
     * @return \TurkkepEFatura\StructType\DimensionType
     */
    public function setMeasure(\TurkkepEFatura\StructType\MeasureType $measure = null)
    {
        $this->Measure = $measure;
        return $this;
    }
    /**
     * Get Description value
     * @return \TurkkepEFatura\StructType\DescriptionType[]|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * This method is responsible for validating the values passed to the setDescription method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDescription method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDescriptionForArrayConstraintsFromSetDescription(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $dimensionTypeDescriptionItem) {
            // validation for constraint: itemType
            if (!$dimensionTypeDescriptionItem instanceof \TurkkepEFatura\StructType\DescriptionType) {
                $invalidValues[] = is_object($dimensionTypeDescriptionItem) ? get_class($dimensionTypeDescriptionItem) : sprintf('%s(%s)', gettype($dimensionTypeDescriptionItem), var_export($dimensionTypeDescriptionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Description property can only contain items of type \TurkkepEFatura\StructType\DescriptionType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Description value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\DescriptionType[] $description
     * @return \TurkkepEFatura\StructType\DimensionType
     */
    public function setDescription(array $description = array())
    {
        // validation for constraint: array
        if ('' !== ($descriptionArrayErrorMessage = self::validateDescriptionForArrayConstraintsFromSetDescription($description))) {
            throw new \InvalidArgumentException($descriptionArrayErrorMessage, __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Add item to Description value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\DescriptionType $item
     * @return \TurkkepEFatura\StructType\DimensionType
     */
    public function addToDescription(\TurkkepEFatura\StructType\DescriptionType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \TurkkepEFatura\StructType\DescriptionType) {
            throw new \InvalidArgumentException(sprintf('The Description property can only contain items of type \TurkkepEFatura\StructType\DescriptionType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Description[] = $item;
        return $this;
    }
    /**
     * Get MinimumMeasure value
     * @return \TurkkepEFatura\StructType\MinimumMeasureType|null
     */
    public function getMinimumMeasure()
    {
        return $this->MinimumMeasure;
    }
    /**
     * Set MinimumMeasure value
     * @param \TurkkepEFatura\StructType\MinimumMeasureType $minimumMeasure
     * @return \TurkkepEFatura\StructType\DimensionType
     */
    public function setMinimumMeasure(\TurkkepEFatura\StructType\MinimumMeasureType $minimumMeasure = null)
    {
        $this->MinimumMeasure = $minimumMeasure;
        return $this;
    }
    /**
     * Get MaximumMeasure value
     * @return \TurkkepEFatura\StructType\MaximumMeasureType|null
     */
    public function getMaximumMeasure()
    {
        return $this->MaximumMeasure;
    }
    /**
     * Set MaximumMeasure value
     * @param \TurkkepEFatura\StructType\MaximumMeasureType $maximumMeasure
     * @return \TurkkepEFatura\StructType\DimensionType
     */
    public function setMaximumMeasure(\TurkkepEFatura\StructType\MaximumMeasureType $maximumMeasure = null)
    {
        $this->MaximumMeasure = $maximumMeasure;
        return $this;
    }
}
