<?php

namespace TurkkepEFatura\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DespatchLine StructType
 * @subpackage Structs
 */
class DespatchLine extends AbstractStructBase
{
    /**
     * The DispatchLineNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DispatchLineNo;
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Quantity;
    /**
     * The QuantityType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \TurkkepEFatura\StructType\QuantityType
     */
    public $QuantityType;
    /**
     * The PriceAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $PriceAmount;
    /**
     * The ItemTotalAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $ItemTotalAmount;
    /**
     * The OutstandingQuantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $OutstandingQuantity;
    /**
     * The ItemName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ItemName;
    /**
     * The RemarkNote
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RemarkNote;
    /**
     * The OutstandingReason
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OutstandingReason;
    /**
     * The ItemID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ItemID;
    /**
     * Constructor method for DespatchLine
     * @uses DespatchLine::setDispatchLineNo()
     * @uses DespatchLine::setQuantity()
     * @uses DespatchLine::setQuantityType()
     * @uses DespatchLine::setPriceAmount()
     * @uses DespatchLine::setItemTotalAmount()
     * @uses DespatchLine::setOutstandingQuantity()
     * @uses DespatchLine::setItemName()
     * @uses DespatchLine::setRemarkNote()
     * @uses DespatchLine::setOutstandingReason()
     * @uses DespatchLine::setItemID()
     * @param int $dispatchLineNo
     * @param float $quantity
     * @param \TurkkepEFatura\StructType\QuantityType $quantityType
     * @param float $priceAmount
     * @param float $itemTotalAmount
     * @param float $outstandingQuantity
     * @param string $itemName
     * @param string $remarkNote
     * @param string $outstandingReason
     * @param string $itemID
     */
    public function __construct($dispatchLineNo = null, $quantity = null, \TurkkepEFatura\StructType\QuantityType $quantityType = null, $priceAmount = null, $itemTotalAmount = null, $outstandingQuantity = null, $itemName = null, $remarkNote = null, $outstandingReason = null, $itemID = null)
    {
        $this
            ->setDispatchLineNo($dispatchLineNo)
            ->setQuantity($quantity)
            ->setQuantityType($quantityType)
            ->setPriceAmount($priceAmount)
            ->setItemTotalAmount($itemTotalAmount)
            ->setOutstandingQuantity($outstandingQuantity)
            ->setItemName($itemName)
            ->setRemarkNote($remarkNote)
            ->setOutstandingReason($outstandingReason)
            ->setItemID($itemID);
    }
    /**
     * Get DispatchLineNo value
     * @return int
     */
    public function getDispatchLineNo()
    {
        return $this->DispatchLineNo;
    }
    /**
     * Set DispatchLineNo value
     * @param int $dispatchLineNo
     * @return \TurkkepEFatura\StructType\DespatchLine
     */
    public function setDispatchLineNo($dispatchLineNo = null)
    {
        // validation for constraint: int
        if (!is_null($dispatchLineNo) && !(is_int($dispatchLineNo) || ctype_digit($dispatchLineNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($dispatchLineNo, true), gettype($dispatchLineNo)), __LINE__);
        }
        $this->DispatchLineNo = $dispatchLineNo;
        return $this;
    }
    /**
     * Get Quantity value
     * @return float
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param float $quantity
     * @return \TurkkepEFatura\StructType\DespatchLine
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: float
        if (!is_null($quantity) && !(is_float($quantity) || is_numeric($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get QuantityType value
     * @return \TurkkepEFatura\StructType\QuantityType
     */
    public function getQuantityType()
    {
        return $this->QuantityType;
    }
    /**
     * Set QuantityType value
     * @param \TurkkepEFatura\StructType\QuantityType $quantityType
     * @return \TurkkepEFatura\StructType\DespatchLine
     */
    public function setQuantityType(\TurkkepEFatura\StructType\QuantityType $quantityType = null)
    {
        $this->QuantityType = $quantityType;
        return $this;
    }
    /**
     * Get PriceAmount value
     * @return float
     */
    public function getPriceAmount()
    {
        return $this->PriceAmount;
    }
    /**
     * Set PriceAmount value
     * @param float $priceAmount
     * @return \TurkkepEFatura\StructType\DespatchLine
     */
    public function setPriceAmount($priceAmount = null)
    {
        // validation for constraint: float
        if (!is_null($priceAmount) && !(is_float($priceAmount) || is_numeric($priceAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($priceAmount, true), gettype($priceAmount)), __LINE__);
        }
        $this->PriceAmount = $priceAmount;
        return $this;
    }
    /**
     * Get ItemTotalAmount value
     * @return float
     */
    public function getItemTotalAmount()
    {
        return $this->ItemTotalAmount;
    }
    /**
     * Set ItemTotalAmount value
     * @param float $itemTotalAmount
     * @return \TurkkepEFatura\StructType\DespatchLine
     */
    public function setItemTotalAmount($itemTotalAmount = null)
    {
        // validation for constraint: float
        if (!is_null($itemTotalAmount) && !(is_float($itemTotalAmount) || is_numeric($itemTotalAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($itemTotalAmount, true), gettype($itemTotalAmount)), __LINE__);
        }
        $this->ItemTotalAmount = $itemTotalAmount;
        return $this;
    }
    /**
     * Get OutstandingQuantity value
     * @return float
     */
    public function getOutstandingQuantity()
    {
        return $this->OutstandingQuantity;
    }
    /**
     * Set OutstandingQuantity value
     * @param float $outstandingQuantity
     * @return \TurkkepEFatura\StructType\DespatchLine
     */
    public function setOutstandingQuantity($outstandingQuantity = null)
    {
        // validation for constraint: float
        if (!is_null($outstandingQuantity) && !(is_float($outstandingQuantity) || is_numeric($outstandingQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($outstandingQuantity, true), gettype($outstandingQuantity)), __LINE__);
        }
        $this->OutstandingQuantity = $outstandingQuantity;
        return $this;
    }
    /**
     * Get ItemName value
     * @return string|null
     */
    public function getItemName()
    {
        return $this->ItemName;
    }
    /**
     * Set ItemName value
     * @param string $itemName
     * @return \TurkkepEFatura\StructType\DespatchLine
     */
    public function setItemName($itemName = null)
    {
        // validation for constraint: string
        if (!is_null($itemName) && !is_string($itemName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemName, true), gettype($itemName)), __LINE__);
        }
        $this->ItemName = $itemName;
        return $this;
    }
    /**
     * Get RemarkNote value
     * @return string|null
     */
    public function getRemarkNote()
    {
        return $this->RemarkNote;
    }
    /**
     * Set RemarkNote value
     * @param string $remarkNote
     * @return \TurkkepEFatura\StructType\DespatchLine
     */
    public function setRemarkNote($remarkNote = null)
    {
        // validation for constraint: string
        if (!is_null($remarkNote) && !is_string($remarkNote)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($remarkNote, true), gettype($remarkNote)), __LINE__);
        }
        $this->RemarkNote = $remarkNote;
        return $this;
    }
    /**
     * Get OutstandingReason value
     * @return string|null
     */
    public function getOutstandingReason()
    {
        return $this->OutstandingReason;
    }
    /**
     * Set OutstandingReason value
     * @param string $outstandingReason
     * @return \TurkkepEFatura\StructType\DespatchLine
     */
    public function setOutstandingReason($outstandingReason = null)
    {
        // validation for constraint: string
        if (!is_null($outstandingReason) && !is_string($outstandingReason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($outstandingReason, true), gettype($outstandingReason)), __LINE__);
        }
        $this->OutstandingReason = $outstandingReason;
        return $this;
    }
    /**
     * Get ItemID value
     * @return string|null
     */
    public function getItemID()
    {
        return $this->ItemID;
    }
    /**
     * Set ItemID value
     * @param string $itemID
     * @return \TurkkepEFatura\StructType\DespatchLine
     */
    public function setItemID($itemID = null)
    {
        // validation for constraint: string
        if (!is_null($itemID) && !is_string($itemID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemID, true), gettype($itemID)), __LINE__);
        }
        $this->ItemID = $itemID;
        return $this;
    }
}
