<?php

namespace TurkkepEFatura\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DespatchInvoice StructType
 * @subpackage Structs
 */
class DespatchInvoice extends AbstractStructBase
{
    /**
     * The DespatchInvoiceId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DespatchInvoiceId;
    /**
     * The Profile
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Profile;
    /**
     * The IssueDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $IssueDate;
    /**
     * The IssueTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $IssueTime;
    /**
     * The DespatchType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DespatchType;
    /**
     * The DocumentCurrency
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DocumentCurrency;
    /**
     * The PricingExchange
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $PricingExchange;
    /**
     * The TotalAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $TotalAmount;
    /**
     * The OrderDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $OrderDate;
    /**
     * The SendDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $SendDate;
    /**
     * The SendTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $SendTime;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Status;
    /**
     * The CopyIndicator
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $CopyIndicator;
    /**
     * The UUID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UUID;
    /**
     * The DispatchReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DispatchReference;
    /**
     * The CarrierTradeRegNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CarrierTradeRegNo;
    /**
     * The CarrierTitle
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CarrierTitle;
    /**
     * The LicensePlate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LicensePlate;
    /**
     * The OrderID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OrderID;
    /**
     * The CustomerParty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\Party
     */
    public $CustomerParty;
    /**
     * The SupplierParty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\Party
     */
    public $SupplierParty;
    /**
     * The TrailerPlate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TrailerPlate;
    /**
     * The EnvelopeReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EnvelopeReference;
    /**
     * The ResponseStatusCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ResponseStatusCode;
    /**
     * The ResponseDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ResponseDescription;
    /**
     * The ERPDispatch
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ERPDispatch;
    /**
     * The SenderAlias
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SenderAlias;
    /**
     * The PostboxAlias
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PostboxAlias;
    /**
     * The XSLTName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $XSLTName;
    /**
     * The Lines
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \TurkkepEFatura\ArrayType\ArrayOfDespatchLine
     */
    public $Lines;
    /**
     * The DespatchDrivers
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \TurkkepEFatura\ArrayType\ArrayOfDespatchDriver
     */
    public $DespatchDrivers;
    /**
     * The NoteList
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \TurkkepEFatura\ArrayType\ArrayOfString
     */
    public $NoteList;
    /**
     * The TrailerPlates
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \TurkkepEFatura\ArrayType\ArrayOfString
     */
    public $TrailerPlates;
    /**
     * The DispatchDeliveryParty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\DispatchDeliveryParty
     */
    public $DispatchDeliveryParty;
    /**
     * The DispatchAdditionalInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\DispatchAdditionalInfo
     */
    public $DispatchAdditionalInfo;
    /**
     * The BuyerCustomerParty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\Party
     */
    public $BuyerCustomerParty;
    /**
     * The SellerSupplierParty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\Party
     */
    public $SellerSupplierParty;
    /**
     * Constructor method for DespatchInvoice
     * @uses DespatchInvoice::setDespatchInvoiceId()
     * @uses DespatchInvoice::setProfile()
     * @uses DespatchInvoice::setIssueDate()
     * @uses DespatchInvoice::setIssueTime()
     * @uses DespatchInvoice::setDespatchType()
     * @uses DespatchInvoice::setDocumentCurrency()
     * @uses DespatchInvoice::setPricingExchange()
     * @uses DespatchInvoice::setTotalAmount()
     * @uses DespatchInvoice::setOrderDate()
     * @uses DespatchInvoice::setSendDate()
     * @uses DespatchInvoice::setSendTime()
     * @uses DespatchInvoice::setStatus()
     * @uses DespatchInvoice::setCopyIndicator()
     * @uses DespatchInvoice::setUUID()
     * @uses DespatchInvoice::setDispatchReference()
     * @uses DespatchInvoice::setCarrierTradeRegNo()
     * @uses DespatchInvoice::setCarrierTitle()
     * @uses DespatchInvoice::setLicensePlate()
     * @uses DespatchInvoice::setOrderID()
     * @uses DespatchInvoice::setCustomerParty()
     * @uses DespatchInvoice::setSupplierParty()
     * @uses DespatchInvoice::setTrailerPlate()
     * @uses DespatchInvoice::setEnvelopeReference()
     * @uses DespatchInvoice::setResponseStatusCode()
     * @uses DespatchInvoice::setResponseDescription()
     * @uses DespatchInvoice::setERPDispatch()
     * @uses DespatchInvoice::setSenderAlias()
     * @uses DespatchInvoice::setPostboxAlias()
     * @uses DespatchInvoice::setXSLTName()
     * @uses DespatchInvoice::setLines()
     * @uses DespatchInvoice::setDespatchDrivers()
     * @uses DespatchInvoice::setNoteList()
     * @uses DespatchInvoice::setTrailerPlates()
     * @uses DespatchInvoice::setDispatchDeliveryParty()
     * @uses DespatchInvoice::setDispatchAdditionalInfo()
     * @uses DespatchInvoice::setBuyerCustomerParty()
     * @uses DespatchInvoice::setSellerSupplierParty()
     * @param int $despatchInvoiceId
     * @param string $profile
     * @param string $issueDate
     * @param string $issueTime
     * @param string $despatchType
     * @param string $documentCurrency
     * @param float $pricingExchange
     * @param float $totalAmount
     * @param string $orderDate
     * @param string $sendDate
     * @param string $sendTime
     * @param int $status
     * @param bool $copyIndicator
     * @param string $uUID
     * @param string $dispatchReference
     * @param string $carrierTradeRegNo
     * @param string $carrierTitle
     * @param string $licensePlate
     * @param string $orderID
     * @param \TurkkepEFatura\StructType\Party $customerParty
     * @param \TurkkepEFatura\StructType\Party $supplierParty
     * @param string $trailerPlate
     * @param string $envelopeReference
     * @param string $responseStatusCode
     * @param string $responseDescription
     * @param string $eRPDispatch
     * @param string $senderAlias
     * @param string $postboxAlias
     * @param string $xSLTName
     * @param \TurkkepEFatura\ArrayType\ArrayOfDespatchLine $lines
     * @param \TurkkepEFatura\ArrayType\ArrayOfDespatchDriver $despatchDrivers
     * @param \TurkkepEFatura\ArrayType\ArrayOfString $noteList
     * @param \TurkkepEFatura\ArrayType\ArrayOfString $trailerPlates
     * @param \TurkkepEFatura\StructType\DispatchDeliveryParty $dispatchDeliveryParty
     * @param \TurkkepEFatura\StructType\DispatchAdditionalInfo $dispatchAdditionalInfo
     * @param \TurkkepEFatura\StructType\Party $buyerCustomerParty
     * @param \TurkkepEFatura\StructType\Party $sellerSupplierParty
     */
    public function __construct($despatchInvoiceId = null, $profile = null, $issueDate = null, $issueTime = null, $despatchType = null, $documentCurrency = null, $pricingExchange = null, $totalAmount = null, $orderDate = null, $sendDate = null, $sendTime = null, $status = null, $copyIndicator = null, $uUID = null, $dispatchReference = null, $carrierTradeRegNo = null, $carrierTitle = null, $licensePlate = null, $orderID = null, \TurkkepEFatura\StructType\Party $customerParty = null, \TurkkepEFatura\StructType\Party $supplierParty = null, $trailerPlate = null, $envelopeReference = null, $responseStatusCode = null, $responseDescription = null, $eRPDispatch = null, $senderAlias = null, $postboxAlias = null, $xSLTName = null, \TurkkepEFatura\ArrayType\ArrayOfDespatchLine $lines = null, \TurkkepEFatura\ArrayType\ArrayOfDespatchDriver $despatchDrivers = null, \TurkkepEFatura\ArrayType\ArrayOfString $noteList = null, \TurkkepEFatura\ArrayType\ArrayOfString $trailerPlates = null, \TurkkepEFatura\StructType\DispatchDeliveryParty $dispatchDeliveryParty = null, \TurkkepEFatura\StructType\DispatchAdditionalInfo $dispatchAdditionalInfo = null, \TurkkepEFatura\StructType\Party $buyerCustomerParty = null, \TurkkepEFatura\StructType\Party $sellerSupplierParty = null)
    {
        $this
            ->setDespatchInvoiceId($despatchInvoiceId)
            ->setProfile($profile)
            ->setIssueDate($issueDate)
            ->setIssueTime($issueTime)
            ->setDespatchType($despatchType)
            ->setDocumentCurrency($documentCurrency)
            ->setPricingExchange($pricingExchange)
            ->setTotalAmount($totalAmount)
            ->setOrderDate($orderDate)
            ->setSendDate($sendDate)
            ->setSendTime($sendTime)
            ->setStatus($status)
            ->setCopyIndicator($copyIndicator)
            ->setUUID($uUID)
            ->setDispatchReference($dispatchReference)
            ->setCarrierTradeRegNo($carrierTradeRegNo)
            ->setCarrierTitle($carrierTitle)
            ->setLicensePlate($licensePlate)
            ->setOrderID($orderID)
            ->setCustomerParty($customerParty)
            ->setSupplierParty($supplierParty)
            ->setTrailerPlate($trailerPlate)
            ->setEnvelopeReference($envelopeReference)
            ->setResponseStatusCode($responseStatusCode)
            ->setResponseDescription($responseDescription)
            ->setERPDispatch($eRPDispatch)
            ->setSenderAlias($senderAlias)
            ->setPostboxAlias($postboxAlias)
            ->setXSLTName($xSLTName)
            ->setLines($lines)
            ->setDespatchDrivers($despatchDrivers)
            ->setNoteList($noteList)
            ->setTrailerPlates($trailerPlates)
            ->setDispatchDeliveryParty($dispatchDeliveryParty)
            ->setDispatchAdditionalInfo($dispatchAdditionalInfo)
            ->setBuyerCustomerParty($buyerCustomerParty)
            ->setSellerSupplierParty($sellerSupplierParty);
    }
    /**
     * Get DespatchInvoiceId value
     * @return int
     */
    public function getDespatchInvoiceId()
    {
        return $this->DespatchInvoiceId;
    }
    /**
     * Set DespatchInvoiceId value
     * @param int $despatchInvoiceId
     * @return \TurkkepEFatura\StructType\DespatchInvoice
     */
    public function setDespatchInvoiceId($despatchInvoiceId = null)
    {
        // validation for constraint: int
        if (!is_null($despatchInvoiceId) && !(is_int($despatchInvoiceId) || ctype_digit($despatchInvoiceId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($despatchInvoiceId, true), gettype($despatchInvoiceId)), __LINE__);
        }
        $this->DespatchInvoiceId = $despatchInvoiceId;
        return $this;
    }
    /**
     * Get Profile value
     * @return string
     */
    public function getProfile()
    {
        return $this->Profile;
    }
    /**
     * Set Profile value
     * @uses \TurkkepEFatura\EnumType\Profile::valueIsValid()
     * @uses \TurkkepEFatura\EnumType\Profile::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $profile
     * @return \TurkkepEFatura\StructType\DespatchInvoice
     */
    public function setProfile($profile = null)
    {
        // validation for constraint: enumeration
        if (!\TurkkepEFatura\EnumType\Profile::valueIsValid($profile)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \TurkkepEFatura\EnumType\Profile', is_array($profile) ? implode(', ', $profile) : var_export($profile, true), implode(', ', \TurkkepEFatura\EnumType\Profile::getValidValues())), __LINE__);
        }
        $this->Profile = $profile;
        return $this;
    }
    /**
     * Get IssueDate value
     * @return string
     */
    public function getIssueDate()
    {
        return $this->IssueDate;
    }
    /**
     * Set IssueDate value
     * @param string $issueDate
     * @return \TurkkepEFatura\StructType\DespatchInvoice
     */
    public function setIssueDate($issueDate = null)
    {
        // validation for constraint: string
        if (!is_null($issueDate) && !is_string($issueDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($issueDate, true), gettype($issueDate)), __LINE__);
        }
        $this->IssueDate = $issueDate;
        return $this;
    }
    /**
     * Get IssueTime value
     * @return string
     */
    public function getIssueTime()
    {
        return $this->IssueTime;
    }
    /**
     * Set IssueTime value
     * @param string $issueTime
     * @return \TurkkepEFatura\StructType\DespatchInvoice
     */
    public function setIssueTime($issueTime = null)
    {
        // validation for constraint: string
        if (!is_null($issueTime) && !is_string($issueTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($issueTime, true), gettype($issueTime)), __LINE__);
        }
        $this->IssueTime = $issueTime;
        return $this;
    }
    /**
     * Get DespatchType value
     * @return string
     */
    public function getDespatchType()
    {
        return $this->DespatchType;
    }
    /**
     * Set DespatchType value
     * @uses \TurkkepEFatura\EnumType\InvoiceType::valueIsValid()
     * @uses \TurkkepEFatura\EnumType\InvoiceType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $despatchType
     * @return \TurkkepEFatura\StructType\DespatchInvoice
     */
    public function setDespatchType($despatchType = null)
    {
        // validation for constraint: enumeration
        if (!\TurkkepEFatura\EnumType\InvoiceType::valueIsValid($despatchType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \TurkkepEFatura\EnumType\InvoiceType', is_array($despatchType) ? implode(', ', $despatchType) : var_export($despatchType, true), implode(', ', \TurkkepEFatura\EnumType\InvoiceType::getValidValues())), __LINE__);
        }
        $this->DespatchType = $despatchType;
        return $this;
    }
    /**
     * Get DocumentCurrency value
     * @return string
     */
    public function getDocumentCurrency()
    {
        return $this->DocumentCurrency;
    }
    /**
     * Set DocumentCurrency value
     * @uses \TurkkepEFatura\EnumType\CurrencyType::valueIsValid()
     * @uses \TurkkepEFatura\EnumType\CurrencyType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $documentCurrency
     * @return \TurkkepEFatura\StructType\DespatchInvoice
     */
    public function setDocumentCurrency($documentCurrency = null)
    {
        // validation for constraint: enumeration
        if (!\TurkkepEFatura\EnumType\CurrencyType::valueIsValid($documentCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \TurkkepEFatura\EnumType\CurrencyType', is_array($documentCurrency) ? implode(', ', $documentCurrency) : var_export($documentCurrency, true), implode(', ', \TurkkepEFatura\EnumType\CurrencyType::getValidValues())), __LINE__);
        }
        $this->DocumentCurrency = $documentCurrency;
        return $this;
    }
    /**
     * Get PricingExchange value
     * @return float
     */
    public function getPricingExchange()
    {
        return $this->PricingExchange;
    }
    /**
     * Set PricingExchange value
     * @param float $pricingExchange
     * @return \TurkkepEFatura\StructType\DespatchInvoice
     */
    public function setPricingExchange($pricingExchange = null)
    {
        // validation for constraint: float
        if (!is_null($pricingExchange) && !(is_float($pricingExchange) || is_numeric($pricingExchange))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($pricingExchange, true), gettype($pricingExchange)), __LINE__);
        }
        $this->PricingExchange = $pricingExchange;
        return $this;
    }
    /**
     * Get TotalAmount value
     * @return float
     */
    public function getTotalAmount()
    {
        return $this->TotalAmount;
    }
    /**
     * Set TotalAmount value
     * @param float $totalAmount
     * @return \TurkkepEFatura\StructType\DespatchInvoice
     */
    public function setTotalAmount($totalAmount = null)
    {
        // validation for constraint: float
        if (!is_null($totalAmount) && !(is_float($totalAmount) || is_numeric($totalAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalAmount, true), gettype($totalAmount)), __LINE__);
        }
        $this->TotalAmount = $totalAmount;
        return $this;
    }
    /**
     * Get OrderDate value
     * @return string
     */
    public function getOrderDate()
    {
        return $this->OrderDate;
    }
    /**
     * Set OrderDate value
     * @param string $orderDate
     * @return \TurkkepEFatura\StructType\DespatchInvoice
     */
    public function setOrderDate($orderDate = null)
    {
        // validation for constraint: string
        if (!is_null($orderDate) && !is_string($orderDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderDate, true), gettype($orderDate)), __LINE__);
        }
        $this->OrderDate = $orderDate;
        return $this;
    }
    /**
     * Get SendDate value
     * @return string
     */
    public function getSendDate()
    {
        return $this->SendDate;
    }
    /**
     * Set SendDate value
     * @param string $sendDate
     * @return \TurkkepEFatura\StructType\DespatchInvoice
     */
    public function setSendDate($sendDate = null)
    {
        // validation for constraint: string
        if (!is_null($sendDate) && !is_string($sendDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sendDate, true), gettype($sendDate)), __LINE__);
        }
        $this->SendDate = $sendDate;
        return $this;
    }
    /**
     * Get SendTime value
     * @return string
     */
    public function getSendTime()
    {
        return $this->SendTime;
    }
    /**
     * Set SendTime value
     * @param string $sendTime
     * @return \TurkkepEFatura\StructType\DespatchInvoice
     */
    public function setSendTime($sendTime = null)
    {
        // validation for constraint: string
        if (!is_null($sendTime) && !is_string($sendTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sendTime, true), gettype($sendTime)), __LINE__);
        }
        $this->SendTime = $sendTime;
        return $this;
    }
    /**
     * Get Status value
     * @return int
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param int $status
     * @return \TurkkepEFatura\StructType\DespatchInvoice
     */
    public function setStatus($status = null)
    {
        // validation for constraint: int
        if (!is_null($status) && !(is_int($status) || ctype_digit($status))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get CopyIndicator value
     * @return bool
     */
    public function getCopyIndicator()
    {
        return $this->CopyIndicator;
    }
    /**
     * Set CopyIndicator value
     * @param bool $copyIndicator
     * @return \TurkkepEFatura\StructType\DespatchInvoice
     */
    public function setCopyIndicator($copyIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($copyIndicator) && !is_bool($copyIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($copyIndicator, true), gettype($copyIndicator)), __LINE__);
        }
        $this->CopyIndicator = $copyIndicator;
        return $this;
    }
    /**
     * Get UUID value
     * @return string|null
     */
    public function getUUID()
    {
        return $this->UUID;
    }
    /**
     * Set UUID value
     * @param string $uUID
     * @return \TurkkepEFatura\StructType\DespatchInvoice
     */
    public function setUUID($uUID = null)
    {
        // validation for constraint: string
        if (!is_null($uUID) && !is_string($uUID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uUID, true), gettype($uUID)), __LINE__);
        }
        $this->UUID = $uUID;
        return $this;
    }
    /**
     * Get DispatchReference value
     * @return string|null
     */
    public function getDispatchReference()
    {
        return $this->DispatchReference;
    }
    /**
     * Set DispatchReference value
     * @param string $dispatchReference
     * @return \TurkkepEFatura\StructType\DespatchInvoice
     */
    public function setDispatchReference($dispatchReference = null)
    {
        // validation for constraint: string
        if (!is_null($dispatchReference) && !is_string($dispatchReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dispatchReference, true), gettype($dispatchReference)), __LINE__);
        }
        $this->DispatchReference = $dispatchReference;
        return $this;
    }
    /**
     * Get CarrierTradeRegNo value
     * @return string|null
     */
    public function getCarrierTradeRegNo()
    {
        return $this->CarrierTradeRegNo;
    }
    /**
     * Set CarrierTradeRegNo value
     * @param string $carrierTradeRegNo
     * @return \TurkkepEFatura\StructType\DespatchInvoice
     */
    public function setCarrierTradeRegNo($carrierTradeRegNo = null)
    {
        // validation for constraint: string
        if (!is_null($carrierTradeRegNo) && !is_string($carrierTradeRegNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($carrierTradeRegNo, true), gettype($carrierTradeRegNo)), __LINE__);
        }
        $this->CarrierTradeRegNo = $carrierTradeRegNo;
        return $this;
    }
    /**
     * Get CarrierTitle value
     * @return string|null
     */
    public function getCarrierTitle()
    {
        return $this->CarrierTitle;
    }
    /**
     * Set CarrierTitle value
     * @param string $carrierTitle
     * @return \TurkkepEFatura\StructType\DespatchInvoice
     */
    public function setCarrierTitle($carrierTitle = null)
    {
        // validation for constraint: string
        if (!is_null($carrierTitle) && !is_string($carrierTitle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($carrierTitle, true), gettype($carrierTitle)), __LINE__);
        }
        $this->CarrierTitle = $carrierTitle;
        return $this;
    }
    /**
     * Get LicensePlate value
     * @return string|null
     */
    public function getLicensePlate()
    {
        return $this->LicensePlate;
    }
    /**
     * Set LicensePlate value
     * @param string $licensePlate
     * @return \TurkkepEFatura\StructType\DespatchInvoice
     */
    public function setLicensePlate($licensePlate = null)
    {
        // validation for constraint: string
        if (!is_null($licensePlate) && !is_string($licensePlate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($licensePlate, true), gettype($licensePlate)), __LINE__);
        }
        $this->LicensePlate = $licensePlate;
        return $this;
    }
    /**
     * Get OrderID value
     * @return string|null
     */
    public function getOrderID()
    {
        return $this->OrderID;
    }
    /**
     * Set OrderID value
     * @param string $orderID
     * @return \TurkkepEFatura\StructType\DespatchInvoice
     */
    public function setOrderID($orderID = null)
    {
        // validation for constraint: string
        if (!is_null($orderID) && !is_string($orderID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderID, true), gettype($orderID)), __LINE__);
        }
        $this->OrderID = $orderID;
        return $this;
    }
    /**
     * Get CustomerParty value
     * @return \TurkkepEFatura\StructType\Party|null
     */
    public function getCustomerParty()
    {
        return $this->CustomerParty;
    }
    /**
     * Set CustomerParty value
     * @param \TurkkepEFatura\StructType\Party $customerParty
     * @return \TurkkepEFatura\StructType\DespatchInvoice
     */
    public function setCustomerParty(\TurkkepEFatura\StructType\Party $customerParty = null)
    {
        $this->CustomerParty = $customerParty;
        return $this;
    }
    /**
     * Get SupplierParty value
     * @return \TurkkepEFatura\StructType\Party|null
     */
    public function getSupplierParty()
    {
        return $this->SupplierParty;
    }
    /**
     * Set SupplierParty value
     * @param \TurkkepEFatura\StructType\Party $supplierParty
     * @return \TurkkepEFatura\StructType\DespatchInvoice
     */
    public function setSupplierParty(\TurkkepEFatura\StructType\Party $supplierParty = null)
    {
        $this->SupplierParty = $supplierParty;
        return $this;
    }
    /**
     * Get TrailerPlate value
     * @return string|null
     */
    public function getTrailerPlate()
    {
        return $this->TrailerPlate;
    }
    /**
     * Set TrailerPlate value
     * @param string $trailerPlate
     * @return \TurkkepEFatura\StructType\DespatchInvoice
     */
    public function setTrailerPlate($trailerPlate = null)
    {
        // validation for constraint: string
        if (!is_null($trailerPlate) && !is_string($trailerPlate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trailerPlate, true), gettype($trailerPlate)), __LINE__);
        }
        $this->TrailerPlate = $trailerPlate;
        return $this;
    }
    /**
     * Get EnvelopeReference value
     * @return string|null
     */
    public function getEnvelopeReference()
    {
        return $this->EnvelopeReference;
    }
    /**
     * Set EnvelopeReference value
     * @param string $envelopeReference
     * @return \TurkkepEFatura\StructType\DespatchInvoice
     */
    public function setEnvelopeReference($envelopeReference = null)
    {
        // validation for constraint: string
        if (!is_null($envelopeReference) && !is_string($envelopeReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($envelopeReference, true), gettype($envelopeReference)), __LINE__);
        }
        $this->EnvelopeReference = $envelopeReference;
        return $this;
    }
    /**
     * Get ResponseStatusCode value
     * @return string|null
     */
    public function getResponseStatusCode()
    {
        return $this->ResponseStatusCode;
    }
    /**
     * Set ResponseStatusCode value
     * @param string $responseStatusCode
     * @return \TurkkepEFatura\StructType\DespatchInvoice
     */
    public function setResponseStatusCode($responseStatusCode = null)
    {
        // validation for constraint: string
        if (!is_null($responseStatusCode) && !is_string($responseStatusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($responseStatusCode, true), gettype($responseStatusCode)), __LINE__);
        }
        $this->ResponseStatusCode = $responseStatusCode;
        return $this;
    }
    /**
     * Get ResponseDescription value
     * @return string|null
     */
    public function getResponseDescription()
    {
        return $this->ResponseDescription;
    }
    /**
     * Set ResponseDescription value
     * @param string $responseDescription
     * @return \TurkkepEFatura\StructType\DespatchInvoice
     */
    public function setResponseDescription($responseDescription = null)
    {
        // validation for constraint: string
        if (!is_null($responseDescription) && !is_string($responseDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($responseDescription, true), gettype($responseDescription)), __LINE__);
        }
        $this->ResponseDescription = $responseDescription;
        return $this;
    }
    /**
     * Get ERPDispatch value
     * @return string|null
     */
    public function getERPDispatch()
    {
        return $this->ERPDispatch;
    }
    /**
     * Set ERPDispatch value
     * @param string $eRPDispatch
     * @return \TurkkepEFatura\StructType\DespatchInvoice
     */
    public function setERPDispatch($eRPDispatch = null)
    {
        // validation for constraint: string
        if (!is_null($eRPDispatch) && !is_string($eRPDispatch)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eRPDispatch, true), gettype($eRPDispatch)), __LINE__);
        }
        $this->ERPDispatch = $eRPDispatch;
        return $this;
    }
    /**
     * Get SenderAlias value
     * @return string|null
     */
    public function getSenderAlias()
    {
        return $this->SenderAlias;
    }
    /**
     * Set SenderAlias value
     * @param string $senderAlias
     * @return \TurkkepEFatura\StructType\DespatchInvoice
     */
    public function setSenderAlias($senderAlias = null)
    {
        // validation for constraint: string
        if (!is_null($senderAlias) && !is_string($senderAlias)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($senderAlias, true), gettype($senderAlias)), __LINE__);
        }
        $this->SenderAlias = $senderAlias;
        return $this;
    }
    /**
     * Get PostboxAlias value
     * @return string|null
     */
    public function getPostboxAlias()
    {
        return $this->PostboxAlias;
    }
    /**
     * Set PostboxAlias value
     * @param string $postboxAlias
     * @return \TurkkepEFatura\StructType\DespatchInvoice
     */
    public function setPostboxAlias($postboxAlias = null)
    {
        // validation for constraint: string
        if (!is_null($postboxAlias) && !is_string($postboxAlias)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postboxAlias, true), gettype($postboxAlias)), __LINE__);
        }
        $this->PostboxAlias = $postboxAlias;
        return $this;
    }
    /**
     * Get XSLTName value
     * @return string|null
     */
    public function getXSLTName()
    {
        return $this->XSLTName;
    }
    /**
     * Set XSLTName value
     * @param string $xSLTName
     * @return \TurkkepEFatura\StructType\DespatchInvoice
     */
    public function setXSLTName($xSLTName = null)
    {
        // validation for constraint: string
        if (!is_null($xSLTName) && !is_string($xSLTName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($xSLTName, true), gettype($xSLTName)), __LINE__);
        }
        $this->XSLTName = $xSLTName;
        return $this;
    }
    /**
     * Get Lines value
     * @return \TurkkepEFatura\ArrayType\ArrayOfDespatchLine|null
     */
    public function getLines()
    {
        return $this->Lines;
    }
    /**
     * Set Lines value
     * @param \TurkkepEFatura\ArrayType\ArrayOfDespatchLine $lines
     * @return \TurkkepEFatura\StructType\DespatchInvoice
     */
    public function setLines(\TurkkepEFatura\ArrayType\ArrayOfDespatchLine $lines = null)
    {
        $this->Lines = $lines;
        return $this;
    }
    /**
     * Get DespatchDrivers value
     * @return \TurkkepEFatura\ArrayType\ArrayOfDespatchDriver|null
     */
    public function getDespatchDrivers()
    {
        return $this->DespatchDrivers;
    }
    /**
     * Set DespatchDrivers value
     * @param \TurkkepEFatura\ArrayType\ArrayOfDespatchDriver $despatchDrivers
     * @return \TurkkepEFatura\StructType\DespatchInvoice
     */
    public function setDespatchDrivers(\TurkkepEFatura\ArrayType\ArrayOfDespatchDriver $despatchDrivers = null)
    {
        $this->DespatchDrivers = $despatchDrivers;
        return $this;
    }
    /**
     * Get NoteList value
     * @return \TurkkepEFatura\ArrayType\ArrayOfString|null
     */
    public function getNoteList()
    {
        return $this->NoteList;
    }
    /**
     * Set NoteList value
     * @param \TurkkepEFatura\ArrayType\ArrayOfString $noteList
     * @return \TurkkepEFatura\StructType\DespatchInvoice
     */
    public function setNoteList(\TurkkepEFatura\ArrayType\ArrayOfString $noteList = null)
    {
        $this->NoteList = $noteList;
        return $this;
    }
    /**
     * Get TrailerPlates value
     * @return \TurkkepEFatura\ArrayType\ArrayOfString|null
     */
    public function getTrailerPlates()
    {
        return $this->TrailerPlates;
    }
    /**
     * Set TrailerPlates value
     * @param \TurkkepEFatura\ArrayType\ArrayOfString $trailerPlates
     * @return \TurkkepEFatura\StructType\DespatchInvoice
     */
    public function setTrailerPlates(\TurkkepEFatura\ArrayType\ArrayOfString $trailerPlates = null)
    {
        $this->TrailerPlates = $trailerPlates;
        return $this;
    }
    /**
     * Get DispatchDeliveryParty value
     * @return \TurkkepEFatura\StructType\DispatchDeliveryParty|null
     */
    public function getDispatchDeliveryParty()
    {
        return $this->DispatchDeliveryParty;
    }
    /**
     * Set DispatchDeliveryParty value
     * @param \TurkkepEFatura\StructType\DispatchDeliveryParty $dispatchDeliveryParty
     * @return \TurkkepEFatura\StructType\DespatchInvoice
     */
    public function setDispatchDeliveryParty(\TurkkepEFatura\StructType\DispatchDeliveryParty $dispatchDeliveryParty = null)
    {
        $this->DispatchDeliveryParty = $dispatchDeliveryParty;
        return $this;
    }
    /**
     * Get DispatchAdditionalInfo value
     * @return \TurkkepEFatura\StructType\DispatchAdditionalInfo|null
     */
    public function getDispatchAdditionalInfo()
    {
        return $this->DispatchAdditionalInfo;
    }
    /**
     * Set DispatchAdditionalInfo value
     * @param \TurkkepEFatura\StructType\DispatchAdditionalInfo $dispatchAdditionalInfo
     * @return \TurkkepEFatura\StructType\DespatchInvoice
     */
    public function setDispatchAdditionalInfo(\TurkkepEFatura\StructType\DispatchAdditionalInfo $dispatchAdditionalInfo = null)
    {
        $this->DispatchAdditionalInfo = $dispatchAdditionalInfo;
        return $this;
    }
    /**
     * Get BuyerCustomerParty value
     * @return \TurkkepEFatura\StructType\Party|null
     */
    public function getBuyerCustomerParty()
    {
        return $this->BuyerCustomerParty;
    }
    /**
     * Set BuyerCustomerParty value
     * @param \TurkkepEFatura\StructType\Party $buyerCustomerParty
     * @return \TurkkepEFatura\StructType\DespatchInvoice
     */
    public function setBuyerCustomerParty(\TurkkepEFatura\StructType\Party $buyerCustomerParty = null)
    {
        $this->BuyerCustomerParty = $buyerCustomerParty;
        return $this;
    }
    /**
     * Get SellerSupplierParty value
     * @return \TurkkepEFatura\StructType\Party|null
     */
    public function getSellerSupplierParty()
    {
        return $this->SellerSupplierParty;
    }
    /**
     * Set SellerSupplierParty value
     * @param \TurkkepEFatura\StructType\Party $sellerSupplierParty
     * @return \TurkkepEFatura\StructType\DespatchInvoice
     */
    public function setSellerSupplierParty(\TurkkepEFatura\StructType\Party $sellerSupplierParty = null)
    {
        $this->SellerSupplierParty = $sellerSupplierParty;
        return $this;
    }
}
