<?php

namespace TurkkepEFatura\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeliveryUnitType StructType
 * @subpackage Structs
 */
class DeliveryUnitType extends AbstractStructBase
{
    /**
     * The BatchQuantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:BatchQuantity
     * @var \TurkkepEFatura\StructType\BatchQuantityType
     */
    public $BatchQuantity;
    /**
     * The ConsumerUnitQuantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:ConsumerUnitQuantity
     * @var \TurkkepEFatura\StructType\ConsumerUnitQuantityType
     */
    public $ConsumerUnitQuantity;
    /**
     * The HazardousRiskIndicator
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:HazardousRiskIndicator
     * @var \TurkkepEFatura\StructType\HazardousRiskIndicatorType
     */
    public $HazardousRiskIndicator;
    /**
     * Constructor method for DeliveryUnitType
     * @uses DeliveryUnitType::setBatchQuantity()
     * @uses DeliveryUnitType::setConsumerUnitQuantity()
     * @uses DeliveryUnitType::setHazardousRiskIndicator()
     * @param \TurkkepEFatura\StructType\BatchQuantityType $batchQuantity
     * @param \TurkkepEFatura\StructType\ConsumerUnitQuantityType $consumerUnitQuantity
     * @param \TurkkepEFatura\StructType\HazardousRiskIndicatorType $hazardousRiskIndicator
     */
    public function __construct(\TurkkepEFatura\StructType\BatchQuantityType $batchQuantity = null, \TurkkepEFatura\StructType\ConsumerUnitQuantityType $consumerUnitQuantity = null, \TurkkepEFatura\StructType\HazardousRiskIndicatorType $hazardousRiskIndicator = null)
    {
        $this
            ->setBatchQuantity($batchQuantity)
            ->setConsumerUnitQuantity($consumerUnitQuantity)
            ->setHazardousRiskIndicator($hazardousRiskIndicator);
    }
    /**
     * Get BatchQuantity value
     * @return \TurkkepEFatura\StructType\BatchQuantityType|null
     */
    public function getBatchQuantity()
    {
        return $this->BatchQuantity;
    }
    /**
     * Set BatchQuantity value
     * @param \TurkkepEFatura\StructType\BatchQuantityType $batchQuantity
     * @return \TurkkepEFatura\StructType\DeliveryUnitType
     */
    public function setBatchQuantity(\TurkkepEFatura\StructType\BatchQuantityType $batchQuantity = null)
    {
        $this->BatchQuantity = $batchQuantity;
        return $this;
    }
    /**
     * Get ConsumerUnitQuantity value
     * @return \TurkkepEFatura\StructType\ConsumerUnitQuantityType|null
     */
    public function getConsumerUnitQuantity()
    {
        return $this->ConsumerUnitQuantity;
    }
    /**
     * Set ConsumerUnitQuantity value
     * @param \TurkkepEFatura\StructType\ConsumerUnitQuantityType $consumerUnitQuantity
     * @return \TurkkepEFatura\StructType\DeliveryUnitType
     */
    public function setConsumerUnitQuantity(\TurkkepEFatura\StructType\ConsumerUnitQuantityType $consumerUnitQuantity = null)
    {
        $this->ConsumerUnitQuantity = $consumerUnitQuantity;
        return $this;
    }
    /**
     * Get HazardousRiskIndicator value
     * @return \TurkkepEFatura\StructType\HazardousRiskIndicatorType|null
     */
    public function getHazardousRiskIndicator()
    {
        return $this->HazardousRiskIndicator;
    }
    /**
     * Set HazardousRiskIndicator value
     * @param \TurkkepEFatura\StructType\HazardousRiskIndicatorType $hazardousRiskIndicator
     * @return \TurkkepEFatura\StructType\DeliveryUnitType
     */
    public function setHazardousRiskIndicator(\TurkkepEFatura\StructType\HazardousRiskIndicatorType $hazardousRiskIndicator = null)
    {
        $this->HazardousRiskIndicator = $hazardousRiskIndicator;
        return $this;
    }
}
