<?php

namespace TurkkepEFatura\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeliveryType StructType
 * @subpackage Structs
 */
class DeliveryType extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:ID
     * @var \TurkkepEFatura\StructType\IDType
     */
    public $ID;
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:Quantity
     * @var \TurkkepEFatura\StructType\QuantityType
     */
    public $Quantity;
    /**
     * The ActualDeliveryDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:ActualDeliveryDate
     * @var \TurkkepEFatura\StructType\ActualDeliveryDateType
     */
    public $ActualDeliveryDate;
    /**
     * The ActualDeliveryTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:ActualDeliveryTime
     * @var \TurkkepEFatura\StructType\ActualDeliveryTimeType
     */
    public $ActualDeliveryTime;
    /**
     * The LatestDeliveryDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:LatestDeliveryDate
     * @var \TurkkepEFatura\StructType\LatestDeliveryDateType
     */
    public $LatestDeliveryDate;
    /**
     * The LatestDeliveryTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:LatestDeliveryTime
     * @var \TurkkepEFatura\StructType\LatestDeliveryTimeType
     */
    public $LatestDeliveryTime;
    /**
     * The TrackingID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:TrackingID
     * @var \TurkkepEFatura\StructType\TrackingIDType
     */
    public $TrackingID;
    /**
     * The DeliveryAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\AddressType
     */
    public $DeliveryAddress;
    /**
     * The AlternativeDeliveryLocation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\LocationType
     */
    public $AlternativeDeliveryLocation;
    /**
     * The EstimatedDeliveryPeriod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\PeriodType
     */
    public $EstimatedDeliveryPeriod;
    /**
     * The CarrierParty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\PartyType
     */
    public $CarrierParty;
    /**
     * The DeliveryParty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\PartyType
     */
    public $DeliveryParty;
    /**
     * The Despatch
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\DespatchType
     */
    public $Despatch;
    /**
     * The DeliveryTerms
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\DeliveryTermsType[]
     */
    public $DeliveryTerms;
    /**
     * The Shipment
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\ShipmentType
     */
    public $Shipment;
    /**
     * Constructor method for DeliveryType
     * @uses DeliveryType::setID()
     * @uses DeliveryType::setQuantity()
     * @uses DeliveryType::setActualDeliveryDate()
     * @uses DeliveryType::setActualDeliveryTime()
     * @uses DeliveryType::setLatestDeliveryDate()
     * @uses DeliveryType::setLatestDeliveryTime()
     * @uses DeliveryType::setTrackingID()
     * @uses DeliveryType::setDeliveryAddress()
     * @uses DeliveryType::setAlternativeDeliveryLocation()
     * @uses DeliveryType::setEstimatedDeliveryPeriod()
     * @uses DeliveryType::setCarrierParty()
     * @uses DeliveryType::setDeliveryParty()
     * @uses DeliveryType::setDespatch()
     * @uses DeliveryType::setDeliveryTerms()
     * @uses DeliveryType::setShipment()
     * @param \TurkkepEFatura\StructType\IDType $iD
     * @param \TurkkepEFatura\StructType\QuantityType $quantity
     * @param \TurkkepEFatura\StructType\ActualDeliveryDateType $actualDeliveryDate
     * @param \TurkkepEFatura\StructType\ActualDeliveryTimeType $actualDeliveryTime
     * @param \TurkkepEFatura\StructType\LatestDeliveryDateType $latestDeliveryDate
     * @param \TurkkepEFatura\StructType\LatestDeliveryTimeType $latestDeliveryTime
     * @param \TurkkepEFatura\StructType\TrackingIDType $trackingID
     * @param \TurkkepEFatura\StructType\AddressType $deliveryAddress
     * @param \TurkkepEFatura\StructType\LocationType $alternativeDeliveryLocation
     * @param \TurkkepEFatura\StructType\PeriodType $estimatedDeliveryPeriod
     * @param \TurkkepEFatura\StructType\PartyType $carrierParty
     * @param \TurkkepEFatura\StructType\PartyType $deliveryParty
     * @param \TurkkepEFatura\StructType\DespatchType $despatch
     * @param \TurkkepEFatura\StructType\DeliveryTermsType[] $deliveryTerms
     * @param \TurkkepEFatura\StructType\ShipmentType $shipment
     */
    public function __construct(\TurkkepEFatura\StructType\IDType $iD = null, \TurkkepEFatura\StructType\QuantityType $quantity = null, \TurkkepEFatura\StructType\ActualDeliveryDateType $actualDeliveryDate = null, \TurkkepEFatura\StructType\ActualDeliveryTimeType $actualDeliveryTime = null, \TurkkepEFatura\StructType\LatestDeliveryDateType $latestDeliveryDate = null, \TurkkepEFatura\StructType\LatestDeliveryTimeType $latestDeliveryTime = null, \TurkkepEFatura\StructType\TrackingIDType $trackingID = null, \TurkkepEFatura\StructType\AddressType $deliveryAddress = null, \TurkkepEFatura\StructType\LocationType $alternativeDeliveryLocation = null, \TurkkepEFatura\StructType\PeriodType $estimatedDeliveryPeriod = null, \TurkkepEFatura\StructType\PartyType $carrierParty = null, \TurkkepEFatura\StructType\PartyType $deliveryParty = null, \TurkkepEFatura\StructType\DespatchType $despatch = null, array $deliveryTerms = array(), \TurkkepEFatura\StructType\ShipmentType $shipment = null)
    {
        $this
            ->setID($iD)
            ->setQuantity($quantity)
            ->setActualDeliveryDate($actualDeliveryDate)
            ->setActualDeliveryTime($actualDeliveryTime)
            ->setLatestDeliveryDate($latestDeliveryDate)
            ->setLatestDeliveryTime($latestDeliveryTime)
            ->setTrackingID($trackingID)
            ->setDeliveryAddress($deliveryAddress)
            ->setAlternativeDeliveryLocation($alternativeDeliveryLocation)
            ->setEstimatedDeliveryPeriod($estimatedDeliveryPeriod)
            ->setCarrierParty($carrierParty)
            ->setDeliveryParty($deliveryParty)
            ->setDespatch($despatch)
            ->setDeliveryTerms($deliveryTerms)
            ->setShipment($shipment);
    }
    /**
     * Get ID value
     * @return \TurkkepEFatura\StructType\IDType|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param \TurkkepEFatura\StructType\IDType $iD
     * @return \TurkkepEFatura\StructType\DeliveryType
     */
    public function setID(\TurkkepEFatura\StructType\IDType $iD = null)
    {
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Quantity value
     * @return \TurkkepEFatura\StructType\QuantityType|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param \TurkkepEFatura\StructType\QuantityType $quantity
     * @return \TurkkepEFatura\StructType\DeliveryType
     */
    public function setQuantity(\TurkkepEFatura\StructType\QuantityType $quantity = null)
    {
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get ActualDeliveryDate value
     * @return \TurkkepEFatura\StructType\ActualDeliveryDateType|null
     */
    public function getActualDeliveryDate()
    {
        return $this->ActualDeliveryDate;
    }
    /**
     * Set ActualDeliveryDate value
     * @param \TurkkepEFatura\StructType\ActualDeliveryDateType $actualDeliveryDate
     * @return \TurkkepEFatura\StructType\DeliveryType
     */
    public function setActualDeliveryDate(\TurkkepEFatura\StructType\ActualDeliveryDateType $actualDeliveryDate = null)
    {
        $this->ActualDeliveryDate = $actualDeliveryDate;
        return $this;
    }
    /**
     * Get ActualDeliveryTime value
     * @return \TurkkepEFatura\StructType\ActualDeliveryTimeType|null
     */
    public function getActualDeliveryTime()
    {
        return $this->ActualDeliveryTime;
    }
    /**
     * Set ActualDeliveryTime value
     * @param \TurkkepEFatura\StructType\ActualDeliveryTimeType $actualDeliveryTime
     * @return \TurkkepEFatura\StructType\DeliveryType
     */
    public function setActualDeliveryTime(\TurkkepEFatura\StructType\ActualDeliveryTimeType $actualDeliveryTime = null)
    {
        $this->ActualDeliveryTime = $actualDeliveryTime;
        return $this;
    }
    /**
     * Get LatestDeliveryDate value
     * @return \TurkkepEFatura\StructType\LatestDeliveryDateType|null
     */
    public function getLatestDeliveryDate()
    {
        return $this->LatestDeliveryDate;
    }
    /**
     * Set LatestDeliveryDate value
     * @param \TurkkepEFatura\StructType\LatestDeliveryDateType $latestDeliveryDate
     * @return \TurkkepEFatura\StructType\DeliveryType
     */
    public function setLatestDeliveryDate(\TurkkepEFatura\StructType\LatestDeliveryDateType $latestDeliveryDate = null)
    {
        $this->LatestDeliveryDate = $latestDeliveryDate;
        return $this;
    }
    /**
     * Get LatestDeliveryTime value
     * @return \TurkkepEFatura\StructType\LatestDeliveryTimeType|null
     */
    public function getLatestDeliveryTime()
    {
        return $this->LatestDeliveryTime;
    }
    /**
     * Set LatestDeliveryTime value
     * @param \TurkkepEFatura\StructType\LatestDeliveryTimeType $latestDeliveryTime
     * @return \TurkkepEFatura\StructType\DeliveryType
     */
    public function setLatestDeliveryTime(\TurkkepEFatura\StructType\LatestDeliveryTimeType $latestDeliveryTime = null)
    {
        $this->LatestDeliveryTime = $latestDeliveryTime;
        return $this;
    }
    /**
     * Get TrackingID value
     * @return \TurkkepEFatura\StructType\TrackingIDType|null
     */
    public function getTrackingID()
    {
        return $this->TrackingID;
    }
    /**
     * Set TrackingID value
     * @param \TurkkepEFatura\StructType\TrackingIDType $trackingID
     * @return \TurkkepEFatura\StructType\DeliveryType
     */
    public function setTrackingID(\TurkkepEFatura\StructType\TrackingIDType $trackingID = null)
    {
        $this->TrackingID = $trackingID;
        return $this;
    }
    /**
     * Get DeliveryAddress value
     * @return \TurkkepEFatura\StructType\AddressType|null
     */
    public function getDeliveryAddress()
    {
        return $this->DeliveryAddress;
    }
    /**
     * Set DeliveryAddress value
     * @param \TurkkepEFatura\StructType\AddressType $deliveryAddress
     * @return \TurkkepEFatura\StructType\DeliveryType
     */
    public function setDeliveryAddress(\TurkkepEFatura\StructType\AddressType $deliveryAddress = null)
    {
        $this->DeliveryAddress = $deliveryAddress;
        return $this;
    }
    /**
     * Get AlternativeDeliveryLocation value
     * @return \TurkkepEFatura\StructType\LocationType|null
     */
    public function getAlternativeDeliveryLocation()
    {
        return $this->AlternativeDeliveryLocation;
    }
    /**
     * Set AlternativeDeliveryLocation value
     * @param \TurkkepEFatura\StructType\LocationType $alternativeDeliveryLocation
     * @return \TurkkepEFatura\StructType\DeliveryType
     */
    public function setAlternativeDeliveryLocation(\TurkkepEFatura\StructType\LocationType $alternativeDeliveryLocation = null)
    {
        $this->AlternativeDeliveryLocation = $alternativeDeliveryLocation;
        return $this;
    }
    /**
     * Get EstimatedDeliveryPeriod value
     * @return \TurkkepEFatura\StructType\PeriodType|null
     */
    public function getEstimatedDeliveryPeriod()
    {
        return $this->EstimatedDeliveryPeriod;
    }
    /**
     * Set EstimatedDeliveryPeriod value
     * @param \TurkkepEFatura\StructType\PeriodType $estimatedDeliveryPeriod
     * @return \TurkkepEFatura\StructType\DeliveryType
     */
    public function setEstimatedDeliveryPeriod(\TurkkepEFatura\StructType\PeriodType $estimatedDeliveryPeriod = null)
    {
        $this->EstimatedDeliveryPeriod = $estimatedDeliveryPeriod;
        return $this;
    }
    /**
     * Get CarrierParty value
     * @return \TurkkepEFatura\StructType\PartyType|null
     */
    public function getCarrierParty()
    {
        return $this->CarrierParty;
    }
    /**
     * Set CarrierParty value
     * @param \TurkkepEFatura\StructType\PartyType $carrierParty
     * @return \TurkkepEFatura\StructType\DeliveryType
     */
    public function setCarrierParty(\TurkkepEFatura\StructType\PartyType $carrierParty = null)
    {
        $this->CarrierParty = $carrierParty;
        return $this;
    }
    /**
     * Get DeliveryParty value
     * @return \TurkkepEFatura\StructType\PartyType|null
     */
    public function getDeliveryParty()
    {
        return $this->DeliveryParty;
    }
    /**
     * Set DeliveryParty value
     * @param \TurkkepEFatura\StructType\PartyType $deliveryParty
     * @return \TurkkepEFatura\StructType\DeliveryType
     */
    public function setDeliveryParty(\TurkkepEFatura\StructType\PartyType $deliveryParty = null)
    {
        $this->DeliveryParty = $deliveryParty;
        return $this;
    }
    /**
     * Get Despatch value
     * @return \TurkkepEFatura\StructType\DespatchType|null
     */
    public function getDespatch()
    {
        return $this->Despatch;
    }
    /**
     * Set Despatch value
     * @param \TurkkepEFatura\StructType\DespatchType $despatch
     * @return \TurkkepEFatura\StructType\DeliveryType
     */
    public function setDespatch(\TurkkepEFatura\StructType\DespatchType $despatch = null)
    {
        $this->Despatch = $despatch;
        return $this;
    }
    /**
     * Get DeliveryTerms value
     * @return \TurkkepEFatura\StructType\DeliveryTermsType[]|null
     */
    public function getDeliveryTerms()
    {
        return $this->DeliveryTerms;
    }
    /**
     * This method is responsible for validating the values passed to the setDeliveryTerms method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDeliveryTerms method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDeliveryTermsForArrayConstraintsFromSetDeliveryTerms(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $deliveryTypeDeliveryTermsItem) {
            // validation for constraint: itemType
            if (!$deliveryTypeDeliveryTermsItem instanceof \TurkkepEFatura\StructType\DeliveryTermsType) {
                $invalidValues[] = is_object($deliveryTypeDeliveryTermsItem) ? get_class($deliveryTypeDeliveryTermsItem) : sprintf('%s(%s)', gettype($deliveryTypeDeliveryTermsItem), var_export($deliveryTypeDeliveryTermsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DeliveryTerms property can only contain items of type \TurkkepEFatura\StructType\DeliveryTermsType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DeliveryTerms value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\DeliveryTermsType[] $deliveryTerms
     * @return \TurkkepEFatura\StructType\DeliveryType
     */
    public function setDeliveryTerms(array $deliveryTerms = array())
    {
        // validation for constraint: array
        if ('' !== ($deliveryTermsArrayErrorMessage = self::validateDeliveryTermsForArrayConstraintsFromSetDeliveryTerms($deliveryTerms))) {
            throw new \InvalidArgumentException($deliveryTermsArrayErrorMessage, __LINE__);
        }
        $this->DeliveryTerms = $deliveryTerms;
        return $this;
    }
    /**
     * Add item to DeliveryTerms value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\DeliveryTermsType $item
     * @return \TurkkepEFatura\StructType\DeliveryType
     */
    public function addToDeliveryTerms(\TurkkepEFatura\StructType\DeliveryTermsType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \TurkkepEFatura\StructType\DeliveryTermsType) {
            throw new \InvalidArgumentException(sprintf('The DeliveryTerms property can only contain items of type \TurkkepEFatura\StructType\DeliveryTermsType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DeliveryTerms[] = $item;
        return $this;
    }
    /**
     * Get Shipment value
     * @return \TurkkepEFatura\StructType\ShipmentType|null
     */
    public function getShipment()
    {
        return $this->Shipment;
    }
    /**
     * Set Shipment value
     * @param \TurkkepEFatura\StructType\ShipmentType $shipment
     * @return \TurkkepEFatura\StructType\DeliveryType
     */
    public function setShipment(\TurkkepEFatura\StructType\ShipmentType $shipment = null)
    {
        $this->Shipment = $shipment;
        return $this;
    }
}
