<?php

namespace TurkkepEFatura\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CrmInvoice StructType
 * @subpackage Structs
 */
class CrmInvoice extends AbstractStructBase
{
    /**
     * The No
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $No;
    /**
     * The Organization
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Organization;
    /**
     * The StartDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $StartDate;
    /**
     * The EInvoiceIncomingCount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $EInvoiceIncomingCount;
    /**
     * The EInvoiceOutgoingCount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $EInvoiceOutgoingCount;
    /**
     * The EArchiveInvoiceCount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $EArchiveInvoiceCount;
    /**
     * The TotalInvoiceCredit
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TotalInvoiceCredit;
    /**
     * The TotalEArchiveCredit
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TotalEArchiveCredit;
    /**
     * The CustomerName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerName;
    /**
     * The Vkn
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Vkn;
    /**
     * Constructor method for CrmInvoice
     * @uses CrmInvoice::setNo()
     * @uses CrmInvoice::setOrganization()
     * @uses CrmInvoice::setStartDate()
     * @uses CrmInvoice::setEInvoiceIncomingCount()
     * @uses CrmInvoice::setEInvoiceOutgoingCount()
     * @uses CrmInvoice::setEArchiveInvoiceCount()
     * @uses CrmInvoice::setTotalInvoiceCredit()
     * @uses CrmInvoice::setTotalEArchiveCredit()
     * @uses CrmInvoice::setCustomerName()
     * @uses CrmInvoice::setVkn()
     * @param int $no
     * @param int $organization
     * @param string $startDate
     * @param int $eInvoiceIncomingCount
     * @param int $eInvoiceOutgoingCount
     * @param int $eArchiveInvoiceCount
     * @param int $totalInvoiceCredit
     * @param int $totalEArchiveCredit
     * @param string $customerName
     * @param string $vkn
     */
    public function __construct($no = null, $organization = null, $startDate = null, $eInvoiceIncomingCount = null, $eInvoiceOutgoingCount = null, $eArchiveInvoiceCount = null, $totalInvoiceCredit = null, $totalEArchiveCredit = null, $customerName = null, $vkn = null)
    {
        $this
            ->setNo($no)
            ->setOrganization($organization)
            ->setStartDate($startDate)
            ->setEInvoiceIncomingCount($eInvoiceIncomingCount)
            ->setEInvoiceOutgoingCount($eInvoiceOutgoingCount)
            ->setEArchiveInvoiceCount($eArchiveInvoiceCount)
            ->setTotalInvoiceCredit($totalInvoiceCredit)
            ->setTotalEArchiveCredit($totalEArchiveCredit)
            ->setCustomerName($customerName)
            ->setVkn($vkn);
    }
    /**
     * Get No value
     * @return int
     */
    public function getNo()
    {
        return $this->No;
    }
    /**
     * Set No value
     * @param int $no
     * @return \TurkkepEFatura\StructType\CrmInvoice
     */
    public function setNo($no = null)
    {
        // validation for constraint: int
        if (!is_null($no) && !(is_int($no) || ctype_digit($no))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($no, true), gettype($no)), __LINE__);
        }
        $this->No = $no;
        return $this;
    }
    /**
     * Get Organization value
     * @return int
     */
    public function getOrganization()
    {
        return $this->Organization;
    }
    /**
     * Set Organization value
     * @param int $organization
     * @return \TurkkepEFatura\StructType\CrmInvoice
     */
    public function setOrganization($organization = null)
    {
        // validation for constraint: int
        if (!is_null($organization) && !(is_int($organization) || ctype_digit($organization))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($organization, true), gettype($organization)), __LINE__);
        }
        $this->Organization = $organization;
        return $this;
    }
    /**
     * Get StartDate value
     * @return string
     */
    public function getStartDate()
    {
        return $this->StartDate;
    }
    /**
     * Set StartDate value
     * @param string $startDate
     * @return \TurkkepEFatura\StructType\CrmInvoice
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDate, true), gettype($startDate)), __LINE__);
        }
        $this->StartDate = $startDate;
        return $this;
    }
    /**
     * Get EInvoiceIncomingCount value
     * @return int
     */
    public function getEInvoiceIncomingCount()
    {
        return $this->EInvoiceIncomingCount;
    }
    /**
     * Set EInvoiceIncomingCount value
     * @param int $eInvoiceIncomingCount
     * @return \TurkkepEFatura\StructType\CrmInvoice
     */
    public function setEInvoiceIncomingCount($eInvoiceIncomingCount = null)
    {
        // validation for constraint: int
        if (!is_null($eInvoiceIncomingCount) && !(is_int($eInvoiceIncomingCount) || ctype_digit($eInvoiceIncomingCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($eInvoiceIncomingCount, true), gettype($eInvoiceIncomingCount)), __LINE__);
        }
        $this->EInvoiceIncomingCount = $eInvoiceIncomingCount;
        return $this;
    }
    /**
     * Get EInvoiceOutgoingCount value
     * @return int
     */
    public function getEInvoiceOutgoingCount()
    {
        return $this->EInvoiceOutgoingCount;
    }
    /**
     * Set EInvoiceOutgoingCount value
     * @param int $eInvoiceOutgoingCount
     * @return \TurkkepEFatura\StructType\CrmInvoice
     */
    public function setEInvoiceOutgoingCount($eInvoiceOutgoingCount = null)
    {
        // validation for constraint: int
        if (!is_null($eInvoiceOutgoingCount) && !(is_int($eInvoiceOutgoingCount) || ctype_digit($eInvoiceOutgoingCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($eInvoiceOutgoingCount, true), gettype($eInvoiceOutgoingCount)), __LINE__);
        }
        $this->EInvoiceOutgoingCount = $eInvoiceOutgoingCount;
        return $this;
    }
    /**
     * Get EArchiveInvoiceCount value
     * @return int
     */
    public function getEArchiveInvoiceCount()
    {
        return $this->EArchiveInvoiceCount;
    }
    /**
     * Set EArchiveInvoiceCount value
     * @param int $eArchiveInvoiceCount
     * @return \TurkkepEFatura\StructType\CrmInvoice
     */
    public function setEArchiveInvoiceCount($eArchiveInvoiceCount = null)
    {
        // validation for constraint: int
        if (!is_null($eArchiveInvoiceCount) && !(is_int($eArchiveInvoiceCount) || ctype_digit($eArchiveInvoiceCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($eArchiveInvoiceCount, true), gettype($eArchiveInvoiceCount)), __LINE__);
        }
        $this->EArchiveInvoiceCount = $eArchiveInvoiceCount;
        return $this;
    }
    /**
     * Get TotalInvoiceCredit value
     * @return int
     */
    public function getTotalInvoiceCredit()
    {
        return $this->TotalInvoiceCredit;
    }
    /**
     * Set TotalInvoiceCredit value
     * @param int $totalInvoiceCredit
     * @return \TurkkepEFatura\StructType\CrmInvoice
     */
    public function setTotalInvoiceCredit($totalInvoiceCredit = null)
    {
        // validation for constraint: int
        if (!is_null($totalInvoiceCredit) && !(is_int($totalInvoiceCredit) || ctype_digit($totalInvoiceCredit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalInvoiceCredit, true), gettype($totalInvoiceCredit)), __LINE__);
        }
        $this->TotalInvoiceCredit = $totalInvoiceCredit;
        return $this;
    }
    /**
     * Get TotalEArchiveCredit value
     * @return int
     */
    public function getTotalEArchiveCredit()
    {
        return $this->TotalEArchiveCredit;
    }
    /**
     * Set TotalEArchiveCredit value
     * @param int $totalEArchiveCredit
     * @return \TurkkepEFatura\StructType\CrmInvoice
     */
    public function setTotalEArchiveCredit($totalEArchiveCredit = null)
    {
        // validation for constraint: int
        if (!is_null($totalEArchiveCredit) && !(is_int($totalEArchiveCredit) || ctype_digit($totalEArchiveCredit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalEArchiveCredit, true), gettype($totalEArchiveCredit)), __LINE__);
        }
        $this->TotalEArchiveCredit = $totalEArchiveCredit;
        return $this;
    }
    /**
     * Get CustomerName value
     * @return string|null
     */
    public function getCustomerName()
    {
        return $this->CustomerName;
    }
    /**
     * Set CustomerName value
     * @param string $customerName
     * @return \TurkkepEFatura\StructType\CrmInvoice
     */
    public function setCustomerName($customerName = null)
    {
        // validation for constraint: string
        if (!is_null($customerName) && !is_string($customerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerName, true), gettype($customerName)), __LINE__);
        }
        $this->CustomerName = $customerName;
        return $this;
    }
    /**
     * Get Vkn value
     * @return string|null
     */
    public function getVkn()
    {
        return $this->Vkn;
    }
    /**
     * Set Vkn value
     * @param string $vkn
     * @return \TurkkepEFatura\StructType\CrmInvoice
     */
    public function setVkn($vkn = null)
    {
        // validation for constraint: string
        if (!is_null($vkn) && !is_string($vkn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vkn, true), gettype($vkn)), __LINE__);
        }
        $this->Vkn = $vkn;
        return $this;
    }
}
