<?php

namespace TurkkepEFatura\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreditNoteType StructType
 * @subpackage Structs
 */
class CreditNoteType extends AbstractStructBase
{
    /**
     * The UBLExtensions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s2:UBLExtensions
     * @var \TurkkepEFatura\ArrayType\ArrayOfUBLExtensionType
     */
    public $UBLExtensions;
    /**
     * The UBLVersionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:UBLVersionID
     * @var \TurkkepEFatura\StructType\UBLVersionIDType
     */
    public $UBLVersionID;
    /**
     * The CustomizationID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:CustomizationID
     * @var \TurkkepEFatura\StructType\CustomizationIDType
     */
    public $CustomizationID;
    /**
     * The ProfileID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:ProfileID
     * @var \TurkkepEFatura\StructType\ProfileIDType
     */
    public $ProfileID;
    /**
     * The ProfileExecutionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:ProfileExecutionID
     * @var \TurkkepEFatura\StructType\ProfileExecutionIDType
     */
    public $ProfileExecutionID;
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:ID
     * @var \TurkkepEFatura\StructType\IDType
     */
    public $ID;
    /**
     * The CopyIndicator
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:CopyIndicator
     * @var \TurkkepEFatura\StructType\CopyIndicatorType
     */
    public $CopyIndicator;
    /**
     * The UUID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:UUID
     * @var \TurkkepEFatura\StructType\UUIDType
     */
    public $UUID;
    /**
     * The IssueDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:IssueDate
     * @var \TurkkepEFatura\StructType\IssueDateType
     */
    public $IssueDate;
    /**
     * The IssueTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:IssueTime
     * @var \TurkkepEFatura\StructType\IssueTimeType
     */
    public $IssueTime;
    /**
     * The TaxPointDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:TaxPointDate
     * @var \TurkkepEFatura\StructType\TaxPointDateType
     */
    public $TaxPointDate;
    /**
     * The CreditNoteTypeCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:CreditNoteTypeCode
     * @var \TurkkepEFatura\StructType\CreditNoteTypeCodeType
     */
    public $CreditNoteTypeCode;
    /**
     * The Note
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: s3:Note
     * @var \TurkkepEFatura\StructType\NoteType[]
     */
    public $Note;
    /**
     * The DocumentCurrencyCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:DocumentCurrencyCode
     * @var \TurkkepEFatura\StructType\DocumentCurrencyCodeType
     */
    public $DocumentCurrencyCode;
    /**
     * The TaxCurrencyCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:TaxCurrencyCode
     * @var \TurkkepEFatura\StructType\TaxCurrencyCodeType
     */
    public $TaxCurrencyCode;
    /**
     * The PricingCurrencyCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:PricingCurrencyCode
     * @var \TurkkepEFatura\StructType\PricingCurrencyCodeType
     */
    public $PricingCurrencyCode;
    /**
     * The PaymentCurrencyCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:PaymentCurrencyCode
     * @var \TurkkepEFatura\StructType\PaymentCurrencyCodeType
     */
    public $PaymentCurrencyCode;
    /**
     * The PaymentAlternativeCurrencyCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:PaymentAlternativeCurrencyCode
     * @var \TurkkepEFatura\StructType\PaymentAlternativeCurrencyCodeType
     */
    public $PaymentAlternativeCurrencyCode;
    /**
     * The AccountingCostCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:AccountingCostCode
     * @var \TurkkepEFatura\StructType\AccountingCostCodeType
     */
    public $AccountingCostCode;
    /**
     * The AccountingCost
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:AccountingCost
     * @var \TurkkepEFatura\StructType\AccountingCostType
     */
    public $AccountingCost;
    /**
     * The LineCountNumeric
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:LineCountNumeric
     * @var \TurkkepEFatura\StructType\LineCountNumericType
     */
    public $LineCountNumeric;
    /**
     * The BuyerReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:BuyerReference
     * @var \TurkkepEFatura\StructType\BuyerReferenceType
     */
    public $BuyerReference;
    /**
     * The InvoicePeriod
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: s6:InvoicePeriod
     * @var \TurkkepEFatura\StructType\PeriodType[]
     */
    public $InvoicePeriod;
    /**
     * The DiscrepancyResponse
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: s6:DiscrepancyResponse
     * @var \TurkkepEFatura\StructType\ResponseType[]
     */
    public $DiscrepancyResponse;
    /**
     * The OrderReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s6:OrderReference
     * @var \TurkkepEFatura\StructType\OrderReferenceType
     */
    public $OrderReference;
    /**
     * The BillingReference
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: s6:BillingReference
     * @var \TurkkepEFatura\StructType\BillingReferenceType[]
     */
    public $BillingReference;
    /**
     * The DespatchDocumentReference
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: s6:DespatchDocumentReference
     * @var \TurkkepEFatura\StructType\DocumentReferenceType[]
     */
    public $DespatchDocumentReference;
    /**
     * The ReceiptDocumentReference
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: s6:ReceiptDocumentReference
     * @var \TurkkepEFatura\StructType\DocumentReferenceType[]
     */
    public $ReceiptDocumentReference;
    /**
     * The ContractDocumentReference
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: s6:ContractDocumentReference
     * @var \TurkkepEFatura\StructType\DocumentReferenceType[]
     */
    public $ContractDocumentReference;
    /**
     * The AdditionalDocumentReference
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: s6:AdditionalDocumentReference
     * @var \TurkkepEFatura\StructType\DocumentReferenceType[]
     */
    public $AdditionalDocumentReference;
    /**
     * The StatementDocumentReference
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: s6:StatementDocumentReference
     * @var \TurkkepEFatura\StructType\DocumentReferenceType[]
     */
    public $StatementDocumentReference;
    /**
     * The OriginatorDocumentReference
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: s6:OriginatorDocumentReference
     * @var \TurkkepEFatura\StructType\DocumentReferenceType[]
     */
    public $OriginatorDocumentReference;
    /**
     * The Signature
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: s6:Signature
     * @var \TurkkepEFatura\StructType\SignatureType[]
     */
    public $Signature;
    /**
     * The AccountingSupplierParty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s6:AccountingSupplierParty
     * @var \TurkkepEFatura\StructType\SupplierPartyType
     */
    public $AccountingSupplierParty;
    /**
     * The AccountingCustomerParty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s6:AccountingCustomerParty
     * @var \TurkkepEFatura\StructType\CustomerPartyType
     */
    public $AccountingCustomerParty;
    /**
     * The PayeeParty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s6:PayeeParty
     * @var \TurkkepEFatura\StructType\PartyType
     */
    public $PayeeParty;
    /**
     * The BuyerCustomerParty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s6:BuyerCustomerParty
     * @var \TurkkepEFatura\StructType\CustomerPartyType
     */
    public $BuyerCustomerParty;
    /**
     * The SellerSupplierParty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s6:SellerSupplierParty
     * @var \TurkkepEFatura\StructType\SupplierPartyType
     */
    public $SellerSupplierParty;
    /**
     * The TaxRepresentativeParty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s6:TaxRepresentativeParty
     * @var \TurkkepEFatura\StructType\PartyType
     */
    public $TaxRepresentativeParty;
    /**
     * The Delivery
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: s6:Delivery
     * @var \TurkkepEFatura\StructType\DeliveryType[]
     */
    public $Delivery;
    /**
     * The DeliveryTerms
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: s6:DeliveryTerms
     * @var \TurkkepEFatura\StructType\DeliveryTermsType[]
     */
    public $DeliveryTerms;
    /**
     * The PaymentMeans
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: s6:PaymentMeans
     * @var \TurkkepEFatura\StructType\PaymentMeansType[]
     */
    public $PaymentMeans;
    /**
     * The PaymentTerms
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: s6:PaymentTerms
     * @var \TurkkepEFatura\StructType\PaymentTermsType[]
     */
    public $PaymentTerms;
    /**
     * The TaxExchangeRate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s6:TaxExchangeRate
     * @var \TurkkepEFatura\StructType\ExchangeRateType
     */
    public $TaxExchangeRate;
    /**
     * The PricingExchangeRate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s6:PricingExchangeRate
     * @var \TurkkepEFatura\StructType\ExchangeRateType
     */
    public $PricingExchangeRate;
    /**
     * The PaymentExchangeRate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s6:PaymentExchangeRate
     * @var \TurkkepEFatura\StructType\ExchangeRateType
     */
    public $PaymentExchangeRate;
    /**
     * The PaymentAlternativeExchangeRate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s6:PaymentAlternativeExchangeRate
     * @var \TurkkepEFatura\StructType\ExchangeRateType
     */
    public $PaymentAlternativeExchangeRate;
    /**
     * The AllowanceCharge
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: s6:AllowanceCharge
     * @var \TurkkepEFatura\StructType\AllowanceChargeType[]
     */
    public $AllowanceCharge;
    /**
     * The TaxTotal
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: s6:TaxTotal
     * @var \TurkkepEFatura\StructType\TaxTotalType[]
     */
    public $TaxTotal;
    /**
     * The LegalMonetaryTotal
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s6:LegalMonetaryTotal
     * @var \TurkkepEFatura\StructType\MonetaryTotalType
     */
    public $LegalMonetaryTotal;
    /**
     * The CreditNoteLine
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: s6:CreditNoteLine
     * @var \TurkkepEFatura\StructType\CreditNoteLineType[]
     */
    public $CreditNoteLine;
    /**
     * Constructor method for CreditNoteType
     * @uses CreditNoteType::setUBLExtensions()
     * @uses CreditNoteType::setUBLVersionID()
     * @uses CreditNoteType::setCustomizationID()
     * @uses CreditNoteType::setProfileID()
     * @uses CreditNoteType::setProfileExecutionID()
     * @uses CreditNoteType::setID()
     * @uses CreditNoteType::setCopyIndicator()
     * @uses CreditNoteType::setUUID()
     * @uses CreditNoteType::setIssueDate()
     * @uses CreditNoteType::setIssueTime()
     * @uses CreditNoteType::setTaxPointDate()
     * @uses CreditNoteType::setCreditNoteTypeCode()
     * @uses CreditNoteType::setNote()
     * @uses CreditNoteType::setDocumentCurrencyCode()
     * @uses CreditNoteType::setTaxCurrencyCode()
     * @uses CreditNoteType::setPricingCurrencyCode()
     * @uses CreditNoteType::setPaymentCurrencyCode()
     * @uses CreditNoteType::setPaymentAlternativeCurrencyCode()
     * @uses CreditNoteType::setAccountingCostCode()
     * @uses CreditNoteType::setAccountingCost()
     * @uses CreditNoteType::setLineCountNumeric()
     * @uses CreditNoteType::setBuyerReference()
     * @uses CreditNoteType::setInvoicePeriod()
     * @uses CreditNoteType::setDiscrepancyResponse()
     * @uses CreditNoteType::setOrderReference()
     * @uses CreditNoteType::setBillingReference()
     * @uses CreditNoteType::setDespatchDocumentReference()
     * @uses CreditNoteType::setReceiptDocumentReference()
     * @uses CreditNoteType::setContractDocumentReference()
     * @uses CreditNoteType::setAdditionalDocumentReference()
     * @uses CreditNoteType::setStatementDocumentReference()
     * @uses CreditNoteType::setOriginatorDocumentReference()
     * @uses CreditNoteType::setSignature()
     * @uses CreditNoteType::setAccountingSupplierParty()
     * @uses CreditNoteType::setAccountingCustomerParty()
     * @uses CreditNoteType::setPayeeParty()
     * @uses CreditNoteType::setBuyerCustomerParty()
     * @uses CreditNoteType::setSellerSupplierParty()
     * @uses CreditNoteType::setTaxRepresentativeParty()
     * @uses CreditNoteType::setDelivery()
     * @uses CreditNoteType::setDeliveryTerms()
     * @uses CreditNoteType::setPaymentMeans()
     * @uses CreditNoteType::setPaymentTerms()
     * @uses CreditNoteType::setTaxExchangeRate()
     * @uses CreditNoteType::setPricingExchangeRate()
     * @uses CreditNoteType::setPaymentExchangeRate()
     * @uses CreditNoteType::setPaymentAlternativeExchangeRate()
     * @uses CreditNoteType::setAllowanceCharge()
     * @uses CreditNoteType::setTaxTotal()
     * @uses CreditNoteType::setLegalMonetaryTotal()
     * @uses CreditNoteType::setCreditNoteLine()
     * @param \TurkkepEFatura\ArrayType\ArrayOfUBLExtensionType $uBLExtensions
     * @param \TurkkepEFatura\StructType\UBLVersionIDType $uBLVersionID
     * @param \TurkkepEFatura\StructType\CustomizationIDType $customizationID
     * @param \TurkkepEFatura\StructType\ProfileIDType $profileID
     * @param \TurkkepEFatura\StructType\ProfileExecutionIDType $profileExecutionID
     * @param \TurkkepEFatura\StructType\IDType $iD
     * @param \TurkkepEFatura\StructType\CopyIndicatorType $copyIndicator
     * @param \TurkkepEFatura\StructType\UUIDType $uUID
     * @param \TurkkepEFatura\StructType\IssueDateType $issueDate
     * @param \TurkkepEFatura\StructType\IssueTimeType $issueTime
     * @param \TurkkepEFatura\StructType\TaxPointDateType $taxPointDate
     * @param \TurkkepEFatura\StructType\CreditNoteTypeCodeType $creditNoteTypeCode
     * @param \TurkkepEFatura\StructType\NoteType[] $note
     * @param \TurkkepEFatura\StructType\DocumentCurrencyCodeType $documentCurrencyCode
     * @param \TurkkepEFatura\StructType\TaxCurrencyCodeType $taxCurrencyCode
     * @param \TurkkepEFatura\StructType\PricingCurrencyCodeType $pricingCurrencyCode
     * @param \TurkkepEFatura\StructType\PaymentCurrencyCodeType $paymentCurrencyCode
     * @param \TurkkepEFatura\StructType\PaymentAlternativeCurrencyCodeType $paymentAlternativeCurrencyCode
     * @param \TurkkepEFatura\StructType\AccountingCostCodeType $accountingCostCode
     * @param \TurkkepEFatura\StructType\AccountingCostType $accountingCost
     * @param \TurkkepEFatura\StructType\LineCountNumericType $lineCountNumeric
     * @param \TurkkepEFatura\StructType\BuyerReferenceType $buyerReference
     * @param \TurkkepEFatura\StructType\PeriodType[] $invoicePeriod
     * @param \TurkkepEFatura\StructType\ResponseType[] $discrepancyResponse
     * @param \TurkkepEFatura\StructType\OrderReferenceType $orderReference
     * @param \TurkkepEFatura\StructType\BillingReferenceType[] $billingReference
     * @param \TurkkepEFatura\StructType\DocumentReferenceType[] $despatchDocumentReference
     * @param \TurkkepEFatura\StructType\DocumentReferenceType[] $receiptDocumentReference
     * @param \TurkkepEFatura\StructType\DocumentReferenceType[] $contractDocumentReference
     * @param \TurkkepEFatura\StructType\DocumentReferenceType[] $additionalDocumentReference
     * @param \TurkkepEFatura\StructType\DocumentReferenceType[] $statementDocumentReference
     * @param \TurkkepEFatura\StructType\DocumentReferenceType[] $originatorDocumentReference
     * @param \TurkkepEFatura\StructType\SignatureType[] $signature
     * @param \TurkkepEFatura\StructType\SupplierPartyType $accountingSupplierParty
     * @param \TurkkepEFatura\StructType\CustomerPartyType $accountingCustomerParty
     * @param \TurkkepEFatura\StructType\PartyType $payeeParty
     * @param \TurkkepEFatura\StructType\CustomerPartyType $buyerCustomerParty
     * @param \TurkkepEFatura\StructType\SupplierPartyType $sellerSupplierParty
     * @param \TurkkepEFatura\StructType\PartyType $taxRepresentativeParty
     * @param \TurkkepEFatura\StructType\DeliveryType[] $delivery
     * @param \TurkkepEFatura\StructType\DeliveryTermsType[] $deliveryTerms
     * @param \TurkkepEFatura\StructType\PaymentMeansType[] $paymentMeans
     * @param \TurkkepEFatura\StructType\PaymentTermsType[] $paymentTerms
     * @param \TurkkepEFatura\StructType\ExchangeRateType $taxExchangeRate
     * @param \TurkkepEFatura\StructType\ExchangeRateType $pricingExchangeRate
     * @param \TurkkepEFatura\StructType\ExchangeRateType $paymentExchangeRate
     * @param \TurkkepEFatura\StructType\ExchangeRateType $paymentAlternativeExchangeRate
     * @param \TurkkepEFatura\StructType\AllowanceChargeType[] $allowanceCharge
     * @param \TurkkepEFatura\StructType\TaxTotalType[] $taxTotal
     * @param \TurkkepEFatura\StructType\MonetaryTotalType $legalMonetaryTotal
     * @param \TurkkepEFatura\StructType\CreditNoteLineType[] $creditNoteLine
     */
    public function __construct(\TurkkepEFatura\ArrayType\ArrayOfUBLExtensionType $uBLExtensions = null, \TurkkepEFatura\StructType\UBLVersionIDType $uBLVersionID = null, \TurkkepEFatura\StructType\CustomizationIDType $customizationID = null, \TurkkepEFatura\StructType\ProfileIDType $profileID = null, \TurkkepEFatura\StructType\ProfileExecutionIDType $profileExecutionID = null, \TurkkepEFatura\StructType\IDType $iD = null, \TurkkepEFatura\StructType\CopyIndicatorType $copyIndicator = null, \TurkkepEFatura\StructType\UUIDType $uUID = null, \TurkkepEFatura\StructType\IssueDateType $issueDate = null, \TurkkepEFatura\StructType\IssueTimeType $issueTime = null, \TurkkepEFatura\StructType\TaxPointDateType $taxPointDate = null, \TurkkepEFatura\StructType\CreditNoteTypeCodeType $creditNoteTypeCode = null, array $note = array(), \TurkkepEFatura\StructType\DocumentCurrencyCodeType $documentCurrencyCode = null, \TurkkepEFatura\StructType\TaxCurrencyCodeType $taxCurrencyCode = null, \TurkkepEFatura\StructType\PricingCurrencyCodeType $pricingCurrencyCode = null, \TurkkepEFatura\StructType\PaymentCurrencyCodeType $paymentCurrencyCode = null, \TurkkepEFatura\StructType\PaymentAlternativeCurrencyCodeType $paymentAlternativeCurrencyCode = null, \TurkkepEFatura\StructType\AccountingCostCodeType $accountingCostCode = null, \TurkkepEFatura\StructType\AccountingCostType $accountingCost = null, \TurkkepEFatura\StructType\LineCountNumericType $lineCountNumeric = null, \TurkkepEFatura\StructType\BuyerReferenceType $buyerReference = null, array $invoicePeriod = array(), array $discrepancyResponse = array(), \TurkkepEFatura\StructType\OrderReferenceType $orderReference = null, array $billingReference = array(), array $despatchDocumentReference = array(), array $receiptDocumentReference = array(), array $contractDocumentReference = array(), array $additionalDocumentReference = array(), array $statementDocumentReference = array(), array $originatorDocumentReference = array(), array $signature = array(), \TurkkepEFatura\StructType\SupplierPartyType $accountingSupplierParty = null, \TurkkepEFatura\StructType\CustomerPartyType $accountingCustomerParty = null, \TurkkepEFatura\StructType\PartyType $payeeParty = null, \TurkkepEFatura\StructType\CustomerPartyType $buyerCustomerParty = null, \TurkkepEFatura\StructType\SupplierPartyType $sellerSupplierParty = null, \TurkkepEFatura\StructType\PartyType $taxRepresentativeParty = null, array $delivery = array(), array $deliveryTerms = array(), array $paymentMeans = array(), array $paymentTerms = array(), \TurkkepEFatura\StructType\ExchangeRateType $taxExchangeRate = null, \TurkkepEFatura\StructType\ExchangeRateType $pricingExchangeRate = null, \TurkkepEFatura\StructType\ExchangeRateType $paymentExchangeRate = null, \TurkkepEFatura\StructType\ExchangeRateType $paymentAlternativeExchangeRate = null, array $allowanceCharge = array(), array $taxTotal = array(), \TurkkepEFatura\StructType\MonetaryTotalType $legalMonetaryTotal = null, array $creditNoteLine = array())
    {
        $this
            ->setUBLExtensions($uBLExtensions)
            ->setUBLVersionID($uBLVersionID)
            ->setCustomizationID($customizationID)
            ->setProfileID($profileID)
            ->setProfileExecutionID($profileExecutionID)
            ->setID($iD)
            ->setCopyIndicator($copyIndicator)
            ->setUUID($uUID)
            ->setIssueDate($issueDate)
            ->setIssueTime($issueTime)
            ->setTaxPointDate($taxPointDate)
            ->setCreditNoteTypeCode($creditNoteTypeCode)
            ->setNote($note)
            ->setDocumentCurrencyCode($documentCurrencyCode)
            ->setTaxCurrencyCode($taxCurrencyCode)
            ->setPricingCurrencyCode($pricingCurrencyCode)
            ->setPaymentCurrencyCode($paymentCurrencyCode)
            ->setPaymentAlternativeCurrencyCode($paymentAlternativeCurrencyCode)
            ->setAccountingCostCode($accountingCostCode)
            ->setAccountingCost($accountingCost)
            ->setLineCountNumeric($lineCountNumeric)
            ->setBuyerReference($buyerReference)
            ->setInvoicePeriod($invoicePeriod)
            ->setDiscrepancyResponse($discrepancyResponse)
            ->setOrderReference($orderReference)
            ->setBillingReference($billingReference)
            ->setDespatchDocumentReference($despatchDocumentReference)
            ->setReceiptDocumentReference($receiptDocumentReference)
            ->setContractDocumentReference($contractDocumentReference)
            ->setAdditionalDocumentReference($additionalDocumentReference)
            ->setStatementDocumentReference($statementDocumentReference)
            ->setOriginatorDocumentReference($originatorDocumentReference)
            ->setSignature($signature)
            ->setAccountingSupplierParty($accountingSupplierParty)
            ->setAccountingCustomerParty($accountingCustomerParty)
            ->setPayeeParty($payeeParty)
            ->setBuyerCustomerParty($buyerCustomerParty)
            ->setSellerSupplierParty($sellerSupplierParty)
            ->setTaxRepresentativeParty($taxRepresentativeParty)
            ->setDelivery($delivery)
            ->setDeliveryTerms($deliveryTerms)
            ->setPaymentMeans($paymentMeans)
            ->setPaymentTerms($paymentTerms)
            ->setTaxExchangeRate($taxExchangeRate)
            ->setPricingExchangeRate($pricingExchangeRate)
            ->setPaymentExchangeRate($paymentExchangeRate)
            ->setPaymentAlternativeExchangeRate($paymentAlternativeExchangeRate)
            ->setAllowanceCharge($allowanceCharge)
            ->setTaxTotal($taxTotal)
            ->setLegalMonetaryTotal($legalMonetaryTotal)
            ->setCreditNoteLine($creditNoteLine);
    }
    /**
     * Get UBLExtensions value
     * @return \TurkkepEFatura\ArrayType\ArrayOfUBLExtensionType|null
     */
    public function getUBLExtensions()
    {
        return $this->UBLExtensions;
    }
    /**
     * Set UBLExtensions value
     * @param \TurkkepEFatura\ArrayType\ArrayOfUBLExtensionType $uBLExtensions
     * @return \TurkkepEFatura\StructType\CreditNoteType
     */
    public function setUBLExtensions(\TurkkepEFatura\ArrayType\ArrayOfUBLExtensionType $uBLExtensions = null)
    {
        $this->UBLExtensions = $uBLExtensions;
        return $this;
    }
    /**
     * Get UBLVersionID value
     * @return \TurkkepEFatura\StructType\UBLVersionIDType|null
     */
    public function getUBLVersionID()
    {
        return $this->UBLVersionID;
    }
    /**
     * Set UBLVersionID value
     * @param \TurkkepEFatura\StructType\UBLVersionIDType $uBLVersionID
     * @return \TurkkepEFatura\StructType\CreditNoteType
     */
    public function setUBLVersionID(\TurkkepEFatura\StructType\UBLVersionIDType $uBLVersionID = null)
    {
        $this->UBLVersionID = $uBLVersionID;
        return $this;
    }
    /**
     * Get CustomizationID value
     * @return \TurkkepEFatura\StructType\CustomizationIDType|null
     */
    public function getCustomizationID()
    {
        return $this->CustomizationID;
    }
    /**
     * Set CustomizationID value
     * @param \TurkkepEFatura\StructType\CustomizationIDType $customizationID
     * @return \TurkkepEFatura\StructType\CreditNoteType
     */
    public function setCustomizationID(\TurkkepEFatura\StructType\CustomizationIDType $customizationID = null)
    {
        $this->CustomizationID = $customizationID;
        return $this;
    }
    /**
     * Get ProfileID value
     * @return \TurkkepEFatura\StructType\ProfileIDType|null
     */
    public function getProfileID()
    {
        return $this->ProfileID;
    }
    /**
     * Set ProfileID value
     * @param \TurkkepEFatura\StructType\ProfileIDType $profileID
     * @return \TurkkepEFatura\StructType\CreditNoteType
     */
    public function setProfileID(\TurkkepEFatura\StructType\ProfileIDType $profileID = null)
    {
        $this->ProfileID = $profileID;
        return $this;
    }
    /**
     * Get ProfileExecutionID value
     * @return \TurkkepEFatura\StructType\ProfileExecutionIDType|null
     */
    public function getProfileExecutionID()
    {
        return $this->ProfileExecutionID;
    }
    /**
     * Set ProfileExecutionID value
     * @param \TurkkepEFatura\StructType\ProfileExecutionIDType $profileExecutionID
     * @return \TurkkepEFatura\StructType\CreditNoteType
     */
    public function setProfileExecutionID(\TurkkepEFatura\StructType\ProfileExecutionIDType $profileExecutionID = null)
    {
        $this->ProfileExecutionID = $profileExecutionID;
        return $this;
    }
    /**
     * Get ID value
     * @return \TurkkepEFatura\StructType\IDType|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param \TurkkepEFatura\StructType\IDType $iD
     * @return \TurkkepEFatura\StructType\CreditNoteType
     */
    public function setID(\TurkkepEFatura\StructType\IDType $iD = null)
    {
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get CopyIndicator value
     * @return \TurkkepEFatura\StructType\CopyIndicatorType|null
     */
    public function getCopyIndicator()
    {
        return $this->CopyIndicator;
    }
    /**
     * Set CopyIndicator value
     * @param \TurkkepEFatura\StructType\CopyIndicatorType $copyIndicator
     * @return \TurkkepEFatura\StructType\CreditNoteType
     */
    public function setCopyIndicator(\TurkkepEFatura\StructType\CopyIndicatorType $copyIndicator = null)
    {
        $this->CopyIndicator = $copyIndicator;
        return $this;
    }
    /**
     * Get UUID value
     * @return \TurkkepEFatura\StructType\UUIDType|null
     */
    public function getUUID()
    {
        return $this->UUID;
    }
    /**
     * Set UUID value
     * @param \TurkkepEFatura\StructType\UUIDType $uUID
     * @return \TurkkepEFatura\StructType\CreditNoteType
     */
    public function setUUID(\TurkkepEFatura\StructType\UUIDType $uUID = null)
    {
        $this->UUID = $uUID;
        return $this;
    }
    /**
     * Get IssueDate value
     * @return \TurkkepEFatura\StructType\IssueDateType|null
     */
    public function getIssueDate()
    {
        return $this->IssueDate;
    }
    /**
     * Set IssueDate value
     * @param \TurkkepEFatura\StructType\IssueDateType $issueDate
     * @return \TurkkepEFatura\StructType\CreditNoteType
     */
    public function setIssueDate(\TurkkepEFatura\StructType\IssueDateType $issueDate = null)
    {
        $this->IssueDate = $issueDate;
        return $this;
    }
    /**
     * Get IssueTime value
     * @return \TurkkepEFatura\StructType\IssueTimeType|null
     */
    public function getIssueTime()
    {
        return $this->IssueTime;
    }
    /**
     * Set IssueTime value
     * @param \TurkkepEFatura\StructType\IssueTimeType $issueTime
     * @return \TurkkepEFatura\StructType\CreditNoteType
     */
    public function setIssueTime(\TurkkepEFatura\StructType\IssueTimeType $issueTime = null)
    {
        $this->IssueTime = $issueTime;
        return $this;
    }
    /**
     * Get TaxPointDate value
     * @return \TurkkepEFatura\StructType\TaxPointDateType|null
     */
    public function getTaxPointDate()
    {
        return $this->TaxPointDate;
    }
    /**
     * Set TaxPointDate value
     * @param \TurkkepEFatura\StructType\TaxPointDateType $taxPointDate
     * @return \TurkkepEFatura\StructType\CreditNoteType
     */
    public function setTaxPointDate(\TurkkepEFatura\StructType\TaxPointDateType $taxPointDate = null)
    {
        $this->TaxPointDate = $taxPointDate;
        return $this;
    }
    /**
     * Get CreditNoteTypeCode value
     * @return \TurkkepEFatura\StructType\CreditNoteTypeCodeType|null
     */
    public function getCreditNoteTypeCode()
    {
        return $this->CreditNoteTypeCode;
    }
    /**
     * Set CreditNoteTypeCode value
     * @param \TurkkepEFatura\StructType\CreditNoteTypeCodeType $creditNoteTypeCode
     * @return \TurkkepEFatura\StructType\CreditNoteType
     */
    public function setCreditNoteTypeCode(\TurkkepEFatura\StructType\CreditNoteTypeCodeType $creditNoteTypeCode = null)
    {
        $this->CreditNoteTypeCode = $creditNoteTypeCode;
        return $this;
    }
    /**
     * Get Note value
     * @return \TurkkepEFatura\StructType\NoteType[]|null
     */
    public function getNote()
    {
        return $this->Note;
    }
    /**
     * This method is responsible for validating the values passed to the setNote method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNote method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateNoteForArrayConstraintsFromSetNote(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $creditNoteTypeNoteItem) {
            // validation for constraint: itemType
            if (!$creditNoteTypeNoteItem instanceof \TurkkepEFatura\StructType\NoteType) {
                $invalidValues[] = is_object($creditNoteTypeNoteItem) ? get_class($creditNoteTypeNoteItem) : sprintf('%s(%s)', gettype($creditNoteTypeNoteItem), var_export($creditNoteTypeNoteItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Note property can only contain items of type \TurkkepEFatura\StructType\NoteType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Note value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\NoteType[] $note
     * @return \TurkkepEFatura\StructType\CreditNoteType
     */
    public function setNote(array $note = array())
    {
        // validation for constraint: array
        if ('' !== ($noteArrayErrorMessage = self::validateNoteForArrayConstraintsFromSetNote($note))) {
            throw new \InvalidArgumentException($noteArrayErrorMessage, __LINE__);
        }
        $this->Note = $note;
        return $this;
    }
    /**
     * Add item to Note value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\NoteType $item
     * @return \TurkkepEFatura\StructType\CreditNoteType
     */
    public function addToNote(\TurkkepEFatura\StructType\NoteType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \TurkkepEFatura\StructType\NoteType) {
            throw new \InvalidArgumentException(sprintf('The Note property can only contain items of type \TurkkepEFatura\StructType\NoteType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Note[] = $item;
        return $this;
    }
    /**
     * Get DocumentCurrencyCode value
     * @return \TurkkepEFatura\StructType\DocumentCurrencyCodeType|null
     */
    public function getDocumentCurrencyCode()
    {
        return $this->DocumentCurrencyCode;
    }
    /**
     * Set DocumentCurrencyCode value
     * @param \TurkkepEFatura\StructType\DocumentCurrencyCodeType $documentCurrencyCode
     * @return \TurkkepEFatura\StructType\CreditNoteType
     */
    public function setDocumentCurrencyCode(\TurkkepEFatura\StructType\DocumentCurrencyCodeType $documentCurrencyCode = null)
    {
        $this->DocumentCurrencyCode = $documentCurrencyCode;
        return $this;
    }
    /**
     * Get TaxCurrencyCode value
     * @return \TurkkepEFatura\StructType\TaxCurrencyCodeType|null
     */
    public function getTaxCurrencyCode()
    {
        return $this->TaxCurrencyCode;
    }
    /**
     * Set TaxCurrencyCode value
     * @param \TurkkepEFatura\StructType\TaxCurrencyCodeType $taxCurrencyCode
     * @return \TurkkepEFatura\StructType\CreditNoteType
     */
    public function setTaxCurrencyCode(\TurkkepEFatura\StructType\TaxCurrencyCodeType $taxCurrencyCode = null)
    {
        $this->TaxCurrencyCode = $taxCurrencyCode;
        return $this;
    }
    /**
     * Get PricingCurrencyCode value
     * @return \TurkkepEFatura\StructType\PricingCurrencyCodeType|null
     */
    public function getPricingCurrencyCode()
    {
        return $this->PricingCurrencyCode;
    }
    /**
     * Set PricingCurrencyCode value
     * @param \TurkkepEFatura\StructType\PricingCurrencyCodeType $pricingCurrencyCode
     * @return \TurkkepEFatura\StructType\CreditNoteType
     */
    public function setPricingCurrencyCode(\TurkkepEFatura\StructType\PricingCurrencyCodeType $pricingCurrencyCode = null)
    {
        $this->PricingCurrencyCode = $pricingCurrencyCode;
        return $this;
    }
    /**
     * Get PaymentCurrencyCode value
     * @return \TurkkepEFatura\StructType\PaymentCurrencyCodeType|null
     */
    public function getPaymentCurrencyCode()
    {
        return $this->PaymentCurrencyCode;
    }
    /**
     * Set PaymentCurrencyCode value
     * @param \TurkkepEFatura\StructType\PaymentCurrencyCodeType $paymentCurrencyCode
     * @return \TurkkepEFatura\StructType\CreditNoteType
     */
    public function setPaymentCurrencyCode(\TurkkepEFatura\StructType\PaymentCurrencyCodeType $paymentCurrencyCode = null)
    {
        $this->PaymentCurrencyCode = $paymentCurrencyCode;
        return $this;
    }
    /**
     * Get PaymentAlternativeCurrencyCode value
     * @return \TurkkepEFatura\StructType\PaymentAlternativeCurrencyCodeType|null
     */
    public function getPaymentAlternativeCurrencyCode()
    {
        return $this->PaymentAlternativeCurrencyCode;
    }
    /**
     * Set PaymentAlternativeCurrencyCode value
     * @param \TurkkepEFatura\StructType\PaymentAlternativeCurrencyCodeType $paymentAlternativeCurrencyCode
     * @return \TurkkepEFatura\StructType\CreditNoteType
     */
    public function setPaymentAlternativeCurrencyCode(\TurkkepEFatura\StructType\PaymentAlternativeCurrencyCodeType $paymentAlternativeCurrencyCode = null)
    {
        $this->PaymentAlternativeCurrencyCode = $paymentAlternativeCurrencyCode;
        return $this;
    }
    /**
     * Get AccountingCostCode value
     * @return \TurkkepEFatura\StructType\AccountingCostCodeType|null
     */
    public function getAccountingCostCode()
    {
        return $this->AccountingCostCode;
    }
    /**
     * Set AccountingCostCode value
     * @param \TurkkepEFatura\StructType\AccountingCostCodeType $accountingCostCode
     * @return \TurkkepEFatura\StructType\CreditNoteType
     */
    public function setAccountingCostCode(\TurkkepEFatura\StructType\AccountingCostCodeType $accountingCostCode = null)
    {
        $this->AccountingCostCode = $accountingCostCode;
        return $this;
    }
    /**
     * Get AccountingCost value
     * @return \TurkkepEFatura\StructType\AccountingCostType|null
     */
    public function getAccountingCost()
    {
        return $this->AccountingCost;
    }
    /**
     * Set AccountingCost value
     * @param \TurkkepEFatura\StructType\AccountingCostType $accountingCost
     * @return \TurkkepEFatura\StructType\CreditNoteType
     */
    public function setAccountingCost(\TurkkepEFatura\StructType\AccountingCostType $accountingCost = null)
    {
        $this->AccountingCost = $accountingCost;
        return $this;
    }
    /**
     * Get LineCountNumeric value
     * @return \TurkkepEFatura\StructType\LineCountNumericType|null
     */
    public function getLineCountNumeric()
    {
        return $this->LineCountNumeric;
    }
    /**
     * Set LineCountNumeric value
     * @param \TurkkepEFatura\StructType\LineCountNumericType $lineCountNumeric
     * @return \TurkkepEFatura\StructType\CreditNoteType
     */
    public function setLineCountNumeric(\TurkkepEFatura\StructType\LineCountNumericType $lineCountNumeric = null)
    {
        $this->LineCountNumeric = $lineCountNumeric;
        return $this;
    }
    /**
     * Get BuyerReference value
     * @return \TurkkepEFatura\StructType\BuyerReferenceType|null
     */
    public function getBuyerReference()
    {
        return $this->BuyerReference;
    }
    /**
     * Set BuyerReference value
     * @param \TurkkepEFatura\StructType\BuyerReferenceType $buyerReference
     * @return \TurkkepEFatura\StructType\CreditNoteType
     */
    public function setBuyerReference(\TurkkepEFatura\StructType\BuyerReferenceType $buyerReference = null)
    {
        $this->BuyerReference = $buyerReference;
        return $this;
    }
    /**
     * Get InvoicePeriod value
     * @return \TurkkepEFatura\StructType\PeriodType[]|null
     */
    public function getInvoicePeriod()
    {
        return $this->InvoicePeriod;
    }
    /**
     * This method is responsible for validating the values passed to the setInvoicePeriod method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInvoicePeriod method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInvoicePeriodForArrayConstraintsFromSetInvoicePeriod(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $creditNoteTypeInvoicePeriodItem) {
            // validation for constraint: itemType
            if (!$creditNoteTypeInvoicePeriodItem instanceof \TurkkepEFatura\StructType\PeriodType) {
                $invalidValues[] = is_object($creditNoteTypeInvoicePeriodItem) ? get_class($creditNoteTypeInvoicePeriodItem) : sprintf('%s(%s)', gettype($creditNoteTypeInvoicePeriodItem), var_export($creditNoteTypeInvoicePeriodItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The InvoicePeriod property can only contain items of type \TurkkepEFatura\StructType\PeriodType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set InvoicePeriod value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\PeriodType[] $invoicePeriod
     * @return \TurkkepEFatura\StructType\CreditNoteType
     */
    public function setInvoicePeriod(array $invoicePeriod = array())
    {
        // validation for constraint: array
        if ('' !== ($invoicePeriodArrayErrorMessage = self::validateInvoicePeriodForArrayConstraintsFromSetInvoicePeriod($invoicePeriod))) {
            throw new \InvalidArgumentException($invoicePeriodArrayErrorMessage, __LINE__);
        }
        $this->InvoicePeriod = $invoicePeriod;
        return $this;
    }
    /**
     * Add item to InvoicePeriod value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\PeriodType $item
     * @return \TurkkepEFatura\StructType\CreditNoteType
     */
    public function addToInvoicePeriod(\TurkkepEFatura\StructType\PeriodType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \TurkkepEFatura\StructType\PeriodType) {
            throw new \InvalidArgumentException(sprintf('The InvoicePeriod property can only contain items of type \TurkkepEFatura\StructType\PeriodType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->InvoicePeriod[] = $item;
        return $this;
    }
    /**
     * Get DiscrepancyResponse value
     * @return \TurkkepEFatura\StructType\ResponseType[]|null
     */
    public function getDiscrepancyResponse()
    {
        return $this->DiscrepancyResponse;
    }
    /**
     * This method is responsible for validating the values passed to the setDiscrepancyResponse method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDiscrepancyResponse method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDiscrepancyResponseForArrayConstraintsFromSetDiscrepancyResponse(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $creditNoteTypeDiscrepancyResponseItem) {
            // validation for constraint: itemType
            if (!$creditNoteTypeDiscrepancyResponseItem instanceof \TurkkepEFatura\StructType\ResponseType) {
                $invalidValues[] = is_object($creditNoteTypeDiscrepancyResponseItem) ? get_class($creditNoteTypeDiscrepancyResponseItem) : sprintf('%s(%s)', gettype($creditNoteTypeDiscrepancyResponseItem), var_export($creditNoteTypeDiscrepancyResponseItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DiscrepancyResponse property can only contain items of type \TurkkepEFatura\StructType\ResponseType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DiscrepancyResponse value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\ResponseType[] $discrepancyResponse
     * @return \TurkkepEFatura\StructType\CreditNoteType
     */
    public function setDiscrepancyResponse(array $discrepancyResponse = array())
    {
        // validation for constraint: array
        if ('' !== ($discrepancyResponseArrayErrorMessage = self::validateDiscrepancyResponseForArrayConstraintsFromSetDiscrepancyResponse($discrepancyResponse))) {
            throw new \InvalidArgumentException($discrepancyResponseArrayErrorMessage, __LINE__);
        }
        $this->DiscrepancyResponse = $discrepancyResponse;
        return $this;
    }
    /**
     * Add item to DiscrepancyResponse value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\ResponseType $item
     * @return \TurkkepEFatura\StructType\CreditNoteType
     */
    public function addToDiscrepancyResponse(\TurkkepEFatura\StructType\ResponseType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \TurkkepEFatura\StructType\ResponseType) {
            throw new \InvalidArgumentException(sprintf('The DiscrepancyResponse property can only contain items of type \TurkkepEFatura\StructType\ResponseType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DiscrepancyResponse[] = $item;
        return $this;
    }
    /**
     * Get OrderReference value
     * @return \TurkkepEFatura\StructType\OrderReferenceType|null
     */
    public function getOrderReference()
    {
        return $this->OrderReference;
    }
    /**
     * Set OrderReference value
     * @param \TurkkepEFatura\StructType\OrderReferenceType $orderReference
     * @return \TurkkepEFatura\StructType\CreditNoteType
     */
    public function setOrderReference(\TurkkepEFatura\StructType\OrderReferenceType $orderReference = null)
    {
        $this->OrderReference = $orderReference;
        return $this;
    }
    /**
     * Get BillingReference value
     * @return \TurkkepEFatura\StructType\BillingReferenceType[]|null
     */
    public function getBillingReference()
    {
        return $this->BillingReference;
    }
    /**
     * This method is responsible for validating the values passed to the setBillingReference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBillingReference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBillingReferenceForArrayConstraintsFromSetBillingReference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $creditNoteTypeBillingReferenceItem) {
            // validation for constraint: itemType
            if (!$creditNoteTypeBillingReferenceItem instanceof \TurkkepEFatura\StructType\BillingReferenceType) {
                $invalidValues[] = is_object($creditNoteTypeBillingReferenceItem) ? get_class($creditNoteTypeBillingReferenceItem) : sprintf('%s(%s)', gettype($creditNoteTypeBillingReferenceItem), var_export($creditNoteTypeBillingReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The BillingReference property can only contain items of type \TurkkepEFatura\StructType\BillingReferenceType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set BillingReference value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\BillingReferenceType[] $billingReference
     * @return \TurkkepEFatura\StructType\CreditNoteType
     */
    public function setBillingReference(array $billingReference = array())
    {
        // validation for constraint: array
        if ('' !== ($billingReferenceArrayErrorMessage = self::validateBillingReferenceForArrayConstraintsFromSetBillingReference($billingReference))) {
            throw new \InvalidArgumentException($billingReferenceArrayErrorMessage, __LINE__);
        }
        $this->BillingReference = $billingReference;
        return $this;
    }
    /**
     * Add item to BillingReference value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\BillingReferenceType $item
     * @return \TurkkepEFatura\StructType\CreditNoteType
     */
    public function addToBillingReference(\TurkkepEFatura\StructType\BillingReferenceType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \TurkkepEFatura\StructType\BillingReferenceType) {
            throw new \InvalidArgumentException(sprintf('The BillingReference property can only contain items of type \TurkkepEFatura\StructType\BillingReferenceType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->BillingReference[] = $item;
        return $this;
    }
    /**
     * Get DespatchDocumentReference value
     * @return \TurkkepEFatura\StructType\DocumentReferenceType[]|null
     */
    public function getDespatchDocumentReference()
    {
        return $this->DespatchDocumentReference;
    }
    /**
     * This method is responsible for validating the values passed to the setDespatchDocumentReference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDespatchDocumentReference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDespatchDocumentReferenceForArrayConstraintsFromSetDespatchDocumentReference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $creditNoteTypeDespatchDocumentReferenceItem) {
            // validation for constraint: itemType
            if (!$creditNoteTypeDespatchDocumentReferenceItem instanceof \TurkkepEFatura\StructType\DocumentReferenceType) {
                $invalidValues[] = is_object($creditNoteTypeDespatchDocumentReferenceItem) ? get_class($creditNoteTypeDespatchDocumentReferenceItem) : sprintf('%s(%s)', gettype($creditNoteTypeDespatchDocumentReferenceItem), var_export($creditNoteTypeDespatchDocumentReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DespatchDocumentReference property can only contain items of type \TurkkepEFatura\StructType\DocumentReferenceType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DespatchDocumentReference value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\DocumentReferenceType[] $despatchDocumentReference
     * @return \TurkkepEFatura\StructType\CreditNoteType
     */
    public function setDespatchDocumentReference(array $despatchDocumentReference = array())
    {
        // validation for constraint: array
        if ('' !== ($despatchDocumentReferenceArrayErrorMessage = self::validateDespatchDocumentReferenceForArrayConstraintsFromSetDespatchDocumentReference($despatchDocumentReference))) {
            throw new \InvalidArgumentException($despatchDocumentReferenceArrayErrorMessage, __LINE__);
        }
        $this->DespatchDocumentReference = $despatchDocumentReference;
        return $this;
    }
    /**
     * Add item to DespatchDocumentReference value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\DocumentReferenceType $item
     * @return \TurkkepEFatura\StructType\CreditNoteType
     */
    public function addToDespatchDocumentReference(\TurkkepEFatura\StructType\DocumentReferenceType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \TurkkepEFatura\StructType\DocumentReferenceType) {
            throw new \InvalidArgumentException(sprintf('The DespatchDocumentReference property can only contain items of type \TurkkepEFatura\StructType\DocumentReferenceType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DespatchDocumentReference[] = $item;
        return $this;
    }
    /**
     * Get ReceiptDocumentReference value
     * @return \TurkkepEFatura\StructType\DocumentReferenceType[]|null
     */
    public function getReceiptDocumentReference()
    {
        return $this->ReceiptDocumentReference;
    }
    /**
     * This method is responsible for validating the values passed to the setReceiptDocumentReference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setReceiptDocumentReference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateReceiptDocumentReferenceForArrayConstraintsFromSetReceiptDocumentReference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $creditNoteTypeReceiptDocumentReferenceItem) {
            // validation for constraint: itemType
            if (!$creditNoteTypeReceiptDocumentReferenceItem instanceof \TurkkepEFatura\StructType\DocumentReferenceType) {
                $invalidValues[] = is_object($creditNoteTypeReceiptDocumentReferenceItem) ? get_class($creditNoteTypeReceiptDocumentReferenceItem) : sprintf('%s(%s)', gettype($creditNoteTypeReceiptDocumentReferenceItem), var_export($creditNoteTypeReceiptDocumentReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ReceiptDocumentReference property can only contain items of type \TurkkepEFatura\StructType\DocumentReferenceType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ReceiptDocumentReference value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\DocumentReferenceType[] $receiptDocumentReference
     * @return \TurkkepEFatura\StructType\CreditNoteType
     */
    public function setReceiptDocumentReference(array $receiptDocumentReference = array())
    {
        // validation for constraint: array
        if ('' !== ($receiptDocumentReferenceArrayErrorMessage = self::validateReceiptDocumentReferenceForArrayConstraintsFromSetReceiptDocumentReference($receiptDocumentReference))) {
            throw new \InvalidArgumentException($receiptDocumentReferenceArrayErrorMessage, __LINE__);
        }
        $this->ReceiptDocumentReference = $receiptDocumentReference;
        return $this;
    }
    /**
     * Add item to ReceiptDocumentReference value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\DocumentReferenceType $item
     * @return \TurkkepEFatura\StructType\CreditNoteType
     */
    public function addToReceiptDocumentReference(\TurkkepEFatura\StructType\DocumentReferenceType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \TurkkepEFatura\StructType\DocumentReferenceType) {
            throw new \InvalidArgumentException(sprintf('The ReceiptDocumentReference property can only contain items of type \TurkkepEFatura\StructType\DocumentReferenceType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ReceiptDocumentReference[] = $item;
        return $this;
    }
    /**
     * Get ContractDocumentReference value
     * @return \TurkkepEFatura\StructType\DocumentReferenceType[]|null
     */
    public function getContractDocumentReference()
    {
        return $this->ContractDocumentReference;
    }
    /**
     * This method is responsible for validating the values passed to the setContractDocumentReference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setContractDocumentReference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateContractDocumentReferenceForArrayConstraintsFromSetContractDocumentReference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $creditNoteTypeContractDocumentReferenceItem) {
            // validation for constraint: itemType
            if (!$creditNoteTypeContractDocumentReferenceItem instanceof \TurkkepEFatura\StructType\DocumentReferenceType) {
                $invalidValues[] = is_object($creditNoteTypeContractDocumentReferenceItem) ? get_class($creditNoteTypeContractDocumentReferenceItem) : sprintf('%s(%s)', gettype($creditNoteTypeContractDocumentReferenceItem), var_export($creditNoteTypeContractDocumentReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ContractDocumentReference property can only contain items of type \TurkkepEFatura\StructType\DocumentReferenceType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ContractDocumentReference value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\DocumentReferenceType[] $contractDocumentReference
     * @return \TurkkepEFatura\StructType\CreditNoteType
     */
    public function setContractDocumentReference(array $contractDocumentReference = array())
    {
        // validation for constraint: array
        if ('' !== ($contractDocumentReferenceArrayErrorMessage = self::validateContractDocumentReferenceForArrayConstraintsFromSetContractDocumentReference($contractDocumentReference))) {
            throw new \InvalidArgumentException($contractDocumentReferenceArrayErrorMessage, __LINE__);
        }
        $this->ContractDocumentReference = $contractDocumentReference;
        return $this;
    }
    /**
     * Add item to ContractDocumentReference value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\DocumentReferenceType $item
     * @return \TurkkepEFatura\StructType\CreditNoteType
     */
    public function addToContractDocumentReference(\TurkkepEFatura\StructType\DocumentReferenceType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \TurkkepEFatura\StructType\DocumentReferenceType) {
            throw new \InvalidArgumentException(sprintf('The ContractDocumentReference property can only contain items of type \TurkkepEFatura\StructType\DocumentReferenceType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ContractDocumentReference[] = $item;
        return $this;
    }
    /**
     * Get AdditionalDocumentReference value
     * @return \TurkkepEFatura\StructType\DocumentReferenceType[]|null
     */
    public function getAdditionalDocumentReference()
    {
        return $this->AdditionalDocumentReference;
    }
    /**
     * This method is responsible for validating the values passed to the setAdditionalDocumentReference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAdditionalDocumentReference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAdditionalDocumentReferenceForArrayConstraintsFromSetAdditionalDocumentReference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $creditNoteTypeAdditionalDocumentReferenceItem) {
            // validation for constraint: itemType
            if (!$creditNoteTypeAdditionalDocumentReferenceItem instanceof \TurkkepEFatura\StructType\DocumentReferenceType) {
                $invalidValues[] = is_object($creditNoteTypeAdditionalDocumentReferenceItem) ? get_class($creditNoteTypeAdditionalDocumentReferenceItem) : sprintf('%s(%s)', gettype($creditNoteTypeAdditionalDocumentReferenceItem), var_export($creditNoteTypeAdditionalDocumentReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AdditionalDocumentReference property can only contain items of type \TurkkepEFatura\StructType\DocumentReferenceType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AdditionalDocumentReference value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\DocumentReferenceType[] $additionalDocumentReference
     * @return \TurkkepEFatura\StructType\CreditNoteType
     */
    public function setAdditionalDocumentReference(array $additionalDocumentReference = array())
    {
        // validation for constraint: array
        if ('' !== ($additionalDocumentReferenceArrayErrorMessage = self::validateAdditionalDocumentReferenceForArrayConstraintsFromSetAdditionalDocumentReference($additionalDocumentReference))) {
            throw new \InvalidArgumentException($additionalDocumentReferenceArrayErrorMessage, __LINE__);
        }
        $this->AdditionalDocumentReference = $additionalDocumentReference;
        return $this;
    }
    /**
     * Add item to AdditionalDocumentReference value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\DocumentReferenceType $item
     * @return \TurkkepEFatura\StructType\CreditNoteType
     */
    public function addToAdditionalDocumentReference(\TurkkepEFatura\StructType\DocumentReferenceType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \TurkkepEFatura\StructType\DocumentReferenceType) {
            throw new \InvalidArgumentException(sprintf('The AdditionalDocumentReference property can only contain items of type \TurkkepEFatura\StructType\DocumentReferenceType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AdditionalDocumentReference[] = $item;
        return $this;
    }
    /**
     * Get StatementDocumentReference value
     * @return \TurkkepEFatura\StructType\DocumentReferenceType[]|null
     */
    public function getStatementDocumentReference()
    {
        return $this->StatementDocumentReference;
    }
    /**
     * This method is responsible for validating the values passed to the setStatementDocumentReference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStatementDocumentReference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateStatementDocumentReferenceForArrayConstraintsFromSetStatementDocumentReference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $creditNoteTypeStatementDocumentReferenceItem) {
            // validation for constraint: itemType
            if (!$creditNoteTypeStatementDocumentReferenceItem instanceof \TurkkepEFatura\StructType\DocumentReferenceType) {
                $invalidValues[] = is_object($creditNoteTypeStatementDocumentReferenceItem) ? get_class($creditNoteTypeStatementDocumentReferenceItem) : sprintf('%s(%s)', gettype($creditNoteTypeStatementDocumentReferenceItem), var_export($creditNoteTypeStatementDocumentReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The StatementDocumentReference property can only contain items of type \TurkkepEFatura\StructType\DocumentReferenceType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set StatementDocumentReference value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\DocumentReferenceType[] $statementDocumentReference
     * @return \TurkkepEFatura\StructType\CreditNoteType
     */
    public function setStatementDocumentReference(array $statementDocumentReference = array())
    {
        // validation for constraint: array
        if ('' !== ($statementDocumentReferenceArrayErrorMessage = self::validateStatementDocumentReferenceForArrayConstraintsFromSetStatementDocumentReference($statementDocumentReference))) {
            throw new \InvalidArgumentException($statementDocumentReferenceArrayErrorMessage, __LINE__);
        }
        $this->StatementDocumentReference = $statementDocumentReference;
        return $this;
    }
    /**
     * Add item to StatementDocumentReference value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\DocumentReferenceType $item
     * @return \TurkkepEFatura\StructType\CreditNoteType
     */
    public function addToStatementDocumentReference(\TurkkepEFatura\StructType\DocumentReferenceType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \TurkkepEFatura\StructType\DocumentReferenceType) {
            throw new \InvalidArgumentException(sprintf('The StatementDocumentReference property can only contain items of type \TurkkepEFatura\StructType\DocumentReferenceType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->StatementDocumentReference[] = $item;
        return $this;
    }
    /**
     * Get OriginatorDocumentReference value
     * @return \TurkkepEFatura\StructType\DocumentReferenceType[]|null
     */
    public function getOriginatorDocumentReference()
    {
        return $this->OriginatorDocumentReference;
    }
    /**
     * This method is responsible for validating the values passed to the setOriginatorDocumentReference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOriginatorDocumentReference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOriginatorDocumentReferenceForArrayConstraintsFromSetOriginatorDocumentReference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $creditNoteTypeOriginatorDocumentReferenceItem) {
            // validation for constraint: itemType
            if (!$creditNoteTypeOriginatorDocumentReferenceItem instanceof \TurkkepEFatura\StructType\DocumentReferenceType) {
                $invalidValues[] = is_object($creditNoteTypeOriginatorDocumentReferenceItem) ? get_class($creditNoteTypeOriginatorDocumentReferenceItem) : sprintf('%s(%s)', gettype($creditNoteTypeOriginatorDocumentReferenceItem), var_export($creditNoteTypeOriginatorDocumentReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The OriginatorDocumentReference property can only contain items of type \TurkkepEFatura\StructType\DocumentReferenceType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set OriginatorDocumentReference value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\DocumentReferenceType[] $originatorDocumentReference
     * @return \TurkkepEFatura\StructType\CreditNoteType
     */
    public function setOriginatorDocumentReference(array $originatorDocumentReference = array())
    {
        // validation for constraint: array
        if ('' !== ($originatorDocumentReferenceArrayErrorMessage = self::validateOriginatorDocumentReferenceForArrayConstraintsFromSetOriginatorDocumentReference($originatorDocumentReference))) {
            throw new \InvalidArgumentException($originatorDocumentReferenceArrayErrorMessage, __LINE__);
        }
        $this->OriginatorDocumentReference = $originatorDocumentReference;
        return $this;
    }
    /**
     * Add item to OriginatorDocumentReference value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\DocumentReferenceType $item
     * @return \TurkkepEFatura\StructType\CreditNoteType
     */
    public function addToOriginatorDocumentReference(\TurkkepEFatura\StructType\DocumentReferenceType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \TurkkepEFatura\StructType\DocumentReferenceType) {
            throw new \InvalidArgumentException(sprintf('The OriginatorDocumentReference property can only contain items of type \TurkkepEFatura\StructType\DocumentReferenceType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->OriginatorDocumentReference[] = $item;
        return $this;
    }
    /**
     * Get Signature value
     * @return \TurkkepEFatura\StructType\SignatureType[]|null
     */
    public function getSignature()
    {
        return $this->Signature;
    }
    /**
     * This method is responsible for validating the values passed to the setSignature method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSignature method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSignatureForArrayConstraintsFromSetSignature(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $creditNoteTypeSignatureItem) {
            // validation for constraint: itemType
            if (!$creditNoteTypeSignatureItem instanceof \TurkkepEFatura\StructType\SignatureType) {
                $invalidValues[] = is_object($creditNoteTypeSignatureItem) ? get_class($creditNoteTypeSignatureItem) : sprintf('%s(%s)', gettype($creditNoteTypeSignatureItem), var_export($creditNoteTypeSignatureItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Signature property can only contain items of type \TurkkepEFatura\StructType\SignatureType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Signature value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\SignatureType[] $signature
     * @return \TurkkepEFatura\StructType\CreditNoteType
     */
    public function setSignature(array $signature = array())
    {
        // validation for constraint: array
        if ('' !== ($signatureArrayErrorMessage = self::validateSignatureForArrayConstraintsFromSetSignature($signature))) {
            throw new \InvalidArgumentException($signatureArrayErrorMessage, __LINE__);
        }
        $this->Signature = $signature;
        return $this;
    }
    /**
     * Add item to Signature value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\SignatureType $item
     * @return \TurkkepEFatura\StructType\CreditNoteType
     */
    public function addToSignature(\TurkkepEFatura\StructType\SignatureType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \TurkkepEFatura\StructType\SignatureType) {
            throw new \InvalidArgumentException(sprintf('The Signature property can only contain items of type \TurkkepEFatura\StructType\SignatureType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Signature[] = $item;
        return $this;
    }
    /**
     * Get AccountingSupplierParty value
     * @return \TurkkepEFatura\StructType\SupplierPartyType|null
     */
    public function getAccountingSupplierParty()
    {
        return $this->AccountingSupplierParty;
    }
    /**
     * Set AccountingSupplierParty value
     * @param \TurkkepEFatura\StructType\SupplierPartyType $accountingSupplierParty
     * @return \TurkkepEFatura\StructType\CreditNoteType
     */
    public function setAccountingSupplierParty(\TurkkepEFatura\StructType\SupplierPartyType $accountingSupplierParty = null)
    {
        $this->AccountingSupplierParty = $accountingSupplierParty;
        return $this;
    }
    /**
     * Get AccountingCustomerParty value
     * @return \TurkkepEFatura\StructType\CustomerPartyType|null
     */
    public function getAccountingCustomerParty()
    {
        return $this->AccountingCustomerParty;
    }
    /**
     * Set AccountingCustomerParty value
     * @param \TurkkepEFatura\StructType\CustomerPartyType $accountingCustomerParty
     * @return \TurkkepEFatura\StructType\CreditNoteType
     */
    public function setAccountingCustomerParty(\TurkkepEFatura\StructType\CustomerPartyType $accountingCustomerParty = null)
    {
        $this->AccountingCustomerParty = $accountingCustomerParty;
        return $this;
    }
    /**
     * Get PayeeParty value
     * @return \TurkkepEFatura\StructType\PartyType|null
     */
    public function getPayeeParty()
    {
        return $this->PayeeParty;
    }
    /**
     * Set PayeeParty value
     * @param \TurkkepEFatura\StructType\PartyType $payeeParty
     * @return \TurkkepEFatura\StructType\CreditNoteType
     */
    public function setPayeeParty(\TurkkepEFatura\StructType\PartyType $payeeParty = null)
    {
        $this->PayeeParty = $payeeParty;
        return $this;
    }
    /**
     * Get BuyerCustomerParty value
     * @return \TurkkepEFatura\StructType\CustomerPartyType|null
     */
    public function getBuyerCustomerParty()
    {
        return $this->BuyerCustomerParty;
    }
    /**
     * Set BuyerCustomerParty value
     * @param \TurkkepEFatura\StructType\CustomerPartyType $buyerCustomerParty
     * @return \TurkkepEFatura\StructType\CreditNoteType
     */
    public function setBuyerCustomerParty(\TurkkepEFatura\StructType\CustomerPartyType $buyerCustomerParty = null)
    {
        $this->BuyerCustomerParty = $buyerCustomerParty;
        return $this;
    }
    /**
     * Get SellerSupplierParty value
     * @return \TurkkepEFatura\StructType\SupplierPartyType|null
     */
    public function getSellerSupplierParty()
    {
        return $this->SellerSupplierParty;
    }
    /**
     * Set SellerSupplierParty value
     * @param \TurkkepEFatura\StructType\SupplierPartyType $sellerSupplierParty
     * @return \TurkkepEFatura\StructType\CreditNoteType
     */
    public function setSellerSupplierParty(\TurkkepEFatura\StructType\SupplierPartyType $sellerSupplierParty = null)
    {
        $this->SellerSupplierParty = $sellerSupplierParty;
        return $this;
    }
    /**
     * Get TaxRepresentativeParty value
     * @return \TurkkepEFatura\StructType\PartyType|null
     */
    public function getTaxRepresentativeParty()
    {
        return $this->TaxRepresentativeParty;
    }
    /**
     * Set TaxRepresentativeParty value
     * @param \TurkkepEFatura\StructType\PartyType $taxRepresentativeParty
     * @return \TurkkepEFatura\StructType\CreditNoteType
     */
    public function setTaxRepresentativeParty(\TurkkepEFatura\StructType\PartyType $taxRepresentativeParty = null)
    {
        $this->TaxRepresentativeParty = $taxRepresentativeParty;
        return $this;
    }
    /**
     * Get Delivery value
     * @return \TurkkepEFatura\StructType\DeliveryType[]|null
     */
    public function getDelivery()
    {
        return $this->Delivery;
    }
    /**
     * This method is responsible for validating the values passed to the setDelivery method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDelivery method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDeliveryForArrayConstraintsFromSetDelivery(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $creditNoteTypeDeliveryItem) {
            // validation for constraint: itemType
            if (!$creditNoteTypeDeliveryItem instanceof \TurkkepEFatura\StructType\DeliveryType) {
                $invalidValues[] = is_object($creditNoteTypeDeliveryItem) ? get_class($creditNoteTypeDeliveryItem) : sprintf('%s(%s)', gettype($creditNoteTypeDeliveryItem), var_export($creditNoteTypeDeliveryItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Delivery property can only contain items of type \TurkkepEFatura\StructType\DeliveryType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Delivery value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\DeliveryType[] $delivery
     * @return \TurkkepEFatura\StructType\CreditNoteType
     */
    public function setDelivery(array $delivery = array())
    {
        // validation for constraint: array
        if ('' !== ($deliveryArrayErrorMessage = self::validateDeliveryForArrayConstraintsFromSetDelivery($delivery))) {
            throw new \InvalidArgumentException($deliveryArrayErrorMessage, __LINE__);
        }
        $this->Delivery = $delivery;
        return $this;
    }
    /**
     * Add item to Delivery value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\DeliveryType $item
     * @return \TurkkepEFatura\StructType\CreditNoteType
     */
    public function addToDelivery(\TurkkepEFatura\StructType\DeliveryType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \TurkkepEFatura\StructType\DeliveryType) {
            throw new \InvalidArgumentException(sprintf('The Delivery property can only contain items of type \TurkkepEFatura\StructType\DeliveryType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Delivery[] = $item;
        return $this;
    }
    /**
     * Get DeliveryTerms value
     * @return \TurkkepEFatura\StructType\DeliveryTermsType[]|null
     */
    public function getDeliveryTerms()
    {
        return $this->DeliveryTerms;
    }
    /**
     * This method is responsible for validating the values passed to the setDeliveryTerms method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDeliveryTerms method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDeliveryTermsForArrayConstraintsFromSetDeliveryTerms(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $creditNoteTypeDeliveryTermsItem) {
            // validation for constraint: itemType
            if (!$creditNoteTypeDeliveryTermsItem instanceof \TurkkepEFatura\StructType\DeliveryTermsType) {
                $invalidValues[] = is_object($creditNoteTypeDeliveryTermsItem) ? get_class($creditNoteTypeDeliveryTermsItem) : sprintf('%s(%s)', gettype($creditNoteTypeDeliveryTermsItem), var_export($creditNoteTypeDeliveryTermsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DeliveryTerms property can only contain items of type \TurkkepEFatura\StructType\DeliveryTermsType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DeliveryTerms value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\DeliveryTermsType[] $deliveryTerms
     * @return \TurkkepEFatura\StructType\CreditNoteType
     */
    public function setDeliveryTerms(array $deliveryTerms = array())
    {
        // validation for constraint: array
        if ('' !== ($deliveryTermsArrayErrorMessage = self::validateDeliveryTermsForArrayConstraintsFromSetDeliveryTerms($deliveryTerms))) {
            throw new \InvalidArgumentException($deliveryTermsArrayErrorMessage, __LINE__);
        }
        $this->DeliveryTerms = $deliveryTerms;
        return $this;
    }
    /**
     * Add item to DeliveryTerms value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\DeliveryTermsType $item
     * @return \TurkkepEFatura\StructType\CreditNoteType
     */
    public function addToDeliveryTerms(\TurkkepEFatura\StructType\DeliveryTermsType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \TurkkepEFatura\StructType\DeliveryTermsType) {
            throw new \InvalidArgumentException(sprintf('The DeliveryTerms property can only contain items of type \TurkkepEFatura\StructType\DeliveryTermsType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DeliveryTerms[] = $item;
        return $this;
    }
    /**
     * Get PaymentMeans value
     * @return \TurkkepEFatura\StructType\PaymentMeansType[]|null
     */
    public function getPaymentMeans()
    {
        return $this->PaymentMeans;
    }
    /**
     * This method is responsible for validating the values passed to the setPaymentMeans method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaymentMeans method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaymentMeansForArrayConstraintsFromSetPaymentMeans(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $creditNoteTypePaymentMeansItem) {
            // validation for constraint: itemType
            if (!$creditNoteTypePaymentMeansItem instanceof \TurkkepEFatura\StructType\PaymentMeansType) {
                $invalidValues[] = is_object($creditNoteTypePaymentMeansItem) ? get_class($creditNoteTypePaymentMeansItem) : sprintf('%s(%s)', gettype($creditNoteTypePaymentMeansItem), var_export($creditNoteTypePaymentMeansItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PaymentMeans property can only contain items of type \TurkkepEFatura\StructType\PaymentMeansType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PaymentMeans value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\PaymentMeansType[] $paymentMeans
     * @return \TurkkepEFatura\StructType\CreditNoteType
     */
    public function setPaymentMeans(array $paymentMeans = array())
    {
        // validation for constraint: array
        if ('' !== ($paymentMeansArrayErrorMessage = self::validatePaymentMeansForArrayConstraintsFromSetPaymentMeans($paymentMeans))) {
            throw new \InvalidArgumentException($paymentMeansArrayErrorMessage, __LINE__);
        }
        $this->PaymentMeans = $paymentMeans;
        return $this;
    }
    /**
     * Add item to PaymentMeans value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\PaymentMeansType $item
     * @return \TurkkepEFatura\StructType\CreditNoteType
     */
    public function addToPaymentMeans(\TurkkepEFatura\StructType\PaymentMeansType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \TurkkepEFatura\StructType\PaymentMeansType) {
            throw new \InvalidArgumentException(sprintf('The PaymentMeans property can only contain items of type \TurkkepEFatura\StructType\PaymentMeansType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PaymentMeans[] = $item;
        return $this;
    }
    /**
     * Get PaymentTerms value
     * @return \TurkkepEFatura\StructType\PaymentTermsType[]|null
     */
    public function getPaymentTerms()
    {
        return $this->PaymentTerms;
    }
    /**
     * This method is responsible for validating the values passed to the setPaymentTerms method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaymentTerms method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaymentTermsForArrayConstraintsFromSetPaymentTerms(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $creditNoteTypePaymentTermsItem) {
            // validation for constraint: itemType
            if (!$creditNoteTypePaymentTermsItem instanceof \TurkkepEFatura\StructType\PaymentTermsType) {
                $invalidValues[] = is_object($creditNoteTypePaymentTermsItem) ? get_class($creditNoteTypePaymentTermsItem) : sprintf('%s(%s)', gettype($creditNoteTypePaymentTermsItem), var_export($creditNoteTypePaymentTermsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PaymentTerms property can only contain items of type \TurkkepEFatura\StructType\PaymentTermsType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PaymentTerms value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\PaymentTermsType[] $paymentTerms
     * @return \TurkkepEFatura\StructType\CreditNoteType
     */
    public function setPaymentTerms(array $paymentTerms = array())
    {
        // validation for constraint: array
        if ('' !== ($paymentTermsArrayErrorMessage = self::validatePaymentTermsForArrayConstraintsFromSetPaymentTerms($paymentTerms))) {
            throw new \InvalidArgumentException($paymentTermsArrayErrorMessage, __LINE__);
        }
        $this->PaymentTerms = $paymentTerms;
        return $this;
    }
    /**
     * Add item to PaymentTerms value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\PaymentTermsType $item
     * @return \TurkkepEFatura\StructType\CreditNoteType
     */
    public function addToPaymentTerms(\TurkkepEFatura\StructType\PaymentTermsType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \TurkkepEFatura\StructType\PaymentTermsType) {
            throw new \InvalidArgumentException(sprintf('The PaymentTerms property can only contain items of type \TurkkepEFatura\StructType\PaymentTermsType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PaymentTerms[] = $item;
        return $this;
    }
    /**
     * Get TaxExchangeRate value
     * @return \TurkkepEFatura\StructType\ExchangeRateType|null
     */
    public function getTaxExchangeRate()
    {
        return $this->TaxExchangeRate;
    }
    /**
     * Set TaxExchangeRate value
     * @param \TurkkepEFatura\StructType\ExchangeRateType $taxExchangeRate
     * @return \TurkkepEFatura\StructType\CreditNoteType
     */
    public function setTaxExchangeRate(\TurkkepEFatura\StructType\ExchangeRateType $taxExchangeRate = null)
    {
        $this->TaxExchangeRate = $taxExchangeRate;
        return $this;
    }
    /**
     * Get PricingExchangeRate value
     * @return \TurkkepEFatura\StructType\ExchangeRateType|null
     */
    public function getPricingExchangeRate()
    {
        return $this->PricingExchangeRate;
    }
    /**
     * Set PricingExchangeRate value
     * @param \TurkkepEFatura\StructType\ExchangeRateType $pricingExchangeRate
     * @return \TurkkepEFatura\StructType\CreditNoteType
     */
    public function setPricingExchangeRate(\TurkkepEFatura\StructType\ExchangeRateType $pricingExchangeRate = null)
    {
        $this->PricingExchangeRate = $pricingExchangeRate;
        return $this;
    }
    /**
     * Get PaymentExchangeRate value
     * @return \TurkkepEFatura\StructType\ExchangeRateType|null
     */
    public function getPaymentExchangeRate()
    {
        return $this->PaymentExchangeRate;
    }
    /**
     * Set PaymentExchangeRate value
     * @param \TurkkepEFatura\StructType\ExchangeRateType $paymentExchangeRate
     * @return \TurkkepEFatura\StructType\CreditNoteType
     */
    public function setPaymentExchangeRate(\TurkkepEFatura\StructType\ExchangeRateType $paymentExchangeRate = null)
    {
        $this->PaymentExchangeRate = $paymentExchangeRate;
        return $this;
    }
    /**
     * Get PaymentAlternativeExchangeRate value
     * @return \TurkkepEFatura\StructType\ExchangeRateType|null
     */
    public function getPaymentAlternativeExchangeRate()
    {
        return $this->PaymentAlternativeExchangeRate;
    }
    /**
     * Set PaymentAlternativeExchangeRate value
     * @param \TurkkepEFatura\StructType\ExchangeRateType $paymentAlternativeExchangeRate
     * @return \TurkkepEFatura\StructType\CreditNoteType
     */
    public function setPaymentAlternativeExchangeRate(\TurkkepEFatura\StructType\ExchangeRateType $paymentAlternativeExchangeRate = null)
    {
        $this->PaymentAlternativeExchangeRate = $paymentAlternativeExchangeRate;
        return $this;
    }
    /**
     * Get AllowanceCharge value
     * @return \TurkkepEFatura\StructType\AllowanceChargeType[]|null
     */
    public function getAllowanceCharge()
    {
        return $this->AllowanceCharge;
    }
    /**
     * This method is responsible for validating the values passed to the setAllowanceCharge method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAllowanceCharge method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAllowanceChargeForArrayConstraintsFromSetAllowanceCharge(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $creditNoteTypeAllowanceChargeItem) {
            // validation for constraint: itemType
            if (!$creditNoteTypeAllowanceChargeItem instanceof \TurkkepEFatura\StructType\AllowanceChargeType) {
                $invalidValues[] = is_object($creditNoteTypeAllowanceChargeItem) ? get_class($creditNoteTypeAllowanceChargeItem) : sprintf('%s(%s)', gettype($creditNoteTypeAllowanceChargeItem), var_export($creditNoteTypeAllowanceChargeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AllowanceCharge property can only contain items of type \TurkkepEFatura\StructType\AllowanceChargeType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AllowanceCharge value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\AllowanceChargeType[] $allowanceCharge
     * @return \TurkkepEFatura\StructType\CreditNoteType
     */
    public function setAllowanceCharge(array $allowanceCharge = array())
    {
        // validation for constraint: array
        if ('' !== ($allowanceChargeArrayErrorMessage = self::validateAllowanceChargeForArrayConstraintsFromSetAllowanceCharge($allowanceCharge))) {
            throw new \InvalidArgumentException($allowanceChargeArrayErrorMessage, __LINE__);
        }
        $this->AllowanceCharge = $allowanceCharge;
        return $this;
    }
    /**
     * Add item to AllowanceCharge value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\AllowanceChargeType $item
     * @return \TurkkepEFatura\StructType\CreditNoteType
     */
    public function addToAllowanceCharge(\TurkkepEFatura\StructType\AllowanceChargeType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \TurkkepEFatura\StructType\AllowanceChargeType) {
            throw new \InvalidArgumentException(sprintf('The AllowanceCharge property can only contain items of type \TurkkepEFatura\StructType\AllowanceChargeType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AllowanceCharge[] = $item;
        return $this;
    }
    /**
     * Get TaxTotal value
     * @return \TurkkepEFatura\StructType\TaxTotalType[]|null
     */
    public function getTaxTotal()
    {
        return $this->TaxTotal;
    }
    /**
     * This method is responsible for validating the values passed to the setTaxTotal method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTaxTotal method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTaxTotalForArrayConstraintsFromSetTaxTotal(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $creditNoteTypeTaxTotalItem) {
            // validation for constraint: itemType
            if (!$creditNoteTypeTaxTotalItem instanceof \TurkkepEFatura\StructType\TaxTotalType) {
                $invalidValues[] = is_object($creditNoteTypeTaxTotalItem) ? get_class($creditNoteTypeTaxTotalItem) : sprintf('%s(%s)', gettype($creditNoteTypeTaxTotalItem), var_export($creditNoteTypeTaxTotalItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TaxTotal property can only contain items of type \TurkkepEFatura\StructType\TaxTotalType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TaxTotal value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\TaxTotalType[] $taxTotal
     * @return \TurkkepEFatura\StructType\CreditNoteType
     */
    public function setTaxTotal(array $taxTotal = array())
    {
        // validation for constraint: array
        if ('' !== ($taxTotalArrayErrorMessage = self::validateTaxTotalForArrayConstraintsFromSetTaxTotal($taxTotal))) {
            throw new \InvalidArgumentException($taxTotalArrayErrorMessage, __LINE__);
        }
        $this->TaxTotal = $taxTotal;
        return $this;
    }
    /**
     * Add item to TaxTotal value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\TaxTotalType $item
     * @return \TurkkepEFatura\StructType\CreditNoteType
     */
    public function addToTaxTotal(\TurkkepEFatura\StructType\TaxTotalType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \TurkkepEFatura\StructType\TaxTotalType) {
            throw new \InvalidArgumentException(sprintf('The TaxTotal property can only contain items of type \TurkkepEFatura\StructType\TaxTotalType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TaxTotal[] = $item;
        return $this;
    }
    /**
     * Get LegalMonetaryTotal value
     * @return \TurkkepEFatura\StructType\MonetaryTotalType|null
     */
    public function getLegalMonetaryTotal()
    {
        return $this->LegalMonetaryTotal;
    }
    /**
     * Set LegalMonetaryTotal value
     * @param \TurkkepEFatura\StructType\MonetaryTotalType $legalMonetaryTotal
     * @return \TurkkepEFatura\StructType\CreditNoteType
     */
    public function setLegalMonetaryTotal(\TurkkepEFatura\StructType\MonetaryTotalType $legalMonetaryTotal = null)
    {
        $this->LegalMonetaryTotal = $legalMonetaryTotal;
        return $this;
    }
    /**
     * Get CreditNoteLine value
     * @return \TurkkepEFatura\StructType\CreditNoteLineType[]|null
     */
    public function getCreditNoteLine()
    {
        return $this->CreditNoteLine;
    }
    /**
     * This method is responsible for validating the values passed to the setCreditNoteLine method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCreditNoteLine method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCreditNoteLineForArrayConstraintsFromSetCreditNoteLine(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $creditNoteTypeCreditNoteLineItem) {
            // validation for constraint: itemType
            if (!$creditNoteTypeCreditNoteLineItem instanceof \TurkkepEFatura\StructType\CreditNoteLineType) {
                $invalidValues[] = is_object($creditNoteTypeCreditNoteLineItem) ? get_class($creditNoteTypeCreditNoteLineItem) : sprintf('%s(%s)', gettype($creditNoteTypeCreditNoteLineItem), var_export($creditNoteTypeCreditNoteLineItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CreditNoteLine property can only contain items of type \TurkkepEFatura\StructType\CreditNoteLineType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CreditNoteLine value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\CreditNoteLineType[] $creditNoteLine
     * @return \TurkkepEFatura\StructType\CreditNoteType
     */
    public function setCreditNoteLine(array $creditNoteLine = array())
    {
        // validation for constraint: array
        if ('' !== ($creditNoteLineArrayErrorMessage = self::validateCreditNoteLineForArrayConstraintsFromSetCreditNoteLine($creditNoteLine))) {
            throw new \InvalidArgumentException($creditNoteLineArrayErrorMessage, __LINE__);
        }
        $this->CreditNoteLine = $creditNoteLine;
        return $this;
    }
    /**
     * Add item to CreditNoteLine value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\CreditNoteLineType $item
     * @return \TurkkepEFatura\StructType\CreditNoteType
     */
    public function addToCreditNoteLine(\TurkkepEFatura\StructType\CreditNoteLineType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \TurkkepEFatura\StructType\CreditNoteLineType) {
            throw new \InvalidArgumentException(sprintf('The CreditNoteLine property can only contain items of type \TurkkepEFatura\StructType\CreditNoteLineType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CreditNoteLine[] = $item;
        return $this;
    }
}
