<?php

namespace TurkkepEFatura\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreditNoteLineType StructType
 * @subpackage Structs
 */
class CreditNoteLineType extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:ID
     * @var \TurkkepEFatura\StructType\IDType
     */
    public $ID;
    /**
     * The UUID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:UUID
     * @var \TurkkepEFatura\StructType\UUIDType
     */
    public $UUID;
    /**
     * The Note
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: s3:Note
     * @var \TurkkepEFatura\StructType\NoteType[]
     */
    public $Note;
    /**
     * The CreditedQuantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:CreditedQuantity
     * @var \TurkkepEFatura\StructType\CreditedQuantityType
     */
    public $CreditedQuantity;
    /**
     * The LineExtensionAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:LineExtensionAmount
     * @var \TurkkepEFatura\StructType\LineExtensionAmountType
     */
    public $LineExtensionAmount;
    /**
     * The TaxPointDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:TaxPointDate
     * @var \TurkkepEFatura\StructType\TaxPointDateType
     */
    public $TaxPointDate;
    /**
     * The AccountingCostCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:AccountingCostCode
     * @var \TurkkepEFatura\StructType\AccountingCostCodeType
     */
    public $AccountingCostCode;
    /**
     * The AccountingCost
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:AccountingCost
     * @var \TurkkepEFatura\StructType\AccountingCostType
     */
    public $AccountingCost;
    /**
     * The PaymentPurposeCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:PaymentPurposeCode
     * @var \TurkkepEFatura\StructType\PaymentPurposeCodeType
     */
    public $PaymentPurposeCode;
    /**
     * The FreeOfChargeIndicator
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:FreeOfChargeIndicator
     * @var \TurkkepEFatura\StructType\FreeOfChargeIndicatorType
     */
    public $FreeOfChargeIndicator;
    /**
     * The InvoicePeriod
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\PeriodType[]
     */
    public $InvoicePeriod;
    /**
     * The OrderLineReference
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\OrderLineReferenceType[]
     */
    public $OrderLineReference;
    /**
     * The DiscrepancyResponse
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\ResponseType[]
     */
    public $DiscrepancyResponse;
    /**
     * The DespatchLineReference
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\LineReferenceType[]
     */
    public $DespatchLineReference;
    /**
     * The ReceiptLineReference
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\LineReferenceType[]
     */
    public $ReceiptLineReference;
    /**
     * The BillingReference
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\BillingReferenceType[]
     */
    public $BillingReference;
    /**
     * The DocumentReference
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\DocumentReferenceType[]
     */
    public $DocumentReference;
    /**
     * The PricingReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\PricingReferenceType
     */
    public $PricingReference;
    /**
     * The OriginatorParty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\PartyType
     */
    public $OriginatorParty;
    /**
     * The Delivery
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\DeliveryType[]
     */
    public $Delivery;
    /**
     * The PaymentTerms
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\PaymentTermsType[]
     */
    public $PaymentTerms;
    /**
     * The TaxTotal
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\TaxTotalType[]
     */
    public $TaxTotal;
    /**
     * The AllowanceCharge
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\AllowanceChargeType[]
     */
    public $AllowanceCharge;
    /**
     * The Item
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\ItemType
     */
    public $Item;
    /**
     * The Price
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\PriceType
     */
    public $Price;
    /**
     * The DeliveryTerms
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\DeliveryTermsType[]
     */
    public $DeliveryTerms;
    /**
     * The SubCreditNoteLine
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\CreditNoteLineType[]
     */
    public $SubCreditNoteLine;
    /**
     * The ItemPriceExtension
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\PriceExtensionType
     */
    public $ItemPriceExtension;
    /**
     * Constructor method for CreditNoteLineType
     * @uses CreditNoteLineType::setID()
     * @uses CreditNoteLineType::setUUID()
     * @uses CreditNoteLineType::setNote()
     * @uses CreditNoteLineType::setCreditedQuantity()
     * @uses CreditNoteLineType::setLineExtensionAmount()
     * @uses CreditNoteLineType::setTaxPointDate()
     * @uses CreditNoteLineType::setAccountingCostCode()
     * @uses CreditNoteLineType::setAccountingCost()
     * @uses CreditNoteLineType::setPaymentPurposeCode()
     * @uses CreditNoteLineType::setFreeOfChargeIndicator()
     * @uses CreditNoteLineType::setInvoicePeriod()
     * @uses CreditNoteLineType::setOrderLineReference()
     * @uses CreditNoteLineType::setDiscrepancyResponse()
     * @uses CreditNoteLineType::setDespatchLineReference()
     * @uses CreditNoteLineType::setReceiptLineReference()
     * @uses CreditNoteLineType::setBillingReference()
     * @uses CreditNoteLineType::setDocumentReference()
     * @uses CreditNoteLineType::setPricingReference()
     * @uses CreditNoteLineType::setOriginatorParty()
     * @uses CreditNoteLineType::setDelivery()
     * @uses CreditNoteLineType::setPaymentTerms()
     * @uses CreditNoteLineType::setTaxTotal()
     * @uses CreditNoteLineType::setAllowanceCharge()
     * @uses CreditNoteLineType::setItem()
     * @uses CreditNoteLineType::setPrice()
     * @uses CreditNoteLineType::setDeliveryTerms()
     * @uses CreditNoteLineType::setSubCreditNoteLine()
     * @uses CreditNoteLineType::setItemPriceExtension()
     * @param \TurkkepEFatura\StructType\IDType $iD
     * @param \TurkkepEFatura\StructType\UUIDType $uUID
     * @param \TurkkepEFatura\StructType\NoteType[] $note
     * @param \TurkkepEFatura\StructType\CreditedQuantityType $creditedQuantity
     * @param \TurkkepEFatura\StructType\LineExtensionAmountType $lineExtensionAmount
     * @param \TurkkepEFatura\StructType\TaxPointDateType $taxPointDate
     * @param \TurkkepEFatura\StructType\AccountingCostCodeType $accountingCostCode
     * @param \TurkkepEFatura\StructType\AccountingCostType $accountingCost
     * @param \TurkkepEFatura\StructType\PaymentPurposeCodeType $paymentPurposeCode
     * @param \TurkkepEFatura\StructType\FreeOfChargeIndicatorType $freeOfChargeIndicator
     * @param \TurkkepEFatura\StructType\PeriodType[] $invoicePeriod
     * @param \TurkkepEFatura\StructType\OrderLineReferenceType[] $orderLineReference
     * @param \TurkkepEFatura\StructType\ResponseType[] $discrepancyResponse
     * @param \TurkkepEFatura\StructType\LineReferenceType[] $despatchLineReference
     * @param \TurkkepEFatura\StructType\LineReferenceType[] $receiptLineReference
     * @param \TurkkepEFatura\StructType\BillingReferenceType[] $billingReference
     * @param \TurkkepEFatura\StructType\DocumentReferenceType[] $documentReference
     * @param \TurkkepEFatura\StructType\PricingReferenceType $pricingReference
     * @param \TurkkepEFatura\StructType\PartyType $originatorParty
     * @param \TurkkepEFatura\StructType\DeliveryType[] $delivery
     * @param \TurkkepEFatura\StructType\PaymentTermsType[] $paymentTerms
     * @param \TurkkepEFatura\StructType\TaxTotalType[] $taxTotal
     * @param \TurkkepEFatura\StructType\AllowanceChargeType[] $allowanceCharge
     * @param \TurkkepEFatura\StructType\ItemType $item
     * @param \TurkkepEFatura\StructType\PriceType $price
     * @param \TurkkepEFatura\StructType\DeliveryTermsType[] $deliveryTerms
     * @param \TurkkepEFatura\StructType\CreditNoteLineType[] $subCreditNoteLine
     * @param \TurkkepEFatura\StructType\PriceExtensionType $itemPriceExtension
     */
    public function __construct(\TurkkepEFatura\StructType\IDType $iD = null, \TurkkepEFatura\StructType\UUIDType $uUID = null, array $note = array(), \TurkkepEFatura\StructType\CreditedQuantityType $creditedQuantity = null, \TurkkepEFatura\StructType\LineExtensionAmountType $lineExtensionAmount = null, \TurkkepEFatura\StructType\TaxPointDateType $taxPointDate = null, \TurkkepEFatura\StructType\AccountingCostCodeType $accountingCostCode = null, \TurkkepEFatura\StructType\AccountingCostType $accountingCost = null, \TurkkepEFatura\StructType\PaymentPurposeCodeType $paymentPurposeCode = null, \TurkkepEFatura\StructType\FreeOfChargeIndicatorType $freeOfChargeIndicator = null, array $invoicePeriod = array(), array $orderLineReference = array(), array $discrepancyResponse = array(), array $despatchLineReference = array(), array $receiptLineReference = array(), array $billingReference = array(), array $documentReference = array(), \TurkkepEFatura\StructType\PricingReferenceType $pricingReference = null, \TurkkepEFatura\StructType\PartyType $originatorParty = null, array $delivery = array(), array $paymentTerms = array(), array $taxTotal = array(), array $allowanceCharge = array(), \TurkkepEFatura\StructType\ItemType $item = null, \TurkkepEFatura\StructType\PriceType $price = null, array $deliveryTerms = array(), array $subCreditNoteLine = array(), \TurkkepEFatura\StructType\PriceExtensionType $itemPriceExtension = null)
    {
        $this
            ->setID($iD)
            ->setUUID($uUID)
            ->setNote($note)
            ->setCreditedQuantity($creditedQuantity)
            ->setLineExtensionAmount($lineExtensionAmount)
            ->setTaxPointDate($taxPointDate)
            ->setAccountingCostCode($accountingCostCode)
            ->setAccountingCost($accountingCost)
            ->setPaymentPurposeCode($paymentPurposeCode)
            ->setFreeOfChargeIndicator($freeOfChargeIndicator)
            ->setInvoicePeriod($invoicePeriod)
            ->setOrderLineReference($orderLineReference)
            ->setDiscrepancyResponse($discrepancyResponse)
            ->setDespatchLineReference($despatchLineReference)
            ->setReceiptLineReference($receiptLineReference)
            ->setBillingReference($billingReference)
            ->setDocumentReference($documentReference)
            ->setPricingReference($pricingReference)
            ->setOriginatorParty($originatorParty)
            ->setDelivery($delivery)
            ->setPaymentTerms($paymentTerms)
            ->setTaxTotal($taxTotal)
            ->setAllowanceCharge($allowanceCharge)
            ->setItem($item)
            ->setPrice($price)
            ->setDeliveryTerms($deliveryTerms)
            ->setSubCreditNoteLine($subCreditNoteLine)
            ->setItemPriceExtension($itemPriceExtension);
    }
    /**
     * Get ID value
     * @return \TurkkepEFatura\StructType\IDType|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param \TurkkepEFatura\StructType\IDType $iD
     * @return \TurkkepEFatura\StructType\CreditNoteLineType
     */
    public function setID(\TurkkepEFatura\StructType\IDType $iD = null)
    {
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get UUID value
     * @return \TurkkepEFatura\StructType\UUIDType|null
     */
    public function getUUID()
    {
        return $this->UUID;
    }
    /**
     * Set UUID value
     * @param \TurkkepEFatura\StructType\UUIDType $uUID
     * @return \TurkkepEFatura\StructType\CreditNoteLineType
     */
    public function setUUID(\TurkkepEFatura\StructType\UUIDType $uUID = null)
    {
        $this->UUID = $uUID;
        return $this;
    }
    /**
     * Get Note value
     * @return \TurkkepEFatura\StructType\NoteType[]|null
     */
    public function getNote()
    {
        return $this->Note;
    }
    /**
     * This method is responsible for validating the values passed to the setNote method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNote method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateNoteForArrayConstraintsFromSetNote(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $creditNoteLineTypeNoteItem) {
            // validation for constraint: itemType
            if (!$creditNoteLineTypeNoteItem instanceof \TurkkepEFatura\StructType\NoteType) {
                $invalidValues[] = is_object($creditNoteLineTypeNoteItem) ? get_class($creditNoteLineTypeNoteItem) : sprintf('%s(%s)', gettype($creditNoteLineTypeNoteItem), var_export($creditNoteLineTypeNoteItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Note property can only contain items of type \TurkkepEFatura\StructType\NoteType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Note value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\NoteType[] $note
     * @return \TurkkepEFatura\StructType\CreditNoteLineType
     */
    public function setNote(array $note = array())
    {
        // validation for constraint: array
        if ('' !== ($noteArrayErrorMessage = self::validateNoteForArrayConstraintsFromSetNote($note))) {
            throw new \InvalidArgumentException($noteArrayErrorMessage, __LINE__);
        }
        $this->Note = $note;
        return $this;
    }
    /**
     * Add item to Note value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\NoteType $item
     * @return \TurkkepEFatura\StructType\CreditNoteLineType
     */
    public function addToNote(\TurkkepEFatura\StructType\NoteType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \TurkkepEFatura\StructType\NoteType) {
            throw new \InvalidArgumentException(sprintf('The Note property can only contain items of type \TurkkepEFatura\StructType\NoteType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Note[] = $item;
        return $this;
    }
    /**
     * Get CreditedQuantity value
     * @return \TurkkepEFatura\StructType\CreditedQuantityType|null
     */
    public function getCreditedQuantity()
    {
        return $this->CreditedQuantity;
    }
    /**
     * Set CreditedQuantity value
     * @param \TurkkepEFatura\StructType\CreditedQuantityType $creditedQuantity
     * @return \TurkkepEFatura\StructType\CreditNoteLineType
     */
    public function setCreditedQuantity(\TurkkepEFatura\StructType\CreditedQuantityType $creditedQuantity = null)
    {
        $this->CreditedQuantity = $creditedQuantity;
        return $this;
    }
    /**
     * Get LineExtensionAmount value
     * @return \TurkkepEFatura\StructType\LineExtensionAmountType|null
     */
    public function getLineExtensionAmount()
    {
        return $this->LineExtensionAmount;
    }
    /**
     * Set LineExtensionAmount value
     * @param \TurkkepEFatura\StructType\LineExtensionAmountType $lineExtensionAmount
     * @return \TurkkepEFatura\StructType\CreditNoteLineType
     */
    public function setLineExtensionAmount(\TurkkepEFatura\StructType\LineExtensionAmountType $lineExtensionAmount = null)
    {
        $this->LineExtensionAmount = $lineExtensionAmount;
        return $this;
    }
    /**
     * Get TaxPointDate value
     * @return \TurkkepEFatura\StructType\TaxPointDateType|null
     */
    public function getTaxPointDate()
    {
        return $this->TaxPointDate;
    }
    /**
     * Set TaxPointDate value
     * @param \TurkkepEFatura\StructType\TaxPointDateType $taxPointDate
     * @return \TurkkepEFatura\StructType\CreditNoteLineType
     */
    public function setTaxPointDate(\TurkkepEFatura\StructType\TaxPointDateType $taxPointDate = null)
    {
        $this->TaxPointDate = $taxPointDate;
        return $this;
    }
    /**
     * Get AccountingCostCode value
     * @return \TurkkepEFatura\StructType\AccountingCostCodeType|null
     */
    public function getAccountingCostCode()
    {
        return $this->AccountingCostCode;
    }
    /**
     * Set AccountingCostCode value
     * @param \TurkkepEFatura\StructType\AccountingCostCodeType $accountingCostCode
     * @return \TurkkepEFatura\StructType\CreditNoteLineType
     */
    public function setAccountingCostCode(\TurkkepEFatura\StructType\AccountingCostCodeType $accountingCostCode = null)
    {
        $this->AccountingCostCode = $accountingCostCode;
        return $this;
    }
    /**
     * Get AccountingCost value
     * @return \TurkkepEFatura\StructType\AccountingCostType|null
     */
    public function getAccountingCost()
    {
        return $this->AccountingCost;
    }
    /**
     * Set AccountingCost value
     * @param \TurkkepEFatura\StructType\AccountingCostType $accountingCost
     * @return \TurkkepEFatura\StructType\CreditNoteLineType
     */
    public function setAccountingCost(\TurkkepEFatura\StructType\AccountingCostType $accountingCost = null)
    {
        $this->AccountingCost = $accountingCost;
        return $this;
    }
    /**
     * Get PaymentPurposeCode value
     * @return \TurkkepEFatura\StructType\PaymentPurposeCodeType|null
     */
    public function getPaymentPurposeCode()
    {
        return $this->PaymentPurposeCode;
    }
    /**
     * Set PaymentPurposeCode value
     * @param \TurkkepEFatura\StructType\PaymentPurposeCodeType $paymentPurposeCode
     * @return \TurkkepEFatura\StructType\CreditNoteLineType
     */
    public function setPaymentPurposeCode(\TurkkepEFatura\StructType\PaymentPurposeCodeType $paymentPurposeCode = null)
    {
        $this->PaymentPurposeCode = $paymentPurposeCode;
        return $this;
    }
    /**
     * Get FreeOfChargeIndicator value
     * @return \TurkkepEFatura\StructType\FreeOfChargeIndicatorType|null
     */
    public function getFreeOfChargeIndicator()
    {
        return $this->FreeOfChargeIndicator;
    }
    /**
     * Set FreeOfChargeIndicator value
     * @param \TurkkepEFatura\StructType\FreeOfChargeIndicatorType $freeOfChargeIndicator
     * @return \TurkkepEFatura\StructType\CreditNoteLineType
     */
    public function setFreeOfChargeIndicator(\TurkkepEFatura\StructType\FreeOfChargeIndicatorType $freeOfChargeIndicator = null)
    {
        $this->FreeOfChargeIndicator = $freeOfChargeIndicator;
        return $this;
    }
    /**
     * Get InvoicePeriod value
     * @return \TurkkepEFatura\StructType\PeriodType[]|null
     */
    public function getInvoicePeriod()
    {
        return $this->InvoicePeriod;
    }
    /**
     * This method is responsible for validating the values passed to the setInvoicePeriod method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInvoicePeriod method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInvoicePeriodForArrayConstraintsFromSetInvoicePeriod(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $creditNoteLineTypeInvoicePeriodItem) {
            // validation for constraint: itemType
            if (!$creditNoteLineTypeInvoicePeriodItem instanceof \TurkkepEFatura\StructType\PeriodType) {
                $invalidValues[] = is_object($creditNoteLineTypeInvoicePeriodItem) ? get_class($creditNoteLineTypeInvoicePeriodItem) : sprintf('%s(%s)', gettype($creditNoteLineTypeInvoicePeriodItem), var_export($creditNoteLineTypeInvoicePeriodItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The InvoicePeriod property can only contain items of type \TurkkepEFatura\StructType\PeriodType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set InvoicePeriod value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\PeriodType[] $invoicePeriod
     * @return \TurkkepEFatura\StructType\CreditNoteLineType
     */
    public function setInvoicePeriod(array $invoicePeriod = array())
    {
        // validation for constraint: array
        if ('' !== ($invoicePeriodArrayErrorMessage = self::validateInvoicePeriodForArrayConstraintsFromSetInvoicePeriod($invoicePeriod))) {
            throw new \InvalidArgumentException($invoicePeriodArrayErrorMessage, __LINE__);
        }
        $this->InvoicePeriod = $invoicePeriod;
        return $this;
    }
    /**
     * Add item to InvoicePeriod value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\PeriodType $item
     * @return \TurkkepEFatura\StructType\CreditNoteLineType
     */
    public function addToInvoicePeriod(\TurkkepEFatura\StructType\PeriodType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \TurkkepEFatura\StructType\PeriodType) {
            throw new \InvalidArgumentException(sprintf('The InvoicePeriod property can only contain items of type \TurkkepEFatura\StructType\PeriodType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->InvoicePeriod[] = $item;
        return $this;
    }
    /**
     * Get OrderLineReference value
     * @return \TurkkepEFatura\StructType\OrderLineReferenceType[]|null
     */
    public function getOrderLineReference()
    {
        return $this->OrderLineReference;
    }
    /**
     * This method is responsible for validating the values passed to the setOrderLineReference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOrderLineReference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOrderLineReferenceForArrayConstraintsFromSetOrderLineReference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $creditNoteLineTypeOrderLineReferenceItem) {
            // validation for constraint: itemType
            if (!$creditNoteLineTypeOrderLineReferenceItem instanceof \TurkkepEFatura\StructType\OrderLineReferenceType) {
                $invalidValues[] = is_object($creditNoteLineTypeOrderLineReferenceItem) ? get_class($creditNoteLineTypeOrderLineReferenceItem) : sprintf('%s(%s)', gettype($creditNoteLineTypeOrderLineReferenceItem), var_export($creditNoteLineTypeOrderLineReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The OrderLineReference property can only contain items of type \TurkkepEFatura\StructType\OrderLineReferenceType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set OrderLineReference value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\OrderLineReferenceType[] $orderLineReference
     * @return \TurkkepEFatura\StructType\CreditNoteLineType
     */
    public function setOrderLineReference(array $orderLineReference = array())
    {
        // validation for constraint: array
        if ('' !== ($orderLineReferenceArrayErrorMessage = self::validateOrderLineReferenceForArrayConstraintsFromSetOrderLineReference($orderLineReference))) {
            throw new \InvalidArgumentException($orderLineReferenceArrayErrorMessage, __LINE__);
        }
        $this->OrderLineReference = $orderLineReference;
        return $this;
    }
    /**
     * Add item to OrderLineReference value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\OrderLineReferenceType $item
     * @return \TurkkepEFatura\StructType\CreditNoteLineType
     */
    public function addToOrderLineReference(\TurkkepEFatura\StructType\OrderLineReferenceType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \TurkkepEFatura\StructType\OrderLineReferenceType) {
            throw new \InvalidArgumentException(sprintf('The OrderLineReference property can only contain items of type \TurkkepEFatura\StructType\OrderLineReferenceType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->OrderLineReference[] = $item;
        return $this;
    }
    /**
     * Get DiscrepancyResponse value
     * @return \TurkkepEFatura\StructType\ResponseType[]|null
     */
    public function getDiscrepancyResponse()
    {
        return $this->DiscrepancyResponse;
    }
    /**
     * This method is responsible for validating the values passed to the setDiscrepancyResponse method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDiscrepancyResponse method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDiscrepancyResponseForArrayConstraintsFromSetDiscrepancyResponse(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $creditNoteLineTypeDiscrepancyResponseItem) {
            // validation for constraint: itemType
            if (!$creditNoteLineTypeDiscrepancyResponseItem instanceof \TurkkepEFatura\StructType\ResponseType) {
                $invalidValues[] = is_object($creditNoteLineTypeDiscrepancyResponseItem) ? get_class($creditNoteLineTypeDiscrepancyResponseItem) : sprintf('%s(%s)', gettype($creditNoteLineTypeDiscrepancyResponseItem), var_export($creditNoteLineTypeDiscrepancyResponseItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DiscrepancyResponse property can only contain items of type \TurkkepEFatura\StructType\ResponseType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DiscrepancyResponse value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\ResponseType[] $discrepancyResponse
     * @return \TurkkepEFatura\StructType\CreditNoteLineType
     */
    public function setDiscrepancyResponse(array $discrepancyResponse = array())
    {
        // validation for constraint: array
        if ('' !== ($discrepancyResponseArrayErrorMessage = self::validateDiscrepancyResponseForArrayConstraintsFromSetDiscrepancyResponse($discrepancyResponse))) {
            throw new \InvalidArgumentException($discrepancyResponseArrayErrorMessage, __LINE__);
        }
        $this->DiscrepancyResponse = $discrepancyResponse;
        return $this;
    }
    /**
     * Add item to DiscrepancyResponse value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\ResponseType $item
     * @return \TurkkepEFatura\StructType\CreditNoteLineType
     */
    public function addToDiscrepancyResponse(\TurkkepEFatura\StructType\ResponseType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \TurkkepEFatura\StructType\ResponseType) {
            throw new \InvalidArgumentException(sprintf('The DiscrepancyResponse property can only contain items of type \TurkkepEFatura\StructType\ResponseType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DiscrepancyResponse[] = $item;
        return $this;
    }
    /**
     * Get DespatchLineReference value
     * @return \TurkkepEFatura\StructType\LineReferenceType[]|null
     */
    public function getDespatchLineReference()
    {
        return $this->DespatchLineReference;
    }
    /**
     * This method is responsible for validating the values passed to the setDespatchLineReference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDespatchLineReference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDespatchLineReferenceForArrayConstraintsFromSetDespatchLineReference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $creditNoteLineTypeDespatchLineReferenceItem) {
            // validation for constraint: itemType
            if (!$creditNoteLineTypeDespatchLineReferenceItem instanceof \TurkkepEFatura\StructType\LineReferenceType) {
                $invalidValues[] = is_object($creditNoteLineTypeDespatchLineReferenceItem) ? get_class($creditNoteLineTypeDespatchLineReferenceItem) : sprintf('%s(%s)', gettype($creditNoteLineTypeDespatchLineReferenceItem), var_export($creditNoteLineTypeDespatchLineReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DespatchLineReference property can only contain items of type \TurkkepEFatura\StructType\LineReferenceType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DespatchLineReference value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\LineReferenceType[] $despatchLineReference
     * @return \TurkkepEFatura\StructType\CreditNoteLineType
     */
    public function setDespatchLineReference(array $despatchLineReference = array())
    {
        // validation for constraint: array
        if ('' !== ($despatchLineReferenceArrayErrorMessage = self::validateDespatchLineReferenceForArrayConstraintsFromSetDespatchLineReference($despatchLineReference))) {
            throw new \InvalidArgumentException($despatchLineReferenceArrayErrorMessage, __LINE__);
        }
        $this->DespatchLineReference = $despatchLineReference;
        return $this;
    }
    /**
     * Add item to DespatchLineReference value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\LineReferenceType $item
     * @return \TurkkepEFatura\StructType\CreditNoteLineType
     */
    public function addToDespatchLineReference(\TurkkepEFatura\StructType\LineReferenceType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \TurkkepEFatura\StructType\LineReferenceType) {
            throw new \InvalidArgumentException(sprintf('The DespatchLineReference property can only contain items of type \TurkkepEFatura\StructType\LineReferenceType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DespatchLineReference[] = $item;
        return $this;
    }
    /**
     * Get ReceiptLineReference value
     * @return \TurkkepEFatura\StructType\LineReferenceType[]|null
     */
    public function getReceiptLineReference()
    {
        return $this->ReceiptLineReference;
    }
    /**
     * This method is responsible for validating the values passed to the setReceiptLineReference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setReceiptLineReference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateReceiptLineReferenceForArrayConstraintsFromSetReceiptLineReference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $creditNoteLineTypeReceiptLineReferenceItem) {
            // validation for constraint: itemType
            if (!$creditNoteLineTypeReceiptLineReferenceItem instanceof \TurkkepEFatura\StructType\LineReferenceType) {
                $invalidValues[] = is_object($creditNoteLineTypeReceiptLineReferenceItem) ? get_class($creditNoteLineTypeReceiptLineReferenceItem) : sprintf('%s(%s)', gettype($creditNoteLineTypeReceiptLineReferenceItem), var_export($creditNoteLineTypeReceiptLineReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ReceiptLineReference property can only contain items of type \TurkkepEFatura\StructType\LineReferenceType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ReceiptLineReference value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\LineReferenceType[] $receiptLineReference
     * @return \TurkkepEFatura\StructType\CreditNoteLineType
     */
    public function setReceiptLineReference(array $receiptLineReference = array())
    {
        // validation for constraint: array
        if ('' !== ($receiptLineReferenceArrayErrorMessage = self::validateReceiptLineReferenceForArrayConstraintsFromSetReceiptLineReference($receiptLineReference))) {
            throw new \InvalidArgumentException($receiptLineReferenceArrayErrorMessage, __LINE__);
        }
        $this->ReceiptLineReference = $receiptLineReference;
        return $this;
    }
    /**
     * Add item to ReceiptLineReference value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\LineReferenceType $item
     * @return \TurkkepEFatura\StructType\CreditNoteLineType
     */
    public function addToReceiptLineReference(\TurkkepEFatura\StructType\LineReferenceType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \TurkkepEFatura\StructType\LineReferenceType) {
            throw new \InvalidArgumentException(sprintf('The ReceiptLineReference property can only contain items of type \TurkkepEFatura\StructType\LineReferenceType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ReceiptLineReference[] = $item;
        return $this;
    }
    /**
     * Get BillingReference value
     * @return \TurkkepEFatura\StructType\BillingReferenceType[]|null
     */
    public function getBillingReference()
    {
        return $this->BillingReference;
    }
    /**
     * This method is responsible for validating the values passed to the setBillingReference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBillingReference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBillingReferenceForArrayConstraintsFromSetBillingReference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $creditNoteLineTypeBillingReferenceItem) {
            // validation for constraint: itemType
            if (!$creditNoteLineTypeBillingReferenceItem instanceof \TurkkepEFatura\StructType\BillingReferenceType) {
                $invalidValues[] = is_object($creditNoteLineTypeBillingReferenceItem) ? get_class($creditNoteLineTypeBillingReferenceItem) : sprintf('%s(%s)', gettype($creditNoteLineTypeBillingReferenceItem), var_export($creditNoteLineTypeBillingReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The BillingReference property can only contain items of type \TurkkepEFatura\StructType\BillingReferenceType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set BillingReference value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\BillingReferenceType[] $billingReference
     * @return \TurkkepEFatura\StructType\CreditNoteLineType
     */
    public function setBillingReference(array $billingReference = array())
    {
        // validation for constraint: array
        if ('' !== ($billingReferenceArrayErrorMessage = self::validateBillingReferenceForArrayConstraintsFromSetBillingReference($billingReference))) {
            throw new \InvalidArgumentException($billingReferenceArrayErrorMessage, __LINE__);
        }
        $this->BillingReference = $billingReference;
        return $this;
    }
    /**
     * Add item to BillingReference value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\BillingReferenceType $item
     * @return \TurkkepEFatura\StructType\CreditNoteLineType
     */
    public function addToBillingReference(\TurkkepEFatura\StructType\BillingReferenceType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \TurkkepEFatura\StructType\BillingReferenceType) {
            throw new \InvalidArgumentException(sprintf('The BillingReference property can only contain items of type \TurkkepEFatura\StructType\BillingReferenceType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->BillingReference[] = $item;
        return $this;
    }
    /**
     * Get DocumentReference value
     * @return \TurkkepEFatura\StructType\DocumentReferenceType[]|null
     */
    public function getDocumentReference()
    {
        return $this->DocumentReference;
    }
    /**
     * This method is responsible for validating the values passed to the setDocumentReference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDocumentReference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDocumentReferenceForArrayConstraintsFromSetDocumentReference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $creditNoteLineTypeDocumentReferenceItem) {
            // validation for constraint: itemType
            if (!$creditNoteLineTypeDocumentReferenceItem instanceof \TurkkepEFatura\StructType\DocumentReferenceType) {
                $invalidValues[] = is_object($creditNoteLineTypeDocumentReferenceItem) ? get_class($creditNoteLineTypeDocumentReferenceItem) : sprintf('%s(%s)', gettype($creditNoteLineTypeDocumentReferenceItem), var_export($creditNoteLineTypeDocumentReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DocumentReference property can only contain items of type \TurkkepEFatura\StructType\DocumentReferenceType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DocumentReference value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\DocumentReferenceType[] $documentReference
     * @return \TurkkepEFatura\StructType\CreditNoteLineType
     */
    public function setDocumentReference(array $documentReference = array())
    {
        // validation for constraint: array
        if ('' !== ($documentReferenceArrayErrorMessage = self::validateDocumentReferenceForArrayConstraintsFromSetDocumentReference($documentReference))) {
            throw new \InvalidArgumentException($documentReferenceArrayErrorMessage, __LINE__);
        }
        $this->DocumentReference = $documentReference;
        return $this;
    }
    /**
     * Add item to DocumentReference value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\DocumentReferenceType $item
     * @return \TurkkepEFatura\StructType\CreditNoteLineType
     */
    public function addToDocumentReference(\TurkkepEFatura\StructType\DocumentReferenceType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \TurkkepEFatura\StructType\DocumentReferenceType) {
            throw new \InvalidArgumentException(sprintf('The DocumentReference property can only contain items of type \TurkkepEFatura\StructType\DocumentReferenceType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DocumentReference[] = $item;
        return $this;
    }
    /**
     * Get PricingReference value
     * @return \TurkkepEFatura\StructType\PricingReferenceType|null
     */
    public function getPricingReference()
    {
        return $this->PricingReference;
    }
    /**
     * Set PricingReference value
     * @param \TurkkepEFatura\StructType\PricingReferenceType $pricingReference
     * @return \TurkkepEFatura\StructType\CreditNoteLineType
     */
    public function setPricingReference(\TurkkepEFatura\StructType\PricingReferenceType $pricingReference = null)
    {
        $this->PricingReference = $pricingReference;
        return $this;
    }
    /**
     * Get OriginatorParty value
     * @return \TurkkepEFatura\StructType\PartyType|null
     */
    public function getOriginatorParty()
    {
        return $this->OriginatorParty;
    }
    /**
     * Set OriginatorParty value
     * @param \TurkkepEFatura\StructType\PartyType $originatorParty
     * @return \TurkkepEFatura\StructType\CreditNoteLineType
     */
    public function setOriginatorParty(\TurkkepEFatura\StructType\PartyType $originatorParty = null)
    {
        $this->OriginatorParty = $originatorParty;
        return $this;
    }
    /**
     * Get Delivery value
     * @return \TurkkepEFatura\StructType\DeliveryType[]|null
     */
    public function getDelivery()
    {
        return $this->Delivery;
    }
    /**
     * This method is responsible for validating the values passed to the setDelivery method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDelivery method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDeliveryForArrayConstraintsFromSetDelivery(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $creditNoteLineTypeDeliveryItem) {
            // validation for constraint: itemType
            if (!$creditNoteLineTypeDeliveryItem instanceof \TurkkepEFatura\StructType\DeliveryType) {
                $invalidValues[] = is_object($creditNoteLineTypeDeliveryItem) ? get_class($creditNoteLineTypeDeliveryItem) : sprintf('%s(%s)', gettype($creditNoteLineTypeDeliveryItem), var_export($creditNoteLineTypeDeliveryItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Delivery property can only contain items of type \TurkkepEFatura\StructType\DeliveryType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Delivery value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\DeliveryType[] $delivery
     * @return \TurkkepEFatura\StructType\CreditNoteLineType
     */
    public function setDelivery(array $delivery = array())
    {
        // validation for constraint: array
        if ('' !== ($deliveryArrayErrorMessage = self::validateDeliveryForArrayConstraintsFromSetDelivery($delivery))) {
            throw new \InvalidArgumentException($deliveryArrayErrorMessage, __LINE__);
        }
        $this->Delivery = $delivery;
        return $this;
    }
    /**
     * Add item to Delivery value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\DeliveryType $item
     * @return \TurkkepEFatura\StructType\CreditNoteLineType
     */
    public function addToDelivery(\TurkkepEFatura\StructType\DeliveryType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \TurkkepEFatura\StructType\DeliveryType) {
            throw new \InvalidArgumentException(sprintf('The Delivery property can only contain items of type \TurkkepEFatura\StructType\DeliveryType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Delivery[] = $item;
        return $this;
    }
    /**
     * Get PaymentTerms value
     * @return \TurkkepEFatura\StructType\PaymentTermsType[]|null
     */
    public function getPaymentTerms()
    {
        return $this->PaymentTerms;
    }
    /**
     * This method is responsible for validating the values passed to the setPaymentTerms method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaymentTerms method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaymentTermsForArrayConstraintsFromSetPaymentTerms(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $creditNoteLineTypePaymentTermsItem) {
            // validation for constraint: itemType
            if (!$creditNoteLineTypePaymentTermsItem instanceof \TurkkepEFatura\StructType\PaymentTermsType) {
                $invalidValues[] = is_object($creditNoteLineTypePaymentTermsItem) ? get_class($creditNoteLineTypePaymentTermsItem) : sprintf('%s(%s)', gettype($creditNoteLineTypePaymentTermsItem), var_export($creditNoteLineTypePaymentTermsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PaymentTerms property can only contain items of type \TurkkepEFatura\StructType\PaymentTermsType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PaymentTerms value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\PaymentTermsType[] $paymentTerms
     * @return \TurkkepEFatura\StructType\CreditNoteLineType
     */
    public function setPaymentTerms(array $paymentTerms = array())
    {
        // validation for constraint: array
        if ('' !== ($paymentTermsArrayErrorMessage = self::validatePaymentTermsForArrayConstraintsFromSetPaymentTerms($paymentTerms))) {
            throw new \InvalidArgumentException($paymentTermsArrayErrorMessage, __LINE__);
        }
        $this->PaymentTerms = $paymentTerms;
        return $this;
    }
    /**
     * Add item to PaymentTerms value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\PaymentTermsType $item
     * @return \TurkkepEFatura\StructType\CreditNoteLineType
     */
    public function addToPaymentTerms(\TurkkepEFatura\StructType\PaymentTermsType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \TurkkepEFatura\StructType\PaymentTermsType) {
            throw new \InvalidArgumentException(sprintf('The PaymentTerms property can only contain items of type \TurkkepEFatura\StructType\PaymentTermsType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PaymentTerms[] = $item;
        return $this;
    }
    /**
     * Get TaxTotal value
     * @return \TurkkepEFatura\StructType\TaxTotalType[]|null
     */
    public function getTaxTotal()
    {
        return $this->TaxTotal;
    }
    /**
     * This method is responsible for validating the values passed to the setTaxTotal method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTaxTotal method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTaxTotalForArrayConstraintsFromSetTaxTotal(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $creditNoteLineTypeTaxTotalItem) {
            // validation for constraint: itemType
            if (!$creditNoteLineTypeTaxTotalItem instanceof \TurkkepEFatura\StructType\TaxTotalType) {
                $invalidValues[] = is_object($creditNoteLineTypeTaxTotalItem) ? get_class($creditNoteLineTypeTaxTotalItem) : sprintf('%s(%s)', gettype($creditNoteLineTypeTaxTotalItem), var_export($creditNoteLineTypeTaxTotalItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TaxTotal property can only contain items of type \TurkkepEFatura\StructType\TaxTotalType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TaxTotal value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\TaxTotalType[] $taxTotal
     * @return \TurkkepEFatura\StructType\CreditNoteLineType
     */
    public function setTaxTotal(array $taxTotal = array())
    {
        // validation for constraint: array
        if ('' !== ($taxTotalArrayErrorMessage = self::validateTaxTotalForArrayConstraintsFromSetTaxTotal($taxTotal))) {
            throw new \InvalidArgumentException($taxTotalArrayErrorMessage, __LINE__);
        }
        $this->TaxTotal = $taxTotal;
        return $this;
    }
    /**
     * Add item to TaxTotal value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\TaxTotalType $item
     * @return \TurkkepEFatura\StructType\CreditNoteLineType
     */
    public function addToTaxTotal(\TurkkepEFatura\StructType\TaxTotalType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \TurkkepEFatura\StructType\TaxTotalType) {
            throw new \InvalidArgumentException(sprintf('The TaxTotal property can only contain items of type \TurkkepEFatura\StructType\TaxTotalType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TaxTotal[] = $item;
        return $this;
    }
    /**
     * Get AllowanceCharge value
     * @return \TurkkepEFatura\StructType\AllowanceChargeType[]|null
     */
    public function getAllowanceCharge()
    {
        return $this->AllowanceCharge;
    }
    /**
     * This method is responsible for validating the values passed to the setAllowanceCharge method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAllowanceCharge method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAllowanceChargeForArrayConstraintsFromSetAllowanceCharge(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $creditNoteLineTypeAllowanceChargeItem) {
            // validation for constraint: itemType
            if (!$creditNoteLineTypeAllowanceChargeItem instanceof \TurkkepEFatura\StructType\AllowanceChargeType) {
                $invalidValues[] = is_object($creditNoteLineTypeAllowanceChargeItem) ? get_class($creditNoteLineTypeAllowanceChargeItem) : sprintf('%s(%s)', gettype($creditNoteLineTypeAllowanceChargeItem), var_export($creditNoteLineTypeAllowanceChargeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AllowanceCharge property can only contain items of type \TurkkepEFatura\StructType\AllowanceChargeType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AllowanceCharge value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\AllowanceChargeType[] $allowanceCharge
     * @return \TurkkepEFatura\StructType\CreditNoteLineType
     */
    public function setAllowanceCharge(array $allowanceCharge = array())
    {
        // validation for constraint: array
        if ('' !== ($allowanceChargeArrayErrorMessage = self::validateAllowanceChargeForArrayConstraintsFromSetAllowanceCharge($allowanceCharge))) {
            throw new \InvalidArgumentException($allowanceChargeArrayErrorMessage, __LINE__);
        }
        $this->AllowanceCharge = $allowanceCharge;
        return $this;
    }
    /**
     * Add item to AllowanceCharge value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\AllowanceChargeType $item
     * @return \TurkkepEFatura\StructType\CreditNoteLineType
     */
    public function addToAllowanceCharge(\TurkkepEFatura\StructType\AllowanceChargeType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \TurkkepEFatura\StructType\AllowanceChargeType) {
            throw new \InvalidArgumentException(sprintf('The AllowanceCharge property can only contain items of type \TurkkepEFatura\StructType\AllowanceChargeType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AllowanceCharge[] = $item;
        return $this;
    }
    /**
     * Get Item value
     * @return \TurkkepEFatura\StructType\ItemType|null
     */
    public function getItem()
    {
        return $this->Item;
    }
    /**
     * Set Item value
     * @param \TurkkepEFatura\StructType\ItemType $item
     * @return \TurkkepEFatura\StructType\CreditNoteLineType
     */
    public function setItem(\TurkkepEFatura\StructType\ItemType $item = null)
    {
        $this->Item = $item;
        return $this;
    }
    /**
     * Get Price value
     * @return \TurkkepEFatura\StructType\PriceType|null
     */
    public function getPrice()
    {
        return $this->Price;
    }
    /**
     * Set Price value
     * @param \TurkkepEFatura\StructType\PriceType $price
     * @return \TurkkepEFatura\StructType\CreditNoteLineType
     */
    public function setPrice(\TurkkepEFatura\StructType\PriceType $price = null)
    {
        $this->Price = $price;
        return $this;
    }
    /**
     * Get DeliveryTerms value
     * @return \TurkkepEFatura\StructType\DeliveryTermsType[]|null
     */
    public function getDeliveryTerms()
    {
        return $this->DeliveryTerms;
    }
    /**
     * This method is responsible for validating the values passed to the setDeliveryTerms method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDeliveryTerms method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDeliveryTermsForArrayConstraintsFromSetDeliveryTerms(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $creditNoteLineTypeDeliveryTermsItem) {
            // validation for constraint: itemType
            if (!$creditNoteLineTypeDeliveryTermsItem instanceof \TurkkepEFatura\StructType\DeliveryTermsType) {
                $invalidValues[] = is_object($creditNoteLineTypeDeliveryTermsItem) ? get_class($creditNoteLineTypeDeliveryTermsItem) : sprintf('%s(%s)', gettype($creditNoteLineTypeDeliveryTermsItem), var_export($creditNoteLineTypeDeliveryTermsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DeliveryTerms property can only contain items of type \TurkkepEFatura\StructType\DeliveryTermsType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DeliveryTerms value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\DeliveryTermsType[] $deliveryTerms
     * @return \TurkkepEFatura\StructType\CreditNoteLineType
     */
    public function setDeliveryTerms(array $deliveryTerms = array())
    {
        // validation for constraint: array
        if ('' !== ($deliveryTermsArrayErrorMessage = self::validateDeliveryTermsForArrayConstraintsFromSetDeliveryTerms($deliveryTerms))) {
            throw new \InvalidArgumentException($deliveryTermsArrayErrorMessage, __LINE__);
        }
        $this->DeliveryTerms = $deliveryTerms;
        return $this;
    }
    /**
     * Add item to DeliveryTerms value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\DeliveryTermsType $item
     * @return \TurkkepEFatura\StructType\CreditNoteLineType
     */
    public function addToDeliveryTerms(\TurkkepEFatura\StructType\DeliveryTermsType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \TurkkepEFatura\StructType\DeliveryTermsType) {
            throw new \InvalidArgumentException(sprintf('The DeliveryTerms property can only contain items of type \TurkkepEFatura\StructType\DeliveryTermsType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DeliveryTerms[] = $item;
        return $this;
    }
    /**
     * Get SubCreditNoteLine value
     * @return \TurkkepEFatura\StructType\CreditNoteLineType[]|null
     */
    public function getSubCreditNoteLine()
    {
        return $this->SubCreditNoteLine;
    }
    /**
     * This method is responsible for validating the values passed to the setSubCreditNoteLine method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSubCreditNoteLine method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSubCreditNoteLineForArrayConstraintsFromSetSubCreditNoteLine(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $creditNoteLineTypeSubCreditNoteLineItem) {
            // validation for constraint: itemType
            if (!$creditNoteLineTypeSubCreditNoteLineItem instanceof \TurkkepEFatura\StructType\CreditNoteLineType) {
                $invalidValues[] = is_object($creditNoteLineTypeSubCreditNoteLineItem) ? get_class($creditNoteLineTypeSubCreditNoteLineItem) : sprintf('%s(%s)', gettype($creditNoteLineTypeSubCreditNoteLineItem), var_export($creditNoteLineTypeSubCreditNoteLineItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SubCreditNoteLine property can only contain items of type \TurkkepEFatura\StructType\CreditNoteLineType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SubCreditNoteLine value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\CreditNoteLineType[] $subCreditNoteLine
     * @return \TurkkepEFatura\StructType\CreditNoteLineType
     */
    public function setSubCreditNoteLine(array $subCreditNoteLine = array())
    {
        // validation for constraint: array
        if ('' !== ($subCreditNoteLineArrayErrorMessage = self::validateSubCreditNoteLineForArrayConstraintsFromSetSubCreditNoteLine($subCreditNoteLine))) {
            throw new \InvalidArgumentException($subCreditNoteLineArrayErrorMessage, __LINE__);
        }
        $this->SubCreditNoteLine = $subCreditNoteLine;
        return $this;
    }
    /**
     * Add item to SubCreditNoteLine value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\CreditNoteLineType $item
     * @return \TurkkepEFatura\StructType\CreditNoteLineType
     */
    public function addToSubCreditNoteLine(\TurkkepEFatura\StructType\CreditNoteLineType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \TurkkepEFatura\StructType\CreditNoteLineType) {
            throw new \InvalidArgumentException(sprintf('The SubCreditNoteLine property can only contain items of type \TurkkepEFatura\StructType\CreditNoteLineType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SubCreditNoteLine[] = $item;
        return $this;
    }
    /**
     * Get ItemPriceExtension value
     * @return \TurkkepEFatura\StructType\PriceExtensionType|null
     */
    public function getItemPriceExtension()
    {
        return $this->ItemPriceExtension;
    }
    /**
     * Set ItemPriceExtension value
     * @param \TurkkepEFatura\StructType\PriceExtensionType $itemPriceExtension
     * @return \TurkkepEFatura\StructType\CreditNoteLineType
     */
    public function setItemPriceExtension(\TurkkepEFatura\StructType\PriceExtensionType $itemPriceExtension = null)
    {
        $this->ItemPriceExtension = $itemPriceExtension;
        return $this;
    }
}
