<?php

namespace TurkkepEFatura\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CorporateRegistrationSchemeType StructType
 * @subpackage Structs
 */
class CorporateRegistrationSchemeType extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:ID
     * @var \TurkkepEFatura\StructType\IDType
     */
    public $ID;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:Name
     * @var \TurkkepEFatura\StructType\NameType
     */
    public $Name;
    /**
     * The CorporateRegistrationTypeCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:CorporateRegistrationTypeCode
     * @var \TurkkepEFatura\StructType\CorporateRegistrationTypeCodeType
     */
    public $CorporateRegistrationTypeCode;
    /**
     * The JurisdictionRegionAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\AddressType[]
     */
    public $JurisdictionRegionAddress;
    /**
     * Constructor method for CorporateRegistrationSchemeType
     * @uses CorporateRegistrationSchemeType::setID()
     * @uses CorporateRegistrationSchemeType::setName()
     * @uses CorporateRegistrationSchemeType::setCorporateRegistrationTypeCode()
     * @uses CorporateRegistrationSchemeType::setJurisdictionRegionAddress()
     * @param \TurkkepEFatura\StructType\IDType $iD
     * @param \TurkkepEFatura\StructType\NameType $name
     * @param \TurkkepEFatura\StructType\CorporateRegistrationTypeCodeType $corporateRegistrationTypeCode
     * @param \TurkkepEFatura\StructType\AddressType[] $jurisdictionRegionAddress
     */
    public function __construct(\TurkkepEFatura\StructType\IDType $iD = null, \TurkkepEFatura\StructType\NameType $name = null, \TurkkepEFatura\StructType\CorporateRegistrationTypeCodeType $corporateRegistrationTypeCode = null, array $jurisdictionRegionAddress = array())
    {
        $this
            ->setID($iD)
            ->setName($name)
            ->setCorporateRegistrationTypeCode($corporateRegistrationTypeCode)
            ->setJurisdictionRegionAddress($jurisdictionRegionAddress);
    }
    /**
     * Get ID value
     * @return \TurkkepEFatura\StructType\IDType|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param \TurkkepEFatura\StructType\IDType $iD
     * @return \TurkkepEFatura\StructType\CorporateRegistrationSchemeType
     */
    public function setID(\TurkkepEFatura\StructType\IDType $iD = null)
    {
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Name value
     * @return \TurkkepEFatura\StructType\NameType|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param \TurkkepEFatura\StructType\NameType $name
     * @return \TurkkepEFatura\StructType\CorporateRegistrationSchemeType
     */
    public function setName(\TurkkepEFatura\StructType\NameType $name = null)
    {
        $this->Name = $name;
        return $this;
    }
    /**
     * Get CorporateRegistrationTypeCode value
     * @return \TurkkepEFatura\StructType\CorporateRegistrationTypeCodeType|null
     */
    public function getCorporateRegistrationTypeCode()
    {
        return $this->CorporateRegistrationTypeCode;
    }
    /**
     * Set CorporateRegistrationTypeCode value
     * @param \TurkkepEFatura\StructType\CorporateRegistrationTypeCodeType $corporateRegistrationTypeCode
     * @return \TurkkepEFatura\StructType\CorporateRegistrationSchemeType
     */
    public function setCorporateRegistrationTypeCode(\TurkkepEFatura\StructType\CorporateRegistrationTypeCodeType $corporateRegistrationTypeCode = null)
    {
        $this->CorporateRegistrationTypeCode = $corporateRegistrationTypeCode;
        return $this;
    }
    /**
     * Get JurisdictionRegionAddress value
     * @return \TurkkepEFatura\StructType\AddressType[]|null
     */
    public function getJurisdictionRegionAddress()
    {
        return $this->JurisdictionRegionAddress;
    }
    /**
     * This method is responsible for validating the values passed to the setJurisdictionRegionAddress method
     * This method is willingly generated in order to preserve the one-line inline validation within the setJurisdictionRegionAddress method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateJurisdictionRegionAddressForArrayConstraintsFromSetJurisdictionRegionAddress(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $corporateRegistrationSchemeTypeJurisdictionRegionAddressItem) {
            // validation for constraint: itemType
            if (!$corporateRegistrationSchemeTypeJurisdictionRegionAddressItem instanceof \TurkkepEFatura\StructType\AddressType) {
                $invalidValues[] = is_object($corporateRegistrationSchemeTypeJurisdictionRegionAddressItem) ? get_class($corporateRegistrationSchemeTypeJurisdictionRegionAddressItem) : sprintf('%s(%s)', gettype($corporateRegistrationSchemeTypeJurisdictionRegionAddressItem), var_export($corporateRegistrationSchemeTypeJurisdictionRegionAddressItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The JurisdictionRegionAddress property can only contain items of type \TurkkepEFatura\StructType\AddressType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set JurisdictionRegionAddress value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\AddressType[] $jurisdictionRegionAddress
     * @return \TurkkepEFatura\StructType\CorporateRegistrationSchemeType
     */
    public function setJurisdictionRegionAddress(array $jurisdictionRegionAddress = array())
    {
        // validation for constraint: array
        if ('' !== ($jurisdictionRegionAddressArrayErrorMessage = self::validateJurisdictionRegionAddressForArrayConstraintsFromSetJurisdictionRegionAddress($jurisdictionRegionAddress))) {
            throw new \InvalidArgumentException($jurisdictionRegionAddressArrayErrorMessage, __LINE__);
        }
        $this->JurisdictionRegionAddress = $jurisdictionRegionAddress;
        return $this;
    }
    /**
     * Add item to JurisdictionRegionAddress value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\AddressType $item
     * @return \TurkkepEFatura\StructType\CorporateRegistrationSchemeType
     */
    public function addToJurisdictionRegionAddress(\TurkkepEFatura\StructType\AddressType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \TurkkepEFatura\StructType\AddressType) {
            throw new \InvalidArgumentException(sprintf('The JurisdictionRegionAddress property can only contain items of type \TurkkepEFatura\StructType\AddressType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->JurisdictionRegionAddress[] = $item;
        return $this;
    }
}
