<?php

namespace TurkkepEFatura\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BillingReferenceLineType StructType
 * @subpackage Structs
 */
class BillingReferenceLineType extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:ID
     * @var \TurkkepEFatura\StructType\IDType
     */
    public $ID;
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:Amount
     * @var \TurkkepEFatura\StructType\AmountType
     */
    public $Amount;
    /**
     * The AllowanceCharge
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\AllowanceChargeType[]
     */
    public $AllowanceCharge;
    /**
     * Constructor method for BillingReferenceLineType
     * @uses BillingReferenceLineType::setID()
     * @uses BillingReferenceLineType::setAmount()
     * @uses BillingReferenceLineType::setAllowanceCharge()
     * @param \TurkkepEFatura\StructType\IDType $iD
     * @param \TurkkepEFatura\StructType\AmountType $amount
     * @param \TurkkepEFatura\StructType\AllowanceChargeType[] $allowanceCharge
     */
    public function __construct(\TurkkepEFatura\StructType\IDType $iD = null, \TurkkepEFatura\StructType\AmountType $amount = null, array $allowanceCharge = array())
    {
        $this
            ->setID($iD)
            ->setAmount($amount)
            ->setAllowanceCharge($allowanceCharge);
    }
    /**
     * Get ID value
     * @return \TurkkepEFatura\StructType\IDType|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param \TurkkepEFatura\StructType\IDType $iD
     * @return \TurkkepEFatura\StructType\BillingReferenceLineType
     */
    public function setID(\TurkkepEFatura\StructType\IDType $iD = null)
    {
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Amount value
     * @return \TurkkepEFatura\StructType\AmountType|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param \TurkkepEFatura\StructType\AmountType $amount
     * @return \TurkkepEFatura\StructType\BillingReferenceLineType
     */
    public function setAmount(\TurkkepEFatura\StructType\AmountType $amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get AllowanceCharge value
     * @return \TurkkepEFatura\StructType\AllowanceChargeType[]|null
     */
    public function getAllowanceCharge()
    {
        return $this->AllowanceCharge;
    }
    /**
     * This method is responsible for validating the values passed to the setAllowanceCharge method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAllowanceCharge method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAllowanceChargeForArrayConstraintsFromSetAllowanceCharge(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $billingReferenceLineTypeAllowanceChargeItem) {
            // validation for constraint: itemType
            if (!$billingReferenceLineTypeAllowanceChargeItem instanceof \TurkkepEFatura\StructType\AllowanceChargeType) {
                $invalidValues[] = is_object($billingReferenceLineTypeAllowanceChargeItem) ? get_class($billingReferenceLineTypeAllowanceChargeItem) : sprintf('%s(%s)', gettype($billingReferenceLineTypeAllowanceChargeItem), var_export($billingReferenceLineTypeAllowanceChargeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AllowanceCharge property can only contain items of type \TurkkepEFatura\StructType\AllowanceChargeType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AllowanceCharge value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\AllowanceChargeType[] $allowanceCharge
     * @return \TurkkepEFatura\StructType\BillingReferenceLineType
     */
    public function setAllowanceCharge(array $allowanceCharge = array())
    {
        // validation for constraint: array
        if ('' !== ($allowanceChargeArrayErrorMessage = self::validateAllowanceChargeForArrayConstraintsFromSetAllowanceCharge($allowanceCharge))) {
            throw new \InvalidArgumentException($allowanceChargeArrayErrorMessage, __LINE__);
        }
        $this->AllowanceCharge = $allowanceCharge;
        return $this;
    }
    /**
     * Add item to AllowanceCharge value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\AllowanceChargeType $item
     * @return \TurkkepEFatura\StructType\BillingReferenceLineType
     */
    public function addToAllowanceCharge(\TurkkepEFatura\StructType\AllowanceChargeType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \TurkkepEFatura\StructType\AllowanceChargeType) {
            throw new \InvalidArgumentException(sprintf('The AllowanceCharge property can only contain items of type \TurkkepEFatura\StructType\AllowanceChargeType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AllowanceCharge[] = $item;
        return $this;
    }
}
