<?php

namespace TurkkepEFatura\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for UBLI ServiceType
 * @subpackage Services
 */
class UBLI extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named UBLIrsaliyeFaturaGonder
     * Meta information extracted from the WSDL
     * - documentation: UBL-TR formatında hazırlanmış bir irsaliye faturayı GİB merkez sistemine gönderir.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TurkkepEFatura\StructType\UBLIrsaliyeFaturaGonder $parameters
     * @return \TurkkepEFatura\StructType\UBLIrsaliyeFaturaGonderResponse|bool
     */
    public function UBLIrsaliyeFaturaGonder(\TurkkepEFatura\StructType\UBLIrsaliyeFaturaGonder $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UBLIrsaliyeFaturaGonder($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \TurkkepEFatura\StructType\UBLIrsaliyeFaturaGonderResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
