<?php

namespace TurkkepEFatura\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Taslak ServiceType
 * @subpackage Services
 */
class Taslak extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named TaslakIrsaliyeIptalEt
     * Meta information extracted from the WSDL
     * - documentation: Taslaktaki Irsaliye Faturanın iptal edilmesini sağlar.TaslakFaturaAra metodundan dönen DispatchId gönderilmelidir
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TurkkepEFatura\StructType\TaslakIrsaliyeIptalEt $parameters
     * @return \TurkkepEFatura\StructType\TaslakIrsaliyeIptalEtResponse|bool
     */
    public function TaslakIrsaliyeIptalEt(\TurkkepEFatura\StructType\TaslakIrsaliyeIptalEt $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->TaslakIrsaliyeIptalEt($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named TaslakFaturaAra
     * Meta information extracted from the WSDL
     * - documentation: Taslaklarda gönderilmeyi bekleyen faturaları getirir.Gelen listedeki faturalara onay verilemez. Faturaya onay vermek için bu metoddan dönen InvoiceId TaslakFaturaOnayla metoduna gönderilmelidir.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TurkkepEFatura\StructType\TaslakFaturaAra $parameters
     * @return \TurkkepEFatura\StructType\TaslakFaturaAraResponse|bool
     */
    public function TaslakFaturaAra(\TurkkepEFatura\StructType\TaslakFaturaAra $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->TaslakFaturaAra($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named TaslakFaturaOnayla
     * Meta information extracted from the WSDL
     * - documentation: Taslaklarda bekleyen faturaları onaylayarak GIB'e gönderilmesini sağlar. TaslakFaturaAra metodundan dönen InvoiceId gönderilmelidir.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TurkkepEFatura\StructType\TaslakFaturaOnayla $parameters
     * @return \TurkkepEFatura\StructType\TaslakFaturaOnaylaResponse|bool
     */
    public function TaslakFaturaOnayla(\TurkkepEFatura\StructType\TaslakFaturaOnayla $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->TaslakFaturaOnayla($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named TaslakFaturaIptalEt
     * Meta information extracted from the WSDL
     * - documentation: Taslaktaki e-Fatura ve e-Arşiv Faturanın iptal edilmesini sağlar.TaslakFaturaAra metodundan dönen InvoiceId gönderilmelidir
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TurkkepEFatura\StructType\TaslakFaturaIptalEt $parameters
     * @return \TurkkepEFatura\StructType\TaslakFaturaIptalEtResponse|bool
     */
    public function TaslakFaturaIptalEt(\TurkkepEFatura\StructType\TaslakFaturaIptalEt $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->TaslakFaturaIptalEt($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named TaslakFaturaOnaylaByUUID
     * Meta information extracted from the WSDL
     * - documentation: Taslaklarda bekleyen faturaları onaylayarak GIB'e gönderilmesini sağlar. TaslakFaturaAra metodundan dönen UUID gönderilmelidir.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TurkkepEFatura\StructType\TaslakFaturaOnaylaByUUID $parameters
     * @return \TurkkepEFatura\StructType\TaslakFaturaOnaylaByUUIDResponse|bool
     */
    public function TaslakFaturaOnaylaByUUID(\TurkkepEFatura\StructType\TaslakFaturaOnaylaByUUID $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->TaslakFaturaOnaylaByUUID($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named TaslakFaturaIptalEtByUUID
     * Meta information extracted from the WSDL
     * - documentation: Taslaktaki e-Fatura ve e-Arşiv Faturanın iptal edilmesini sağlar. TaslakFaturaAra metodundan dönen UUID gönderilmelidir.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TurkkepEFatura\StructType\TaslakFaturaIptalEtByUUID $parameters
     * @return \TurkkepEFatura\StructType\TaslakFaturaIptalEtByUUIDResponse|bool
     */
    public function TaslakFaturaIptalEtByUUID(\TurkkepEFatura\StructType\TaslakFaturaIptalEtByUUID $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->TaslakFaturaIptalEtByUUID($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named TaslakIrsaliyeAra
     * Meta information extracted from the WSDL
     * - documentation: Taslaklarda gönderilmeyi bekleyen israliyeleri getirir.Gelen listedeki irsaliyelere onay verilemez. İrsaliyeye onay vermek için bu metoddan dönen DespatchInvoiceId TaslakIrsaliyeOnayla metoduna gönderilmelidir.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TurkkepEFatura\StructType\TaslakIrsaliyeAra $parameters
     * @return \TurkkepEFatura\StructType\TaslakIrsaliyeAraResponse|bool
     */
    public function TaslakIrsaliyeAra(\TurkkepEFatura\StructType\TaslakIrsaliyeAra $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->TaslakIrsaliyeAra($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named TaslakIrsaliyeOnayla
     * Meta information extracted from the WSDL
     * - documentation: Taslaklarda bekleyen israliyeleri onaylayarak GIB'e gönderilmesini sağlar. TaslakIrsaliyeAra metodundan dönen DespatchInvoiceId gönderilmelidir.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TurkkepEFatura\StructType\TaslakIrsaliyeOnayla $parameters
     * @return \TurkkepEFatura\StructType\TaslakIrsaliyeOnaylaResponse|bool
     */
    public function TaslakIrsaliyeOnayla(\TurkkepEFatura\StructType\TaslakIrsaliyeOnayla $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->TaslakIrsaliyeOnayla($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \TurkkepEFatura\StructType\TaslakFaturaAraResponse|\TurkkepEFatura\StructType\TaslakFaturaIptalEtByUUIDResponse|\TurkkepEFatura\StructType\TaslakFaturaIptalEtResponse|\TurkkepEFatura\StructType\TaslakFaturaOnaylaByUUIDResponse|\TurkkepEFatura\StructType\TaslakFaturaOnaylaResponse|\TurkkepEFatura\StructType\TaslakIrsaliyeAraResponse|\TurkkepEFatura\StructType\TaslakIrsaliyeIptalEtResponse|\TurkkepEFatura\StructType\TaslakIrsaliyeOnaylaResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
