<?php

namespace TurkkepEFatura\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Oturum ServiceType
 * @subpackage Services
 */
class Oturum extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named OturumAc
     * Meta information extracted from the WSDL
     * - documentation: Tüm web servis yöntemlerinden önce bu yöntem ile güvenlik doğrulaması yapılmalıdır. Bu yöntem hatasız çalıştırıldıktan sonra diğer yöntemler kullanılabilir.OturumAc yöntemi yapılmadan diğer yöntemlerin
     * çağrılması durumunda sistem otomatik olarak hata fırlatacaktır.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TurkkepEFatura\StructType\OturumAc $parameters
     * @return \TurkkepEFatura\StructType\OturumAcResponse|bool
     */
    public function OturumAc(\TurkkepEFatura\StructType\OturumAc $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->OturumAc($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \TurkkepEFatura\StructType\OturumAcResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
