<?php

namespace TurkkepEFatura\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Irsaliye ServiceType
 * @subpackage Services
 */
class Irsaliye extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named
     * IrsaliyeFaturaGonderAnaOrganizasyon
     * Meta information extracted from the WSDL
     * - documentation: DespatchInvoice sınıfı ile hazırlanmış bir irsaliye faturayı GİB merkez sistemine gönderir.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TurkkepEFatura\StructType\IrsaliyeFaturaGonderAnaOrganizasyon $parameters
     * @return \TurkkepEFatura\StructType\IrsaliyeFaturaGonderAnaOrganizasyonResponse|bool
     */
    public function IrsaliyeFaturaGonderAnaOrganizasyon(\TurkkepEFatura\StructType\IrsaliyeFaturaGonderAnaOrganizasyon $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->IrsaliyeFaturaGonderAnaOrganizasyon($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named IrsaliyeFaturaGonder
     * Meta information extracted from the WSDL
     * - documentation: DespatchInvoice sınıfı ile hazırlanmış bir irsaliye faturayı GİB merkez sistemine gönderir.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TurkkepEFatura\StructType\IrsaliyeFaturaGonder $parameters
     * @return \TurkkepEFatura\StructType\IrsaliyeFaturaGonderResponse|bool
     */
    public function IrsaliyeFaturaGonder(\TurkkepEFatura\StructType\IrsaliyeFaturaGonder $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->IrsaliyeFaturaGonder($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \TurkkepEFatura\StructType\IrsaliyeFaturaGonderAnaOrganizasyonResponse|\TurkkepEFatura\StructType\IrsaliyeFaturaGonderResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
