<?php

namespace TurkkepEFatura\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Fatura ServiceType
 * @subpackage Services
 */
class Fatura extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named FaturaExcel
     * Meta information extracted from the WSDL
     * - documentation: Firmaya göre fatura exceli verir
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TurkkepEFatura\StructType\FaturaExcel $parameters
     * @return \TurkkepEFatura\StructType\FaturaExcelResponse|bool
     */
    public function FaturaExcel(\TurkkepEFatura\StructType\FaturaExcel $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->FaturaExcel($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named FaturaGonder
     * Meta information extracted from the WSDL
     * - documentation: Invoice sınıfı ile hazırlanmış bir faturayı GİB merkez sistemine gönderir.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TurkkepEFatura\StructType\FaturaGonder $parameters
     * @return \TurkkepEFatura\StructType\FaturaGonderResponse|bool
     */
    public function FaturaGonder(\TurkkepEFatura\StructType\FaturaGonder $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->FaturaGonder($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named FaturaGonder2
     * Meta information extracted from the WSDL
     * - documentation: Invoice sınıfı ile hazırlanmış bir faturayı GİB merkez sistemine gönderir.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TurkkepEFatura\StructType\FaturaGonder2 $parameters
     * @return \TurkkepEFatura\StructType\FaturaGonder2Response|bool
     */
    public function FaturaGonder2(\TurkkepEFatura\StructType\FaturaGonder2 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->FaturaGonder2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named FaturaGonderAnaOrganizasyon
     * Meta information extracted from the WSDL
     * - documentation: Invoice sınıfı ile hazırlanmış bir faturayı GİB merkez sistemine gönderir.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TurkkepEFatura\StructType\FaturaGonderAnaOrganizasyon $parameters
     * @return \TurkkepEFatura\StructType\FaturaGonderAnaOrganizasyonResponse|bool
     */
    public function FaturaGonderAnaOrganizasyon(\TurkkepEFatura\StructType\FaturaGonderAnaOrganizasyon $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->FaturaGonderAnaOrganizasyon($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named FaturaNumarasiSorgula
     * Meta information extracted from the WSDL
     * - documentation: Invoice ID'ye ait Fatura Numarasını döner.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TurkkepEFatura\StructType\FaturaNumarasiSorgula $parameters
     * @return \TurkkepEFatura\StructType\FaturaNumarasiSorgulaResponse|bool
     */
    public function FaturaNumarasiSorgula(\TurkkepEFatura\StructType\FaturaNumarasiSorgula $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->FaturaNumarasiSorgula($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \TurkkepEFatura\StructType\FaturaExcelResponse|\TurkkepEFatura\StructType\FaturaGonder2Response|\TurkkepEFatura\StructType\FaturaGonderAnaOrganizasyonResponse|\TurkkepEFatura\StructType\FaturaGonderResponse|\TurkkepEFatura\StructType\FaturaNumarasiSorgulaResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
