<?php

namespace TurkkepEFatura\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Etiket ServiceType
 * @subpackage Services
 */
class Etiket extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named EtiketGetir
     * Meta information extracted from the WSDL
     * - documentation: VKN veya TCKN ile belirtilen bir mükellefe ait etiket listesini döner. Irsaliye etiketi getirmek icin isDespatchAdvice parametresi true olarak verilir.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TurkkepEFatura\StructType\EtiketGetir $parameters
     * @return \TurkkepEFatura\StructType\EtiketGetirResponse|bool
     */
    public function EtiketGetir(\TurkkepEFatura\StructType\EtiketGetir $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->EtiketGetir($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \TurkkepEFatura\StructType\EtiketGetirResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
