<?php

namespace TurkkepEFatura\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for EF ServiceType
 * @subpackage Services
 */
class EF extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named EFaturaKalanKontorSorgula
     * Meta information extracted from the WSDL
     * - documentation: E-Fatura üzerinden kalan kontör sayısını gönderir.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TurkkepEFatura\StructType\EFaturaKalanKontorSorgula $parameters
     * @return \TurkkepEFatura\StructType\EFaturaKalanKontorSorgulaResponse|bool
     */
    public function EFaturaKalanKontorSorgula(\TurkkepEFatura\StructType\EFaturaKalanKontorSorgula $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->EFaturaKalanKontorSorgula($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \TurkkepEFatura\StructType\EFaturaKalanKontorSorgulaResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
