<?php

namespace TurkkepEFatura\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for EB ServiceType
 * @subpackage Services
 */
class EB extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named EBaseGetCreditInvoiceTotal
     * Meta information extracted from the WSDL
     * - documentation: Fatura Adetleri
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TurkkepEFatura\StructType\EBaseGetCreditInvoiceTotal $parameters
     * @return \TurkkepEFatura\StructType\EBaseGetCreditInvoiceTotalResponse|bool
     */
    public function EBaseGetCreditInvoiceTotal(\TurkkepEFatura\StructType\EBaseGetCreditInvoiceTotal $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->EBaseGetCreditInvoiceTotal($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \TurkkepEFatura\StructType\EBaseGetCreditInvoiceTotalResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
