<?php

namespace Ys\SurratKargo\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TeslimatBilgisi StructType
 * @subpackage Structs
 */
class TeslimatBilgisi extends AbstractStructBase
{
    /**
     * The TeslimatTarihi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $TeslimatTarihi;
    /**
     * The SonHareketTarihi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $SonHareketTarihi;
    /**
     * The TeslimatDurumu
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TeslimatDurumu;
    /**
     * The TeslimAlan
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TeslimAlan;
    /**
     * The SonDurum
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SonDurum;
    /**
     * The SonBulunduguYer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SonBulunduguYer;
    /**
     * The SonHareket
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SonHareket;
    /**
     * The TeslimatAciklamasi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TeslimatAciklamasi;
    /**
     * Constructor method for TeslimatBilgisi
     * @uses TeslimatBilgisi::setTeslimatTarihi()
     * @uses TeslimatBilgisi::setSonHareketTarihi()
     * @uses TeslimatBilgisi::setTeslimatDurumu()
     * @uses TeslimatBilgisi::setTeslimAlan()
     * @uses TeslimatBilgisi::setSonDurum()
     * @uses TeslimatBilgisi::setSonBulunduguYer()
     * @uses TeslimatBilgisi::setSonHareket()
     * @uses TeslimatBilgisi::setTeslimatAciklamasi()
     * @param string $teslimatTarihi
     * @param string $sonHareketTarihi
     * @param int $teslimatDurumu
     * @param string $teslimAlan
     * @param string $sonDurum
     * @param string $sonBulunduguYer
     * @param string $sonHareket
     * @param string $teslimatAciklamasi
     */
    public function __construct($teslimatTarihi = null, $sonHareketTarihi = null, $teslimatDurumu = null, $teslimAlan = null, $sonDurum = null, $sonBulunduguYer = null, $sonHareket = null, $teslimatAciklamasi = null)
    {
        $this
            ->setTeslimatTarihi($teslimatTarihi)
            ->setSonHareketTarihi($sonHareketTarihi)
            ->setTeslimatDurumu($teslimatDurumu)
            ->setTeslimAlan($teslimAlan)
            ->setSonDurum($sonDurum)
            ->setSonBulunduguYer($sonBulunduguYer)
            ->setSonHareket($sonHareket)
            ->setTeslimatAciklamasi($teslimatAciklamasi);
    }
    /**
     * Get TeslimatTarihi value
     * @return string
     */
    public function getTeslimatTarihi()
    {
        return $this->TeslimatTarihi;
    }
    /**
     * Set TeslimatTarihi value
     * @param string $teslimatTarihi
     * @return \Ys\SurratKargo\StructType\TeslimatBilgisi
     */
    public function setTeslimatTarihi($teslimatTarihi = null)
    {
        // validation for constraint: string
        if (!is_null($teslimatTarihi) && !is_string($teslimatTarihi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($teslimatTarihi, true), gettype($teslimatTarihi)), __LINE__);
        }
        $this->TeslimatTarihi = $teslimatTarihi;
        return $this;
    }
    /**
     * Get SonHareketTarihi value
     * @return string
     */
    public function getSonHareketTarihi()
    {
        return $this->SonHareketTarihi;
    }
    /**
     * Set SonHareketTarihi value
     * @param string $sonHareketTarihi
     * @return \Ys\SurratKargo\StructType\TeslimatBilgisi
     */
    public function setSonHareketTarihi($sonHareketTarihi = null)
    {
        // validation for constraint: string
        if (!is_null($sonHareketTarihi) && !is_string($sonHareketTarihi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sonHareketTarihi, true), gettype($sonHareketTarihi)), __LINE__);
        }
        $this->SonHareketTarihi = $sonHareketTarihi;
        return $this;
    }
    /**
     * Get TeslimatDurumu value
     * @return int
     */
    public function getTeslimatDurumu()
    {
        return $this->TeslimatDurumu;
    }
    /**
     * Set TeslimatDurumu value
     * @param int $teslimatDurumu
     * @return \Ys\SurratKargo\StructType\TeslimatBilgisi
     */
    public function setTeslimatDurumu($teslimatDurumu = null)
    {
        // validation for constraint: int
        if (!is_null($teslimatDurumu) && !(is_int($teslimatDurumu) || ctype_digit($teslimatDurumu))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($teslimatDurumu, true), gettype($teslimatDurumu)), __LINE__);
        }
        $this->TeslimatDurumu = $teslimatDurumu;
        return $this;
    }
    /**
     * Get TeslimAlan value
     * @return string|null
     */
    public function getTeslimAlan()
    {
        return $this->TeslimAlan;
    }
    /**
     * Set TeslimAlan value
     * @param string $teslimAlan
     * @return \Ys\SurratKargo\StructType\TeslimatBilgisi
     */
    public function setTeslimAlan($teslimAlan = null)
    {
        // validation for constraint: string
        if (!is_null($teslimAlan) && !is_string($teslimAlan)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($teslimAlan, true), gettype($teslimAlan)), __LINE__);
        }
        $this->TeslimAlan = $teslimAlan;
        return $this;
    }
    /**
     * Get SonDurum value
     * @return string|null
     */
    public function getSonDurum()
    {
        return $this->SonDurum;
    }
    /**
     * Set SonDurum value
     * @param string $sonDurum
     * @return \Ys\SurratKargo\StructType\TeslimatBilgisi
     */
    public function setSonDurum($sonDurum = null)
    {
        // validation for constraint: string
        if (!is_null($sonDurum) && !is_string($sonDurum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sonDurum, true), gettype($sonDurum)), __LINE__);
        }
        $this->SonDurum = $sonDurum;
        return $this;
    }
    /**
     * Get SonBulunduguYer value
     * @return string|null
     */
    public function getSonBulunduguYer()
    {
        return $this->SonBulunduguYer;
    }
    /**
     * Set SonBulunduguYer value
     * @param string $sonBulunduguYer
     * @return \Ys\SurratKargo\StructType\TeslimatBilgisi
     */
    public function setSonBulunduguYer($sonBulunduguYer = null)
    {
        // validation for constraint: string
        if (!is_null($sonBulunduguYer) && !is_string($sonBulunduguYer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sonBulunduguYer, true), gettype($sonBulunduguYer)), __LINE__);
        }
        $this->SonBulunduguYer = $sonBulunduguYer;
        return $this;
    }
    /**
     * Get SonHareket value
     * @return string|null
     */
    public function getSonHareket()
    {
        return $this->SonHareket;
    }
    /**
     * Set SonHareket value
     * @param string $sonHareket
     * @return \Ys\SurratKargo\StructType\TeslimatBilgisi
     */
    public function setSonHareket($sonHareket = null)
    {
        // validation for constraint: string
        if (!is_null($sonHareket) && !is_string($sonHareket)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sonHareket, true), gettype($sonHareket)), __LINE__);
        }
        $this->SonHareket = $sonHareket;
        return $this;
    }
    /**
     * Get TeslimatAciklamasi value
     * @return string|null
     */
    public function getTeslimatAciklamasi()
    {
        return $this->TeslimatAciklamasi;
    }
    /**
     * Set TeslimatAciklamasi value
     * @param string $teslimatAciklamasi
     * @return \Ys\SurratKargo\StructType\TeslimatBilgisi
     */
    public function setTeslimatAciklamasi($teslimatAciklamasi = null)
    {
        // validation for constraint: string
        if (!is_null($teslimatAciklamasi) && !is_string($teslimatAciklamasi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($teslimatAciklamasi, true), gettype($teslimatAciklamasi)), __LINE__);
        }
        $this->TeslimatAciklamasi = $teslimatAciklamasi;
        return $this;
    }
}
