<?php

namespace Ys\SurratKargo\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OdemeIslemleri StructType
 * @subpackage Structs
 */
class OdemeIslemleri extends AbstractStructBase
{
    /**
     * The OdemeEvrakNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OdemeEvrakNo;
    /**
     * The Aciklama
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Aciklama;
    /**
     * The Detay
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Ys\SurratKargo\ArrayType\ArrayOfOdemeIslemleriDetay
     */
    public $Detay;
    /**
     * Constructor method for OdemeIslemleri
     * @uses OdemeIslemleri::setOdemeEvrakNo()
     * @uses OdemeIslemleri::setAciklama()
     * @uses OdemeIslemleri::setDetay()
     * @param string $odemeEvrakNo
     * @param string $aciklama
     * @param \Ys\SurratKargo\ArrayType\ArrayOfOdemeIslemleriDetay $detay
     */
    public function __construct($odemeEvrakNo = null, $aciklama = null, \Ys\SurratKargo\ArrayType\ArrayOfOdemeIslemleriDetay $detay = null)
    {
        $this
            ->setOdemeEvrakNo($odemeEvrakNo)
            ->setAciklama($aciklama)
            ->setDetay($detay);
    }
    /**
     * Get OdemeEvrakNo value
     * @return string|null
     */
    public function getOdemeEvrakNo()
    {
        return $this->OdemeEvrakNo;
    }
    /**
     * Set OdemeEvrakNo value
     * @param string $odemeEvrakNo
     * @return \Ys\SurratKargo\StructType\OdemeIslemleri
     */
    public function setOdemeEvrakNo($odemeEvrakNo = null)
    {
        // validation for constraint: string
        if (!is_null($odemeEvrakNo) && !is_string($odemeEvrakNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($odemeEvrakNo, true), gettype($odemeEvrakNo)), __LINE__);
        }
        $this->OdemeEvrakNo = $odemeEvrakNo;
        return $this;
    }
    /**
     * Get Aciklama value
     * @return string|null
     */
    public function getAciklama()
    {
        return $this->Aciklama;
    }
    /**
     * Set Aciklama value
     * @param string $aciklama
     * @return \Ys\SurratKargo\StructType\OdemeIslemleri
     */
    public function setAciklama($aciklama = null)
    {
        // validation for constraint: string
        if (!is_null($aciklama) && !is_string($aciklama)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aciklama, true), gettype($aciklama)), __LINE__);
        }
        $this->Aciklama = $aciklama;
        return $this;
    }
    /**
     * Get Detay value
     * @return \Ys\SurratKargo\ArrayType\ArrayOfOdemeIslemleriDetay|null
     */
    public function getDetay()
    {
        return $this->Detay;
    }
    /**
     * Set Detay value
     * @param \Ys\SurratKargo\ArrayType\ArrayOfOdemeIslemleriDetay $detay
     * @return \Ys\SurratKargo\StructType\OdemeIslemleri
     */
    public function setDetay(\Ys\SurratKargo\ArrayType\ArrayOfOdemeIslemleriDetay $detay = null)
    {
        $this->Detay = $detay;
        return $this;
    }
}
