<?php

namespace Ys\SurratKargo\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for KargoBarkod StructType
 * @subpackage Structs
 */
class KargoBarkod extends AbstractStructBase
{
    /**
     * The OzelKargoTakipNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OzelKargoTakipNo;
    /**
     * The Aciklama
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Aciklama;
    /**
     * The Detay
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Ys\SurratKargo\ArrayType\ArrayOfKargoBarkodDetay
     */
    public $Detay;
    /**
     * The PdfBarkod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PdfBarkod;
    /**
     * The PpdBarkod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Ys\SurratKargo\ArrayType\ArrayOfString
     */
    public $PpdBarkod;
    /**
     * Constructor method for KargoBarkod
     * @uses KargoBarkod::setOzelKargoTakipNo()
     * @uses KargoBarkod::setAciklama()
     * @uses KargoBarkod::setDetay()
     * @uses KargoBarkod::setPdfBarkod()
     * @uses KargoBarkod::setPpdBarkod()
     * @param string $ozelKargoTakipNo
     * @param string $aciklama
     * @param \Ys\SurratKargo\ArrayType\ArrayOfKargoBarkodDetay $detay
     * @param string $pdfBarkod
     * @param \Ys\SurratKargo\ArrayType\ArrayOfString $ppdBarkod
     */
    public function __construct($ozelKargoTakipNo = null, $aciklama = null, \Ys\SurratKargo\ArrayType\ArrayOfKargoBarkodDetay $detay = null, $pdfBarkod = null, \Ys\SurratKargo\ArrayType\ArrayOfString $ppdBarkod = null)
    {
        $this
            ->setOzelKargoTakipNo($ozelKargoTakipNo)
            ->setAciklama($aciklama)
            ->setDetay($detay)
            ->setPdfBarkod($pdfBarkod)
            ->setPpdBarkod($ppdBarkod);
    }
    /**
     * Get OzelKargoTakipNo value
     * @return string|null
     */
    public function getOzelKargoTakipNo()
    {
        return $this->OzelKargoTakipNo;
    }
    /**
     * Set OzelKargoTakipNo value
     * @param string $ozelKargoTakipNo
     * @return \Ys\SurratKargo\StructType\KargoBarkod
     */
    public function setOzelKargoTakipNo($ozelKargoTakipNo = null)
    {
        // validation for constraint: string
        if (!is_null($ozelKargoTakipNo) && !is_string($ozelKargoTakipNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ozelKargoTakipNo, true), gettype($ozelKargoTakipNo)), __LINE__);
        }
        $this->OzelKargoTakipNo = $ozelKargoTakipNo;
        return $this;
    }
    /**
     * Get Aciklama value
     * @return string|null
     */
    public function getAciklama()
    {
        return $this->Aciklama;
    }
    /**
     * Set Aciklama value
     * @param string $aciklama
     * @return \Ys\SurratKargo\StructType\KargoBarkod
     */
    public function setAciklama($aciklama = null)
    {
        // validation for constraint: string
        if (!is_null($aciklama) && !is_string($aciklama)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aciklama, true), gettype($aciklama)), __LINE__);
        }
        $this->Aciklama = $aciklama;
        return $this;
    }
    /**
     * Get Detay value
     * @return \Ys\SurratKargo\ArrayType\ArrayOfKargoBarkodDetay|null
     */
    public function getDetay()
    {
        return $this->Detay;
    }
    /**
     * Set Detay value
     * @param \Ys\SurratKargo\ArrayType\ArrayOfKargoBarkodDetay $detay
     * @return \Ys\SurratKargo\StructType\KargoBarkod
     */
    public function setDetay(\Ys\SurratKargo\ArrayType\ArrayOfKargoBarkodDetay $detay = null)
    {
        $this->Detay = $detay;
        return $this;
    }
    /**
     * Get PdfBarkod value
     * @return string|null
     */
    public function getPdfBarkod()
    {
        return $this->PdfBarkod;
    }
    /**
     * Set PdfBarkod value
     * @param string $pdfBarkod
     * @return \Ys\SurratKargo\StructType\KargoBarkod
     */
    public function setPdfBarkod($pdfBarkod = null)
    {
        // validation for constraint: string
        if (!is_null($pdfBarkod) && !is_string($pdfBarkod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pdfBarkod, true), gettype($pdfBarkod)), __LINE__);
        }
        $this->PdfBarkod = $pdfBarkod;
        return $this;
    }
    /**
     * Get PpdBarkod value
     * @return \Ys\SurratKargo\ArrayType\ArrayOfString|null
     */
    public function getPpdBarkod()
    {
        return $this->PpdBarkod;
    }
    /**
     * Set PpdBarkod value
     * @param \Ys\SurratKargo\ArrayType\ArrayOfString $ppdBarkod
     * @return \Ys\SurratKargo\StructType\KargoBarkod
     */
    public function setPpdBarkod(\Ys\SurratKargo\ArrayType\ArrayOfString $ppdBarkod = null)
    {
        $this->PpdBarkod = $ppdBarkod;
        return $this;
    }
}
