<?php

namespace Ys\SurratKargo\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CargoTrackingMethod StructType
 * @subpackage Structs
 */
class CargoTrackingMethod extends AbstractStructBase
{
    /**
     * The CustomerCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerCode;
    /**
     * The Password
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Password;
    /**
     * The SalesCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SalesCode;
    /**
     * Constructor method for CargoTrackingMethod
     * @uses CargoTrackingMethod::setCustomerCode()
     * @uses CargoTrackingMethod::setPassword()
     * @uses CargoTrackingMethod::setSalesCode()
     * @param string $customerCode
     * @param string $password
     * @param string $salesCode
     */
    public function __construct($customerCode = null, $password = null, $salesCode = null)
    {
        $this
            ->setCustomerCode($customerCode)
            ->setPassword($password)
            ->setSalesCode($salesCode);
    }
    /**
     * Get CustomerCode value
     * @return string|null
     */
    public function getCustomerCode()
    {
        return $this->CustomerCode;
    }
    /**
     * Set CustomerCode value
     * @param string $customerCode
     * @return \Ys\SurratKargo\StructType\CargoTrackingMethod
     */
    public function setCustomerCode($customerCode = null)
    {
        // validation for constraint: string
        if (!is_null($customerCode) && !is_string($customerCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerCode, true), gettype($customerCode)), __LINE__);
        }
        $this->CustomerCode = $customerCode;
        return $this;
    }
    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \Ys\SurratKargo\StructType\CargoTrackingMethod
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
    /**
     * Get SalesCode value
     * @return string|null
     */
    public function getSalesCode()
    {
        return $this->SalesCode;
    }
    /**
     * Set SalesCode value
     * @param string $salesCode
     * @return \Ys\SurratKargo\StructType\CargoTrackingMethod
     */
    public function setSalesCode($salesCode = null)
    {
        // validation for constraint: string
        if (!is_null($salesCode) && !is_string($salesCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salesCode, true), gettype($salesCode)), __LINE__);
        }
        $this->SalesCode = $salesCode;
        return $this;
    }
}
