<?php

namespace Ys\SurratKargo\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Ortak ServiceType
 * @subpackage Services
 */
class Ortak extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named OrtakBarkodOlustur
     * Meta information extracted from the WSDL
     * - documentation: [Pazaryerimi]=1 ise [EntegrasyonMusteri]=[Trendyol|Hepsiburada|N11|Gittigidiyor] olarak beslenmelidir.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Ys\SurratKargo\StructType\OrtakBarkodOlustur $parameters
     * @return \Ys\SurratKargo\StructType\OrtakBarkodOlusturResponse|bool
     */
    public function OrtakBarkodOlustur(\Ys\SurratKargo\StructType\OrtakBarkodOlustur $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->__soapCall('OrtakBarkodOlustur', array(
                $parameters,
            ), array(), array(), $this->outputHeaders));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Ys\SurratKargo\StructType\OrtakBarkodOlusturResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
