<?php

namespace Ys\SurratKargo\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Cargo ServiceType
 * @subpackage Services
 */
class Cargo extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named CargoTrackingMethod
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Ys\SurratKargo\StructType\CargoTrackingMethod $parameters
     * @return \Ys\SurratKargo\StructType\CargoTrackingMethodResponse|bool
     */
    public function CargoTrackingMethod(\Ys\SurratKargo\StructType\CargoTrackingMethod $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->__soapCall('CargoTrackingMethod', array(
                $parameters,
            ), array(), array(), $this->outputHeaders));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Ys\SurratKargo\StructType\CargoTrackingMethodResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
