<?php


namespace Ysb\PayTr;


use Exception;
use Ysb\PayTr\Objects\PayTrOrder;

class PayTrClient
{

    #region fields

    /** @var string */
    protected $merchantId = "233777";

    /** @var string */
    protected $merchantKey = "dhUCNKo1dyJkePKP";

    /** @var string */
    protected $merchantSalt = "gtaoWtZ7zxYZXEgb";

    /** @var string */
    protected $merchantOkUrl;

    /** @var string */
    protected $merchantFailUrl;

    /** @var bool */
    protected $testMode = false;

    /** @var int */
    protected $timeout = 30;

    protected $apiUrl = "https://www.paytr.com/odeme/api/get-token";

    #endregion fields

    #region ctor

    public function __construct($config = array())
    {
        if (array_key_exists("merchantId", $config)) {
            $this->merchantId = $config["merchantId"];
        }

        if (array_key_exists("merchantKey", $config)) {
            $this->merchantKey = $config["merchantKey"];
        }

        if (array_key_exists("merchantSalt", $config)) {
            
            $this->merchantSalt = $config["merchantSalt"];
        }

        if (array_key_exists("merchantOkUrl", $config)) {
            $this->merchantOkUrl = $config["merchantOkUrl"];
        }

        if (array_key_exists("merchantFailUrl", $config)) {
            $this->merchantFailUrl = $config["merchantFailUrl"];
        }

        if (array_key_exists("testMode", $config)) {
            $this->testMode = $config["testMode"];
        }

        if (array_key_exists("apiUrl", $config)) {
            $this->apiUrl = $config["apiUrl"];
        }

    }



    #endregion ctor

    #region properties

    /**
     * @return string
     */
    public function getMerchantId()
    {
        return $this->merchantId;
    }

    /**
     * @param string $merchantId
     * @return $this
     */
    public function setMerchantId($merchantId)
    {
        $this->merchantId = $merchantId;
        return $this;
    }

    /**
     * @return string
     */
    public function getMerchantKey()
    {
        return $this->merchantKey;
    }

    /**
     * @param string $merchantKey
     * @return $this
     */
    public function setMerchantKey($merchantKey)
    {
        $this->merchantKey = $merchantKey;
        return $this;
    }

    /**
     * @return string
     */
    public function getMerchantSalt()
    {
        return $this->merchantSalt;
    }

    /**
     * @param string $merchantSalt
     * @return $this
     */
    public function setMerchantSalt($merchantSalt)
    {
        $this->merchantSalt = $merchantSalt;
        return $this;
    }

    /**
     * @return string
     */
    public function getMerchantOkUrl()
    {
        return $this->merchantOkUrl;
    }

    /**
     * @param string $merchantOkUrl
     * @return $this
     */
    public function setMerchantOkUrl($merchantOkUrl)
    {
        $this->merchantOkUrl = $merchantOkUrl;
        return $this;
    }

    /**
     * @return string
     */
    public function getMerchantFailUrl()
    {
        return $this->merchantFailUrl;
    }

    /**
     * @param string $merchantFailUrl
     * @return $this
     */
    public function setMerchantFailUrl($merchantFailUrl)
    {
        $this->merchantFailUrl = $merchantFailUrl;
        return $this;
    }

    /**
     * @return bool
     */
    public function isTestMode()
    {
        return $this->testMode;
    }

    /**
     * @param bool $testMode
     * @return $this
     */
    public function setTestMode($testMode = true)
    {
        $this->testMode = $testMode;
        return $this;
    }

    /**
     * @return int
     */
    public function getTimeout()
    {
        return $this->timeout;
    }

    /**
     * @param int $timeout
     * @return $this
     */
    public function setTimeout($timeout)
    {
        $this->timeout = $timeout;
        return $this;
    }



    #endregion properties

    #region methods


    /**
     * @param PayTrOrder $order
     * @return string
     * @throws Exception
     */
    public function getIFrameToken($order)
    {
        $formData = $order->toArray();

        $formData["merchant_id"] = $this->getMerchantId();
        $formData["paytr_token"] = $this->createToken($order);
        $formData["debug_on"] = $this->isTestMode() ? 1 : 0;
        $formData["merchant_ok_url"] = $this->getMerchantOkUrl();
        $formData["merchant_fail_url"] = $this->getMerchantFailUrl();
        $formData["timeout_limit"] = $this->getTimeout();
        $formData["test_mode"] = $this->isTestMode() ? 1 : 0;

        $ch=curl_init();
        curl_setopt($ch, CURLOPT_URL, $this->apiUrl);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1) ;
        curl_setopt($ch, CURLOPT_POSTFIELDS, $formData);
        curl_setopt($ch, CURLOPT_FRESH_CONNECT, true);
        curl_setopt($ch, CURLOPT_TIMEOUT, 20);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);


        $result = @curl_exec($ch);

        if(curl_errno($ch)){
            $exp = new Exception("PAYTR IFRAME connection error. err:".curl_error($ch));
            curl_close($ch);
            throw $exp;
        }

        $result=json_decode($result,1);

        if($result['status']=='success'){
            return $result['token'];
        }
        curl_close($ch);
        throw new Exception("PAYTR IFRAME failed. reason:".$result['reason']);

    }


    public function checkRespose($post){
        ## POST değerleri ile hash oluştur.
        $hash = base64_encode(
            hash_hmac(
                'sha256',
                $post['merchant_oid'].$this->getMerchantSalt().$post['status'].
                $post['total_amount'],
                $this->getMerchantKey(),
                true
            )
        );
        #
        ## Oluşturulan hash'i, paytr'dan gelen post içindeki hash ile karşılaştır (isteğin paytr'dan geldiğine ve değişmediğine emin olmak için)
        ## Bu işlemi yapmazsanız maddi zarara uğramanız olasıdır.
        return $hash == $post['hash'];
    }

    #endregion methods

    #region utils


    /**
     * @param PayTrOrder $order
     * @return string
     */
    protected function createToken($order)
    {
        $hash_str = $this->merchantId . $order->getUserIp() . $order->getOrderId() .
            $order->getEmail() . $order->getPaymentAmount() .
            $order->getBasketItemsBase64() . ($order->isNoInstallment() ? 1 : 0) .
            $order->getMaxInstallment() . $order->getCurrency() . ($this->isTestMode() ? 1 : 0);
        $paytr_token = base64_encode(hash_hmac('sha256', $hash_str . $this->getMerchantSalt(), $this->getMerchantKey(), true));
        return $paytr_token;
    }

    #endregion utils

}