<?php


namespace Ysb\PayTr\Objects;


class PayTrNoIframeBasketItem
{

    #region fields

    /** @var string */
    protected $productName;

    /** @var string */
    protected $unitPrice;

    /** @var int */
    protected $quantity;

    #endregion fields

    #region ctor

    /**
     * PayTrBasketItem constructor.
     * @param string $productName
     * @param string $unitPrice
     * @param int $quantity
     */
    public function __construct($productName = "", $unitPrice = "", $quantity = 1)
    {
        $this->productName = $productName;
        $this->unitPrice = $unitPrice;
        $this->quantity = $quantity;
    }

    #endregion ctor

    #region properties

    /**
     * @return string
     */
    public function getProductName()
    {
        return $this->productName;
    }

    /**
     * @param string $productName
     * @return $this
     */
    public function setProductName($productName)
    {
        $this->productName = $productName;
        return $this;
    }

    /**
     * @return string
     */
    public function getUnitPrice()
    {
        return $this->unitPrice;
    }

    /**
     * @param string $unitPrice
     * @return $this
     */
    public function setUnitPrice($unitPrice)
    {
        $this->unitPrice = $unitPrice;
        return $this;
    }

    /**
     * @return int
     */
    public function getQuantity()
    {
        return $this->quantity;
    }

    /**
     * @param int $quantity
     * @return $this
     */
    public function setQuantity($quantity)
    {
        $this->quantity = $quantity;
        return $this;
    }

    #endregion properties

    #region Methods

    public function toArray(){
        return array(
            $this->productName,
            $this->unitPrice,
            $this->quantity
        );
    }

    #endregion Methods

}