<?php

use Ysb\PayTr\Objects\PayTrNoIframeOrder;
use Ysb\PayTr\Objects\PayTrOrder;
use Ysb\PayTr\PayTrNoIframeClient;

include_once 'vendor/autoload.php';


#region paytr


// 1. ADIM
function iparaIndexPost()
{


    $payTr = new \Ysb\PayTr\PayTrClient([
        "merchantId" => "233777",
        "merchantKey" => "dhUCNKo1dyJkePKP",
        "merchantSalt" => "gtaoWtZ7zxYZXEgb",
        "merchantOkUrl" => "Payment/payTrSuccess/",
        "merchantFailUrl" => "Payment/payTrFail",
        "testMode" => true // gerçek ortamda false olacak.
    ]);


    $adres = "";
    $il = "";
    $ilce = "";
    $adres = $adres . ' ' . $il . ' / ' . $ilce;
    $data = array();

    $order = new PayTrOrder();
    $order->setUserName($data['order_name']) // müşteri adı
    ->setEmail($data['order_mail']) // müşteri email
    ->setPaymentAmount($data['order_total'] * 100) // sipariş tutarı 9.99 için 9.99 * 100 = 999 gönderilmelidir.
    ->setOrderId($data['order_rand_id']) // takip edilecek order ıd
    ->setUserAddress($adres) // Müşteri adresi
    ->setUserPhone($data['order_gsm']) // Müşteri telefon no
    ->setNoInstallment(true) // taksit yapılmayacaksa true yoksa false
    ->setMaxInstallment(0) // Sayfada görüntülenecek taksit adedini sınırlamak istiyorsanız uygun şekilde değiştirin. Sıfır (0) gönderilmesi durumunda yürürlükteki en fazla izin verilen taksit geçerli olur.
    ->setCurrency("TL"); // Para birimi

    foreach ($data['cart'] as $value) {
        if (!isset($value['ucretsiz'])) {
            $price = 0.0;

        } else {
            if (!isset($value['eksilt'])) {
                $price = 0.00;
            } else {
                $price = 0.0;
            }
        }
        $order->addBasketItem($value['name'], $price, 1); //ürün bilgisi
    }
    try {
        $token = $payTr->getIFrameToken($order);
    } catch (Exception $exp) {
        echo $exp->getMessage();
        return;
    }


    $strHtml = <<<EOT
<!-- Ödeme formunun açılması için gereken HTML kodlar / Başlangıç -->

    <script src="https://www.paytr.com/js/iframeResizer.min.js"></script>
        <iframe src="https://www.paytr.com/odeme/guvenli/' . $token . '" onload="iFrameResize({log:false})"  id="paytriframe" frameborder="0" scrolling="no" style="width: 100%;"></iframe>

 	<!--<script>iFrameResize({},\'#paytriframe\');</script>-->
	<!-- Ödeme formunun açılması için gereken HTML kodlar / Bitiş -->
	

EOT;


    echo $strHtml;
}

function payTrSuccess($oid)
{
    // Başarılı
    ## Başarılı ödeme sonrası müşterinizin yönlendirileceği sayfa
    ## !!! Bu sayfa siparişi onaylayacağınız sayfa değildir! Yalnızca müşterinizi bilgilendireceğiniz sayfadır!
    ## !!! Siparişi onaylayacağız sayfa "Bildirim URL" sayfasıdır

    $data['sip_id'] = $oid;


}


function payTrFail()
{
    // Başarısız
    ## Ödeme sürecinde beklenmedik bir hata oluşması durumunda müşterinizin yönlendirileceği sayfa
    ## !!! Bu sayfa siparişi iptal edeceğiniz sayfa değildir! Yalnızca müşterinizi bilgilendireceğiniz sayfadır!
    ## !!! Siparişi iptal edeceğiniz sayfa "Bildirim URL" sayfasıdır

}


// 2. Adım

function callbackPayTr()
{
    ## ÖNEMLİ UYARILAR ##
    ## 1) Bu sayfaya oturum (SESSION) ile veri taşıyamazsınız. Çünkü bu sayfa müşterilerin yönlendirildiği bir sayfa değildir.
    ## 2) Entegrasyonun 1. ADIM'ında gönderdiğniz merchant_oid değeri bu sayfaya POST ile gelir. Bu değeri kullanarak
    ## veri tabanınızdan ilgili siparişi tespit edip onaylamalı veya iptal etmelisiniz.
    ## 3) Aynı sipariş için birden fazla bildirim ulaşabilir (Ağ bağlantı sorunları vb. nedeniyle). Bu nedenle öncelikle
    ## siparişin durumunu veri tabanınızdan kontrol edin, eğer onaylandıysa tekrar işlem yapmayın. Örneği aşağıda bulunmaktadır.

    $post = $_POST;
    $payTr = new \Ysb\PayTr\PayTrClient([
        "merchantId" => "233777",
        "merchantKey" => "dhUCNKo1dyJkePKP",
        "merchantSalt" => "gtaoWtZ7zxYZXEgb",
        "merchantOkUrl" => "Payment/payTrSuccess",
        "merchantFailUrl" => "Payment/payTrFail",
        "testMode" => true // gerçek ortamda false olacak.
    ]);


    if ($payTr->checkRespose($post)) {


        $order_id = $post['merchant_oid'];

        // istek paytr den geliyor.
        ## BURADA YAPILMASI GEREKENLER
        ## 1) Siparişin durumunu $post['merchant_oid'] değerini kullanarak veri tabanınızdan sorgulayın.
        ## 2) Eğer sipariş zaten daha önceden onaylandıysa veya iptal edildiyse  echo "OK"; exit; yaparak sonlandırın.

        /* Sipariş durum sorgulama örnek
            $durum = SQL
           if($durum == "onay" || $durum == "iptal"){
                echo "OK";
                exit;
            }

*/
        if($post['status'] == 'success') { ## Ödeme Onaylandı

            ## BURADA YAPILMASI GEREKENLER
            ## 1) Siparişi onaylayın.
            ## 2) Eğer müşterinize mesaj / SMS / e-posta gibi bilgilendirme yapacaksanız bu aşamada yapmalısınız.
            ## 3) 1. ADIM'da gönderilen payment_amount sipariş tutarı taksitli alışveriş yapılması durumunda
            ## değişebilir. Güncel tutarı $post['total_amount'] değerinden alarak muhasebe işlemlerinizde kullanabilirsiniz.

        } else { ## Ödemeye Onay Verilmedi

            ## BURADA YAPILMASI GEREKENLER
            ## 1) Siparişi iptal edin.
            ## 2) Eğer ödemenin onaylanmama sebebini kayıt edecekseniz aşağıdaki değerleri kullanabilirsiniz.
            ## $post['failed_reason_code'] - başarısız hata kodu
            ## $post['failed_reason_msg'] - başarısız hata mesajı

        }

        ## Bildirimin alındığını PayTR sistemine bildir.
        echo "OK";
        exit;


    } else {
        // istek paytr den gelmiyor
        die('PAYTR notification failed: bad hash');
    }


}

#endregion paytr


#region paytr no iframe


function iparaMoIframeIndex()
{
    // Burada kredi kartı formu basılacak
}

// 1. ADIM

function iparaMoIframeIndexPost()
{
    // Kredi kartı formundan gelen bilgiler $_Post

    $total_fiyat = 0.0;
    $ara_toplam = 0.0;

    $genel_detay = ['ara_toplam' => $ara_toplam, 'kargo_name' => $_POST['order_kargo_name'], 'kargo_price' => $_POST['order_kargo_price']];

    $_SESSION['siparis_bilgileri'] = [
        'order_tcno' => $_POST['order_tcno'],
        'order_nots' => $_POST['order_nots'],
        'order_firma_unvan' => $_POST['order_firma_unvan'],
        'order_vd' => $_POST['order_vd'],
        'order_vno' => $_POST['order_vno'],
        'order_name_first' => $_POST['order_name_first'],
        'order_name_second' => $_POST['order_name_second'],
        'order_mail' => $_POST['order_mail'],
        'order_gsm' => $_POST['order_gsm'],
        'genel_tutar' => $total_hediyeli,
        'order_kargo_name' => $_POST['order_kargo_name'],
        'order_kargo_price' => $_POST['order_kargo_price'],
        'order_fat_tur' => $_POST['order_fat_tur'],
        'order_odeme_tip' => $_POST['order_odeme_tip'],
        'order_fatura_adres_id' => $_POST['order_fatura_adres_id'],
        'order_adres_id' => $_POST['order_adres_id'],
        'fatura_none' => $_POST['fatura_none'],
        'order_campain' => json_encode($_SESSION['kosul']),
    ];

    $ara_top = 0.0;


    $data['order_rand_id'] = time();
    $data['order_uye_id'] = isset($_SESSION['uye']) ? $_SESSION['uye'] : 0;
    $data['order_durum'] = 17;
    $data['order_total'] = $total_hediyeli;
    $data['order_kargo_total'] = $_SESSION['siparis_bilgileri']['order_kargo_price'];
    $data['order_tahsilat_ucret'] = 0;
    $data['order_grand_total'] = json_encode($genel_detay);
    $data['order_products'] = json_encode($_SESSION['cart']);
    $data['order_ip'] = $_SERVER['REMOTE_ADDR'];
    $data['order_name'] = $_SESSION['siparis_bilgileri']['order_name_first'] . ' ' . $_SESSION['siparis_bilgileri']['order_name_second'];
    $data['order_fat_tur'] = $_SESSION['siparis_bilgileri']['order_fat_tur'];
    $data['order_odeme_tip'] = $_SESSION['siparis_bilgileri']['order_odeme_tip'];
    $data['order_fatura_adres_id'] = $_SESSION['siparis_bilgileri']['order_fatura_adres_id'];
    $data['order_adres_id'] = $_SESSION['siparis_bilgileri']['order_adres_id'];
    $data['order_mail'] = $_SESSION['siparis_bilgileri']['order_mail'];
    $data['fatura_none'] = $_SESSION['siparis_bilgileri']['fatura_none'];
    $data['order_campain'] = json_encode($_SESSION['kosul']);
    $data['order_gsm'] = $_SESSION['siparis_bilgileri']['order_gsm'];

    //$result_error = $this->db->insert('order_error', $data); //sipariş db ye kaydet

//prep($result_error);


    $payTr = new PayTrNoIframeClient([
        "merchantId" => "233777",
        "merchantKey" => "dhUCNKo1dyJkePKP",
        "merchantSalt" => "gtaoWtZ7zxYZXEgb",
        "merchantOkUrl" => "Payment/payTrNoIframeSuccess/",
        "merchantFailUrl" => "Payment/payTrNoIframeFail",
        "testMode" => true // gerçek ortamda false olacak.
    ]);

    $adres = "";
    $il = "";
    $ilce = "";


    $order = new PayTrNoIframeOrder();
    $order->setUserName($data['order_name']) // müşteri adı
    ->setEmail($data['order_mail']) // müşteri email
    ->setPaymentAmount($data['order_total'])
        ->setMerchantOid($data['order_rand_id']) // takip edilecek order ıd
        ->setUserAddress($adres) // Müşteri adresi
        ->setUserPhone($data['order_gsm']) // Müşteri telefon no
        ->setInstallmentCount(0) // taksit sayısı
        ->setCurrency("TL") // Para birimi
        ->setCcOwner($_POST["cc_owner"]) // Kart Sahibi Adı
        ->setCardNumber($_POST["card_number"]) // Kart Numarası
        ->setExpiryMonth($_POST["expiry_month"]) // Kart Son Kullanma Ay
        ->setExpiryYear($_POST["expiry_year"]) //  Kart Son Kullanma Yıl
        ->setCvv($_POST["cvv"]) //  Kart Güvenlik Kodu
        ->setNon3d(!empty($_POST["non_3d"]) ? true : false); //  true : 3d olmadan ödeme al. false 3d


        $order->addBasketItem('name', 0.0, 1); //ürün bilgisi

    $formHtml = $payTr->createPostFormHtml($order);

    echo $formHtml;
}


function payTrMoIframeSuccess($oid)
{
    // Başarılı
    ## Başarılı ödeme sonrası müşterinizin yönlendirileceği sayfa
    ## !!! Bu sayfa siparişi onaylayacağınız sayfa değildir! Yalnızca müşterinizi bilgilendireceğiniz sayfadır!
    ## !!! Siparişi onaylayacağız sayfa "Bildirim URL" sayfasıdır

}


function payTrNoIframeFail()
{
    // Başarısız
    ## Ödeme sürecinde beklenmedik bir hata oluşması durumunda müşterinizin yönlendirileceği sayfa
    ## !!! Bu sayfa siparişi iptal edeceğiniz sayfa değildir! Yalnızca müşterinizi bilgilendireceğiniz sayfadır!
    ## !!! Siparişi iptal edeceğiniz sayfa "Bildirim URL" sayfasıdır

}


// 2. Adım

function callbackPayTrNoIframe()
{
    ## ÖNEMLİ UYARILAR ##
    ## 1) Bu sayfaya oturum (SESSION) ile veri taşıyamazsınız. Çünkü bu sayfa müşterilerin yönlendirildiği bir sayfa değildir.
    ## 2) Entegrasyonun 1. ADIM'ında gönderdiğniz merchant_oid değeri bu sayfaya POST ile gelir. Bu değeri kullanarak
    ## veri tabanınızdan ilgili siparişi tespit edip onaylamalı veya iptal etmelisiniz.
    ## 3) Aynı sipariş için birden fazla bildirim ulaşabilir (Ağ bağlantı sorunları vb. nedeniyle). Bu nedenle öncelikle
    ## siparişin durumunu veri tabanınızdan kontrol edin, eğer onaylandıysa tekrar işlem yapmayın. Örneği aşağıda bulunmaktadır.

    $post = $_POST;
    $payTr = new PayTrNoIframeClient([
        "merchantId" => "233777",
        "merchantKey" => "dhUCNKo1dyJkePKP",
        "merchantSalt" => "gtaoWtZ7zxYZXEgb",
        "merchantOkUrl" => "Payment/payTrNoIframeSuccess",
        "merchantFailUrl" => "Payment/payTrNoIframeFail",
        "testMode" => true // gerçek ortamda false olacak.
    ]);


    if ($payTr->checkRespose($post)) {


        $order_id = $post['merchant_oid'];

        // istek paytr den geliyor.
        ## BURADA YAPILMASI GEREKENLER
        ## 1) Siparişin durumunu $post['merchant_oid'] değerini kullanarak veri tabanınızdan sorgulayın.
        ## 2) Eğer sipariş zaten daha önceden onaylandıysa veya iptal edildiyse  echo "OK"; exit; yaparak sonlandırın.

        /* Sipariş durum sorgulama örnek
            $durum = SQL
           if($durum == "onay" || $durum == "iptal"){
                echo "OK";
                exit;
            }
*/




            if ($post['status'] == 'success') { ## Ödeme Onaylandı

                /* Ödeme başarılı */
                /*   $myfile = fopen("newfile.txt", "w") or die("Unable to open file!");
                   $txt = json_encode($this->db->last_query());
                   fwrite($myfile, $txt);
                   fclose($myfile);
                   die();*/

            } else { ## Ödemeye Onay Verilmedi

                ## BURADA YAPILMASI GEREKENLER
                ## 1) Siparişi iptal edin.
                ## 2) Eğer ödemenin onaylanmama sebebini kayıt edecekseniz aşağıdaki değerleri kullanabilirsiniz.
                ## $post['failed_reason_code'] - başarısız hata kodu
                ## $post['failed_reason_msg'] - başarısız hata mesajı

            }




        ## Bildirimin alındığını PayTR sistemine bildir.
        echo "OK";
        exit;


    } else {
        // istek paytr den gelmiyor
        die('PAYTR notification failed: bad hash');
    }


}

#endregion paytr no iframe
