<?php


namespace Ysb\PayTr\Objects;


class PayTrOrder
{

    #region fields

    /** @var array|PayTrBasketItem[] */
    protected $basketItems = array();

    /** @var string */
    protected $email = "";

    /** @var string */
    protected $orderId = "";

    /** @var string */
    protected $userName = "";

    /** @var string */
    protected $userAddress = "";

    /** @var string */
    protected $userPhone = "";

    /** @var string */
    protected $paymentAmount = "";

    /** @var string */
    protected $userIp = "";

    /** @var bool */
    protected $noInstallment = false;

    /** @var int */
    protected $maxInstallment = 0; // Sayfada görüntülenecek taksit adedini sınırlamak istiyorsanız uygun şekilde değiştirin.
    ## Sıfır (0) gönderilmesi durumunda yürürlükteki en fazla izin verilen taksit geçerli olur.

    /** @var string */
    protected $currency = "TL";

    #endregion fields

    #region ctor

    public function __construct()
    {
    }

    #endregion ctor

    #region properties

    /**
     * @return array
     */
    public function getBasketItems()
    {
        return $this->basketItems;
    }

    /**
     * @param array $basketItems
     * @return PayTrOrder
     */
    public function setBasketItems($basketItems)
    {
        $this->basketItems = $basketItems;
        return $this;
    }

    /**
     * @return string
     */
    public function getEmail()
    {
        return $this->email;
    }

    /**
     * @param string $email
     * @return PayTrOrder
     */
    public function setEmail($email)
    {
        $this->email = $email;
        return $this;
    }

    /**
     * @return string
     */
    public function getOrderId()
    {
        return $this->orderId;
    }

    /**
     * @param string $orderId
     * @return PayTrOrder
     */
    public function setOrderId($orderId)
    {
        $this->orderId = $orderId;
        return $this;
    }

    /**
     * @return string
     */
    public function getUserName()
    {
        return $this->userName;
    }

    /**
     * @param string $userName
     * @return PayTrOrder
     */
    public function setUserName($userName)
    {
        $this->userName = $userName;
        return $this;
    }

    /**
     * @return string
     */
    public function getUserAddress()
    {
        return $this->userAddress;
    }

    /**
     * @param string $userAddress
     * @return PayTrOrder
     */
    public function setUserAddress($userAddress)
    {
        $this->userAddress = $userAddress;
        return $this;
    }

    /**
     * @return string
     */
    public function getUserPhone()
    {
        return $this->userPhone;
    }

    /**
     * @param string $userPhone
     * @return PayTrOrder
     */
    public function setUserPhone($userPhone)
    {
        $this->userPhone = $userPhone;
        return $this;
    }

    /**
     * @return string
     */
    public function getPaymentAmount()
    {
        return $this->paymentAmount;
    }

    /**
     * @param string $paymentAmount
     * @return PayTrOrder
     */
    public function setPaymentAmount($paymentAmount)
    {
        $this->paymentAmount = $paymentAmount;
        return $this;
    }

    /**
     * @return string
     */
    public function getUserIp()
    {
        $user_ip = $this->userIp;
        if (empty($user_ip)) {
            if (isset($_SERVER["HTTP_CLIENT_IP"])) {
                $user_ip = $_SERVER["HTTP_CLIENT_IP"];
            } elseif (isset($_SERVER["HTTP_X_FORWARDED_FOR"])) {
                $user_ip = $_SERVER["HTTP_X_FORWARDED_FOR"];
            } else {
                $user_ip = $_SERVER["REMOTE_ADDR"];
            }
            $this->userIp = $user_ip;
        }
        return $this->userIp;
    }

    /**
     * @param string $userIp
     * @return PayTrOrder
     */
    public function setUserIp($userIp)
    {
        $this->userIp = $userIp;
        return $this;
    }

    /**
     * @return bool
     */
    public function isNoInstallment()
    {
        return $this->noInstallment;
    }

    /**
     * @param bool $noInstallment
     * @return PayTrOrder
     */
    public function setNoInstallment($noInstallment)
    {
        $this->noInstallment = $noInstallment;
        return $this;
    }

    /**
     * @return int
     */
    public function getMaxInstallment()
    {
        return $this->maxInstallment;
    }

    /**
     * @param int $maxInstallment
     * @return PayTrOrder
     */
    public function setMaxInstallment($maxInstallment)
    {
        $this->maxInstallment = $maxInstallment;
        return $this;
    }

    /**
     * @return string
     */
    public function getCurrency()
    {
        return $this->currency;
    }

    /**
     * @param string $currency
     * @return PayTrOrder
     */
    public function setCurrency($currency)
    {
        $this->currency = $currency;
        return $this;
    }



    #endregion properties

    #region Methods

    /**
     * @param $productName
     * @param $unitPrice
     * @param int $quantity
     * @return $this
     */
    public function addBasketItem($productName, $unitPrice, $quantity = 1)
    {
        $this->basketItems[] = new PayTrBasketItem($productName, $unitPrice, $quantity);
        return $this;
    }

    /**
     * @return string
     */
    public function getBasketItemsBase64(){
        $user_basket = "";
        if (!empty($this->basketItems)) {
            $bskArr = array();
            foreach ($this->basketItems as $basketItem) {
                $bskArr[] = $basketItem->toArray();
            }
            $user_basket = base64_encode(json_encode($bskArr));
        }
        return $user_basket;
    }

    /**
     * @return array
     */
    public function toArray()
    {
        return array(
            "user_ip" => $this->getUserIp(),
            "merchant_oid" => $this->orderId,
            "email" => $this->email,
            "payment_amount" => $this->paymentAmount,
            "user_basket" => $this->getBasketItemsBase64(),
            "no_installment" => ($this->noInstallment) ? 1 : 0,
            "max_installment" => $this->maxInstallment,
            "user_name" => $this->userName,
            "user_address" => $this->userAddress,
            "user_phone" => $this->userPhone,
            "currency" => $this->currency
        );
    }

    #endregion Methods

}