<?php


namespace Ysb\PayTr\Objects;


class PayTrNoIframeOrder
{

    #region fields

    /** @var array|PayTrNoIframeBasketItem[] */
    protected $basketItems = array();

    /** @var string */
    protected $email = "";

    /** @var string */
    protected $merchantOid = "";


    /** @var string */
    protected $userPhone = "";

    /** @var string */
    protected $paymentAmount = "";

    /** @var string */
    protected $userIp = ""; // zorunlu

    /** @var string */
    protected $currency = "TL";

    /**
     * @var string
     */
    protected $paymentType = "card"; // card ya da card_points

    /**
     * @var int
     */
    protected $installmentCount = 0;

    /**
     * @var string|null
     */
    protected $cardType = null; // advantage, axess,combo, bonus, cardfinans, maximum, paraf, world, saglamkart

    /**
     * @var string|null
     *
     * Türkçe için tr veya
     * İngilizce için en
     * (Boş gönderilirse tr geçerli olur)
     *
     */
    protected $clientLang = null;

    /**
     * @var bool|null
     * Non 3D işlem yapabilmek için 1 gönderilebilir
     */
    protected $non3d = null;

    /**
     * @var bool|null
     *Non 3D işlemde, başarısız işlem durumunu
     * test etmek için 1 gönderilir
     * (test_mode ve non_3d değerleri 1 ise dikkate alınır!)
     */
    protected $non3dTestFailed = null;

    /**
     * @var string
     * Kart sahibi
     */
    protected $ccOwner = "";

    /**
     * @var string
     * Kart numarası
     * 16 Karakter
     */
    protected $cardNumber = "";

    /**
     * @var string
     * Kart son kullanma tarihi(Ay)
     * 1, 2, 3, .. , 11, 12
     */
    protected $expiryMonth = "";

    /**
     * @var string
     * Kart son kullanma tarihi(Yıl)
     * 18, 19, 20,…
     */
    protected $expiryYear = "";

    /**
     * @var string
     * Kart güvenlik kodu
     * 3 karakter
     */
    protected $cvv = "";

    /**
     * @var string
     */
    protected $userName = "";
    /**
     * @var string
     */
    protected $userAddress = "";



    #endregion fields

    #region ctor

    public function __construct()
    {
    }

    #endregion ctor

    #region properties

    /**
     * @return array
     */
    public function getBasketItems()
    {
        return $this->basketItems;
    }

    /**
     * @param array $basketItems
     * @return $this
     */
    public function setBasketItems($basketItems)
    {
        $this->basketItems = $basketItems;
        return $this;
    }

    /**
     * @return string
     */
    public function getEmail()
    {
        return $this->email;
    }

    /**
     * @param string $email
     * @return $this
     */
    public function setEmail($email)
    {
        $this->email = $email;
        return $this;
    }

    /**
     * @return string
     */
    public function getMerchantOid()
    {
        return $this->merchantOid;
    }

    /**
     * @param string $merchantOid
     * @return $this
     */
    public function setMerchantOid($merchantOid)
    {
        $this->merchantOid = $merchantOid;
        return $this;
    }



    /**
     * @return string
     */
    public function getUserPhone()
    {
        return $this->userPhone;
    }

    /**
     * @param string $userPhone
     * @return $this
     */
    public function setUserPhone($userPhone)
    {
        $this->userPhone = $userPhone;
        return $this;
    }

    /**
     * @return string
     */
    public function getUserName()
    {
        return $this->userName;
    }

    /**
     * @param string $userName
     * @return PayTrNoIframeOrder
     */
    public function setUserName($userName)
    {
        $this->userName = $userName;
        return $this;
    }

    /**
     * @return string
     */
    public function getUserAddress()
    {
        return $this->userAddress;
    }

    /**
     * @param string $userAddress
     * @return PayTrNoIframeOrder
     */
    public function setUserAddress($userAddress)
    {
        $this->userAddress = $userAddress;
        return $this;
    }



    /**
     * @return string
     */
    public function getPaymentAmount()
    {
        return $this->paymentAmount;
    }

    /**
     * @return string
     */
    public function getPaymentType()
    {
        return $this->paymentType;
    }

    /**
     * @param string $paymentType
     * @return PayTrNoIframeOrder
     */
    public function setPaymentType($paymentType)
    {
        $this->paymentType = $paymentType;
        return $this;
    }

    /**
     * @return int
     */
    public function getInstallmentCount()
    {
        return $this->installmentCount;
    }

    /**
     * @param int $installmentCount
     * @return PayTrNoIframeOrder
     */
    public function setInstallmentCount($installmentCount)
    {
        $this->installmentCount = $installmentCount;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getCardType()
    {
        return $this->cardType;
    }

    /**
     * @param string|null $cardType
     * @return PayTrNoIframeOrder
     */
    public function setCardType($cardType)
    {
        $this->cardType = $cardType;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getClientLang()
    {
        return $this->clientLang;
    }

    /**
     * @param string|null $clientLang
     * @return PayTrNoIframeOrder
     */
    public function setClientLang($clientLang)
    {
        $this->clientLang = $clientLang;
        return $this;
    }

    /**
     * @return bool|null
     */
    public function getNon3d()
    {
        return $this->non3d;
    }

    /**
     * @param bool|null $non3d
     * @return PayTrNoIframeOrder
     */
    public function setNon3d($non3d)
    {
        $this->non3d = $non3d;
        return $this;
    }

    /**
     * @return bool|null
     */
    public function getNon3dTestFailed()
    {
        return $this->non3dTestFailed;
    }

    /**
     * @param bool|null $non3dTestFailed
     * @return PayTrNoIframeOrder
     */
    public function setNon3dTestFailed($non3dTestFailed)
    {
        $this->non3dTestFailed = $non3dTestFailed;
        return $this;
    }

    /**
     * @return string
     */
    public function getCcOwner()
    {
        return $this->ccOwner;
    }

    /**
     * @param string $ccOwner
     * @return PayTrNoIframeOrder
     */
    public function setCcOwner($ccOwner)
    {
        $this->ccOwner = $ccOwner;
        return $this;
    }

    /**
     * @return string
     */
    public function getCardNumber()
    {
        return $this->cardNumber;
    }

    /**
     * @param string $cardNumber
     * @return PayTrNoIframeOrder
     */
    public function setCardNumber($cardNumber)
    {
        if (!empty($cardNumber)){
            $cardNumber = trim(str_replace(" ", "",$cardNumber));
        }
        $this->cardNumber = $cardNumber;
        return $this;
    }

    /**
     * @return string
     */
    public function getExpiryMonth()
    {
        return $this->expiryMonth;
    }

    /**
     * @param string $expiryMonth
     * @return PayTrNoIframeOrder
     */
    public function setExpiryMonth($expiryMonth)
    {
        $this->expiryMonth = $expiryMonth;
        return $this;
    }

    /**
     * @return string
     */
    public function getExpiryYear()
    {
        return $this->expiryYear;
    }

    /**
     * @param string $expiryYear
     * @return PayTrNoIframeOrder
     */
    public function setExpiryYear($expiryYear)
    {
        $this->expiryYear = $expiryYear;
        return $this;
    }

    /**
     * @return string
     */
    public function getCvv()
    {
        return $this->cvv;
    }

    /**
     * @param string $cvv
     * @return PayTrNoIframeOrder
     */
    public function setCvv($cvv)
    {
        $this->cvv = $cvv;
        return $this;
    }

    /**
     * @param string $paymentAmount
     * @return $this
     */
    public function setPaymentAmount($paymentAmount)
    {
        if(is_float($paymentAmount)){
            $paymentAmount = number_format($paymentAmount,2,".","");
        }
        $this->paymentAmount = $paymentAmount;
        return $this;
    }

    /**
     * @return string
     */
    public function getUserIp()
    {
        $user_ip = $this->userIp;
        if (empty($user_ip)) {
            if (isset($_SERVER["HTTP_CLIENT_IP"])) {
                $user_ip = $_SERVER["HTTP_CLIENT_IP"];
            } elseif (isset($_SERVER["HTTP_X_FORWARDED_FOR"])) {
                $user_ip = $_SERVER["HTTP_X_FORWARDED_FOR"];
            } else {
                $user_ip = $_SERVER["REMOTE_ADDR"];
            }
            $this->userIp = $user_ip;
        }
        return $this->userIp;
    }

    /**
     * @param string $userIp
     * @return $this
     */
    public function setUserIp($userIp)
    {
        $this->userIp = $userIp;
        return $this;
    }






    /**
     * @return string
     */
    public function getCurrency()
    {
        return $this->currency;
    }

    /**
     * @param string $currency
     * @return $this
     */
    public function setCurrency($currency)
    {
        $this->currency = $currency;
        return $this;
    }



    #endregion properties

    #region Methods

    /**
     * @param $productName
     * @param $unitPrice
     * @param int $quantity
     * @return $this
     */
    public function addBasketItem($productName, $unitPrice, $quantity = 1)
    {
        $this->basketItems[] = new PayTrNoIframeBasketItem($productName, $unitPrice, $quantity);
        return $this;
    }

    /**
     * @return string
     */
    public function getBasketItemsBase64(){
        $user_basket = $this->getBasketItemsJson();
        if (!empty($user_basket)) {
            $user_basket = base64_encode($user_basket);
        }
        return $user_basket;
    }

    /**
     * @return string
     */
    public function getBasketItemsJson(){
        $user_basket = "";
        if (!empty($this->basketItems)) {
            $bskArr = array();
            foreach ($this->basketItems as $basketItem) {
                $bskArr[] = $basketItem->toArray();
            }
            $user_basket = json_encode($bskArr);
        }
        return $user_basket;
    }

    /**
     * @return array
     */
    public function toArray()
    {
        $arr = array(
            "user_ip" => $this->getUserIp(), // zorunlu
            "merchant_oid" => $this->merchantOid, // zorunlu
            "email" => $this->email, // zorunlu
            "payment_amount" => $this->paymentAmount, // zorunlu
            "user_basket" => $this->getBasketItemsJson(), // zorunlu
            "currency" => $this->currency, // opsiyonel boş borakılırsa tl
            "payment_type" => $this->paymentType, // zorunlu
            "installment_count" => $this->installmentCount, // zorunlu
            "cc_owner" => $this->ccOwner, // zorunlu max 50 karakter
            "card_number" => $this->cardNumber, // zorunlu 16 karakter
            "expiry_month" => $this->expiryMonth, // zorunlu 1-12 arası
            "expiry_year" => $this->expiryYear, // zorunlu 18, 19, 20,…
            "cvv" => $this->cvv, // zorunlu 3 karakter
        );

        if(!empty($this->userName)){
            $arr['user_name'] = $this->userName; // opsiyonel
        }
        if(!empty($this->userAddress)){
            $arr['user_address'] = $this->userAddress; // opsiyonel
        }

        if(!empty($this->userPhone)){
            $arr['user_phone'] = $this->userPhone; // opsiyonel
        }

        if(!empty($this->cardType)){
            $arr['card_type'] = $this->cardType; // opsiyonel
        }

        if(!empty($this->clientLang)){
            $arr['client_lang'] = $this->clientLang; // opsiyonel
        }

        if($this->non3d !== null){
            $arr['non_3d'] = $this->non3d ? 1 : 0; // opsiyonel 0 veya 1
        }

        if($this->non3dTestFailed !== null){
            $arr['non3d_test_failed'] = $this->non3dTestFailed ? 1 : 0; // opsiyonel 0 veya 1
        }


        return $arr;
    }

    #endregion Methods


}