<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://soap.netgsm.com.tr:8080/Sms_webservis/SMS?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://soap.netgsm.com.tr:8080/Sms_webservis/SMS?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => \Ys\NetgsmSmsSoap\ClassMap::get(),
);
/**
 * Samples for Sms ServiceType
 */
$sms = new \Ys\NetgsmSmsSoap\ServiceType\Sms($options);
/**
 * Sample call for smsGonderNNV2 operation/method
 */
if ($sms->smsGonderNNV2(new \Ys\NetgsmSmsSoap\StructType\SmsGonderNNV2()) !== false) {
    print_r($sms->getResult());
} else {
    print_r(Error($sms->getLast));
}
/**
 * Sample call for smsGonder1NV2 operation/method
 */
if ($sms->smsGonder1NV2(new \Ys\NetgsmSmsSoap\StructType\SmsGonder1NV2()) !== false) {
    print_r($sms->getResult());
} else {
    print_r($sms->getLastError());
}
/**
 * Samples for Smsgondern ServiceType
 */
$smsgondern = new \Ys\NetgsmSmsSoap\ServiceType\Smsgondern($options);
/**
 * Sample call for sms_gonder_1n operation/method
 */
if ($smsgondern->sms_gonder_1n(new \Ys\NetgsmSmsSoap\StructType\Sms_gonder_1n()) !== false) {
    print_r($smsgondern->getResult());
} else {
    print_r($smsgondern->getLastError());
}
/**
 * Samples for Kredi ServiceType
 */
$kredi = new \Ys\NetgsmSmsSoap\ServiceType\Kredi($options);
/**
 * Sample call for kredi operation/method
 */
if ($kredi->kredi(new \Ys\NetgsmSmsSoap\StructType\Kredi()) !== false) {
    print_r($kredi->getResult());
} else {
    print_r($kredi->getLastError());
}
/**
 * Samples for Paketkampanya ServiceType
 */
$paketkampanya = new \Ys\NetgsmSmsSoap\ServiceType\Paketkampanya($options);
/**
 * Sample call for paketkampanya operation/method
 */
if ($paketkampanya->paketkampanya(new \Ys\NetgsmSmsSoap\StructType\Paketkampanya()) !== false) {
    print_r($paketkampanya->getResult());
} else {
    print_r($paketkampanya->getLastError());
}
/**
 * Samples for Rapor ServiceType
 */
$rapor = new \Ys\NetgsmSmsSoap\ServiceType\Rapor($options);
/**
 * Sample call for rapor operation/method
 */
if ($rapor->rapor(new \Ys\NetgsmSmsSoap\StructType\Rapor()) !== false) {
    print_r($rapor->getResult());
} else {
    print_r($rapor->getLastError());
}
/**
 * Sample call for raporV3 operation/method
 */
if ($rapor->raporV3(new \Ys\NetgsmSmsSoap\StructType\RaporV3()) !== false) {
    print_r($rapor->getResult());
} else {
    print_r($rapor->getLastError());
}
/**
 * Samples for Raporv ServiceType
 */
$raporv = new \Ys\NetgsmSmsSoap\ServiceType\Raporv($options);
/**
 * Sample call for rapor_v2 operation/method
 */
if ($raporv->rapor_v2(new \Ys\NetgsmSmsSoap\StructType\Rapor_v2()) !== false) {
    print_r($raporv->getResult());
} else {
    print_r($raporv->getLastError());
}
/**
 * Samples for Gondericiadlari ServiceType
 */
$gondericiadlari = new \Ys\NetgsmSmsSoap\ServiceType\Gondericiadlari($options);
/**
 * Sample call for gondericiadlari operation/method
 */
if ($gondericiadlari->gondericiadlari(new \Ys\NetgsmSmsSoap\StructType\Gondericiadlari()) !== false) {
    print_r($gondericiadlari->getResult());
} else {
    print_r($gondericiadlari->getLastError());
}
/**
 * Samples for Smsgondernn ServiceType
 */
$smsgondernn = new \Ys\NetgsmSmsSoap\ServiceType\Smsgondernn($options);
/**
 * Sample call for sms_gonder_nn operation/method
 */
if ($smsgondernn->sms_gonder_nn(new \Ys\NetgsmSmsSoap\StructType\Sms_gonder_nn()) !== false) {
    print_r($smsgondernn->getResult());
} else {
    print_r($smsgondernn->getLastError());
}
/**
 * Samples for Gelensms ServiceType
 */
$gelensms = new \Ys\NetgsmSmsSoap\ServiceType\Gelensms($options);
/**
 * Sample call for gelensms operation/method
 */
if ($gelensms->gelensms(new \Ys\NetgsmSmsSoap\StructType\Gelensms()) !== false) {
    print_r($gelensms->getResult());
} else {
    print_r($gelensms->getLastError());
}
/**
 * Sample call for gelensmsV2 operation/method
 */
if ($gelensms->gelensmsV2(new \Ys\NetgsmSmsSoap\StructType\GelensmsV2()) !== false) {
    print_r($gelensms->getResult());
} else {
    print_r($gelensms->getLastError());
}
